/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.preferences;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.chart.property.widget.CustomizerWidgetsDescriptor;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.framework.manager.StandardJSONWidgetsDescriptorResolver;
import com.jaspersoft.studio.widgets.framework.model.WidgetsDescriptor;
import java.io.File;
import java.net.URL;
import net.sf.jasperreports.eclipse.messages.Messages;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationTitleAreaDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ChartCustomizerSelectionDialog
extends PersistentLocationTitleAreaDialog {
    private String fDirectory = null;
    private Text fDirText;
    private String title;
    private String message;

    public ChartCustomizerSelectionDialog(Shell shell, String title, String message) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.title = title;
        this.message = message;
    }

    public String getSelectedResource() {
        return this.fDirectory;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.message);
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Font font = parentComposite.getFont();
        Composite composite = new Composite(parentComposite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setFont(font);
        Composite dirComposite = new Composite(composite, 0);
        layout = new GridLayout(3, false);
        dirComposite.setLayout((Layout)layout);
        dirComposite.setLayoutData((Object)new GridData(768));
        dirComposite.setFont(font);
        Label label = new Label(dirComposite, 0);
        label.setText(Messages.common_path);
        label.setFont(font);
        this.fDirText = new Text(dirComposite, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 1;
        this.fDirText.setLayoutData((Object)data);
        this.fDirText.setFont(font);
        this.fDirText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChartCustomizerSelectionDialog.this.validate();
            }
        });
        Button button = new Button(dirComposite, 8);
        button.setText(Messages.common_browse);
        data = new GridData();
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Point minSize = button.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minSize.x);
        button.setLayoutData((Object)data);
        button.setFont(JFaceResources.getDialogFont());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ChartCustomizerSelectionDialog.this.browse();
            }
        });
        return parentComposite;
    }

    protected void configureShell(Shell newShell) {
        String title = Messages.ChartCustomizerSelectionDialog_dialogTitle;
        newShell.setText(title);
        super.configureShell(newShell);
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.fDirText.setText("");
        this.validate();
        return c;
    }

    protected void okPressed() {
        this.fDirectory = this.fDirText.getText().trim();
        super.okPressed();
    }

    private void browse() {
        String last = this.fDirText.getText().trim();
        FileDialog fd = new FileDialog(UIUtils.getShell());
        fd.setFilterPath(last);
        fd.setFilterExtensions(new String[]{"*.json", "*.*"});
        String selection = fd.open();
        if (selection != null) {
            boolean isValid = true;
            try {
                StandardJSONWidgetsDescriptorResolver resolver = new StandardJSONWidgetsDescriptorResolver(CustomizerWidgetsDescriptor.class);
                URL resourceURL = new File(selection).toURI().toURL();
                WidgetsDescriptor loadedDecriptor = resolver.loadDescriptor(JasperReportsConfiguration.getDefaultInstance(), resourceURL.toExternalForm());
                isValid = loadedDecriptor != null;
            }
            catch (Exception e) {
                JaspersoftStudioPlugin.getInstance().logError((Throwable)e);
                isValid = false;
            }
            if (!isValid) {
                isValid = UIUtils.showConfirmation((String)Messages.ChartCustomizerSelectionDialog_errorTitle, (String)Messages.ChartCustomizerSelectionDialog_errorMessages);
            }
            if (isValid) {
                this.fDirText.setText(selection);
            }
        }
    }

    private void validate() {
        File file = new File(this.fDirText.getText().trim());
        this.getButton(0).setEnabled(file.exists());
    }
}

