/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.property.descriptor;

import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.property.descriptor.ChartCustomizerDefinition;
import com.jaspersoft.studio.components.chart.property.widget.CustomizerDefinitionManager;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class CustomizerPropertyExpressionsDTO
extends PropertyExpressionsDTO {
    private Integer customizerNumber = null;
    private String customizerClass = null;
    private MChart pnode;

    public CustomizerPropertyExpressionsDTO(PropertyExpressionsDTO dto, MChart pnode) {
        super(dto.getProperties(), dto.getJrElement(), dto.geteContext());
        this.customizerClass = pnode.getValue().getCustomizerClass();
        this.pnode = pnode;
    }

    public MChart getPnode() {
        return this.pnode;
    }

    public int getCustomizersNumber() {
        if (this.customizerNumber == null) {
            int count = 0;
            String classAttribute = "net.sf.jasperreports.customizer.class.";
            for (PropertyExpressionDTO property : this.getProperties()) {
                String name;
                if (property.isExpression() || !(name = property.getName().trim().toLowerCase()).startsWith(classAttribute)) continue;
                ++count;
            }
            if (this.customizerClass != null && !this.customizerClass.trim().isEmpty()) {
                ++count;
            }
            this.customizerNumber = count;
        }
        return this.customizerNumber;
    }

    public void createCustomizerEntry(String className, boolean headPosition) {
        String key = this.getUniqueKey();
        String classAttribute = "net.sf.jasperreports.customizer.class." + key;
        if (headPosition) {
            this.addProperty(classAttribute, className, false, 0);
        } else {
            this.addProperty(classAttribute, className, false);
        }
    }

    public List<ChartCustomizerDefinition> getDefinedCustomizers() {
        ArrayList<ChartCustomizerDefinition> selectedCustomizers = new ArrayList<ChartCustomizerDefinition>();
        JasperReportsConfiguration jConfig = this.pnode.getJasperConfiguration();
        for (PropertyExpressionDTO prop : this.getProperties()) {
            String propName;
            if (prop.isExpression() || !(propName = prop.getName().trim()).toLowerCase().startsWith("net.sf.jasperreports.customizer.class.")) continue;
            String key = propName.substring("net.sf.jasperreports.customizer.class.".length());
            String customizerClass = prop.getValue();
            ChartCustomizerDefinition definition = CustomizerDefinitionManager.getCustomizerDefinition(customizerClass, key, jConfig);
            if (definition == null) continue;
            selectedCustomizers.add(definition);
        }
        if (this.customizerClass != null && !this.customizerClass.trim().isEmpty()) {
            selectedCustomizers.add(new ChartCustomizerDefinition(this.customizerClass, this.getUniqueKey(), false));
        }
        return selectedCustomizers;
    }

    public String getUniqueKey() {
        int index = 0;
        HashSet<String> usedKeys = this.getUsedKeys();
        boolean existing = usedKeys.contains(String.valueOf(index));
        while (existing) {
            existing = usedKeys.contains(String.valueOf(++index));
        }
        return String.valueOf(index);
    }

    private HashSet<String> getUsedKeys() {
        HashSet<String> result = new HashSet<String>();
        for (PropertyExpressionDTO prop : new ArrayList(this.getProperties())) {
            String propName;
            if (prop.isExpression() || !(propName = prop.getName().trim()).toLowerCase().startsWith("net.sf.jasperreports.customizer.class.")) continue;
            String key = propName.substring("net.sf.jasperreports.customizer.class.".length());
            result.add(key);
        }
        return result;
    }

    public void deleteCustomizer(ChartCustomizerDefinition definition, boolean removeProperties) {
        this.customizerNumber = null;
        if (definition.isPropertiesCustomizer()) {
            String customizerKey = definition.getKey();
            for (PropertyExpressionDTO prop : new ArrayList(this.getProperties())) {
                String key;
                String propName;
                if (prop.isExpression() || !(propName = prop.getName().trim()).toLowerCase().startsWith("net.sf.jasperreports.customizer.")) continue;
                if (propName.toLowerCase().startsWith("net.sf.jasperreports.customizer.class.")) {
                    key = propName.substring("net.sf.jasperreports.customizer.class.".length());
                    if (!customizerKey.equalsIgnoreCase(key)) continue;
                    this.removeProperty(prop.getName(), prop.isExpression());
                    if (removeProperties) continue;
                    break;
                }
                if (!removeProperties) continue;
                key = propName.substring("net.sf.jasperreports.customizer.".length());
                int suffixIndex = key.indexOf(46);
                if (suffixIndex != -1) {
                    key = key.substring(0, suffixIndex);
                }
                if (!customizerKey.equalsIgnoreCase(key)) continue;
                this.removeProperty(prop.getName(), prop.isExpression());
            }
        } else {
            this.customizerClass = null;
        }
    }

    public void addCustomizer(ChartCustomizerDefinition definition) {
        String classProperty = "net.sf.jasperreports.customizer.class." + definition.getKey();
        this.addProperty(classProperty, definition.getCustomizerClass(), false);
    }

    public void updateCustomizerClass(ChartCustomizerDefinition editElement) {
        if (!editElement.isPropertiesCustomizer()) {
            this.customizerClass = editElement.getCustomizerClass();
        } else if (editElement.isOnlyClass()) {
            String classProp = "net.sf.jasperreports.customizer.class." + editElement.getKey();
            this.setProperty(classProp, editElement.getCustomizerClass(), false);
        }
    }

    public boolean addProperty(String name, String value, boolean isExpression) {
        this.customizerNumber = null;
        return super.addProperty(name, value, isExpression);
    }

    public void setProperty(String name, String value, boolean isExpression) {
        this.customizerNumber = null;
        super.setProperty(name, value, isExpression);
    }

    public boolean removeProperty(String propertyName, boolean isExpression) {
        this.customizerNumber = null;
        return super.removeProperty(propertyName, isExpression);
    }
}

