/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.property.widget;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.property.widget.NewMeterIntervalWizard;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.color.ColorCellEditor;
import com.jaspersoft.studio.property.descriptor.color.ColorLabelProvider;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionCellEditor;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.swt.widgets.table.DeleteButton;
import com.jaspersoft.studio.swt.widgets.table.INewElement;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.swt.widgets.table.ListOrderButtons;
import com.jaspersoft.studio.swt.widgets.table.NewButton;
import com.jaspersoft.studio.utils.AlfaRGB;
import com.jaspersoft.studio.utils.Colors;
import java.awt.Color;
import java.util.List;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.design.JRDesignDataRange;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MeterIntervalsDialog
extends Dialog {
    private AbstractSection section;
    private IPropertyDescriptor pDescriptor;
    private List<JRMeterInterval> intervalsList;
    private Table table;
    private TableViewer tableViewer;
    private Composite sectioncmp;
    private JRExpressionCellEditor lowExp;
    private JRExpressionCellEditor highExp;

    public MeterIntervalsDialog(Shell parentShell, AbstractSection section, IPropertyDescriptor pDescriptor, List<JRMeterInterval> intervalsList) {
        super(parentShell);
        this.pDescriptor = pDescriptor;
        this.intervalsList = intervalsList;
        this.section = section;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.MeterIntervalsDialog_dialogTitle);
    }

    protected Control createDialogArea(Composite parent) {
        this.sectioncmp = (Composite)super.createDialogArea(parent);
        this.sectioncmp = new Composite(this.sectioncmp, 0);
        this.sectioncmp.setLayout((Layout)new GridLayout(2, false));
        this.sectioncmp.setLayoutData((Object)new GridData(1808));
        Composite bGroup = new Composite(this.sectioncmp, 0);
        bGroup.setLayout((Layout)new GridLayout(1, false));
        bGroup.setLayoutData((Object)new GridData(1040));
        this.buildTable(this.sectioncmp);
        new NewButton().createNewButtons(bGroup, this.tableViewer, new INewElement(){

            public Object newElement(List<?> input, int pos) {
                NewMeterIntervalWizard wizard = new NewMeterIntervalWizard();
                WizardDialog dialog = new WizardDialog(UIUtils.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    return wizard.getMeterInterval();
                }
                return null;
            }
        });
        new DeleteButton().createDeleteButton(bGroup, this.tableViewer);
        new ListOrderButtons().createOrderButtons(bGroup, this.tableViewer);
        this.table.setToolTipText(this.pDescriptor.getDescription());
        APropertyNode selctedNode = this.section.getElement();
        if (selctedNode != null) {
            ExpressionContext expContext = new ExpressionContext(selctedNode.getJasperConfiguration());
            this.lowExp.setExpressionContext(expContext);
            this.highExp.setExpressionContext(expContext);
        }
        this.tableViewer.setInput(this.intervalsList);
        return this.sectioncmp;
    }

    private void buildTable(Composite composite) {
        this.table = new Table(composite, 67588);
        GridData gd = new GridData(1808);
        gd.heightHint = 200;
        gd.widthHint = 580;
        this.table.setLayoutData((Object)gd);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        this.tableViewer = new TableViewer(this.table);
        this.tableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new TLabelProvider());
        this.attachCellEditors(this.tableViewer, (Composite)this.table);
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(25));
        this.table.setLayout((Layout)tlayout);
        TableColumn[] column = new TableColumn[4];
        column[0] = new TableColumn(this.table, 0);
        column[0].setText(Messages.MeterIntervalsDialog_label);
        column[1] = new TableColumn(this.table, 0);
        column[1].setText(Messages.MeterIntervalsDialog_background);
        column[2] = new TableColumn(this.table, 0);
        column[2].setText(Messages.MeterIntervalsDialog_lowExpression);
        column[3] = new TableColumn(this.table, 0);
        column[3].setText(Messages.MeterIntervalsDialog_highExpression);
        int i = 0;
        int n = column.length;
        while (i < n) {
            column[i].pack();
            ++i;
        }
    }

    private void attachCellEditors(TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals("LABEL")) {
                    return true;
                }
                if (property.equals("COLOR")) {
                    return true;
                }
                if (property.equals("HIGH")) {
                    return true;
                }
                return property.equals("LOW");
            }

            public Object getValue(Object element, String property) {
                JRMeterInterval mi = (JRMeterInterval)element;
                if (property.equals("LABEL")) {
                    return mi.getLabel();
                }
                if (property.equals("COLOR")) {
                    AlfaRGB color = Colors.getSWTRGB4AWTGBColor((Color)mi.getBackgroundColor());
                    Double alfa = mi.getAlphaDouble();
                    color.setAlfa(alfa != null ? alfa : 1.0);
                    return color;
                }
                if (property.equals("HIGH")) {
                    return mi.getDataRange().getHighExpression();
                }
                if (property.equals("LOW")) {
                    return mi.getDataRange().getLowExpression();
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                TableItem ti = (TableItem)element;
                JRMeterInterval mi = (JRMeterInterval)ti.getData();
                if (property.equals("LABEL")) {
                    mi.setLabel((String)value);
                }
                if (property.equals("COLOR")) {
                    AlfaRGB argb = (AlfaRGB)value;
                    mi.setBackgroundColor(Colors.getAWT4SWTRGBColor((AlfaRGB)argb));
                    mi.setAlpha(Double.valueOf((double)argb.getAlfa() / 255.0));
                }
                if (property.equals("HIGH")) {
                    ((JRDesignDataRange)mi.getDataRange()).setHighExpression((JRExpression)value);
                }
                if (property.equals("LOW")) {
                    ((JRDesignDataRange)mi.getDataRange()).setLowExpression((JRExpression)value);
                }
                MeterIntervalsDialog.this.tableViewer.update(element, new String[]{property});
                MeterIntervalsDialog.this.tableViewer.refresh();
                MeterIntervalsDialog.this.propertyChange();
            }
        });
        this.lowExp = new JRExpressionCellEditor(parent, null);
        this.highExp = new JRExpressionCellEditor(parent, null);
        ColorCellEditor argbColor = new ColorCellEditor(parent){

            protected void updateContents(Object value) {
                AlfaRGB argb = (AlfaRGB)value;
                if (argb == null) {
                    this.rgbLabel.setText("");
                } else {
                    RGB rgb = argb.getRgb();
                    this.rgbLabel.setText("RGBA (" + rgb.red + "," + rgb.green + "," + rgb.blue + "," + argb.getAlfa() + ")");
                }
            }
        };
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), argbColor, this.lowExp, this.highExp});
        viewer.setColumnProperties(new String[]{"LABEL", "COLOR", "LOW", "HIGH"});
    }

    private void propertyChange() {
        this.intervalsList = (List)this.tableViewer.getInput();
    }

    public List<JRMeterInterval> getIntervalsList() {
        return this.intervalsList;
    }

    private final class TLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ColorLabelProvider colorLabel = new ColorLabelProvider(NullEnum.NULL);

        private TLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            JRMeterInterval mi = (JRMeterInterval)element;
            switch (columnIndex) {
                case 1: {
                    AlfaRGB color = Colors.getSWTRGB4AWTGBColor((Color)mi.getBackgroundColor());
                    Double alfa = mi.getAlphaDouble();
                    color.setAlfa(alfa != null ? alfa : 1.0);
                    return this.colorLabel.getImage((Object)color);
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            JRMeterInterval mi = (JRMeterInterval)element;
            JRDataRange dataRange = mi.getDataRange();
            switch (columnIndex) {
                case 0: {
                    return Misc.nvl((Object)mi.getLabel(), (String)"");
                }
                case 1: {
                    AlfaRGB color = Colors.getSWTRGB4AWTGBColor((Color)mi.getBackgroundColor());
                    Double alfa = mi.getAlphaDouble();
                    color.setAlfa(alfa != null ? alfa : 1.0);
                    RGB rgb = color.getRgb();
                    return "RGBA (" + rgb.red + "," + rgb.green + "," + rgb.blue + "," + color.getAlfa() + ")";
                }
                case 2: {
                    if (dataRange == null) break;
                    JRExpression lowe = dataRange.getLowExpression();
                    return lowe != null ? lowe.getText() : "";
                }
                case 3: {
                    if (dataRange == null) break;
                    JRExpression highe = dataRange.getHighExpression();
                    return highe != null ? highe.getText() : "";
                }
            }
            return "";
        }
    }
}

