/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.MChart;
import com.jaspersoft.studio.components.chart.wizard.ChartWizard;
import com.jaspersoft.studio.utils.UIUtil;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import com.jaspersoft.studio.wizards.JSSWizardPage;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.design.JRDesignAreaPlot;
import net.sf.jasperreports.charts.design.JRDesignBar3DPlot;
import net.sf.jasperreports.charts.design.JRDesignBarPlot;
import net.sf.jasperreports.charts.design.JRDesignBubblePlot;
import net.sf.jasperreports.charts.design.JRDesignCandlestickPlot;
import net.sf.jasperreports.charts.design.JRDesignCategoryDataset;
import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignGanttDataset;
import net.sf.jasperreports.charts.design.JRDesignGanttSeries;
import net.sf.jasperreports.charts.design.JRDesignHighLowDataset;
import net.sf.jasperreports.charts.design.JRDesignHighLowPlot;
import net.sf.jasperreports.charts.design.JRDesignLinePlot;
import net.sf.jasperreports.charts.design.JRDesignMeterPlot;
import net.sf.jasperreports.charts.design.JRDesignMultiAxisPlot;
import net.sf.jasperreports.charts.design.JRDesignPie3DPlot;
import net.sf.jasperreports.charts.design.JRDesignPieDataset;
import net.sf.jasperreports.charts.design.JRDesignPiePlot;
import net.sf.jasperreports.charts.design.JRDesignScatterPlot;
import net.sf.jasperreports.charts.design.JRDesignThermometerPlot;
import net.sf.jasperreports.charts.design.JRDesignTimeSeries;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesDataset;
import net.sf.jasperreports.charts.design.JRDesignTimeSeriesPlot;
import net.sf.jasperreports.charts.design.JRDesignValueDataset;
import net.sf.jasperreports.charts.design.JRDesignXyDataset;
import net.sf.jasperreports.charts.design.JRDesignXySeries;
import net.sf.jasperreports.charts.design.JRDesignXyzDataset;
import net.sf.jasperreports.charts.design.JRDesignXyzSeries;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.design.JRDesignChart;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryGroupRenderer;
import org.eclipse.nebula.widgets.gallery.AbstractGalleryItemRenderer;
import org.eclipse.nebula.widgets.gallery.Gallery;
import org.eclipse.nebula.widgets.gallery.GalleryItem;
import org.eclipse.nebula.widgets.gallery.NoGroupRenderer;
import org.eclipse.nebula.widgets.gallery.RoundedGalleryItemRenderer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Scale;

public class ChartTypeWizardPage
extends JSSWizardPage {
    private static final int GALLERY_HEIGHT = 100;
    private static final int GALLERY_WIDTH = 100;
    private MChart chart;
    private byte chartType = (byte)7;
    private Scale zoomFactor;
    private Gallery chartsGallery;
    private GalleryItem itemGroup;
    private static Map<String, Image> standardImages = new HashMap<String, Image>();
    private static Map<String, Image> selectedImages = new HashMap<String, Image>();
    private boolean lastPageShown = false;

    protected ChartTypeWizardPage(MChart chart) {
        super("chartwizard");
        this.setTitle(Messages.common_chart_wizard);
        this.setDescription(Messages.ChartWizardPage_chart_wizard_description);
        this.chart = chart;
        this.chartType = chart.getValue().getChartType();
    }

    protected String getContextName() {
        return ContextHelpIDs.WIZARD_CHART_TYPE;
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.setControl((Control)composite);
        this.zoomFactor = new Scale(composite, 0);
        this.zoomFactor.setMinimum(1);
        this.zoomFactor.setMaximum(50);
        this.zoomFactor.setIncrement(1);
        this.zoomFactor.setPageIncrement(5);
        GridData gd = new GridData(128);
        gd.widthHint = 150;
        this.zoomFactor.setLayoutData((Object)gd);
        this.chartsGallery = new Gallery(composite, 0x10000A00);
        final NoGroupRenderer gr = new NoGroupRenderer();
        gr.setMinMargin(2);
        gr.setItemSize(100, 100);
        gr.setAutoMargin(true);
        gd = new GridData(1808);
        gd.widthHint = 500;
        this.chartsGallery.setLayoutData((Object)gd);
        this.chartsGallery.setGroupRenderer((AbstractGalleryGroupRenderer)gr);
        RoundedGalleryItemRenderer ir = new RoundedGalleryItemRenderer();
        ir.setShowLabels(true);
        this.chartsGallery.setItemRenderer((AbstractGalleryItemRenderer)ir);
        this.itemGroup = new GalleryItem(this.chartsGallery, 0);
        this.fillTableb4j(this.chartsGallery, this.itemGroup);
        this.chartsGallery.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof GalleryItem) {
                    ChartTypeWizardPage.this.chartType = (Byte)((GalleryItem)e.item).getData();
                    if (ChartTypeWizardPage.this.chartType == 19) {
                        if (ChartTypeWizardPage.this.getWizard() instanceof ChartWizard) {
                            ((ChartWizard)ChartTypeWizardPage.this.getWizard()).fixLastPage(true);
                        }
                    } else if (ChartTypeWizardPage.this.getWizard() instanceof ChartWizard) {
                        ((ChartWizard)ChartTypeWizardPage.this.getWizard()).fixLastPage(false);
                    }
                    ChartTypeWizardPage.this.setPageComplete(true);
                } else {
                    ChartTypeWizardPage.this.setPageComplete(false);
                }
            }
        });
        this.setTableSelection();
        this.zoomFactor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                double c = 1.0 + 0.1 * (double)ChartTypeWizardPage.this.zoomFactor.getSelection();
                gr.setItemSize((int)(100.0 * c), (int)(100.0 * c));
            }
        });
    }

    private void setTableSelection() {
        GalleryItem[] galleryItemArray = this.itemGroup.getItems();
        int n = galleryItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            GalleryItem ti = galleryItemArray[n2];
            if (((Byte)ti.getData()).intValue() == this.chartType) {
                this.chartsGallery.setSelection(new GalleryItem[]{ti});
                break;
            }
            ++n2;
        }
    }

    public IWizardPage getNextPage() {
        if (this.finishPage()) {
            this.lastPageShown = true;
            return super.getNextPage();
        }
        return this;
    }

    public void setLastPageShown(boolean lastPageShown) {
        this.lastPageShown = lastPageShown;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean finishPage() {
        JRDesignChart oldChart = this.chart.getValue();
        if (this.chartType == oldChart.getChartType()) return true;
        if (this.lastPageShown) {
            if (!UIUtils.showConfirmation((String)Messages.ChartTypeWizardPage_0, (String)Messages.ChartTypeWizardPage_1)) return false;
            this.setChartType(oldChart, this.chartType);
            return true;
        } else {
            this.setChartType(oldChart, this.chartType);
        }
        return true;
    }

    public void setChartType(JRDesignChart chart, byte chartType) {
        try {
            byte old = chart.getChartType();
            JRChartDataset ds = chart.getDataset();
            JRChartPlot plot = chart.getPlot();
            switch (chartType) {
                case 1: {
                    if (!(ds instanceof JRDesignCategoryDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2CategoryDataset(ds));
                    }
                    if (plot instanceof JRDesignAreaPlot) break;
                    this.setPlot((JRChartPlot)this.merge2AreaPlot(chart, plot), chart);
                    break;
                }
                case 3: {
                    if (!(ds instanceof JRDesignCategoryDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2CategoryDataset(ds));
                    }
                    if (plot instanceof JRDesignBarPlot) break;
                    this.setPlot((JRChartPlot)this.merge2BarPlot(chart, plot), chart);
                    break;
                }
                case 2: {
                    if (!(ds instanceof JRDesignCategoryDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2CategoryDataset(ds));
                    }
                    if (plot instanceof JRDesignBar3DPlot) break;
                    this.setPlot((JRChartPlot)this.merge2Bar3DPlot(chart, plot), chart);
                    break;
                }
                case 4: {
                    if (!(ds instanceof JRDesignXyzDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2XyzDataset(ds));
                    }
                    if (plot instanceof JRDesignBubblePlot) break;
                    this.setPlot((JRChartPlot)this.merge2BubblePlot(chart, plot), chart);
                    break;
                }
                case 5: {
                    if (!(ds instanceof JRDesignHighLowDataset)) {
                        chart.setDataset((JRChartDataset)new JRDesignHighLowDataset(ds));
                    }
                    if (plot instanceof JRDesignCandlestickPlot) break;
                    this.setPlot((JRChartPlot)this.merge2CandleStickPlot(chart, plot), chart);
                    break;
                }
                case 6: {
                    if (!(ds instanceof JRDesignHighLowDataset)) {
                        chart.setDataset((JRChartDataset)new JRDesignHighLowDataset(ds));
                    }
                    if (plot instanceof JRDesignHighLowPlot) break;
                    this.setPlot((JRChartPlot)this.merge2HighLowPlot(chart, plot), chart);
                    break;
                }
                case 7: {
                    if (!(ds instanceof JRDesignCategoryDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2CategoryDataset(ds));
                    }
                    if (plot instanceof JRDesignLinePlot) break;
                    this.setPlot((JRChartPlot)this.merge2LinePlot(chart, plot), chart);
                    break;
                }
                case 17: {
                    if (!(ds instanceof JRDesignValueDataset)) {
                        chart.setDataset((JRChartDataset)new JRDesignValueDataset(ds));
                    }
                    if (plot instanceof JRDesignMeterPlot) break;
                    this.setPlot((JRChartPlot)this.merge2MeterPlot(chart, plot), chart);
                    break;
                }
                case 19: {
                    chart.setDataset(null);
                    this.setPlot((JRChartPlot)new JRDesignMultiAxisPlot(chart.getPlot(), (JRChart)chart), chart);
                    break;
                }
                case 9: {
                    if (!(ds instanceof JRDesignPieDataset)) {
                        chart.setDataset((JRChartDataset)new JRDesignPieDataset(ds));
                    }
                    if (plot instanceof JRDesignPiePlot) break;
                    this.setPlot((JRChartPlot)this.merge2PiePlot(chart, plot), chart);
                    break;
                }
                case 8: {
                    if (!(ds instanceof JRDesignPieDataset)) {
                        chart.setDataset((JRChartDataset)new JRDesignPieDataset(ds));
                    }
                    if (plot instanceof JRDesignPie3DPlot) break;
                    this.setPlot((JRChartPlot)this.merge2Pie3DPlot(chart, plot), chart);
                    break;
                }
                case 10: {
                    if (!(ds instanceof JRDesignXyDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2XyDataset(ds));
                    }
                    if (plot instanceof JRDesignScatterPlot) break;
                    this.setPlot((JRChartPlot)this.merge2ScatterPlot(chart, plot), chart);
                    break;
                }
                case 12: {
                    if (!(ds instanceof JRDesignCategoryDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2CategoryDataset(ds));
                    }
                    if (plot instanceof JRDesignBarPlot) break;
                    this.setPlot((JRChartPlot)this.merge2BarPlot(chart, plot), chart);
                    break;
                }
                case 11: {
                    if (!(ds instanceof JRDesignCategoryDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2CategoryDataset(ds));
                    }
                    if (plot instanceof JRDesignBar3DPlot) break;
                    this.setPlot((JRChartPlot)this.merge2Bar3DPlot(chart, plot), chart);
                    break;
                }
                case 18: {
                    if (!(ds instanceof JRDesignValueDataset)) {
                        chart.setDataset((JRChartDataset)new JRDesignValueDataset(ds));
                    }
                    if (plot instanceof JRDesignThermometerPlot) break;
                    this.setPlot((JRChartPlot)this.merge2ThermometerPlot(chart, plot), chart);
                    break;
                }
                case 16: {
                    if (!(ds instanceof JRDesignTimeSeriesDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2TimeSeriesDataset(ds));
                    }
                    if (plot instanceof JRDesignTimeSeriesPlot) break;
                    this.setPlot((JRChartPlot)this.merge2TimeSeriesPlot(chart, plot), chart);
                    break;
                }
                case 13: {
                    if (!(ds instanceof JRDesignXyDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2XyDataset(ds));
                    }
                    if (plot instanceof JRDesignAreaPlot) break;
                    this.setPlot((JRChartPlot)this.merge2AreaPlot(chart, plot), chart);
                    break;
                }
                case 14: {
                    if (!(ds instanceof JRDesignXyDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2XyDataset(ds));
                    }
                    if (plot instanceof JRDesignBarPlot) break;
                    this.setPlot((JRChartPlot)this.merge2BarPlot(chart, plot), chart);
                    break;
                }
                case 15: {
                    if (!(ds instanceof JRDesignXyDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2XyDataset(ds));
                    }
                    if (plot instanceof JRDesignLinePlot) break;
                    this.setPlot((JRChartPlot)this.merge2LinePlot(chart, plot), chart);
                    break;
                }
                case 20: {
                    if (!(ds instanceof JRDesignCategoryDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2CategoryDataset(ds));
                    }
                    if (plot instanceof JRDesignAreaPlot) break;
                    this.setPlot((JRChartPlot)this.merge2AreaPlot(chart, plot), chart);
                    break;
                }
                case 21: {
                    if (!(ds instanceof JRDesignGanttDataset)) {
                        chart.setDataset((JRChartDataset)this.merge2GanttDataset(ds));
                    }
                    if (plot instanceof JRDesignBarPlot) break;
                    this.setPlot((JRChartPlot)this.merge2BarPlot(chart, plot), chart);
                    break;
                }
                default: {
                    throw new JRRuntimeException("charts.chart.type.unsupported", null);
                }
            }
            this.setChartTypeByte(chart, chartType);
            chart.getEventSupport().firePropertyChange("chartType", (int)old, (int)chartType);
        }
        catch (SecurityException e) {
            e.printStackTrace();
            chart.setChartType(chartType);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
            chart.setChartType(chartType);
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
            chart.setChartType(chartType);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            chart.setChartType(chartType);
        }
        catch (JRException e) {
            e.printStackTrace();
            chart.setChartType(chartType);
        }
    }

    private void setChartTypeByte(JRDesignChart chart, byte type) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = chart.getClass().getDeclaredField("chartType");
        f.setAccessible(true);
        f.setByte(chart, type);
    }

    private void setPlot(JRChartPlot plot, JRDesignChart chart) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = chart.getClass().getDeclaredField("plot");
        f.setAccessible(true);
        f.set(chart, plot);
        MChart.setupPlot(chart);
    }

    protected JRDesignMeterPlot merge2MeterPlot(JRDesignChart chart, JRChartPlot plot) throws JRException {
        JRDesignMeterPlot np = new JRDesignMeterPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignThermometerPlot) {
            np.setDataRange(((JRDesignThermometerPlot)plot).getDataRange());
            np.setValueDisplay(((JRDesignThermometerPlot)plot).getValueDisplay());
        }
        return np;
    }

    protected JRDesignThermometerPlot merge2ThermometerPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignThermometerPlot np = new JRDesignThermometerPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignMeterPlot) {
            np.setDataRange(((JRDesignMeterPlot)plot).getDataRange());
            np.setValueDisplay(((JRDesignMeterPlot)plot).getValueDisplay());
        }
        return np;
    }

    protected JRDesignPiePlot merge2PiePlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignPiePlot np = new JRDesignPiePlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignPie3DPlot) {
            np.setCircular(((JRDesignPie3DPlot)plot).getCircular());
            np.setLabelFormat(((JRDesignPie3DPlot)plot).getLabelFormat());
            np.setLegendLabelFormat(((JRDesignPie3DPlot)plot).getLegendLabelFormat());
            np.setItemLabel(((JRDesignPie3DPlot)plot).getItemLabel());
            np.setShowLabels(((JRDesignPie3DPlot)plot).getShowLabels());
        }
        return np;
    }

    protected JRDesignPie3DPlot merge2Pie3DPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignPie3DPlot np = new JRDesignPie3DPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignPiePlot) {
            np.setCircular(((JRDesignPiePlot)plot).getCircular());
            np.setLabelFormat(((JRDesignPiePlot)plot).getLabelFormat());
            np.setLegendLabelFormat(((JRDesignPiePlot)plot).getLegendLabelFormat());
            np.setItemLabel(((JRDesignPiePlot)plot).getItemLabel());
            np.setShowLabels(((JRDesignPiePlot)plot).getShowLabels());
        }
        return np;
    }

    protected JRDesignScatterPlot merge2ScatterPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignScatterPlot np = new JRDesignScatterPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBarPlot) {
            np.setXAxisLabelColor(((JRDesignBarPlot)plot).getCategoryAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignBarPlot)plot).getCategoryAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignBarPlot)plot).getCategoryAxisLabelFont());
            np.setXAxisLineColor(((JRDesignBarPlot)plot).getCategoryAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignBarPlot)plot).getCategoryAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignBarPlot)plot).getCategoryAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignBarPlot)plot).getCategoryAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignBarPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBarPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBarPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBarPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBarPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignBarPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignBarPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignBarPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignBarPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignBarPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignBarPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignBarPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignBarPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBar3DPlot) {
            np.setXAxisLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignBar3DPlot)plot).getCategoryAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisLabelFont());
            np.setXAxisLineColor(((JRDesignBar3DPlot)plot).getCategoryAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignBar3DPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignBar3DPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignBar3DPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignBar3DPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignBar3DPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignBar3DPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignBar3DPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignAreaPlot) {
            np.setXAxisLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignAreaPlot)plot).getCategoryAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisLabelFont());
            np.setXAxisLineColor(((JRDesignAreaPlot)plot).getCategoryAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignAreaPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignAreaPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignAreaPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignAreaPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignAreaPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignAreaPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignAreaPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignLinePlot) {
            np.setXAxisLabelColor(((JRDesignLinePlot)plot).getCategoryAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignLinePlot)plot).getCategoryAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignLinePlot)plot).getCategoryAxisLabelFont());
            np.setXAxisLineColor(((JRDesignLinePlot)plot).getCategoryAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignLinePlot)plot).getCategoryAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignLinePlot)plot).getCategoryAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignLinePlot)plot).getCategoryAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignLinePlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignLinePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignLinePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignLinePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignLinePlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignLinePlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignLinePlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignLinePlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignLinePlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignLinePlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignLinePlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignLinePlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignLinePlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignCandlestickPlot) {
            np.setXAxisLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignCandlestickPlot)plot).getTimeAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisLabelFont());
            np.setXAxisLineColor(((JRDesignCandlestickPlot)plot).getTimeAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignCandlestickPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignCandlestickPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignTimeSeriesPlot) {
            np.setXAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelFont());
            np.setXAxisLineColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignHighLowPlot) {
            np.setXAxisLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignHighLowPlot)plot).getTimeAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisLabelFont());
            np.setXAxisLineColor(((JRDesignHighLowPlot)plot).getTimeAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignHighLowPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignHighLowPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignHighLowPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignHighLowPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignHighLowPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignHighLowPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignHighLowPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBubblePlot) {
            np.setXAxisLabelColor(((JRDesignBubblePlot)plot).getXAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignBubblePlot)plot).getXAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignBubblePlot)plot).getXAxisLabelFont());
            np.setXAxisLineColor(((JRDesignBubblePlot)plot).getXAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignBubblePlot)plot).getXAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignBubblePlot)plot).getXAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignBubblePlot)plot).getXAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignBubblePlot)plot).getYAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignBubblePlot)plot).getYAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignBubblePlot)plot).getYAxisLabelFont());
            np.setYAxisLineColor(((JRDesignBubblePlot)plot).getYAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignBubblePlot)plot).getYAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignBubblePlot)plot).getYAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignBubblePlot)plot).getYAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignBubblePlot merge2BubblePlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignBubblePlot np = new JRDesignBubblePlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBarPlot) {
            np.setXAxisLabelColor(((JRDesignBarPlot)plot).getCategoryAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignBarPlot)plot).getCategoryAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignBarPlot)plot).getCategoryAxisLabelFont());
            np.setXAxisLineColor(((JRDesignBarPlot)plot).getCategoryAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignBarPlot)plot).getCategoryAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignBarPlot)plot).getCategoryAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignBarPlot)plot).getCategoryAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignBarPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBarPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBarPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBarPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBarPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignBarPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignBarPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignBarPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignBarPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignBarPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignBarPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignBarPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignBarPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBar3DPlot) {
            np.setXAxisLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignBar3DPlot)plot).getCategoryAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisLabelFont());
            np.setXAxisLineColor(((JRDesignBar3DPlot)plot).getCategoryAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignBar3DPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignBar3DPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignBar3DPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignBar3DPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignBar3DPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignBar3DPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignBar3DPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignAreaPlot) {
            np.setXAxisLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignAreaPlot)plot).getCategoryAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisLabelFont());
            np.setXAxisLineColor(((JRDesignAreaPlot)plot).getCategoryAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignAreaPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignAreaPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignAreaPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignAreaPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignAreaPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignAreaPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignAreaPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignLinePlot) {
            np.setXAxisLabelColor(((JRDesignLinePlot)plot).getCategoryAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignLinePlot)plot).getCategoryAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignLinePlot)plot).getCategoryAxisLabelFont());
            np.setXAxisLineColor(((JRDesignLinePlot)plot).getCategoryAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignLinePlot)plot).getCategoryAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignLinePlot)plot).getCategoryAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignLinePlot)plot).getCategoryAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignLinePlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignLinePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignLinePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignLinePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignLinePlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignLinePlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignLinePlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignLinePlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignLinePlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignLinePlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignLinePlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignLinePlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignLinePlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignCandlestickPlot) {
            np.setXAxisLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignCandlestickPlot)plot).getTimeAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisLabelFont());
            np.setXAxisLineColor(((JRDesignCandlestickPlot)plot).getTimeAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignCandlestickPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignCandlestickPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignTimeSeriesPlot) {
            np.setXAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelFont());
            np.setXAxisLineColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignHighLowPlot) {
            np.setXAxisLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignHighLowPlot)plot).getTimeAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisLabelFont());
            np.setXAxisLineColor(((JRDesignHighLowPlot)plot).getTimeAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignHighLowPlot)plot).getValueAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignHighLowPlot)plot).getValueAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignHighLowPlot)plot).getValueAxisLabelFont());
            np.setYAxisLineColor(((JRDesignHighLowPlot)plot).getValueAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignHighLowPlot)plot).getValueAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignHighLowPlot)plot).getValueAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignHighLowPlot)plot).getValueAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignScatterPlot) {
            np.setXAxisLabelColor(((JRDesignScatterPlot)plot).getXAxisLabelColor());
            np.setXAxisLabelExpression(((JRDesignScatterPlot)plot).getXAxisLabelExpression());
            np.setXAxisLabelFont(((JRDesignScatterPlot)plot).getXAxisLabelFont());
            np.setXAxisLineColor(((JRDesignScatterPlot)plot).getXAxisLineColor());
            np.setXAxisTickLabelColor(((JRDesignScatterPlot)plot).getXAxisTickLabelColor());
            np.setXAxisTickLabelFont(((JRDesignScatterPlot)plot).getXAxisTickLabelFont());
            np.setXAxisTickLabelMask(((JRDesignScatterPlot)plot).getXAxisTickLabelMask());
            np.setXAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMinValueExpression());
            np.setYAxisLabelColor(((JRDesignScatterPlot)plot).getYAxisLabelColor());
            np.setYAxisLabelExpression(((JRDesignScatterPlot)plot).getYAxisLabelExpression());
            np.setYAxisLabelFont(((JRDesignScatterPlot)plot).getYAxisLabelFont());
            np.setYAxisLineColor(((JRDesignScatterPlot)plot).getYAxisLineColor());
            np.setYAxisTickLabelColor(((JRDesignScatterPlot)plot).getYAxisTickLabelColor());
            np.setYAxisTickLabelFont(((JRDesignScatterPlot)plot).getYAxisTickLabelFont());
            np.setYAxisTickLabelMask(((JRDesignScatterPlot)plot).getYAxisTickLabelMask());
            np.setYAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignHighLowPlot merge2HighLowPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignHighLowPlot np = new JRDesignHighLowPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBarPlot) {
            np.setTimeAxisLabelColor(((JRDesignBarPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBarPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBarPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBarPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBarPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBarPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBarPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBarPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBarPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBarPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBarPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBarPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBarPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBarPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBarPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBarPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBarPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBarPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBarPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBarPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBar3DPlot) {
            np.setTimeAxisLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBar3DPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBar3DPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBar3DPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBar3DPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBar3DPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBar3DPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBar3DPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBar3DPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBar3DPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignAreaPlot) {
            np.setTimeAxisLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignAreaPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignAreaPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignAreaPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignAreaPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignAreaPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignAreaPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignAreaPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignAreaPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignAreaPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignLinePlot) {
            np.setTimeAxisLabelColor(((JRDesignLinePlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignLinePlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignLinePlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignLinePlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignLinePlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignLinePlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignLinePlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignLinePlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignLinePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignLinePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignLinePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignLinePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignLinePlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignLinePlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignLinePlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignLinePlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignLinePlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignLinePlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignLinePlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignLinePlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignCandlestickPlot) {
            np.setTimeAxisLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignCandlestickPlot)plot).getTimeAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignCandlestickPlot)plot).getTimeAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignCandlestickPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignCandlestickPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignTimeSeriesPlot) {
            np.setTimeAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBubblePlot) {
            np.setTimeAxisLabelColor(((JRDesignBubblePlot)plot).getXAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBubblePlot)plot).getXAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBubblePlot)plot).getXAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBubblePlot)plot).getXAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBubblePlot)plot).getXAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBubblePlot)plot).getXAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBubblePlot)plot).getXAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBubblePlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBubblePlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBubblePlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBubblePlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBubblePlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBubblePlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBubblePlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getYAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignScatterPlot) {
            np.setTimeAxisLabelColor(((JRDesignScatterPlot)plot).getXAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignScatterPlot)plot).getXAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignScatterPlot)plot).getXAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignScatterPlot)plot).getXAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignScatterPlot)plot).getXAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignScatterPlot)plot).getXAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignScatterPlot)plot).getXAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignScatterPlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignScatterPlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignScatterPlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignScatterPlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignScatterPlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignScatterPlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignScatterPlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignTimeSeriesPlot merge2TimeSeriesPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignTimeSeriesPlot np = new JRDesignTimeSeriesPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBarPlot) {
            np.setTimeAxisLabelColor(((JRDesignBarPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBarPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBarPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBarPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBarPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBarPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBarPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBarPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBarPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBarPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBarPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBarPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBarPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBarPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBarPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBarPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBarPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBarPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBarPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBarPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBar3DPlot) {
            np.setTimeAxisLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBar3DPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBar3DPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBar3DPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBar3DPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBar3DPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBar3DPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBar3DPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBar3DPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBar3DPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignAreaPlot) {
            np.setTimeAxisLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignAreaPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignAreaPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignAreaPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignAreaPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignAreaPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignAreaPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignAreaPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignAreaPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignAreaPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignLinePlot) {
            np.setTimeAxisLabelColor(((JRDesignLinePlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignLinePlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignLinePlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignLinePlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignLinePlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignLinePlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignLinePlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignLinePlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignLinePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignLinePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignLinePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignLinePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignLinePlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignLinePlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignLinePlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignLinePlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignLinePlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignLinePlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignLinePlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignLinePlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignCandlestickPlot) {
            np.setTimeAxisLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignCandlestickPlot)plot).getTimeAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignCandlestickPlot)plot).getTimeAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignCandlestickPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignCandlestickPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignHighLowPlot) {
            np.setTimeAxisLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignHighLowPlot)plot).getTimeAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignHighLowPlot)plot).getTimeAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignHighLowPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignHighLowPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignHighLowPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignHighLowPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignHighLowPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignHighLowPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignHighLowPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBubblePlot) {
            np.setTimeAxisLabelColor(((JRDesignBubblePlot)plot).getXAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBubblePlot)plot).getXAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBubblePlot)plot).getXAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBubblePlot)plot).getXAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBubblePlot)plot).getXAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBubblePlot)plot).getXAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBubblePlot)plot).getXAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBubblePlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBubblePlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBubblePlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBubblePlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBubblePlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBubblePlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBubblePlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getYAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignScatterPlot) {
            np.setTimeAxisLabelColor(((JRDesignScatterPlot)plot).getXAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignScatterPlot)plot).getXAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignScatterPlot)plot).getXAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignScatterPlot)plot).getXAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignScatterPlot)plot).getXAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignScatterPlot)plot).getXAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignScatterPlot)plot).getXAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignScatterPlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignScatterPlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignScatterPlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignScatterPlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignScatterPlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignScatterPlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignScatterPlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignCandlestickPlot merge2CandleStickPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignCandlestickPlot np = new JRDesignCandlestickPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBarPlot) {
            np.setTimeAxisLabelColor(((JRDesignBarPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBarPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBarPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBarPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBarPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBarPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBarPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBarPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBarPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBarPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBarPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBarPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBarPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBarPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBarPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBarPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBarPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBarPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBarPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBarPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBar3DPlot) {
            np.setTimeAxisLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBar3DPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBar3DPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBar3DPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBar3DPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBar3DPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBar3DPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBar3DPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBar3DPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBar3DPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignAreaPlot) {
            np.setTimeAxisLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignAreaPlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignAreaPlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignAreaPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignAreaPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignAreaPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignAreaPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignAreaPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignAreaPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignAreaPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignLinePlot) {
            np.setTimeAxisLabelColor(((JRDesignLinePlot)plot).getCategoryAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignLinePlot)plot).getCategoryAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignLinePlot)plot).getCategoryAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignLinePlot)plot).getCategoryAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignLinePlot)plot).getCategoryAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignLinePlot)plot).getCategoryAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignLinePlot)plot).getCategoryAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignLinePlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignLinePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignLinePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignLinePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignLinePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignLinePlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignLinePlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignLinePlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignLinePlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignLinePlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignLinePlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignLinePlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignLinePlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignTimeSeriesPlot) {
            np.setTimeAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignHighLowPlot) {
            np.setTimeAxisLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignHighLowPlot)plot).getTimeAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignHighLowPlot)plot).getTimeAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignHighLowPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignHighLowPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignHighLowPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignHighLowPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignHighLowPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignHighLowPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignHighLowPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBubblePlot) {
            np.setTimeAxisLabelColor(((JRDesignBubblePlot)plot).getXAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignBubblePlot)plot).getXAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignBubblePlot)plot).getXAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignBubblePlot)plot).getXAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignBubblePlot)plot).getXAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignBubblePlot)plot).getXAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignBubblePlot)plot).getXAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBubblePlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBubblePlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBubblePlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBubblePlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBubblePlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBubblePlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBubblePlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getYAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignScatterPlot) {
            np.setTimeAxisLabelColor(((JRDesignScatterPlot)plot).getXAxisLabelColor());
            np.setTimeAxisLabelExpression(((JRDesignScatterPlot)plot).getXAxisLabelExpression());
            np.setTimeAxisLabelFont(((JRDesignScatterPlot)plot).getXAxisLabelFont());
            np.setTimeAxisLineColor(((JRDesignScatterPlot)plot).getXAxisLineColor());
            np.setTimeAxisTickLabelColor(((JRDesignScatterPlot)plot).getXAxisTickLabelColor());
            np.setTimeAxisTickLabelFont(((JRDesignScatterPlot)plot).getXAxisTickLabelFont());
            np.setTimeAxisTickLabelMask(((JRDesignScatterPlot)plot).getXAxisTickLabelMask());
            np.setTimeAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignScatterPlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignScatterPlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignScatterPlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignScatterPlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignScatterPlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignScatterPlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignScatterPlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignAreaPlot merge2AreaPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignAreaPlot np = new JRDesignAreaPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBarPlot) {
            np.setCategoryAxisLabelColor(((JRDesignBarPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBarPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBarPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBarPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBarPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBarPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBarPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignBarPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBarPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBarPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBarPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBarPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBarPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBarPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBarPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBarPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBarPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBarPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBarPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBarPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBarPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBar3DPlot) {
            np.setCategoryAxisLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBar3DPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBar3DPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBar3DPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBar3DPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBar3DPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBar3DPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBar3DPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBar3DPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBar3DPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignLinePlot) {
            np.setCategoryAxisLabelColor(((JRDesignLinePlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignLinePlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignLinePlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignLinePlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignLinePlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignLinePlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignLinePlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignLinePlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignLinePlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignLinePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignLinePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignLinePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignLinePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignLinePlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignLinePlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignLinePlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignLinePlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignLinePlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignLinePlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignLinePlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignLinePlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignCandlestickPlot) {
            np.setCategoryAxisLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignCandlestickPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignCandlestickPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignCandlestickPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignCandlestickPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignTimeSeriesPlot) {
            np.setCategoryAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignHighLowPlot) {
            np.setCategoryAxisLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignHighLowPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignHighLowPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignHighLowPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignHighLowPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignHighLowPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignHighLowPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignHighLowPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignHighLowPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignHighLowPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBubblePlot) {
            np.setCategoryAxisLabelColor(((JRDesignBubblePlot)plot).getXAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBubblePlot)plot).getXAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBubblePlot)plot).getXAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBubblePlot)plot).getXAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBubblePlot)plot).getXAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBubblePlot)plot).getXAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBubblePlot)plot).getXAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBubblePlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBubblePlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBubblePlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBubblePlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBubblePlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBubblePlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBubblePlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getYAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignScatterPlot) {
            np.setCategoryAxisLabelColor(((JRDesignScatterPlot)plot).getXAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignScatterPlot)plot).getXAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignScatterPlot)plot).getXAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignScatterPlot)plot).getXAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignScatterPlot)plot).getXAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignScatterPlot)plot).getXAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignScatterPlot)plot).getXAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignScatterPlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignScatterPlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignScatterPlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignScatterPlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignScatterPlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignScatterPlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignScatterPlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignLinePlot merge2LinePlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignLinePlot np = new JRDesignLinePlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBarPlot) {
            np.setCategoryAxisLabelColor(((JRDesignBarPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBarPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBarPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBarPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBarPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBarPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBarPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignBarPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBarPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBarPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBarPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBarPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBarPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBarPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBarPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBarPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBarPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBarPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBarPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBarPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBarPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBar3DPlot) {
            np.setCategoryAxisLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBar3DPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBar3DPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBar3DPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBar3DPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBar3DPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBar3DPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBar3DPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBar3DPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBar3DPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignAreaPlot) {
            np.setCategoryAxisLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignAreaPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignAreaPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignAreaPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignAreaPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignAreaPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignAreaPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignAreaPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignAreaPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignAreaPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignCandlestickPlot) {
            np.setCategoryAxisLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignCandlestickPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignCandlestickPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignCandlestickPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignCandlestickPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignTimeSeriesPlot) {
            np.setCategoryAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignHighLowPlot) {
            np.setCategoryAxisLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignHighLowPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignHighLowPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignHighLowPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignHighLowPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignHighLowPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignHighLowPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignHighLowPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignHighLowPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignHighLowPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBubblePlot) {
            np.setCategoryAxisLabelColor(((JRDesignBubblePlot)plot).getXAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBubblePlot)plot).getXAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBubblePlot)plot).getXAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBubblePlot)plot).getXAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBubblePlot)plot).getXAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBubblePlot)plot).getXAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBubblePlot)plot).getXAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBubblePlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBubblePlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBubblePlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBubblePlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBubblePlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBubblePlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBubblePlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getYAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignScatterPlot) {
            np.setCategoryAxisLabelColor(((JRDesignScatterPlot)plot).getXAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignScatterPlot)plot).getXAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignScatterPlot)plot).getXAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignScatterPlot)plot).getXAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignScatterPlot)plot).getXAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignScatterPlot)plot).getXAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignScatterPlot)plot).getXAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignScatterPlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignScatterPlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignScatterPlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignScatterPlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignScatterPlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignScatterPlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignScatterPlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignBar3DPlot merge2Bar3DPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignBar3DPlot np = new JRDesignBar3DPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBarPlot) {
            np.setCategoryAxisLabelColor(((JRDesignBarPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBarPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBarPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBarPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBarPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBarPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBarPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignBarPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBarPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBarPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBarPlot)plot).getDomainAxisMinValueExpression());
            np.setItemLabel(((JRDesignBarPlot)plot).getItemLabel());
            np.setRangeAxisMaxValueExpression(((JRDesignBarPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBarPlot)plot).getRangeAxisMinValueExpression());
            np.setShowLabels(((JRDesignBarPlot)plot).getShowLabels());
            np.setValueAxisLabelColor(((JRDesignBarPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBarPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBarPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBarPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBarPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBarPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBarPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBarPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignAreaPlot) {
            np.setCategoryAxisLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignAreaPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignAreaPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignAreaPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignAreaPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignAreaPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignAreaPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignAreaPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignAreaPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignAreaPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignLinePlot) {
            np.setCategoryAxisLabelColor(((JRDesignLinePlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignLinePlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignLinePlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignLinePlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignLinePlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignLinePlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignLinePlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignLinePlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignLinePlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignLinePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignLinePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignLinePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignLinePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignLinePlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignLinePlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignLinePlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignLinePlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignLinePlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignLinePlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignLinePlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignLinePlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignCandlestickPlot) {
            np.setCategoryAxisLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignCandlestickPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignCandlestickPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignCandlestickPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignCandlestickPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignTimeSeriesPlot) {
            np.setCategoryAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignHighLowPlot) {
            np.setCategoryAxisLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignHighLowPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignHighLowPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignHighLowPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignHighLowPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignHighLowPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignHighLowPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignHighLowPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignHighLowPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignHighLowPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBubblePlot) {
            np.setCategoryAxisLabelColor(((JRDesignBubblePlot)plot).getXAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBubblePlot)plot).getXAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBubblePlot)plot).getXAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBubblePlot)plot).getXAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBubblePlot)plot).getXAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBubblePlot)plot).getXAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBubblePlot)plot).getXAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBubblePlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBubblePlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBubblePlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBubblePlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBubblePlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBubblePlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBubblePlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getYAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignScatterPlot) {
            np.setCategoryAxisLabelColor(((JRDesignScatterPlot)plot).getXAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignScatterPlot)plot).getXAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignScatterPlot)plot).getXAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignScatterPlot)plot).getXAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignScatterPlot)plot).getXAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignScatterPlot)plot).getXAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignScatterPlot)plot).getXAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignScatterPlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignScatterPlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignScatterPlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignScatterPlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignScatterPlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignScatterPlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignScatterPlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignBarPlot merge2BarPlot(JRDesignChart chart, JRChartPlot plot) {
        JRDesignBarPlot np = new JRDesignBarPlot(chart.getPlot(), (JRChart)chart);
        if (plot instanceof JRDesignBar3DPlot) {
            np.setCategoryAxisLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBar3DPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBar3DPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignBar3DPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBar3DPlot)plot).getDomainAxisMinValueExpression());
            np.setItemLabel(((JRDesignBar3DPlot)plot).getItemLabel());
            np.setRangeAxisMaxValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBar3DPlot)plot).getRangeAxisMinValueExpression());
            np.setShowLabels(((JRDesignBar3DPlot)plot).getShowLabels());
            np.setValueAxisLabelColor(((JRDesignBar3DPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBar3DPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBar3DPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBar3DPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBar3DPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBar3DPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBar3DPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBar3DPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignAreaPlot) {
            np.setCategoryAxisLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignAreaPlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignAreaPlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignAreaPlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignAreaPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignAreaPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignAreaPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignAreaPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignAreaPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignAreaPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignAreaPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignAreaPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignAreaPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignAreaPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignLinePlot) {
            np.setCategoryAxisLabelColor(((JRDesignLinePlot)plot).getCategoryAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignLinePlot)plot).getCategoryAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignLinePlot)plot).getCategoryAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignLinePlot)plot).getCategoryAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignLinePlot)plot).getCategoryAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignLinePlot)plot).getCategoryAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignLinePlot)plot).getCategoryAxisTickLabelMask());
            np.setCategoryAxisTickLabelRotation(((JRDesignLinePlot)plot).getCategoryAxisTickLabelRotation());
            np.setCategoryAxisVerticalTickLabels(((JRDesignLinePlot)plot).getCategoryAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignLinePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignLinePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignLinePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignLinePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignLinePlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignLinePlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignLinePlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignLinePlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignLinePlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignLinePlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignLinePlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignLinePlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignCandlestickPlot) {
            np.setCategoryAxisLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignCandlestickPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignCandlestickPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignCandlestickPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignCandlestickPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignCandlestickPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignCandlestickPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignCandlestickPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignTimeSeriesPlot) {
            np.setCategoryAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignTimeSeriesPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignTimeSeriesPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignTimeSeriesPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignTimeSeriesPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignHighLowPlot) {
            np.setCategoryAxisLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignHighLowPlot)plot).getTimeAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignHighLowPlot)plot).getTimeAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignHighLowPlot)plot).getTimeAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getTimeAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignHighLowPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignHighLowPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignHighLowPlot)plot).getValueAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignHighLowPlot)plot).getValueAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignHighLowPlot)plot).getValueAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignHighLowPlot)plot).getValueAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignHighLowPlot)plot).getValueAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignHighLowPlot)plot).getValueAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignHighLowPlot)plot).getValueAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignHighLowPlot)plot).getValueAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignBubblePlot) {
            np.setCategoryAxisLabelColor(((JRDesignBubblePlot)plot).getXAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignBubblePlot)plot).getXAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignBubblePlot)plot).getXAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignBubblePlot)plot).getXAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignBubblePlot)plot).getXAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignBubblePlot)plot).getXAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignBubblePlot)plot).getXAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignBubblePlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignBubblePlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignBubblePlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignBubblePlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignBubblePlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignBubblePlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignBubblePlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignBubblePlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignBubblePlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignBubblePlot)plot).getYAxisVerticalTickLabels());
        } else if (plot instanceof JRDesignScatterPlot) {
            np.setCategoryAxisLabelColor(((JRDesignScatterPlot)plot).getXAxisLabelColor());
            np.setCategoryAxisLabelExpression(((JRDesignScatterPlot)plot).getXAxisLabelExpression());
            np.setCategoryAxisLabelFont(((JRDesignScatterPlot)plot).getXAxisLabelFont());
            np.setCategoryAxisLineColor(((JRDesignScatterPlot)plot).getXAxisLineColor());
            np.setCategoryAxisTickLabelColor(((JRDesignScatterPlot)plot).getXAxisTickLabelColor());
            np.setCategoryAxisTickLabelFont(((JRDesignScatterPlot)plot).getXAxisTickLabelFont());
            np.setCategoryAxisTickLabelMask(((JRDesignScatterPlot)plot).getXAxisTickLabelMask());
            np.setCategoryAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getXAxisVerticalTickLabels());
            np.setDomainAxisMaxValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMaxValueExpression());
            np.setDomainAxisMinValueExpression(((JRDesignScatterPlot)plot).getDomainAxisMinValueExpression());
            np.setRangeAxisMaxValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMaxValueExpression());
            np.setRangeAxisMinValueExpression(((JRDesignScatterPlot)plot).getRangeAxisMinValueExpression());
            np.setValueAxisLabelColor(((JRDesignScatterPlot)plot).getYAxisLabelColor());
            np.setValueAxisLabelExpression(((JRDesignScatterPlot)plot).getYAxisLabelExpression());
            np.setValueAxisLabelFont(((JRDesignScatterPlot)plot).getYAxisLabelFont());
            np.setValueAxisLineColor(((JRDesignScatterPlot)plot).getYAxisLineColor());
            np.setValueAxisTickLabelColor(((JRDesignScatterPlot)plot).getYAxisTickLabelColor());
            np.setValueAxisTickLabelFont(((JRDesignScatterPlot)plot).getYAxisTickLabelFont());
            np.setValueAxisTickLabelMask(((JRDesignScatterPlot)plot).getYAxisTickLabelMask());
            np.setValueAxisVerticalTickLabels(((JRDesignScatterPlot)plot).getYAxisVerticalTickLabels());
        }
        return np;
    }

    protected JRDesignTimeSeriesDataset merge2TimeSeriesDataset(JRChartDataset ds) {
        JRDesignTimeSeriesDataset nds;
        block5: {
            block7: {
                block6: {
                    block4: {
                        nds = new JRDesignTimeSeriesDataset(ds);
                        if (!(ds instanceof JRDesignXyDataset)) break block4;
                        JRXySeries[] jRXySeriesArray = ((JRDesignXyDataset)ds).getSeries();
                        int n = jRXySeriesArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JRXySeries s = jRXySeriesArray[n2];
                            JRDesignTimeSeries ns = new JRDesignTimeSeries();
                            ns.setItemHyperlink(s.getItemHyperlink());
                            ns.setSeriesExpression(s.getSeriesExpression());
                            ns.setTimePeriodExpression(s.getXValueExpression());
                            ns.setValueExpression(s.getYValueExpression());
                            nds.addTimeSeries((JRTimeSeries)ns);
                            ++n2;
                        }
                        break block5;
                    }
                    if (!(ds instanceof JRDesignCategoryDataset)) break block6;
                    JRCategorySeries[] jRCategorySeriesArray = ((JRDesignCategoryDataset)ds).getSeries();
                    int n = jRCategorySeriesArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        JRCategorySeries s = jRCategorySeriesArray[n3];
                        JRDesignTimeSeries ns = new JRDesignTimeSeries();
                        ns.setItemHyperlink(s.getItemHyperlink());
                        ns.setSeriesExpression(s.getSeriesExpression());
                        ns.setTimePeriodExpression(s.getCategoryExpression());
                        ns.setValueExpression(s.getValueExpression());
                        nds.addTimeSeries((JRTimeSeries)ns);
                        ++n3;
                    }
                    break block5;
                }
                if (!(ds instanceof JRDesignXyDataset)) break block7;
                JRXySeries[] jRXySeriesArray = ((JRDesignXyDataset)ds).getSeries();
                int n = jRXySeriesArray.length;
                int n4 = 0;
                while (n4 < n) {
                    JRXySeries s = jRXySeriesArray[n4];
                    JRDesignTimeSeries ns = new JRDesignTimeSeries();
                    ns.setItemHyperlink(s.getItemHyperlink());
                    ns.setSeriesExpression(s.getSeriesExpression());
                    ns.setTimePeriodExpression(s.getXValueExpression());
                    ns.setValueExpression(s.getYValueExpression());
                    nds.addTimeSeries((JRTimeSeries)ns);
                    ++n4;
                }
                break block5;
            }
            if (!(ds instanceof JRDesignGanttDataset)) break block5;
            JRGanttSeries[] jRGanttSeriesArray = ((JRDesignGanttDataset)ds).getSeries();
            int n = jRGanttSeriesArray.length;
            int n5 = 0;
            while (n5 < n) {
                JRGanttSeries s = jRGanttSeriesArray[n5];
                JRDesignTimeSeries ns = new JRDesignTimeSeries();
                ns.setItemHyperlink(s.getItemHyperlink());
                ns.setSeriesExpression(s.getSeriesExpression());
                nds.addTimeSeries((JRTimeSeries)ns);
                ++n5;
            }
        }
        return nds;
    }

    protected JRDesignGanttDataset merge2GanttDataset(JRChartDataset ds) {
        JRDesignGanttDataset nds;
        block5: {
            block7: {
                block6: {
                    block4: {
                        nds = new JRDesignGanttDataset(ds);
                        if (!(ds instanceof JRDesignXyDataset)) break block4;
                        JRXySeries[] jRXySeriesArray = ((JRDesignXyDataset)ds).getSeries();
                        int n = jRXySeriesArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JRXySeries s = jRXySeriesArray[n2];
                            JRDesignGanttSeries ns = new JRDesignGanttSeries();
                            ns.setItemHyperlink(s.getItemHyperlink());
                            ns.setSeriesExpression(s.getSeriesExpression());
                            nds.addGanttSeries((JRGanttSeries)ns);
                            ++n2;
                        }
                        break block5;
                    }
                    if (!(ds instanceof JRDesignCategoryDataset)) break block6;
                    JRCategorySeries[] jRCategorySeriesArray = ((JRDesignCategoryDataset)ds).getSeries();
                    int n = jRCategorySeriesArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        JRCategorySeries s = jRCategorySeriesArray[n3];
                        JRDesignGanttSeries ns = new JRDesignGanttSeries();
                        ns.setItemHyperlink(s.getItemHyperlink());
                        ns.setSeriesExpression(s.getSeriesExpression());
                        nds.addGanttSeries((JRGanttSeries)ns);
                        ++n3;
                    }
                    break block5;
                }
                if (!(ds instanceof JRDesignXyDataset)) break block7;
                JRXySeries[] jRXySeriesArray = ((JRDesignXyDataset)ds).getSeries();
                int n = jRXySeriesArray.length;
                int n4 = 0;
                while (n4 < n) {
                    JRXySeries s = jRXySeriesArray[n4];
                    JRDesignGanttSeries ns = new JRDesignGanttSeries();
                    ns.setItemHyperlink(s.getItemHyperlink());
                    ns.setSeriesExpression(s.getSeriesExpression());
                    nds.addGanttSeries((JRGanttSeries)ns);
                    ++n4;
                }
                break block5;
            }
            if (!(ds instanceof JRDesignTimeSeriesDataset)) break block5;
            JRTimeSeries[] jRTimeSeriesArray = ((JRDesignTimeSeriesDataset)ds).getSeries();
            int n = jRTimeSeriesArray.length;
            int n5 = 0;
            while (n5 < n) {
                JRTimeSeries s = jRTimeSeriesArray[n5];
                JRDesignGanttSeries ns = new JRDesignGanttSeries();
                ns.setItemHyperlink(s.getItemHyperlink());
                ns.setSeriesExpression(s.getSeriesExpression());
                nds.addGanttSeries((JRGanttSeries)ns);
                ++n5;
            }
        }
        return nds;
    }

    protected JRDesignXyzDataset merge2XyzDataset(JRChartDataset ds) {
        JRDesignXyzDataset nds;
        block5: {
            block7: {
                block6: {
                    block4: {
                        nds = new JRDesignXyzDataset(ds);
                        if (!(ds instanceof JRDesignXyDataset)) break block4;
                        JRXySeries[] jRXySeriesArray = ((JRDesignXyDataset)ds).getSeries();
                        int n = jRXySeriesArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JRXySeries s = jRXySeriesArray[n2];
                            JRDesignXyzSeries ns = new JRDesignXyzSeries();
                            ns.setItemHyperlink(s.getItemHyperlink());
                            ns.setSeriesExpression(s.getSeriesExpression());
                            ns.setXValueExpression(s.getXValueExpression());
                            ns.setYValueExpression(s.getYValueExpression());
                            nds.addXyzSeries((JRXyzSeries)ns);
                            ++n2;
                        }
                        break block5;
                    }
                    if (!(ds instanceof JRDesignCategoryDataset)) break block6;
                    JRCategorySeries[] jRCategorySeriesArray = ((JRDesignCategoryDataset)ds).getSeries();
                    int n = jRCategorySeriesArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        JRCategorySeries s = jRCategorySeriesArray[n3];
                        JRDesignXyzSeries ns = new JRDesignXyzSeries();
                        ns.setItemHyperlink(s.getItemHyperlink());
                        ns.setSeriesExpression(s.getSeriesExpression());
                        ns.setXValueExpression(s.getCategoryExpression());
                        ns.setYValueExpression(s.getValueExpression());
                        nds.addXyzSeries((JRXyzSeries)ns);
                        ++n3;
                    }
                    break block5;
                }
                if (!(ds instanceof JRDesignGanttDataset)) break block7;
                JRGanttSeries[] jRGanttSeriesArray = ((JRDesignGanttDataset)ds).getSeries();
                int n = jRGanttSeriesArray.length;
                int n4 = 0;
                while (n4 < n) {
                    JRGanttSeries s = jRGanttSeriesArray[n4];
                    JRDesignXyzSeries ns = new JRDesignXyzSeries();
                    ns.setItemHyperlink(s.getItemHyperlink());
                    ns.setSeriesExpression(s.getSeriesExpression());
                    nds.addXyzSeries((JRXyzSeries)ns);
                    ++n4;
                }
                break block5;
            }
            if (!(ds instanceof JRDesignTimeSeriesDataset)) break block5;
            JRTimeSeries[] jRTimeSeriesArray = ((JRDesignTimeSeriesDataset)ds).getSeries();
            int n = jRTimeSeriesArray.length;
            int n5 = 0;
            while (n5 < n) {
                JRTimeSeries s = jRTimeSeriesArray[n5];
                JRDesignXyzSeries ns = new JRDesignXyzSeries();
                ns.setItemHyperlink(s.getItemHyperlink());
                ns.setSeriesExpression(s.getSeriesExpression());
                ns.setXValueExpression(s.getTimePeriodExpression());
                ns.setYValueExpression(s.getValueExpression());
                nds.addXyzSeries((JRXyzSeries)ns);
                ++n5;
            }
        }
        return nds;
    }

    protected JRDesignXyDataset merge2XyDataset(JRChartDataset ds) {
        JRDesignXyDataset nds;
        block5: {
            block7: {
                block6: {
                    block4: {
                        nds = new JRDesignXyDataset(ds);
                        if (!(ds instanceof JRDesignXyzDataset)) break block4;
                        JRXyzSeries[] jRXyzSeriesArray = ((JRDesignXyzDataset)ds).getSeries();
                        int n = jRXyzSeriesArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JRXyzSeries s = jRXyzSeriesArray[n2];
                            JRDesignXySeries ns = new JRDesignXySeries();
                            ns.setItemHyperlink(s.getItemHyperlink());
                            ns.setSeriesExpression(s.getSeriesExpression());
                            ns.setXValueExpression(s.getXValueExpression());
                            ns.setYValueExpression(s.getYValueExpression());
                            nds.addXySeries((JRXySeries)ns);
                            ++n2;
                        }
                        break block5;
                    }
                    if (!(ds instanceof JRDesignCategoryDataset)) break block6;
                    JRCategorySeries[] jRCategorySeriesArray = ((JRDesignCategoryDataset)ds).getSeries();
                    int n = jRCategorySeriesArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        JRCategorySeries s = jRCategorySeriesArray[n3];
                        JRDesignXySeries ns = new JRDesignXySeries();
                        ns.setItemHyperlink(s.getItemHyperlink());
                        ns.setSeriesExpression(s.getSeriesExpression());
                        ns.setXValueExpression(s.getCategoryExpression());
                        ns.setYValueExpression(s.getValueExpression());
                        nds.addXySeries((JRXySeries)ns);
                        ++n3;
                    }
                    break block5;
                }
                if (!(ds instanceof JRDesignGanttDataset)) break block7;
                JRGanttSeries[] jRGanttSeriesArray = ((JRDesignGanttDataset)ds).getSeries();
                int n = jRGanttSeriesArray.length;
                int n4 = 0;
                while (n4 < n) {
                    JRGanttSeries s = jRGanttSeriesArray[n4];
                    JRDesignXySeries ns = new JRDesignXySeries();
                    ns.setItemHyperlink(s.getItemHyperlink());
                    ns.setSeriesExpression(s.getSeriesExpression());
                    nds.addXySeries((JRXySeries)ns);
                    ++n4;
                }
                break block5;
            }
            if (!(ds instanceof JRDesignTimeSeriesDataset)) break block5;
            JRTimeSeries[] jRTimeSeriesArray = ((JRDesignTimeSeriesDataset)ds).getSeries();
            int n = jRTimeSeriesArray.length;
            int n5 = 0;
            while (n5 < n) {
                JRTimeSeries s = jRTimeSeriesArray[n5];
                JRDesignXySeries ns = new JRDesignXySeries();
                ns.setItemHyperlink(s.getItemHyperlink());
                ns.setSeriesExpression(s.getSeriesExpression());
                ns.setXValueExpression(s.getTimePeriodExpression());
                ns.setYValueExpression(s.getValueExpression());
                nds.addXySeries((JRXySeries)ns);
                ++n5;
            }
        }
        return nds;
    }

    protected JRDesignCategoryDataset merge2CategoryDataset(JRChartDataset ds) {
        JRDesignCategoryDataset nds;
        block5: {
            block7: {
                block6: {
                    block4: {
                        nds = new JRDesignCategoryDataset(ds);
                        if (!(ds instanceof JRDesignXyzDataset)) break block4;
                        JRXyzSeries[] jRXyzSeriesArray = ((JRDesignXyzDataset)ds).getSeries();
                        int n = jRXyzSeriesArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            JRXyzSeries s = jRXyzSeriesArray[n2];
                            JRDesignCategorySeries ns = new JRDesignCategorySeries();
                            ns.setItemHyperlink(s.getItemHyperlink());
                            ns.setSeriesExpression(s.getSeriesExpression());
                            ns.setCategoryExpression(s.getXValueExpression());
                            ns.setValueExpression(s.getYValueExpression());
                            nds.addCategorySeries((JRCategorySeries)ns);
                            ++n2;
                        }
                        break block5;
                    }
                    if (!(ds instanceof JRDesignXyDataset)) break block6;
                    JRXySeries[] jRXySeriesArray = ((JRDesignXyDataset)ds).getSeries();
                    int n = jRXySeriesArray.length;
                    int n3 = 0;
                    while (n3 < n) {
                        JRXySeries s = jRXySeriesArray[n3];
                        JRDesignCategorySeries ns = new JRDesignCategorySeries();
                        ns.setItemHyperlink(s.getItemHyperlink());
                        ns.setSeriesExpression(s.getSeriesExpression());
                        ns.setCategoryExpression(s.getXValueExpression());
                        ns.setValueExpression(s.getYValueExpression());
                        nds.addCategorySeries((JRCategorySeries)ns);
                        ++n3;
                    }
                    break block5;
                }
                if (!(ds instanceof JRDesignGanttDataset)) break block7;
                JRGanttSeries[] jRGanttSeriesArray = ((JRDesignGanttDataset)ds).getSeries();
                int n = jRGanttSeriesArray.length;
                int n4 = 0;
                while (n4 < n) {
                    JRGanttSeries s = jRGanttSeriesArray[n4];
                    JRDesignCategorySeries ns = new JRDesignCategorySeries();
                    ns.setItemHyperlink(s.getItemHyperlink());
                    ns.setSeriesExpression(s.getSeriesExpression());
                    nds.addCategorySeries((JRCategorySeries)ns);
                    ++n4;
                }
                break block5;
            }
            if (!(ds instanceof JRDesignTimeSeriesDataset)) break block5;
            JRTimeSeries[] jRTimeSeriesArray = ((JRDesignTimeSeriesDataset)ds).getSeries();
            int n = jRTimeSeriesArray.length;
            int n5 = 0;
            while (n5 < n) {
                JRTimeSeries s = jRTimeSeriesArray[n5];
                JRDesignCategorySeries ns = new JRDesignCategorySeries();
                ns.setItemHyperlink(s.getItemHyperlink());
                ns.setSeriesExpression(s.getSeriesExpression());
                ns.setCategoryExpression(s.getTimePeriodExpression());
                ns.setValueExpression(s.getValueExpression());
                nds.addCategorySeries((JRCategorySeries)ns);
                ++n5;
            }
        }
        return nds;
    }

    public boolean canFlipToNextPage() {
        JRDesignChart old;
        if (this.chartType == 19 && this.chartType != (old = this.chart.getValue()).getChartType()) {
            old.setChartType(this.chartType);
        }
        return super.canFlipToNextPage();
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.chartsGallery.setFocus();
        }
    }

    private void fillTableb4j(Gallery table, GalleryItem rootItem) {
        table.setRedraw(false);
        ChartTypeWizardPage.getTableItem((byte)1, rootItem);
        ChartTypeWizardPage.getTableItem((byte)20, rootItem);
        ChartTypeWizardPage.getTableItem((byte)13, rootItem);
        ChartTypeWizardPage.getTableItem((byte)3, rootItem);
        ChartTypeWizardPage.getTableItem((byte)2, rootItem);
        ChartTypeWizardPage.getTableItem((byte)14, rootItem);
        ChartTypeWizardPage.getTableItem((byte)12, rootItem);
        ChartTypeWizardPage.getTableItem((byte)11, rootItem);
        ChartTypeWizardPage.getTableItem((byte)7, rootItem);
        ChartTypeWizardPage.getTableItem((byte)15, rootItem);
        ChartTypeWizardPage.getTableItem((byte)9, rootItem);
        ChartTypeWizardPage.getTableItem((byte)8, rootItem);
        ChartTypeWizardPage.getTableItem((byte)4, rootItem);
        ChartTypeWizardPage.getTableItem((byte)5, rootItem);
        ChartTypeWizardPage.getTableItem((byte)16, rootItem);
        ChartTypeWizardPage.getTableItem((byte)6, rootItem);
        ChartTypeWizardPage.getTableItem((byte)10, rootItem);
        ChartTypeWizardPage.getTableItem((byte)18, rootItem);
        ChartTypeWizardPage.getTableItem((byte)17, rootItem);
        ChartTypeWizardPage.getTableItem((byte)21, rootItem);
        ChartTypeWizardPage.getTableItem((byte)19, rootItem);
        table.setRedraw(true);
    }

    public static GalleryItem getTableItem(byte chartype, GalleryItem gr) {
        switch (chartype) {
            case 1: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_area_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/area_big.png");
                ti.setData((Object)1);
                return ti;
            }
            case 3: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_bar_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/bar_big.png");
                ti.setData((Object)3);
                return ti;
            }
            case 2: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_bar3d_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/bar3d_big.png");
                ti.setData((Object)2);
                return ti;
            }
            case 4: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_bubble_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/bubble_big.png");
                ti.setData((Object)4);
                return ti;
            }
            case 5: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_candlestick_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/candlestick_big.png");
                ti.setData((Object)5);
                return ti;
            }
            case 21: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_gantt);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/gantt_big.png");
                ti.setData((Object)21);
                return ti;
            }
            case 6: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_highlow_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/highlow_big.png");
                ti.setData((Object)6);
                return ti;
            }
            case 7: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_line_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/line_big.png");
                ti.setData((Object)7);
                return ti;
            }
            case 17: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_meter_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/meter_big.png");
                ti.setData((Object)17);
                return ti;
            }
            case 19: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_multiaxes_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/multiaxis_big.png");
                ti.setData((Object)19);
                return ti;
            }
            case 9: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_pie_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/pie_big.png");
                ti.setData((Object)9);
                return ti;
            }
            case 8: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_pie3d_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/pie3d_big.png");
                ti.setData((Object)8);
                return ti;
            }
            case 10: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_scatter_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/scatter_big.png");
                ti.setData((Object)10);
                return ti;
            }
            case 20: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_stacked_area);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/stackedarea_big.png");
                ti.setData((Object)20);
                return ti;
            }
            case 12: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_stacked_bar);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/stackedbar_big.png");
                ti.setData((Object)12);
                return ti;
            }
            case 11: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_stacked_bar3D);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/stackedbar3d_big.png");
                ti.setData((Object)11);
                return ti;
            }
            case 18: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_thermometer_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/thermometer_big.png");
                ti.setData((Object)18);
                return ti;
            }
            case 16: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_timeseries_chart);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/timeseries_big.png");
                ti.setData((Object)16);
                return ti;
            }
            case 13: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_xy_area);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/xyarea_big.png");
                ti.setData((Object)13);
                return ti;
            }
            case 14: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_xy_bar);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/xybar_big.png");
                ti.setData((Object)14);
                return ti;
            }
            case 15: {
                GalleryItem ti = new GalleryItem(gr, 0);
                ti.setText(Messages.common_xy_line);
                ChartTypeWizardPage.setGallyeryItemImageInfo(ti, "/icons/xyline_big.png");
                ti.setData((Object)15);
                return ti;
            }
        }
        return null;
    }

    private static void setGallyeryItemImageInfo(GalleryItem item, String imagePath) {
        UIUtil.setGallyeryItemImageInfo((GalleryItem)item, (String)"com.jaspersoft.studio.components", (String)imagePath, selectedImages, standardImages);
    }
}

