/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data;

import com.jaspersoft.studio.components.chart.wizard.fragments.data.ADSComponent;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog.SeriesDialog;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.series.GanttSeries;
import com.jaspersoft.studio.components.chart.wizard.fragments.data.widget.DatasetSeriesWidget;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.property.dataset.ExpressionWidget;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.design.JRDesignGanttDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementDataset;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class DSGantt
extends ADSComponent {
    private JRDesignGanttDataset dataset;
    private ExpressionWidget labelWidget;
    private ExpressionWidget percent;
    private ExpressionWidget endDate;
    private ExpressionWidget starDate;
    private ExpressionWidget subtask;
    private ExpressionWidget task;
    private Combo seriesCombo;

    public DSGantt(Composite composite, DatasetSeriesWidget dsWidget) {
        super(composite, dsWidget);
    }

    @Override
    public String getName() {
        return "Gantt Dataset";
    }

    @Override
    public void setData(JSSDrawVisitor drawVisitor, JRDesignElement jrChart, JRDesignElementDataset eDataset, JasperReportsConfiguration jrContext) {
        Assert.isTrue((boolean)(eDataset instanceof JRDesignGanttDataset));
        super.setData(drawVisitor, jrChart, eDataset, jrContext);
        this.dataset = (JRDesignGanttDataset)eDataset;
        this.setSeries(0);
    }

    private void setSeries(int selection) {
        List seriesList = this.dataset.getSeriesList();
        if (!seriesList.isEmpty()) {
            String[] srnames = new String[seriesList.size()];
            int i = 0;
            while (i < seriesList.size()) {
                JRGanttSeries cs = (JRGanttSeries)seriesList.get(i);
                JRExpression se = cs.getSeriesExpression();
                srnames[i] = se != null && se.getText() != null ? se.getText() : "";
                ++i;
            }
            this.seriesCombo.setItems(srnames);
            this.seriesCombo.select(selection);
            this.handleSelectSeries(selection);
        } else {
            this.seriesCombo.setItems(new String[0]);
            this.handleSelectSeries(-1);
        }
    }

    private void handleSelectSeries(int selection) {
        JRGanttSeries serie = null;
        if (selection >= 0 && selection < this.dataset.getSeriesList().size()) {
            serie = (JRGanttSeries)this.dataset.getSeriesList().get(selection);
        }
        this.task.bindObject(serie, "TaskExpression");
        this.subtask.bindObject(serie, "SubtaskExpression");
        this.starDate.bindObject((Object)serie, "StartDateExpression");
        this.endDate.bindObject((Object)serie, "EndDateExpression");
        this.percent.bindObject((Object)serie, "PercentExpression");
        this.labelWidget.bindObject((Object)serie, "LabelExpression");
        this.task.setEnabled(serie != null);
        this.subtask.setEnabled(serie != null);
        this.starDate.setEnabled(serie != null);
        this.endDate.setEnabled(serie != null);
        this.percent.setEnabled(serie != null);
        this.labelWidget.setEnabled(serie != null);
    }

    @Override
    protected Control createChartTop(Composite composite) {
        Composite yCompo = new Composite(composite, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(10, false));
        Label lbl = new Label(yCompo, 0);
        lbl.setText("Series");
        this.seriesCombo = new Combo(yCompo, 2056);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.seriesCombo.setLayoutData((Object)gd);
        this.seriesCombo.setItems(new String[]{"series 1"});
        this.seriesCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DSGantt.this.handleSelectSeries(DSGantt.this.seriesCombo.getSelectionIndex());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        final Button btn = new Button(yCompo, 0x800008);
        btn.setText("...");
        btn.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                GanttSeries serie = new GanttSeries();
                SeriesDialog<JRGanttSeries> dlg = new SeriesDialog<JRGanttSeries>(btn.getShell(), serie);
                dlg.setExpressionContext(DSGantt.this.expContext);
                List oldList = DSGantt.this.dataset.getSeriesList();
                int oldsel = DSGantt.this.seriesCombo.getSelectionIndex();
                JRGanttSeries selected = null;
                if (oldsel >= 0) {
                    selected = (JRGanttSeries)oldList.get(oldsel);
                }
                serie.setList(oldList);
                if (dlg.open() == 0) {
                    List<JRGanttSeries> newlist = serie.getList();
                    JRGanttSeries[] jRGanttSeriesArray = DSGantt.this.dataset.getSeries();
                    int n = jRGanttSeriesArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        JRGanttSeries item = jRGanttSeriesArray[n2];
                        DSGantt.this.dataset.removeGanttSeries(item);
                        ++n2;
                    }
                    for (JRGanttSeries item : serie.getList()) {
                        DSGantt.this.dataset.addGanttSeries(item);
                    }
                    int sel = selected != null && newlist.indexOf(selected) >= 0 ? newlist.indexOf(selected) : 0;
                    DSGantt.this.setSeries(sel);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        return yCompo;
    }

    @Override
    protected Control createChartLeft(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.task = new ExpressionWidget(yCompo, "Task");
        this.subtask = new ExpressionWidget(yCompo, "Subtask");
        return yCompo;
    }

    @Override
    protected Control createChartBottom(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(64));
        yCompo.setLayout((Layout)new GridLayout(9, false));
        this.starDate = new ExpressionWidget(yCompo, "Start Date");
        this.endDate = new ExpressionWidget(yCompo, "End Date");
        this.percent = new ExpressionWidget(yCompo, "Percent");
        return yCompo;
    }

    @Override
    protected Control createChartRight(Composite parent) {
        Composite yCompo = new Composite(parent, 0);
        yCompo.setLayoutData((Object)new GridData(768));
        yCompo.setLayout((Layout)new GridLayout(3, false));
        this.labelWidget = new ExpressionWidget(yCompo, "Label");
        return yCompo;
    }

    @Override
    public void setExpressionContext(ExpressionContext expContext) {
        super.setExpressionContext(expContext);
        this.endDate.setExpressionContext(expContext);
        this.labelWidget.setExpressionContext(expContext);
        this.starDate.setExpressionContext(expContext);
        this.subtask.setExpressionContext(expContext);
        this.task.setExpressionContext(expContext);
        this.percent.setExpressionContext(expContext);
    }
}

