/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chart.wizard.fragments.data.dialog;

import com.jaspersoft.studio.components.chart.property.descriptor.CustomizerPropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import net.sf.jasperreports.engine.JRExpression;

public class DtoPropertyEditor
implements IPropertyEditor {
    private CustomizerPropertyExpressionsDTO propertiesDTO;
    private String keyPrefix;

    public DtoPropertyEditor(String keyPrefix, CustomizerPropertyExpressionsDTO propertiesDTO) {
        this.propertiesDTO = propertiesDTO;
        this.keyPrefix = keyPrefix;
    }

    public String getPropertyValue(String propertyName) {
        PropertyExpressionDTO prop = this.propertiesDTO.getProperty(String.valueOf(this.keyPrefix) + propertyName, false);
        if (prop != null) {
            return prop.getValue();
        }
        return null;
    }

    public JRExpression getPropertyValueExpression(String propertyName) {
        PropertyExpressionDTO prop = this.propertiesDTO.getProperty(String.valueOf(this.keyPrefix) + propertyName, true);
        if (prop != null) {
            return prop.getValueAsExpression();
        }
        return null;
    }

    public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
        String fullPropertyName = String.valueOf(this.keyPrefix) + propertyName;
        if (valueExpression != null) {
            this.propertiesDTO.setProperty(fullPropertyName, valueExpression.getText(), true);
        } else if (value != null) {
            if (value.isEmpty()) {
                this.propertiesDTO.removeProperty(fullPropertyName, false);
            } else {
                this.propertiesDTO.setProperty(fullPropertyName, value, false);
            }
        }
        if (value == null) {
            this.propertiesDTO.removeProperty(fullPropertyName, false);
        }
        if (valueExpression == null) {
            this.propertiesDTO.removeProperty(fullPropertyName, true);
        }
    }

    public void removeProperty(String propertyName) {
        this.propertiesDTO.removeProperty(String.valueOf(this.keyPrefix) + propertyName, false);
        this.propertiesDTO.removeProperty(String.valueOf(this.keyPrefix) + propertyName, true);
    }
}

