/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.chartspider.model.command;

import com.jaspersoft.studio.components.chart.messages.Messages;
import com.jaspersoft.studio.components.chart.model.series.category.MCategorySeries;
import com.jaspersoft.studio.components.chartspider.model.MChartSpiderDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.design.JRDesignCategorySeries;
import net.sf.jasperreports.components.spiderchart.StandardSpiderDataset;
import org.eclipse.gef.commands.Command;

public class ReorderCategorySeriesCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignCategorySeries jrElement;
    private StandardSpiderDataset jrGroup;

    public ReorderCategorySeriesCommand(MCategorySeries child, MChartSpiderDataset parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.jrElement = child.getValue();
        this.jrGroup = (StandardSpiderDataset)parent.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getSeriesList().indexOf(this.jrElement);
        this.jrGroup.removeCategorySeries((JRCategorySeries)this.jrElement);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addCategorySeries(this.newIndex, (JRCategorySeries)this.jrElement);
        } else {
            this.jrGroup.addCategorySeries((JRCategorySeries)this.jrElement);
        }
    }

    public void undo() {
        this.jrGroup.removeCategorySeries((JRCategorySeries)this.jrElement);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getSeriesList().size()) {
            this.jrGroup.addCategorySeries(this.oldIndex, (JRCategorySeries)this.jrElement);
        } else {
            this.jrGroup.addCategorySeries((JRCategorySeries)this.jrElement);
        }
    }
}

