/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab;

import com.jaspersoft.studio.components.crosstab.Guide;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import org.eclipse.draw2d.geometry.Rectangle;

public class CrosstabCell {
    public JRDesignCellContents cell;
    public byte type;
    private Guide north;
    private Guide south;
    private Guide west;
    private Guide east;

    public CrosstabCell(byte type) {
        this.type = type;
    }

    public CrosstabCell(JRDesignCellContents cell) {
        this.cell = cell;
        if (cell != null) {
            this.type = cell.getOrigin() != null ? cell.getOrigin().getType() : (byte)7;
        }
    }

    public CrosstabCell(JRDesignCellContents cell, byte type) {
        this.cell = cell;
        this.type = type;
    }

    public Guide getWest() {
        return this.west;
    }

    public void setWest(Guide west) {
        this.west = west;
    }

    public Guide getEast() {
        return this.east;
    }

    public void setEast(Guide east) {
        this.east = east;
    }

    public Guide getNorth() {
        return this.north;
    }

    public void setNorth(Guide north) {
        this.north = north;
    }

    public Guide getSouth() {
        return this.south;
    }

    public void setSouth(Guide south) {
        this.south = south;
    }

    public Rectangle getBounds() {
        Guide tmp;
        int w = 60;
        int h = 20;
        if (this.east != null && this.west != null) {
            if (this.east.getY() < this.west.getY()) {
                tmp = this.west;
                this.west = this.east;
                this.east = tmp;
            }
            w = this.east.getY() - this.west.getY();
        }
        if (this.south != null && this.north != null) {
            if (this.south.getY() < this.north.getY()) {
                tmp = this.north;
                this.north = this.south;
                this.south = tmp;
            }
            h = this.south.getY() - this.north.getY();
        }
        if (this.west != null && this.north != null) {
            return new Rectangle(this.west.getY(), this.north.getY(), w, h);
        }
        if (this.cell != null) {
            return new Rectangle(0, 0, this.cell.getWidth(), this.cell.getHeight());
        }
        return new Rectangle(0, 0, w, h);
    }

    public String toString() {
        String str = "[" + this.type + ":" + this.hashCode() + "-";
        str = this.cell != null ? String.valueOf(str) + "-h:" + this.cell.getHeight() + "]" : String.valueOf(str) + "[++++]";
        return str;
    }

    public boolean equals(Object obj) {
        CrosstabCell toObj = (CrosstabCell)obj;
        if (this.cell != null) {
            return this.cell.equals(toObj.cell);
        }
        if (this.cell == null && toObj.cell == null) {
            return this.type == toObj.type;
        }
        return false;
    }

    public int hashCode() {
        if (this.cell != null) {
            return this.cell.hashCode();
        }
        return this.type;
    }
}

