/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab;

import com.jaspersoft.studio.components.crosstab.CrosstabCell;
import com.jaspersoft.studio.components.crosstab.CrosstabMatrix;
import com.jaspersoft.studio.components.crosstab.Guide;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class CrosstabManager {
    private JRDesignCrosstab crosstab;
    private JasperDesign jDesign;
    private Dimension size;
    private CrosstabMatrix matrix = new CrosstabMatrix();

    public CrosstabManager(JRDesignCrosstab crosstab, JasperDesign jd) {
        this.crosstab = crosstab;
        this.jDesign = jd;
        this.init(crosstab);
    }

    public void refresh() {
        this.crosstab.preprocess();
        this.init(this.crosstab);
    }

    public Dimension getSize() {
        return this.size;
    }

    public void setSize() {
        int xmin = 0;
        int xmax = 0;
        int ymin = 0;
        int ymax = 0;
        for (Rectangle r : this.matrix.getCells().values()) {
            if (xmin > r.x) {
                xmin = r.x;
            }
            if (xmax < r.x + r.width) {
                xmax = r.x + r.width;
            }
            if (ymin > r.y) {
                ymin = r.y;
            }
            if (ymax >= r.y + r.height) continue;
            ymax = r.y + r.height;
        }
        this.size = new Dimension(xmax - xmin, ymax - ymin);
    }

    public CrosstabCell getCell(Point location) {
        Map<CrosstabCell, Rectangle> cellmap = this.matrix.getCells();
        for (CrosstabCell cell : cellmap.keySet()) {
            Rectangle r = cellmap.get(cell);
            if (r.x > location.x || r.x + r.width < location.x || r.y > location.y || r.y + r.height < location.y) continue;
            return cell;
        }
        return null;
    }

    public Rectangle getCellBounds(CrosstabCell cell) {
        return this.matrix.getBounds(cell);
    }

    public static int getHW(int hw) {
        return CrosstabManager.getHW(hw, 0);
    }

    public static int getHW(int hw, int def) {
        if (hw < 0) {
            return def;
        }
        return hw;
    }

    public void init(JRDesignCrosstab crosstab) {
        this.matrix.fill(crosstab);
        this.setSize();
    }

    public void setCellRow(int y, String rowTotal) {
        JRCrosstabCell[][] cells = this.crosstab.getCells();
        int i = cells.length - 1;
        while (i >= 0) {
            int j = cells[i].length - 1;
            while (j >= 0) {
                Rectangle r;
                JRCrosstabCell jrCrosstabCell = cells[i][j];
                if (jrCrosstabCell != null && (jrCrosstabCell.getRowTotalGroup() != null && jrCrosstabCell.getRowTotalGroup().equals(rowTotal) || rowTotal == null && jrCrosstabCell.getRowTotalGroup() == null) && (r = this.matrix.getBounds(new CrosstabCell((JRDesignCellContents)jrCrosstabCell.getContents()))) != null) {
                    r.setLocation(r.x, y);
                }
                --j;
            }
            --i;
        }
    }

    public void setCellColumn(int x, String colTotal) {
        JRCrosstabCell[][] cells = this.crosstab.getCells();
        int i = cells.length - 1;
        while (i >= 0) {
            int j = cells[i].length - 1;
            while (j >= 0) {
                JRCrosstabCell jrCrosstabCell = cells[i][j];
                if (jrCrosstabCell != null && (jrCrosstabCell.getColumnTotalGroup() != null && jrCrosstabCell.getColumnTotalGroup().equals(colTotal) || colTotal == null && jrCrosstabCell.getColumnTotalGroup() == null)) {
                    Rectangle r = this.matrix.getBounds(new CrosstabCell((JRDesignCellContents)jrCrosstabCell.getContents()));
                    r.setLocation(x, r.y);
                }
                --j;
            }
            --i;
        }
    }

    public Rectangle getBounds(CrosstabCell cell) {
        return this.matrix.getBounds(cell);
    }

    public void setWidth(JRDesignCellContents cell, int width) {
        JRCrosstabCell[][] cells = this.crosstab.getCells();
        List colGroupsList = this.crosstab.getColumnGroupsList();
        List rowGroupsList = this.crosstab.getRowGroupsList();
        String rowGroupName = cell.getOrigin().getRowGroupName();
        block0 : switch (cell.getOrigin().getType()) {
            case 7: {
                int i = cells.length - 1;
                while (i >= 0) {
                    int j = cells[i].length - 1;
                    while (j >= 0) {
                        JRDesignCrosstabCell jrCrosstabCell = (JRDesignCrosstabCell)cells[i][j];
                        if (jrCrosstabCell != null && jrCrosstabCell.getContents() == cell) {
                            jrCrosstabCell.setWidth(Integer.valueOf(width));
                            int k = 0;
                            while (k < cells.length) {
                                if (cells[k][j] != null) {
                                    ((JRDesignCrosstabCell)cells[k][j]).setWidth(Integer.valueOf(width));
                                }
                                ++k;
                            }
                        }
                        --j;
                    }
                    --i;
                }
                break;
            }
            case 1: 
            case 8: {
                if (rowGroupsList.isEmpty()) break;
                JRDesignCrosstabRowGroup p = (JRDesignCrosstabRowGroup)rowGroupsList.get(rowGroupsList.size() - 1);
                int delta = width - cell.getWidth();
                this.setCellWidth(p, p.getWidth(), p.getWidth() + delta);
                break;
            }
            case 3: {
                int i = 0;
                while (i < rowGroupsList.size()) {
                    JRDesignCrosstabRowGroup p = (JRDesignCrosstabRowGroup)rowGroupsList.get(i);
                    if (p.getName().equals(rowGroupName)) {
                        this.setCellWidth(p, p.getWidth(), width);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                rowGroupsList = this.crosstab.getRowGroupsList();
                int i = 0;
                while (i < rowGroupsList.size()) {
                    JRDesignCrosstabRowGroup p = (JRDesignCrosstabRowGroup)rowGroupsList.get(i);
                    if (p.getName().equals(rowGroupName)) {
                        int delta = width - cell.getWidth();
                        width = p.getWidth() + delta;
                        this.setCellWidth(p, p.getWidth(), width);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 6: {
                boolean calculated = false;
                String colGroupName = cell.getOrigin().getColumnGroupName();
                int i = cells.length - 1;
                while (i >= 0) {
                    int j = cells[i].length - 1;
                    while (j >= 0) {
                        JRDesignCrosstabCell jrCrosstabCell = (JRDesignCrosstabCell)cells[i][j];
                        if (jrCrosstabCell != null && jrCrosstabCell.getColumnTotalGroup() != null && colGroupName != null && jrCrosstabCell.getColumnTotalGroup().equals(colGroupName)) {
                            if (!calculated) {
                                width = CrosstabManager.getCellWidth((JRCrosstabCell)jrCrosstabCell) + width - cell.getWidth();
                                calculated = true;
                            }
                            if (width >= 0) {
                                jrCrosstabCell.setWidth(Integer.valueOf(width));
                            } else {
                                return;
                            }
                        }
                        --j;
                    }
                    --i;
                }
                break;
            }
            case 5: {
                String colGroupName = cell.getOrigin().getColumnGroupName();
                int i = 0;
                while (i < colGroupsList.size()) {
                    JRDesignCrosstabColumnGroup rg = (JRDesignCrosstabColumnGroup)colGroupsList.get(i);
                    if (rg.getName().equals(colGroupName)) {
                        if (i == colGroupsList.size() - 1) {
                            if (i < cells.length) {
                                this.setWidth((JRDesignCellContents)cells[cells.length - 1][cells[i].length - 1].getContents(), width);
                            }
                        } else {
                            int delta = width - cell.getWidth();
                            JRDesignCrosstabColumnGroup cgNext = (JRDesignCrosstabColumnGroup)colGroupsList.get(i + 1);
                            if (cgNext.getHeader() != null && cgNext.getTotalHeader() != null) {
                                int cgNextWidth = CrosstabManager.getCellWidth(cgNext.getHeader()) + CrosstabManager.getCellWidth(cgNext.getTotalHeader());
                                int cgNextNewWidth = cgNextWidth + delta;
                                int[] proprtionalWidth = this.getColumnsProportionalWidth((JRCrosstabColumnGroup)cgNext, cgNextNewWidth);
                                this.setWidth((JRDesignCellContents)cgNext.getHeader(), proprtionalWidth[0]);
                                this.setWidth((JRDesignCellContents)cgNext.getTotalHeader(), proprtionalWidth[1]);
                                break block0;
                            }
                            if (rg.getTotalHeader() != null) {
                                JRDesignCellContents totalHeader = (JRDesignCellContents)cgNext.getTotalHeader();
                                this.setWidth(totalHeader, totalHeader.getWidth() + delta);
                                break block0;
                            }
                            JRDesignCellContents header = (JRDesignCellContents)cgNext.getHeader();
                            this.setWidth(header, header.getWidth() + delta);
                            break block0;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public void setHeight(JRDesignCellContents cell, int height) {
        JRCrosstabCell[][] cells = this.crosstab.getCells();
        List colGroupsList = this.crosstab.getColumnGroupsList();
        List rowGroupsList = this.crosstab.getRowGroupsList();
        String columnGroupName = cell.getOrigin().getColumnGroupName();
        block0 : switch (cell.getOrigin().getType()) {
            case 7: {
                if (height < 0) break;
                int i = cells.length - 1;
                while (i >= 0) {
                    int j = cells[i].length - 1;
                    while (j >= 0) {
                        JRDesignCrosstabCell jrCrosstabCell = (JRDesignCrosstabCell)cells[i][j];
                        if (jrCrosstabCell != null && jrCrosstabCell.getContents() == cell) {
                            jrCrosstabCell.setHeight(Integer.valueOf(height));
                            int k = 0;
                            while (k < cells[i].length) {
                                if (cells[i][k] != null) {
                                    ((JRDesignCrosstabCell)cells[i][k]).setHeight(Integer.valueOf(height));
                                }
                                ++k;
                            }
                        }
                        --j;
                    }
                    --i;
                }
                break;
            }
            case 1: {
                if (colGroupsList.isEmpty()) break;
                JRDesignCrosstabColumnGroup p = (JRDesignCrosstabColumnGroup)colGroupsList.get(colGroupsList.size() - 1);
                this.setCellHeight(p, p.getHeight(), p.getHeight() + height - cell.getHeight());
                break;
            }
            case 8: {
                if (colGroupsList.isEmpty()) break;
                JRDesignCrosstabColumnGroup p = (JRDesignCrosstabColumnGroup)colGroupsList.get(colGroupsList.size() - 1);
                this.setCellHeight(p, p.getHeight(), height);
                break;
            }
            case 5: {
                int i = 0;
                while (i < colGroupsList.size()) {
                    JRDesignCrosstabColumnGroup p = (JRDesignCrosstabColumnGroup)colGroupsList.get(i);
                    if (p.getName().equals(columnGroupName)) {
                        this.setCellHeight(p, p.getHeight(), height);
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 6: {
                int i = 0;
                while (i < colGroupsList.size()) {
                    JRDesignCrosstabColumnGroup p = (JRDesignCrosstabColumnGroup)colGroupsList.get(i);
                    if (p.getName().equals(columnGroupName)) {
                        this.setCellHeight(p, p.getHeight(), p.getHeight() + height - cell.getHeight());
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                boolean calculated = false;
                String rowGroupName = cell.getOrigin().getRowGroupName();
                int i = cells.length - 1;
                while (i >= 0) {
                    int j = cells[i].length - 1;
                    while (j >= 0) {
                        JRDesignCrosstabCell jrCrosstabCell = (JRDesignCrosstabCell)cells[i][j];
                        if (jrCrosstabCell != null && jrCrosstabCell.getRowTotalGroup() != null && rowGroupName != null && jrCrosstabCell.getRowTotalGroup().equals(rowGroupName)) {
                            if (!calculated) {
                                height = jrCrosstabCell.getHeight() + height - cell.getHeight();
                                calculated = true;
                            }
                            if (height >= 0) {
                                jrCrosstabCell.setHeight(Integer.valueOf(height));
                            } else {
                                return;
                            }
                        }
                        --j;
                    }
                    --i;
                }
                break;
            }
            case 3: {
                String rowGroupName = cell.getOrigin().getRowGroupName();
                int i = 0;
                while (i < rowGroupsList.size()) {
                    JRDesignCrosstabRowGroup rg = (JRDesignCrosstabRowGroup)rowGroupsList.get(i);
                    if (rg.getName().equals(rowGroupName)) {
                        if (i == rowGroupsList.size() - 1) {
                            this.setHeight((JRDesignCellContents)cells[cells.length - 1][cells[i].length - 1].getContents(), height);
                        } else {
                            int delta = height - cell.getHeight();
                            JRDesignCrosstabRowGroup rgNext = (JRDesignCrosstabRowGroup)rowGroupsList.get(i + 1);
                            if (rgNext.getTotalPositionValue().equals((Object)CrosstabTotalPositionEnum.END)) {
                                JRDesignCellContents totalHeader = (JRDesignCellContents)rgNext.getTotalHeader();
                                this.setHeight(totalHeader, totalHeader.getHeight() + delta);
                                break block0;
                            }
                            JRDesignCellContents header = (JRDesignCellContents)rgNext.getHeader();
                            this.setHeight(header, header.getHeight() + delta);
                            break block0;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    private void setCellHeight(JRDesignCrosstabColumnGroup p, int oldValue, int height) {
        if (height >= 0) {
            p.setHeight(height);
        } else {
            p.setHeight(0);
        }
        p.getEventSupport().firePropertyChange("height", oldValue, height);
    }

    private void setCellWidth(JRDesignCrosstabRowGroup p, int oldValue, int width) {
        if (width > 0) {
            p.setWidth(width);
        } else {
            p.setWidth(0);
        }
        p.getEventSupport().firePropertyChange("width", oldValue, width);
    }

    public Dimension getCellPackSize(CrosstabCell cc) {
        if ((cc = this.matrix.getCrosstabCell(cc)) == null) {
            return null;
        }
        Guide g = cc.getEast();
        int w = -g.getY();
        for (CrosstabCell c : g.getPrev()) {
            List cells;
            if (c.cell == null || (cells = c.cell.getChildren()).isEmpty()) continue;
            int width = ModelUtils.getContainerSize((List)cells, (Dimension)new Dimension((int)0, (int)0)).width;
            w = Math.max(w, width - c.cell.getWidth());
        }
        g = cc.getSouth();
        int h = 0;
        if (g != null) {
            h = -g.getY();
            for (CrosstabCell c : g.getPrev()) {
                List cells;
                if (c.cell == null || (cells = c.cell.getChildren()).isEmpty()) continue;
                int height = ModelUtils.getContainerSize((List)cells, (Dimension)new Dimension((int)0, (int)0)).height;
                h = Math.max(h, height - c.cell.getHeight());
            }
        }
        Rectangle b = cc.getBounds();
        return new Dimension(b.width + w, b.height + h);
    }

    public List<CrosstabCell> getLeftOf(CrosstabCell cell) {
        cell = this.matrix.getCrosstabCell(cell);
        Guide g = cell.getWest();
        return g.getPrev();
    }

    public List<CrosstabCell> getTopOf(CrosstabCell cell) {
        cell = this.matrix.getCrosstabCell(cell);
        Guide g = cell.getNorth();
        return g.getPrev();
    }

    public List<CrosstabCell> getBottomOf(CrosstabCell cell) {
        cell = this.matrix.getCrosstabCell(cell);
        Guide g = cell.getSouth();
        return g.getPrev();
    }

    public List<CrosstabCell> getRightOf(CrosstabCell cell) {
        cell = this.matrix.getCrosstabCell(cell);
        Guide g = cell.getEast();
        return g.getPrev();
    }

    private HashMap<JRCellContents, Integer> getCellsWidth() {
        JRCrosstabColumnGroup group;
        HashMap<JRCellContents, Integer> originalWidth = new HashMap<JRCellContents, Integer>();
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = this.crosstab.getColumnGroups();
        int n = jRCrosstabColumnGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            group = jRCrosstabColumnGroupArray[n2];
            if (group.getHeader() != null) {
                originalWidth.put(group.getHeader(), group.getHeader().getWidth());
            }
            if (group.getTotalHeader() != null) {
                originalWidth.put(group.getTotalHeader(), group.getTotalHeader().getWidth());
            }
            if (group.getCrosstabHeader() != null) {
                originalWidth.put(group.getCrosstabHeader(), group.getCrosstabHeader().getWidth());
            }
            ++n2;
        }
        jRCrosstabColumnGroupArray = this.crosstab.getRowGroups();
        n = jRCrosstabColumnGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            group = jRCrosstabColumnGroupArray[n2];
            if (group.getHeader() != null) {
                originalWidth.put(group.getHeader(), group.getHeader().getWidth());
            }
            if (group.getTotalHeader() != null) {
                originalWidth.put(group.getTotalHeader(), group.getTotalHeader().getWidth());
            }
            ++n2;
        }
        for (JRCrosstabCell cell : this.crosstab.getCellsList()) {
            if (cell.getContents() == null) continue;
            originalWidth.put(cell.getContents(), cell.getWidth());
        }
        return originalWidth;
    }

    private void relayoutChangedCells(HashMap<JRCellContents, Integer> originalWidth) {
        Integer size;
        JRCrosstabColumnGroup group;
        ArrayList<JRCellContents> cellsToLayout = new ArrayList<JRCellContents>();
        JRCrosstabColumnGroup[] jRCrosstabColumnGroupArray = this.crosstab.getColumnGroups();
        int n = jRCrosstabColumnGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            group = jRCrosstabColumnGroupArray[n2];
            if (group.getHeader() != null) {
                size = originalWidth.get(group.getHeader());
                if (!group.getHeader().equals(size)) {
                    cellsToLayout.add(group.getHeader());
                }
            }
            if (group.getTotalHeader() != null) {
                size = originalWidth.get(group.getTotalHeader());
                if (!group.getTotalHeader().equals(size)) {
                    cellsToLayout.add(group.getTotalHeader());
                }
            }
            if (group.getCrosstabHeader() != null) {
                size = originalWidth.get(group.getCrosstabHeader());
                if (!group.getCrosstabHeader().equals(size)) {
                    cellsToLayout.add(group.getCrosstabHeader());
                }
            }
            ++n2;
        }
        jRCrosstabColumnGroupArray = this.crosstab.getRowGroups();
        n = jRCrosstabColumnGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            group = jRCrosstabColumnGroupArray[n2];
            if (group.getHeader() != null) {
                size = originalWidth.get(group.getHeader());
                if (!group.getHeader().equals(size)) {
                    cellsToLayout.add(group.getHeader());
                }
            }
            if (group.getTotalHeader() != null) {
                size = originalWidth.get(group.getTotalHeader());
                if (!group.getTotalHeader().equals(size)) {
                    cellsToLayout.add(group.getTotalHeader());
                }
            }
            ++n2;
        }
        for (JRCrosstabCell cell : this.crosstab.getCellsList()) {
            if (cell.getContents() == null) continue;
            Integer size2 = originalWidth.get(cell.getContents());
            if (cell.getContents().equals(size2)) continue;
            cellsToLayout.add(cell.getContents());
        }
        VerticalRowLayout defaultLayout = new VerticalRowLayout();
        for (JRCellContents cell : cellsToLayout) {
            ILayout layout = LayoutManager.getLayout((JRPropertiesHolder[])new JRPropertiesHolder[]{cell}, null, null, (ILayout)defaultLayout);
            layout.layout(this.jDesign, (JRElementGroup)cell, cell.getElements(), new Dimension(cell.getWidth(), cell.getHeight()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillSpace(int newWidth, boolean isProportional) {
        JRDesignCrosstab jRDesignCrosstab = this.crosstab;
        synchronized (jRDesignCrosstab) {
            int currentColumnsWidth;
            int rowGroupsHeaderSize = 0;
            int columnGroupHeaderSize = 0;
            int columnGroupTotalHeaderSize = 0;
            if (this.crosstab.getRowGroups().length > 0) {
                rowGroupsHeaderSize = this.crosstab.getRowGroups()[0].getTotalHeader().getWidth();
            }
            if (this.crosstab.getColumnGroups().length > 0) {
                JRCrosstabColumnGroup firstColGroup = this.crosstab.getColumnGroups()[0];
                columnGroupHeaderSize = CrosstabManager.getCellWidth(firstColGroup.getHeader());
                columnGroupTotalHeaderSize = CrosstabManager.getCellWidth(firstColGroup.getTotalHeader());
            }
            if ((currentColumnsWidth = rowGroupsHeaderSize + columnGroupHeaderSize + columnGroupTotalHeaderSize) == newWidth) {
                return;
            }
            if (isProportional) {
                HashMap<JRCellContents, Integer> originalSize = this.getCellsWidth();
                int[] proportionalWidths = this.getColumnsProportionalWidth(newWidth);
                if (this.crosstab.getRowGroups().length > 0) {
                    this.setWidth((JRDesignCellContents)this.crosstab.getRowGroups()[0].getTotalHeader(), proportionalWidths[2]);
                }
                if (this.crosstab.getColumnGroups().length > 0) {
                    JRCrosstabColumnGroup group = this.crosstab.getColumnGroups()[0];
                    if (group.getHeader() != null) {
                        this.setWidth((JRDesignCellContents)group.getHeader(), proportionalWidths[0]);
                    }
                    if (group.getTotalHeader() != null) {
                        this.setWidth((JRDesignCellContents)group.getTotalHeader(), proportionalWidths[1]);
                    }
                }
                this.refresh();
                this.crosstab.getEventSupport().firePropertyChange(new PropertyChangeEvent(this.crosstab, "width", null, null));
                this.relayoutChangedCells(originalSize);
            }
        }
    }

    private static int getCellWidth(JRCellContents cell) {
        if (cell != null) {
            return cell.getWidth();
        }
        return 0;
    }

    private static int getCellWidth(JRCrosstabCell cell) {
        if (cell != null && cell.getWidth() != null) {
            return cell.getWidth();
        }
        return 0;
    }

    private int[] getColumnsProportionalWidth(int newWidth) {
        int proportionalWidth;
        int[] result = new int[3];
        int columnsTotalWidth = 0;
        int rowGroupsHeaderSize = 0;
        int columnGroupHeaderSize = 0;
        int columnGroupTotalHeaderSize = 0;
        if (this.crosstab.getRowGroups().length > 0) {
            rowGroupsHeaderSize = this.crosstab.getRowGroups()[0].getTotalHeader().getWidth();
        }
        if (this.crosstab.getColumnGroups().length > 0) {
            JRCrosstabColumnGroup firstColGroup = this.crosstab.getColumnGroups()[0];
            columnGroupHeaderSize = CrosstabManager.getCellWidth(firstColGroup.getHeader());
            columnGroupTotalHeaderSize = CrosstabManager.getCellWidth(firstColGroup.getTotalHeader());
        }
        int currentColumnsWidth = columnGroupHeaderSize + columnGroupTotalHeaderSize + rowGroupsHeaderSize;
        float proportionalFactor = (float)columnGroupHeaderSize / (float)currentColumnsWidth;
        result[0] = proportionalWidth = (int)(proportionalFactor * (float)newWidth);
        columnsTotalWidth += proportionalWidth;
        proportionalFactor = (float)columnGroupTotalHeaderSize / (float)currentColumnsWidth;
        result[1] = proportionalWidth = (int)(proportionalFactor * (float)newWidth);
        columnsTotalWidth += proportionalWidth;
        proportionalFactor = (float)rowGroupsHeaderSize / (float)currentColumnsWidth;
        result[2] = proportionalWidth = (int)(proportionalFactor * (float)newWidth);
        int remains = newWidth - (columnsTotalWidth += proportionalWidth);
        int index = 0;
        while (remains > 0) {
            int n = index++;
            result[n] = result[n] + 1;
            --remains;
            if (index != result.length) continue;
            index = 0;
        }
        return result;
    }

    private int[] getColumnsProportionalWidth(JRCrosstabColumnGroup group, int newWidth) {
        int proportionalWidth;
        float proportionalFactor;
        int[] result = new int[2];
        int columnsTotalWidth = 0;
        int currentColumnsWidth = CrosstabManager.getCellWidth(group.getHeader()) + CrosstabManager.getCellWidth(group.getTotalHeader());
        if (group.getHeader() != null) {
            proportionalFactor = (float)group.getHeader().getWidth() / (float)currentColumnsWidth;
            result[0] = proportionalWidth = (int)(proportionalFactor * (float)newWidth);
            columnsTotalWidth += proportionalWidth;
        }
        if (group.getTotalHeader() != null) {
            proportionalFactor = (float)group.getTotalHeader().getWidth() / (float)currentColumnsWidth;
            result[1] = proportionalWidth = (int)(proportionalFactor * (float)newWidth);
            columnsTotalWidth += proportionalWidth;
        }
        int remains = newWidth - columnsTotalWidth;
        int index = 0;
        while (remains > 0) {
            int n = index++;
            result[n] = result[n] + 1;
            --remains;
            if (index != result.length) continue;
            index = 0;
        }
        return result;
    }
}

