/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab;

import com.jaspersoft.studio.components.crosstab.CrosstabCell;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;

public class Guide {
    private int y;
    private List<CrosstabCell> prev = new ArrayList<CrosstabCell>();
    private List<CrosstabCell> next = new ArrayList<CrosstabCell>();

    public Guide(int y) {
        this.y = y;
    }

    public void setNext(List<CrosstabCell> next) {
        this.next = next;
    }

    public void setPrev(List<CrosstabCell> prev) {
        this.prev = prev;
    }

    public List<CrosstabCell> getPrev() {
        return this.prev;
    }

    public List<CrosstabCell> getNext() {
        return this.next;
    }

    public void addWest(CrosstabCell cell) {
        cell.setEast(this);
        this.prev.add(cell);
    }

    public void addEast(CrosstabCell cell) {
        cell.setWest(this);
        this.next.add(cell);
    }

    public void addNorth(CrosstabCell cell) {
        cell.setSouth(this);
        this.prev.add(cell);
    }

    public void addSouth(CrosstabCell cell) {
        cell.setNorth(this);
        this.next.add(cell);
    }

    public void mirrorV() {
        this.switchCellsV(this.next);
        this.switchCellsV(this.prev);
        List<CrosstabCell> tmp = this.next;
        this.next = this.prev;
        this.prev = tmp;
    }

    private void switchCellsV(List<CrosstabCell> cols) {
        for (CrosstabCell cc : cols) {
            Guide t = cc.getEast();
            cc.setEast(cc.getWest());
            cc.setWest(t);
        }
    }

    public int getY() {
        return this.y;
    }

    public void setX(Guide west, JRCellContents c) {
        if (c != null) {
            this.y = Math.max(this.y, west.getY() + c.getWidth());
        }
    }

    public void setY(Guide north, JRCellContents c) {
        if (c != null) {
            this.y = Math.max(this.y, north.getY() + c.getHeight());
        }
    }

    public void setY(int y) {
        this.y = y;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("y: " + this.y + " NORTH");
        for (CrosstabCell cc : this.prev) {
            res.append(cc.toString());
        }
        res.append("\nSOUTH");
        for (CrosstabCell cc : this.next) {
            res.append(cc.toString());
        }
        return res.toString();
    }
}

