/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.action;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.crosstab.action.RemoveStyleCommand;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.command.ForceRefreshCommand;
import com.jaspersoft.studio.model.style.command.DeleteStyleCommand;
import com.jaspersoft.studio.property.SetPropertyValueCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.eclipse.ui.util.ExtendedMessageDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class RemoveCrosstabStylesAction
extends ACachedSelectionAction {
    private boolean deleteStyles = false;
    private HashSet<String> deletedStyles;
    public static final String ID = "com.jaspersoft.studio.components.table.action.RemoveCrosstabStyles";

    public RemoveCrosstabStylesAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.RemoveStylesAction_actionTitle);
        this.setId(ID);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/crosstab-style-remove-16.png"));
    }

    protected boolean calculateEnabled() {
        List crosstabs = this.editor.getSelectionCache().getSelectionModelForType(MCrosstab.class);
        return crosstabs.size() > 0;
    }

    private List<EditPart> getSelectedTables() {
        List result = this.editor.getSelectionCache().getSelectionModelPartForType(MCrosstab.class);
        return result;
    }

    public void run() {
        this.deleteStyles = false;
        int selection = this.getResponse();
        if (selection != 2 && selection != -1) {
            this.deleteStyles = selection == 0;
            List<EditPart> parts = this.getSelectedTables();
            this.execute(this.changeStyleCommand(parts));
            for (EditPart part : parts) {
                if (!(part instanceof FigureEditPart)) continue;
                ((FigureEditPart)part).refreshVisuals();
            }
        }
    }

    protected int getResponse() {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String styleBehavior = store.getString("tableCrosstabDeleteStyle");
        if (styleBehavior.equals("deleteStyles")) {
            return 0;
        }
        if (styleBehavior.equals("deleteStylesReferences")) {
            return 1;
        }
        Shell shell = UIUtils.getShell();
        ExtendedMessageDialog question = new ExtendedMessageDialog(shell, Messages.RemoveStylesAction_messageTitle, null, Messages.RemoveStylesAction_messageText, 3, new String[]{Messages.RemoveStylesAction_option1, Messages.RemoveStylesAction_option2, Messages.RemoveStylesAction_option3}, 2, Messages.EditTableStyleAction_rememberDecision);
        int response = question.open();
        if (question.getCheckboxResult()) {
            if (response == 0) {
                store.setValue("tableCrosstabDeleteStyle", "deleteStyles");
            } else if (response == 1) {
                store.setValue("tableCrosstabDeleteStyle", "deleteStylesReferences");
            }
        }
        return response;
    }

    protected void createCommand(JRCellContents cell, JSSCompoundCommand container, MReport report) {
        if (cell != null && cell instanceof JRDesignCellContents) {
            JRStyle style;
            container.add((Command)new RemoveStyleCommand((JRDesignCellContents)cell));
            if (this.deleteStyles && cell.getStyle() != null && !this.deletedStyles.contains((style = cell.getStyle()).getName())) {
                this.deletedStyles.add(style.getName());
                container.add((Command)new DeleteStyleCommand(report, (JRDesignStyle)style));
            }
        }
    }

    protected Command changeStyleCommand(List<EditPart> editParts) {
        JSSCompoundCommand command = new JSSCompoundCommand(null);
        this.deletedStyles = new HashSet();
        for (EditPart editPart : editParts) {
            JRDesignCrosstabRowGroup designGroup;
            MCrosstab crosstabModel = (MCrosstab)((Object)editPart.getModel());
            MReport report = ModelUtils.getReport((ANode)crosstabModel);
            command.setReferenceNodeIfNull((ANode)crosstabModel);
            JRDesignCrosstab crosstab = crosstabModel.getValue();
            command.add((Command)new ForceRefreshCommand((ANode)crosstabModel));
            for (JRCrosstabRowGroup rowGroup : crosstab.getRowGroupsList()) {
                designGroup = (JRDesignCrosstabRowGroup)rowGroup;
                this.createCommand(designGroup.getTotalHeader(), command, report);
                this.createCommand(designGroup.getHeader(), command, report);
            }
            for (JRCrosstabColumnGroup colGroup : crosstab.getColumnGroupsList()) {
                designGroup = (JRDesignCrosstabColumnGroup)colGroup;
                this.createCommand(designGroup.getTotalHeader(), command, report);
                this.createCommand(designGroup.getHeader(), command, report);
            }
            for (JRCrosstabCell dataCell : crosstab.getCellsList()) {
                this.createCommand(dataCell.getContents(), command, report);
            }
            JRPropertiesMap crosstabMap = crosstab.getPropertiesMap();
            command.add((Command)new SetPropertyValueCommand(crosstabMap, "com.jaspersoft.studio.crosstab.style.detail", null));
            command.add((Command)new SetPropertyValueCommand(crosstabMap, "com.jaspersoft.studio.crosstab.style.group", null));
            command.add((Command)new SetPropertyValueCommand(crosstabMap, "com.jaspersoft.studio.crosstab.style.header", null));
            command.add((Command)new SetPropertyValueCommand(crosstabMap, "com.jaspersoft.studio.crosstab.style.total", null));
            command.add((Command)new ForceRefreshCommand((ANode)crosstabModel));
        }
        return command;
    }
}

