/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.util.Pair;

public class CrosstabUtil {
    public static JRDesignCrosstabRowGroup createRowGroup(JasperDesign jasperDesign, JRDesignCrosstab jrCrosstab, String name, CrosstabTotalPositionEnum total) {
        int width = 60;
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = jrCrosstab.getRowGroups();
        if (jRCrosstabRowGroupArray.length != 0) {
            JRCrosstabRowGroup group = jRCrosstabRowGroupArray[0];
            width = group.getWidth();
        }
        JRDesignCrosstabRowGroup jrGroup = new JRDesignCrosstabRowGroup();
        jrGroup.setTotalPosition(total);
        jrGroup.setName(ModelUtils.getDefaultName((JRDesignCrosstab)jrCrosstab, (String)name));
        jrGroup.setWidth(width);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("");
        exp.setValueClass(String.class);
        JRDesignCrosstabBucket bucket = new JRDesignCrosstabBucket();
        bucket.setExpression(exp);
        jrGroup.setBucket(bucket);
        JRDesignCellContents headerCell = new JRDesignCellContents();
        jrGroup.setHeader(headerCell);
        exp = new JRDesignExpression();
        exp.setText("$V{" + jrGroup.getName() + "}");
        JRDesignTextField tf = (JRDesignTextField)new MTextField().createJRElement(jasperDesign);
        tf.setX(0);
        tf.setY(0);
        tf.setWidth(jrGroup.getWidth());
        tf.setHeight(20);
        if ("Crosstab Data Text" != null && jasperDesign.getStylesMap().containsKey("Crosstab Data Text")) {
            tf.setStyle((JRStyle)jasperDesign.getStylesMap().get("Crosstab Data Text"));
        }
        tf.setExpression((JRExpression)exp);
        headerCell.addElement((JRDesignElement)tf);
        JRDesignCellContents totalCell = new JRDesignCellContents();
        JRDesignStaticText stext = new JRDesignStaticText();
        stext.setX(0);
        stext.setY(0);
        stext.setWidth(jrGroup.getWidth());
        stext.setHeight(20);
        stext.setText(String.valueOf(Messages.common_total) + " " + jrGroup.getName());
        totalCell.addElement((JRDesignElement)stext);
        jrGroup.setTotalHeader(totalCell);
        return jrGroup;
    }

    public static void addColumnGroup(JRDesignCrosstab jrCross, JRDesignCrosstabColumnGroup jrColGr, int index, Map<String, JRCrosstabCell> cellsToRestore) throws JRException {
        JRDesignCrosstabCell dT;
        if (index >= 0 && index <= jrCross.getColumnGroupsList().size()) {
            jrCross.addColumnGroup(index, jrColGr);
        } else {
            jrCross.addColumnGroup(jrColGr);
        }
        if (!jrCross.getCellsMap().containsKey(new Pair(null, null))) {
            dT = new JRDesignCrosstabCell();
            dT.setColumnTotalGroup(null);
            dT.setRowTotalGroup(null);
            jrCross.addCell(dT);
            dT.setHeight(Integer.valueOf(jrColGr.getHeight()));
            dT.setWidth(Integer.valueOf(60));
        }
        if (cellsToRestore.containsKey(null)) {
            dT = cellsToRestore.get(null);
            jrCross.addCell(dT);
        } else {
            dT = new JRDesignCrosstabCell();
            dT.setColumnTotalGroup(jrColGr.getName());
            jrCross.addCell(dT);
            dT.setHeight(Integer.valueOf(jrColGr.getHeight()));
            dT.setWidth(Integer.valueOf(60));
        }
        List rows = jrCross.getRowGroupsList();
        if (rows != null) {
            for (JRCrosstabRowGroup r : rows) {
                JRDesignCrosstabCell cell;
                if (cellsToRestore.containsKey(r.getName())) {
                    cell = (JRDesignCrosstabCell)cellsToRestore.get(r.getName());
                    jrCross.addCell(cell);
                    continue;
                }
                cell = new JRDesignCrosstabCell();
                cell.setColumnTotalGroup(jrColGr.getName());
                cell.setRowTotalGroup(r.getName());
                jrCross.addCell(cell);
                cell.setHeight(Integer.valueOf(jrColGr.getHeight()));
                cell.setWidth(Integer.valueOf(60));
            }
        }
        jrCross.preprocess();
    }

    public static void addRowGroup(JRDesignCrosstab jrCross, JRDesignCrosstabRowGroup jrRowGr, int index, Map<String, JRCrosstabCell> cellsToRestore) throws JRException {
        JRDesignCrosstabCell dT;
        JRCrosstabRowGroup lastGroup = null;
        if (!jrCross.getRowGroupsList().isEmpty()) {
            lastGroup = (JRCrosstabRowGroup)jrCross.getRowGroupsList().get(jrCross.getRowGroupsList().size() - 1);
        }
        if (index >= 0 && index < jrCross.getRowGroupsList().size()) {
            jrCross.addRowGroup(index, jrRowGr);
        } else {
            jrCross.addRowGroup(jrRowGr);
        }
        if (!jrCross.getCellsMap().containsKey(new Pair(null, null))) {
            dT = new JRDesignCrosstabCell();
            dT.setColumnTotalGroup(null);
            dT.setRowTotalGroup(null);
            jrCross.addCell(dT);
            dT.setHeight(Integer.valueOf(20));
            dT.setWidth(Integer.valueOf(jrRowGr.getWidth()));
        }
        if (cellsToRestore.containsKey(null)) {
            dT = cellsToRestore.get(null);
            jrCross.addCell(dT);
        } else {
            dT = new JRDesignCrosstabCell();
            dT.setRowTotalGroup(jrRowGr.getName());
            jrCross.addCell(dT);
            dT.setHeight(Integer.valueOf(20));
            if (lastGroup != null) {
                Pair key = new Pair((Object)lastGroup.getName(), (Object)dT.getColumnTotalGroup());
                JRCrosstabCell cell = (JRCrosstabCell)jrCross.getCellsMap().get(key);
                dT.setWidth(cell.getWidth());
            } else {
                dT.setWidth(Integer.valueOf(jrRowGr.getWidth()));
            }
        }
        List columns = jrCross.getColumnGroupsList();
        if (columns != null) {
            for (JRCrosstabColumnGroup c : columns) {
                JRDesignCrosstabCell cell;
                if (cellsToRestore.containsKey(c.getName())) {
                    cell = (JRDesignCrosstabCell)cellsToRestore.get(c.getName());
                    jrCross.addCell(cell);
                    continue;
                }
                cell = new JRDesignCrosstabCell();
                cell.setRowTotalGroup(jrRowGr.getName());
                cell.setColumnTotalGroup(c.getName());
                jrCross.addCell(cell);
                cell.setHeight(Integer.valueOf(c.getHeight()));
                if (lastGroup != null) {
                    Pair key = new Pair((Object)lastGroup.getName(), (Object)c.getName());
                    JRCrosstabCell otherCell = (JRCrosstabCell)jrCross.getCellsMap().get(key);
                    cell.setWidth(otherCell.getWidth());
                    continue;
                }
                cell.setWidth(Integer.valueOf(jrRowGr.getWidth()));
            }
        }
        jrCross.preprocess();
    }

    public static void addColumnGroup(JRDesignCrosstab jrCross, JRDesignCrosstabColumnGroup jrRowGr, int index) throws JRException {
        CrosstabUtil.addColumnGroup(jrCross, jrRowGr, index, 20);
    }

    public static void addColumnGroup(JRDesignCrosstab jrCross, JRDesignCrosstabColumnGroup jrRowGr, int index, int height) throws JRException {
        JRDesignCrosstabCell dT;
        if (index >= 0 && index <= jrCross.getColumnGroupsList().size()) {
            jrCross.addColumnGroup(index, jrRowGr);
        } else {
            jrCross.addColumnGroup(jrRowGr);
        }
        if (!jrCross.getCellsMap().containsKey(new Pair(null, null))) {
            dT = new JRDesignCrosstabCell();
            dT.setColumnTotalGroup(null);
            dT.setRowTotalGroup(null);
            jrCross.addCell(dT);
            dT.setHeight(Integer.valueOf(height));
            dT.setWidth(Integer.valueOf(60));
        }
        dT = new JRDesignCrosstabCell();
        dT.setColumnTotalGroup(jrRowGr.getName());
        jrCross.addCell(dT);
        dT.setHeight(Integer.valueOf(height));
        dT.setWidth(Integer.valueOf(60));
        List rows = jrCross.getRowGroupsList();
        if (rows != null) {
            for (JRCrosstabRowGroup r : rows) {
                JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
                cell.setColumnTotalGroup(jrRowGr.getName());
                cell.setRowTotalGroup(r.getName());
                jrCross.addCell(cell);
                cell.setHeight(Integer.valueOf(height));
                cell.setWidth(Integer.valueOf(60));
            }
        }
        jrCross.preprocess();
    }

    public static void addRowGroup(JRDesignCrosstab jrCross, JRDesignCrosstabRowGroup jrRowGr, int index) throws JRException {
        CrosstabUtil.addRowGroup(jrCross, jrRowGr, index, 20);
    }

    public static void addRowGroup(JRDesignCrosstab jrCross, JRDesignCrosstabRowGroup jrRowGr, int index, int height) throws JRException {
        JRDesignCrosstabCell dT;
        JRCrosstabRowGroup lastGroup = null;
        if (!jrCross.getRowGroupsList().isEmpty()) {
            lastGroup = (JRCrosstabRowGroup)jrCross.getRowGroupsList().get(jrCross.getRowGroupsList().size() - 1);
        }
        if (index >= 0 && index < jrCross.getRowGroupsList().size()) {
            jrCross.addRowGroup(index, jrRowGr);
        } else {
            jrCross.addRowGroup(jrRowGr);
        }
        if (!jrCross.getCellsMap().containsKey(new Pair(null, null))) {
            dT = new JRDesignCrosstabCell();
            dT.setColumnTotalGroup(null);
            dT.setRowTotalGroup(null);
            jrCross.addCell(dT);
            dT.setHeight(Integer.valueOf(height));
            dT.setWidth(Integer.valueOf(jrRowGr.getWidth()));
        }
        dT = new JRDesignCrosstabCell();
        dT.setRowTotalGroup(jrRowGr.getName());
        jrCross.addCell(dT);
        dT.setHeight(Integer.valueOf(height));
        if (lastGroup != null) {
            Pair key = new Pair((Object)lastGroup.getName(), (Object)dT.getColumnTotalGroup());
            JRCrosstabCell cell = (JRCrosstabCell)jrCross.getCellsMap().get(key);
            dT.setWidth(cell.getWidth());
        } else {
            dT.setWidth(Integer.valueOf(jrRowGr.getWidth()));
        }
        List columns = jrCross.getColumnGroupsList();
        if (columns != null) {
            for (JRCrosstabColumnGroup c : columns) {
                JRDesignCrosstabCell cell = new JRDesignCrosstabCell();
                cell.setRowTotalGroup(jrRowGr.getName());
                cell.setColumnTotalGroup(c.getName());
                jrCross.addCell(cell);
                cell.setHeight(Integer.valueOf(height));
                if (lastGroup != null) {
                    Pair key = new Pair((Object)lastGroup.getName(), (Object)c.getName());
                    JRCrosstabCell otherCell = (JRCrosstabCell)jrCross.getCellsMap().get(key);
                    cell.setWidth(otherCell.getWidth());
                    continue;
                }
                cell.setWidth(Integer.valueOf(jrRowGr.getWidth()));
            }
        }
        jrCross.preprocess();
    }

    public static JRDesignCrosstabColumnGroup createColumnGroup(JasperDesign jasperDesign, JRDesignCrosstab jrCrosstab, String name, CrosstabTotalPositionEnum total) {
        JRDesignCrosstabColumnGroup jrGroup = new JRDesignCrosstabColumnGroup();
        jrGroup.setTotalPosition(total);
        jrGroup.setName(ModelUtils.getDefaultName((JRDesignCrosstab)jrCrosstab, (String)name));
        jrGroup.setHeight(20);
        JRDesignExpression exp = new JRDesignExpression();
        exp.setText("");
        exp.setValueClass(String.class);
        JRDesignCrosstabBucket bucket = new JRDesignCrosstabBucket();
        bucket.setExpression(exp);
        bucket.setOrder(BucketOrder.ASCENDING);
        jrGroup.setBucket(bucket);
        JRDesignCellContents headerCell = new JRDesignCellContents();
        jrGroup.setHeader(headerCell);
        exp = new JRDesignExpression();
        exp.setText("$V{" + jrGroup.getName() + "}");
        JRDesignTextField tf = (JRDesignTextField)new MTextField().createJRElement(jasperDesign);
        tf.setX(0);
        tf.setY(0);
        tf.setWidth(60);
        tf.setHeight(jrGroup.getHeight());
        if ("Crosstab Data Text" != null && jasperDesign.getStylesMap().containsKey("Crosstab Data Text")) {
            tf.setStyle((JRStyle)jasperDesign.getStylesMap().get("Crosstab Data Text"));
        }
        tf.setExpression((JRExpression)exp);
        headerCell.addElement((JRDesignElement)tf);
        JRDesignCellContents totalCell = new JRDesignCellContents();
        JRDesignStaticText stext = new JRDesignStaticText();
        stext.setX(0);
        stext.setY(0);
        stext.setWidth(60);
        stext.setHeight(jrGroup.getHeight());
        stext.setText(String.valueOf(Messages.common_total) + " " + jrGroup.getName());
        totalCell.addElement((JRDesignElement)stext);
        jrGroup.setTotalHeader(totalCell);
        return jrGroup;
    }

    public static MCrosstab getMCrosstab(INode node) {
        INode tmpNode = node.getParent();
        while (tmpNode != null) {
            if (tmpNode instanceof MCrosstab) {
                return (MCrosstab)tmpNode;
            }
            tmpNode = tmpNode.getParent();
        }
        return null;
    }
}

