/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model;

import com.jaspersoft.studio.callout.pin.IPinContainer;
import com.jaspersoft.studio.components.crosstab.CrosstabComponentFactory;
import com.jaspersoft.studio.components.crosstab.CrosstabManager;
import com.jaspersoft.studio.components.crosstab.CrosstabNodeIconDescriptor;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.HorizontalPositionUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstabDataset;
import com.jaspersoft.studio.components.crosstab.model.header.MCrosstabHeader;
import com.jaspersoft.studio.components.crosstab.model.header.MCrosstabHeaderCell;
import com.jaspersoft.studio.components.crosstab.model.nodata.MCrosstabWhenNoData;
import com.jaspersoft.studio.components.crosstab.model.nodata.MCrosstabWhenNoDataCell;
import com.jaspersoft.studio.components.crosstab.model.title.MTitle;
import com.jaspersoft.studio.components.crosstab.model.title.MTitleCell;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.layout.FreeLayout;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MGraphicElementLineBox;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.dataset.descriptor.DatasetRunPropertyDescriptor;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.checkbox.CheckBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.IntegerPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.JSSComboPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.CrosstabColumnCell;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.design.DesignCrosstabColumnCell;
import net.sf.jasperreports.crosstabs.design.JRDesignCellContents;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabDataset;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MCrosstab
extends MGraphicElementLineBox
implements IContainer,
IContainerEditPart,
IGroupElement,
IContainerLayout,
IDatasetContainer,
IPinContainer {
    public static final long serialVersionUID = 10200L;
    public static final String UPDATE_CROSSTAB_MODEL = "updateCrosstabModel";
    private boolean flagRefreshCells = false;
    private static NamedEnumPropertyDescriptor<RunDirectionEnum> runDirectionD;
    private static IIconDescriptor iconDescriptor;
    private static IPropertyDescriptor[] descriptors;
    private CrosstabManager ctManager;
    private MCrosstabDataset mCrosstabDataset;

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new CrosstabNodeIconDescriptor("crosstab");
        }
        return iconDescriptor;
    }

    public MCrosstab() {
    }

    public MCrosstab(ANode parent, int newIndex, CrosstabManager ctManager) {
        super(parent, newIndex);
        this.ctManager = ctManager;
    }

    public CrosstabManager getCrosstabManager() {
        return this.ctManager;
    }

    public MCrosstab(ANode parent, JRCrosstab jrCrosstab, int newIndex, CrosstabManager ctManager) {
        super(parent, newIndex);
        this.setValue(jrCrosstab);
        this.ctManager = ctManager;
    }

    public JRDesignCrosstab getValue() {
        return (JRDesignCrosstab)super.getValue();
    }

    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        runDirectionD = new NamedEnumPropertyDescriptor((Object)"runDirection", Messages.MCrosstab_run_direction, (Enum)RunDirectionEnum.LTR, NullEnum.NOTNULL);
        runDirectionD.setDescription(Messages.MCrosstab_run_direction_description);
        desc.add((IPropertyDescriptor)runDirectionD);
        JRExpressionPropertyDescriptor paramMapExprD = new JRExpressionPropertyDescriptor((Object)"parametersMapExpression", Messages.MCrosstab_parameter_map_expression);
        paramMapExprD.setDescription(Messages.MCrosstab_parameter_map_expression_description);
        paramMapExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#parametersMapExpression"));
        desc.add((IPropertyDescriptor)paramMapExprD);
        CheckBoxPropertyDescriptor repeatColumnHeadersD = new CheckBoxPropertyDescriptor((Object)"isRepeatColumnHeaders", Messages.MCrosstab_repeat_column_headers, NullEnum.NOTNULL);
        repeatColumnHeadersD.setDescription(Messages.MCrosstab_repeat_column_headers_description);
        desc.add((IPropertyDescriptor)repeatColumnHeadersD);
        CheckBoxPropertyDescriptor repeatRowHeadersD = new CheckBoxPropertyDescriptor((Object)"isRepeatRowHeaders", Messages.MCrosstab_repeat_row_headers, NullEnum.NOTNULL);
        repeatRowHeadersD.setDescription(Messages.MCrosstab_repeat_row_headers_description);
        desc.add((IPropertyDescriptor)repeatRowHeadersD);
        CheckBoxPropertyDescriptor ignoreWidthD = new CheckBoxPropertyDescriptor((Object)"ignoreWidth", Messages.MCrosstab_ignore_witdh, NullEnum.NULL);
        ignoreWidthD.setDescription(Messages.MCrosstab_ignore_witdh_description);
        desc.add((IPropertyDescriptor)ignoreWidthD);
        IntegerPropertyDescriptor columnBreakOffsetD = new IntegerPropertyDescriptor((Object)"columnBreakOffset", Messages.MCrosstab_column_break_offset);
        columnBreakOffsetD.setDescription(Messages.MCrosstab_column_break_offset_description);
        desc.add((IPropertyDescriptor)columnBreakOffsetD);
        DatasetRunPropertyDescriptor datasetD = new DatasetRunPropertyDescriptor((Object)"dataset", Messages.MCrosstab_dataset);
        datasetD.setDescription(Messages.MCrosstab_dataset_description);
        desc.add((IPropertyDescriptor)datasetD);
        JSSComboPropertyDescriptor horizongalPositionD = new JSSComboPropertyDescriptor((Object)"horizontalPosition", Messages.MCrosstab_horizontalposition, HorizontalPositionUtil.getItems());
        horizongalPositionD.setDescription(Messages.MCrosstab_horizontalposition);
        desc.add((IPropertyDescriptor)horizongalPositionD);
        CheckBoxPropertyDescriptor columnsFillDescriptor = new CheckBoxPropertyDescriptor((Object)"com.jaspersoft.studio.components.autoresize.proportional", Messages.MCrosstab_columnFitName);
        columnsFillDescriptor.setDescription(Messages.MCrosstab_columnFitDescription);
        desc.add((IPropertyDescriptor)columnsFillDescriptor);
        horizongalPositionD.setCategory(Messages.MCrosstab_crosstab_properties_category);
        datasetD.setCategory(Messages.MCrosstab_crosstab_properties_category);
        repeatColumnHeadersD.setCategory(Messages.MCrosstab_crosstab_properties_category);
        repeatRowHeadersD.setCategory(Messages.MCrosstab_crosstab_properties_category);
        ignoreWidthD.setCategory(Messages.MCrosstab_crosstab_properties_category);
        columnBreakOffsetD.setCategory(Messages.MCrosstab_crosstab_properties_category);
        runDirectionD.setCategory(Messages.MCrosstab_crosstab_properties_category);
        paramMapExprD.setCategory(Messages.MCrosstab_crosstab_properties_category);
        columnsFillDescriptor.setCategory(Messages.MCrosstab_crosstab_properties_category);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#crosstab");
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("com.jaspersoft.studio.components.autoresize.proportional", new DefaultValue((Object)Boolean.FALSE, false));
        return defaultsMap;
    }

    public void setGroupItems(String[] items) {
        if (this.mCrosstabDataset != null) {
            this.mCrosstabDataset.setGroupItems(items);
        }
    }

    public Object getPropertyValue(Object id) {
        JRDesignCrosstab jrElement = this.getValue();
        if (id.equals("isRepeatColumnHeaders")) {
            return jrElement.isRepeatColumnHeaders();
        }
        if (id.equals("horizontalPosition")) {
            return HorizontalPositionUtil.getPos4TextPosition(jrElement.getHorizontalPosition());
        }
        if (id.equals("isRepeatRowHeaders")) {
            return jrElement.isRepeatRowHeaders();
        }
        if (id.equals("ignoreWidth")) {
            return jrElement.getIgnoreWidth();
        }
        if (id.equals("columnBreakOffset")) {
            return jrElement.getColumnBreakOffset();
        }
        if (id.equals("runDirection")) {
            return runDirectionD.getIntValue((Enum)jrElement.getRunDirectionValue());
        }
        if (id.equals("parametersMapExpression")) {
            return ExprUtil.getExpression((JRExpression)jrElement.getParametersMapExpression());
        }
        if (id.equals("dataset")) {
            if (this.mCrosstabDataset == null) {
                this.mCrosstabDataset = new MCrosstabDataset(jrElement.getDataset(), this.getJasperDesign());
                this.setChildListener((ANode)this.mCrosstabDataset);
            }
            return this.mCrosstabDataset;
        }
        if (id.equals("com.jaspersoft.studio.components.autoresize.proportional")) {
            return this.hasColumnsAutoresizeProportional();
        }
        return super.getPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        JRDesignCrosstab jrElement = this.getValue();
        if (id.equals("isRepeatColumnHeaders")) {
            jrElement.setRepeatColumnHeaders(((Boolean)value).booleanValue());
        } else if (id.equals("isRepeatRowHeaders")) {
            jrElement.setRepeatRowHeaders(((Boolean)value).booleanValue());
        } else if (id.equals("horizontalPosition")) {
            jrElement.setHorizontalPosition(HorizontalPositionUtil.getTextPosition4Pos((Integer)value));
        } else if (id.equals("ignoreWidth")) {
            jrElement.setIgnoreWidth((Boolean)value);
        } else if (id.equals("columnBreakOffset")) {
            jrElement.setColumnBreakOffset(((Integer)value).intValue());
        }
        if (id.equals("runDirection")) {
            jrElement.setRunDirection((RunDirectionEnum)runDirectionD.getEnumValue(value));
            this.getCrosstabManager().refresh();
            this.getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent((Object)this, "runDirection", null, value));
        } else if (id.equals("parametersMapExpression")) {
            jrElement.setParametersMapExpression(ExprUtil.setValues((JRExpression)jrElement.getParametersMapExpression(), (Object)value));
        } else if (id.equals("com.jaspersoft.studio.components.autoresize.proportional")) {
            String oldValue = this.getValue().getPropertiesMap().getProperty("com.jaspersoft.studio.components.autoresize.proportional");
            Object newValue = null;
            if (value == null || !Boolean.parseBoolean(value.toString())) {
                this.getValue().getPropertiesMap().removeProperty("com.jaspersoft.studio.components.autoresize.proportional");
            } else {
                this.getValue().getPropertiesMap().setProperty("com.jaspersoft.studio.components.autoresize.proportional", value.toString());
                newValue = value;
            }
            this.propertyChange(new PropertyChangeEvent((Object)this, "com.jaspersoft.studio.components.autoresize.proportional", oldValue, newValue));
        } else if (id.equals("com.jaspersoft.studio.element.name")) {
            super.setPropertyValue(id, value);
            this.firePropertyChange(new PropertyChangeEvent(this.getValue(), "renamedElementEditor", false, true));
        } else {
            super.setPropertyValue(id, value);
        }
    }

    public int getDefaultHeight() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(((Object)((Object)this)).getClass(), "height");
        return defaultValue != null ? (Integer)defaultValue : 200;
    }

    public int getDefaultWidth() {
        Object defaultValue = DefaultManager.INSTANCE.getDefaultPropertiesValue(((Object)((Object)this)).getClass(), "width");
        return defaultValue != null ? (Integer)defaultValue : 200;
    }

    public JRDesignElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignCrosstab jrDesignElement = new JRDesignCrosstab((JRDefaultStyleProvider)jasperDesign);
        JRDesignCrosstabDataset dataset = new JRDesignCrosstabDataset();
        dataset.setDatasetRun((JRDatasetRun)new JRDesignDatasetRun());
        jrDesignElement.setDataset(dataset);
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(((Object)((Object)this)).getClass(), (JRElement)jrDesignElement);
        }
        jrDesignElement.getPropertiesMap().setProperty("com.jaspersoft.studio.layout", VerticalRowLayout.class.getName());
        return jrDesignElement;
    }

    public String getDisplayText() {
        String name = this.getElementNameProperty();
        return String.valueOf(MCrosstab.getIconDescriptor().getTitle()) + " " + Misc.nvl((String)name);
    }

    public ImageDescriptor getImagePath() {
        return MCrosstab.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MCrosstab.getIconDescriptor().getToolTip();
    }

    public void setValue(Object value) {
        JRCellContents wndCell;
        JRCellContents headerCell;
        JRCellContents titleCell;
        DesignCrosstabColumnCell tcc;
        JRDesignCrosstab oldObject = this.getValue();
        JRCrosstab newObject = (JRCrosstab)value;
        if (oldObject != null) {
            tcc = (DesignCrosstabColumnCell)oldObject.getTitleCell();
            if (tcc != null) {
                tcc.getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
                titleCell = tcc.getCellContents();
                if (titleCell != null) {
                    ((JRDesignCellContents)titleCell).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
                }
            }
            if ((headerCell = oldObject.getHeaderCell()) != null) {
                ((JRDesignCellContents)headerCell).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            if ((wndCell = oldObject.getWhenNoDataCell()) != null) {
                ((JRDesignCellContents)wndCell).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
            }
        }
        if (newObject != null) {
            tcc = (DesignCrosstabColumnCell)newObject.getTitleCell();
            if (tcc != null) {
                tcc.getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
                titleCell = tcc.getCellContents();
                if (titleCell != null) {
                    ((JRDesignCellContents)titleCell).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
                }
            }
            if ((headerCell = newObject.getHeaderCell()) != null) {
                ((JRDesignCellContents)headerCell).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
            if ((wndCell = newObject.getWhenNoDataCell()) != null) {
                ((JRDesignCellContents)wndCell).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
        }
        super.setValue(value);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        List child;
        if (this.getParent() == null || this.flagRefreshCells) {
            return;
        }
        String pname = evt.getPropertyName();
        Object newValue = evt.getNewValue();
        Object oldValue = evt.getOldValue();
        if (pname.equals("width") || pname.equals("height")) {
            this.getValue().preprocess();
            this.getCrosstabManager().init(this.getValue());
        } else if (pname.equals("headerCell")) {
            if (evt.getSource() == this.getValue()) {
                if (oldValue != null && newValue == null) {
                    child = this.getChildren();
                    int i = 0;
                    while (i < child.size()) {
                        INode n = (INode)child.get(i);
                        if (n instanceof MCrosstabHeaderCell) {
                            this.removeChild((ANode)n);
                            new MCrosstabHeader((ANode)this, i);
                            break;
                        }
                        ++i;
                    }
                } else {
                    child = this.getChildren();
                    int i = 0;
                    while (i < child.size()) {
                        INode n = (INode)child.get(i);
                        if (n instanceof MCrosstabHeader) {
                            this.removeChild((ANode)n);
                            new MCrosstabHeaderCell((ANode)this, (JRCellContents)newValue, i);
                            break;
                        }
                        ++i;
                    }
                }
            }
            this.getCrosstabManager().refresh();
        } else if (this.getParent() instanceof MPage) {
            if (pname.equals("titleCell")) {
                if (evt.getSource() == this.getValue()) {
                    if (oldValue != null && newValue == null) {
                        child = this.getChildren();
                        int i = 0;
                        while (i < child.size()) {
                            INode n = (INode)child.get(i);
                            if (n instanceof MTitleCell) {
                                this.removeChild((ANode)n);
                                new MTitle((ANode)this, i);
                                break;
                            }
                            ++i;
                        }
                    } else {
                        child = this.getChildren();
                        int i = 0;
                        while (i < child.size()) {
                            INode n = (INode)child.get(i);
                            if (n instanceof MTitle) {
                                this.removeChild((ANode)n);
                                new MTitleCell((ANode)this, (CrosstabColumnCell)newValue, i);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                this.getCrosstabManager().refresh();
            } else if (pname.equals("whenNoDataCell")) {
                if (evt.getSource() == this.getValue()) {
                    if (oldValue != null && newValue == null) {
                        child = this.getChildren();
                        int i = 0;
                        while (i < child.size()) {
                            INode n = (INode)child.get(i);
                            if (n instanceof MCrosstabWhenNoDataCell) {
                                this.removeChild((ANode)n);
                                new MCrosstabWhenNoData((ANode)this, i);
                                break;
                            }
                            ++i;
                        }
                    } else {
                        child = this.getChildren();
                        int i = 0;
                        while (i < child.size()) {
                            INode n = (INode)child.get(i);
                            if (n instanceof MCrosstabWhenNoData) {
                                this.removeChild((ANode)n);
                                new MCrosstabWhenNoDataCell((ANode)this, (JRCellContents)newValue, i);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                this.getCrosstabManager().refresh();
            } else if (pname.equals("cells") || pname.equals("rowGroups") || pname.equals("columnGroups")) {
                MCrosstab.super.propertyChange(evt);
                this.getCrosstabManager().refresh();
            } else if (pname.equals("measures")) {
                this.getCrosstabManager().refresh();
            }
        }
        if (evt.getPropertyName().equals(UPDATE_CROSSTAB_MODEL)) {
            this.getValue().preprocess();
            CrosstabComponentFactory.deleteCellNodes(this);
            CrosstabComponentFactory.createCellNodes(this.getValue(), this);
            this.getCrosstabManager().refresh();
            this.setChangedProperty(true, evt);
        }
        if (this.getCrosstabManager() != null && this.hasColumnsAutoresizeProportional() && this.isColumnsResizeEvent(evt)) {
            String oldAutoresizeValue = this.getValue().getPropertiesMap().getProperty("com.jaspersoft.studio.components.autoresize.proportional");
            this.getValue().getPropertiesMap().removeProperty("com.jaspersoft.studio.components.autoresize.proportional");
            this.getCrosstabManager().fillSpace(this.getValue().getWidth(), true);
            this.getValue().getPropertiesMap().setProperty("com.jaspersoft.studio.components.autoresize.proportional", oldAutoresizeValue);
        }
        super.propertyChange(evt);
    }

    public JRElementGroup getJRElementGroup() {
        return null;
    }

    public JRPropertiesHolder[] getPropertyHolder() {
        return new JRPropertiesHolder[]{this.getValue()};
    }

    public HashSet<String> generateGraphicalProperties() {
        HashSet result = super.generateGraphicalProperties();
        result.add("backcolor");
        result.add("style");
        result.add("mode");
        result.add("styleNameReference");
        result.add("width");
        result.add("height");
        result.add("elementGroup");
        result.add("columnGroups");
        result.add("rowGroups");
        result.add("measures");
        result.add("titleCell");
        result.add("headerCell");
        result.add("cells");
        result.add("totalPosition");
        return result;
    }

    public List<MDatasetRun> getDatasetRunList() {
        ArrayList<MDatasetRun> datasetList = new ArrayList<MDatasetRun>();
        MCrosstabDataset crosstabDataset = (MCrosstabDataset)((Object)this.getPropertyValue("dataset"));
        datasetList.add((MDatasetRun)crosstabDataset.getPropertyValue("datasetRun"));
        return datasetList;
    }

    private void fillUsedStyles(List<INode> children, Map<String, List<ANode>> map) {
        for (INode node : children) {
            if (!(node instanceof ANode)) continue;
            this.mergeElementStyle(map, ((ANode)node).getUsedStyles());
        }
    }

    public Map<String, List<ANode>> getUsedStyles() {
        Map result = super.getUsedStyles();
        this.fillUsedStyles(this.getChildren(), result);
        return result;
    }

    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        JRDesignCrosstab jrSource = this.getValue();
        if (jrSource != null) {
            JRDesignCrosstab jrTarget = (JRDesignCrosstab)target;
            jrTarget.setRepeatColumnHeaders(jrSource.isRepeatColumnHeaders());
            jrTarget.setRepeatRowHeaders(jrSource.isRepeatRowHeaders());
            jrTarget.setHorizontalPosition(jrSource.getHorizontalPosition());
            jrTarget.setIgnoreWidth(jrSource.getIgnoreWidth());
            jrTarget.setColumnBreakOffset(jrSource.getColumnBreakOffset());
            jrTarget.setRunDirection(jrSource.getRunDirectionValue());
        }
    }

    public boolean showChildren() {
        return this.getParent() instanceof MPage;
    }

    public void createSubeditor() {
        CrosstabComponentFactory.createSubeditor(this);
    }

    public ExpressionContext getExpressionContext() {
        return new ExpressionContext(this.getValue(), this.getJasperConfiguration());
    }

    public ILayout getDefaultLayout() {
        return LayoutManager.getLayout((String)FreeLayout.class.getName());
    }

    public boolean hasColumnsAutoresizeProportional() {
        JRPropertiesMap map;
        String value;
        if (this.getValue() != null && (value = (map = this.getValue().getPropertiesMap()).getProperty("com.jaspersoft.studio.components.autoresize.proportional")) != null) {
            return Boolean.parseBoolean(value.toString());
        }
        return false;
    }

    private boolean isColumnsResizeEvent(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("width")) {
            return true;
        }
        return evt.getPropertyName().equals("com.jaspersoft.studio.components.autoresize.proportional");
    }
}

