/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.columngroup.command;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.CrosstabUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.cell.MCell;
import com.jaspersoft.studio.components.crosstab.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.crosstab.model.columngroup.MColumnGroups;
import com.jaspersoft.studio.components.crosstab.model.columngroup.command.DeleteColumnGroupCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Display;

public class CreateColumnCommand
extends Command {
    private JRDesignCrosstabColumnGroup jrGroup;
    private MCrosstab crosstabNode;
    private JRDesignCrosstab jrCrosstab;
    private int index;
    private JasperDesign jasperDesign;

    public CreateColumnCommand(MColumnGroups destNode, MColumnGroup srcNode, int index) {
        this((ANode)destNode, srcNode, index);
    }

    public CreateColumnCommand(MColumnGroup destNode, MColumnGroup srcNode, int index) {
        this(destNode.getMCrosstab(), srcNode, index);
    }

    public CreateColumnCommand(MCell destNode, MColumnGroup srcNode, int index) {
        this(destNode.getMCrosstab(), srcNode, index);
    }

    public CreateColumnCommand(MCrosstab destNode, MColumnGroup srcNode, int index) {
        this((ANode)destNode, srcNode, index);
    }

    public CreateColumnCommand(MCrosstab destNode, JRDesignCrosstabColumnGroup jrGroup, int index) {
        this.crosstabNode = destNode;
        this.jrCrosstab = destNode.getValue();
        this.index = index;
        this.jrGroup = jrGroup;
        this.jasperDesign = destNode.getJasperDesign();
    }

    private CreateColumnCommand(ANode destNode, MColumnGroup srcNode, int index) {
        this.crosstabNode = srcNode.getMCrosstab();
        this.jrCrosstab = (JRDesignCrosstab)destNode.getValue();
        this.index = index;
        if (srcNode != null && srcNode.getValue() != null) {
            this.jrGroup = srcNode.getValue();
        }
        this.jasperDesign = destNode.getJasperDesign();
    }

    public void execute() {
        block4: {
            if (this.jrGroup == null) {
                this.jrGroup = CrosstabUtil.createColumnGroup(this.jasperDesign, this.jrCrosstab, Messages.CreateColumnGroupCommand_column_group, CrosstabTotalPositionEnum.END);
            }
            if (this.jrGroup != null) {
                try {
                    CrosstabUtil.addColumnGroup(this.jrCrosstab, this.jrGroup, this.index);
                }
                catch (JRException e) {
                    e.printStackTrace();
                    if (!e.getMessage().startsWith("A group or measure having the same name already exists in the crosstab.")) break block4;
                    String defaultName = ModelUtils.getDefaultName((Map)this.jrCrosstab.getColumnGroupIndicesMap(), (String)"CopyOFColumnGroup_");
                    InputDialog dlg = new InputDialog(Display.getDefault().getActiveShell(), Messages.CreateColumnGroupCommand_column_group_name, Messages.CreateColumnGroupCommand_column_group_name_dialog, defaultName, null);
                    if (dlg.open() != 0) break block4;
                    this.jrGroup.setName(dlg.getValue());
                    this.execute();
                }
            }
        }
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrGroup);
        this.jrCrosstab.getEventSupport().firePropertyChange("com.jaspersoft.studio.components.autoresize.proportional", null, (Object)this.jrGroup);
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        DeleteColumnGroupCommand deleteCommand = new DeleteColumnGroupCommand(this.crosstabNode, this.jrGroup);
        deleteCommand.execute();
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrGroup);
        this.jrCrosstab.getEventSupport().firePropertyChange("com.jaspersoft.studio.components.autoresize.proportional", (Object)this.jrGroup, null);
    }
}

