/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.columngroup.command;

import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.CrosstabUtil;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.crosstab.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.crosstab.model.columngroup.MColumnGroups;
import com.jaspersoft.studio.components.crosstab.model.columngroup.command.DeleteColumnGroupCommand;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.LazyCrosstabLayoutCommand;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.engine.JRException;
import org.eclipse.gef.commands.Command;

public class ReorderColumnGroupCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private JRDesignCrosstabColumnGroup jrColumnGroup;
    private MCrosstab crosstabNode;
    private JRDesignCrosstab jrCrosstab;
    private LazyCrosstabLayoutCommand layoutCommand;

    public ReorderColumnGroupCommand(MColumnGroup child, MColumnGroups parent, int newIndex) {
        super(Messages.common_reorder_elements);
        this.newIndex = Math.max(0, newIndex);
        this.crosstabNode = child.getMCrosstab();
        this.jrCrosstab = (JRDesignCrosstab)parent.getValue();
        this.jrColumnGroup = child.getValue();
        this.layoutCommand = new LazyCrosstabLayoutCommand(child.getMCrosstab());
    }

    public void execute() {
        this.oldIndex = this.jrCrosstab.getColumnGroupsList().indexOf(this.jrColumnGroup);
        DeleteColumnGroupCommand deleteCommand = new DeleteColumnGroupCommand(this.crosstabNode, this.jrColumnGroup);
        deleteCommand.execute();
        try {
            CrosstabUtil.addColumnGroup(this.jrCrosstab, this.jrColumnGroup, this.newIndex, deleteCommand.getRemovedCells());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrColumnGroup);
        this.layoutCommand.execute();
    }

    public void undo() {
        DeleteColumnGroupCommand deleteCommand = new DeleteColumnGroupCommand(this.crosstabNode, this.jrColumnGroup);
        deleteCommand.execute();
        try {
            CrosstabUtil.addColumnGroup(this.jrCrosstab, this.jrColumnGroup, this.oldIndex, deleteCommand.getRemovedCells());
        }
        catch (JRException e) {
            e.printStackTrace();
        }
        this.jrCrosstab.getEventSupport().firePropertyChange("updateCrosstabModel", null, (Object)this.jrColumnGroup);
        this.layoutCommand.undo();
    }

    public boolean canExecute() {
        return this.newIndex != -1;
    }
}

