/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.crosstab.command;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.model.command.DeleteElementCommand;
import com.jaspersoft.studio.model.style.command.DeleteStyleCommand;
import com.jaspersoft.studio.utils.ModelUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.util.RunnableCancelQuestion;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceStore;

public class DeleteCrosstabCommand
extends DeleteElementCommand {
    private List<Command> delteStylesCommand = new ArrayList<Command>();
    private MCrosstab crosstab;
    private boolean cancelled = false;

    public DeleteCrosstabCommand(MCrosstab srcNode) {
        super((MGraphicElement)srcNode);
        this.crosstab = srcNode;
    }

    private boolean isUsedOnlyByCrosstab(List<ANode> nodesUsingInsideCrosstab, List<ANode> nodesUsingOutsideCrosstab) {
        if (nodesUsingInsideCrosstab == null || nodesUsingOutsideCrosstab == null) {
            return false;
        }
        if (nodesUsingInsideCrosstab.size() != nodesUsingOutsideCrosstab.size()) {
            return false;
        }
        for (ANode nodeUsingInsideTable : nodesUsingInsideCrosstab) {
            if (nodesUsingOutsideCrosstab.contains(nodeUsingInsideTable)) continue;
            return false;
        }
        return true;
    }

    protected boolean isExistingInternalStyle(String styleName, JasperDesign jd) {
        if (styleName != null) {
            return jd.getStylesMap().containsKey(styleName);
        }
        return false;
    }

    protected boolean hasStyleProperties(JRPropertiesMap crosstabMap) {
        return crosstabMap.containsProperty("com.jaspersoft.studio.crosstab.style.group") || crosstabMap.containsProperty("com.jaspersoft.studio.crosstab.style.detail") || crosstabMap.containsProperty("com.jaspersoft.studio.crosstab.style.header") || crosstabMap.containsProperty("com.jaspersoft.studio.crosstab.style.total");
    }

    public void execute() {
        this.delteStylesCommand.clear();
        MReport report = ModelUtils.getReport((ANode)this.crosstab);
        Map reportStyles = report.getUsedStyles();
        Map<String, List<ANode>> crosstabStyles = this.crosstab.getUsedStyles();
        HashSet<String> unusedStyles = new HashSet<String>();
        for (Map.Entry<String, List<ANode>> entry : crosstabStyles.entrySet()) {
            List nodesUsingOutsideTable = (List)reportStyles.get(entry.getKey());
            if (!this.jDesign.getStylesMap().containsKey(entry.getKey()) || !this.isUsedOnlyByCrosstab(entry.getValue(), nodesUsingOutsideTable)) continue;
            unusedStyles.add(entry.getKey());
        }
        JRPropertiesMap tableMap = this.crosstab.getPropertiesMap();
        if (this.hasStyleProperties(tableMap)) {
            String styleName = tableMap.getProperty("com.jaspersoft.studio.crosstab.style.detail");
            if (this.isExistingInternalStyle(styleName, this.jDesign)) {
                unusedStyles.add(styleName);
            }
            if (this.isExistingInternalStyle(styleName = tableMap.getProperty("com.jaspersoft.studio.crosstab.style.group"), this.jDesign)) {
                unusedStyles.add(styleName);
            }
            if (this.isExistingInternalStyle(styleName = tableMap.getProperty("com.jaspersoft.studio.crosstab.style.header"), this.jDesign)) {
                unusedStyles.add(styleName);
            }
            if (this.isExistingInternalStyle(styleName = tableMap.getProperty("com.jaspersoft.studio.crosstab.style.total"), this.jDesign)) {
                unusedStyles.add(styleName);
            }
        }
        if (!unusedStyles.isEmpty()) {
            String unusedStylesName = "";
            int count = 0;
            for (String styleName : unusedStyles) {
                unusedStylesName = String.valueOf(unusedStylesName) + styleName;
                if (count != unusedStyles.size() - 1) {
                    unusedStylesName = String.valueOf(unusedStylesName) + ", ";
                }
                ++count;
            }
            RunnableCancelQuestion.RESPONSE_TYPE response = this.getResponse(unusedStylesName);
            if (response == RunnableCancelQuestion.RESPONSE_TYPE.YES) {
                for (String style : unusedStyles) {
                    JRStyle styleObject = (JRStyle)this.jDesign.getStylesMap().get(style);
                    DeleteStyleCommand command = new DeleteStyleCommand(report, (JRDesignStyle)styleObject);
                    this.delteStylesCommand.add((Command)command);
                }
            } else if (response == RunnableCancelQuestion.RESPONSE_TYPE.CANCEL) {
                this.cancelled = true;
            }
        }
        if (!this.cancelled) {
            for (Command cmd : this.delteStylesCommand) {
                cmd.execute();
            }
            super.execute();
        }
    }

    public void undo() {
        if (!this.cancelled) {
            for (Command cmd : this.delteStylesCommand) {
                cmd.undo();
            }
            super.undo();
        }
    }

    protected RunnableCancelQuestion.RESPONSE_TYPE getResponse(String unusedStylesName) {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String styleBehavior = store.getString("tableCrosstabDelete");
        if (styleBehavior.equals("deleteStyles")) {
            return RunnableCancelQuestion.RESPONSE_TYPE.YES;
        }
        if (styleBehavior.equals("doNotDelete")) {
            return RunnableCancelQuestion.RESPONSE_TYPE.NO;
        }
        String questionText = MessageFormat.format(Messages.DeleteTableCommand_unusedMessage, unusedStylesName);
        Pair response = UIUtils.showCancellableConfirmation((String)Messages.DeleteTableCommand_unusedTitle, (String)questionText, (String)Messages.EditTableStyleAction_rememberDecision);
        if (((Boolean)response.getValue()).booleanValue()) {
            if (response.getKey() == RunnableCancelQuestion.RESPONSE_TYPE.YES) {
                store.setValue("tableCrosstabDelete", "deleteStyles");
            } else if (response.getKey() == RunnableCancelQuestion.RESPONSE_TYPE.NO) {
                store.setValue("tableCrosstabDelete", "doNotDelete");
            }
        }
        return (RunnableCancelQuestion.RESPONSE_TYPE)response.getKey();
    }
}

