/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.crosstab.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.crosstab.model.MCrosstab;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutCommand;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.layout.VerticalRowLayout;
import com.jaspersoft.studio.model.ANode;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesMap;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.gef.commands.Command;

public class LazyCrosstabLayoutCommand
extends Command {
    private JSSCompoundCommand cmd = null;
    private MCrosstab container;

    public LazyCrosstabLayoutCommand(MCrosstab container) {
        this.container = container;
    }

    public boolean canExecute() {
        return this.container != null;
    }

    public void execute() {
        this.cmd = new JSSCompoundCommand((ANode)this.container);
        this.createLayoutCommand(this.cmd);
        if (this.cmd != null) {
            this.cmd.execute();
        }
    }

    public void undo() {
        if (this.cmd != null) {
            this.cmd.undo();
        }
    }

    public void createLayoutCommand(JSSCompoundCommand c) {
        if (this.container == null) {
            return;
        }
        JRDesignCrosstab crosstab = this.container.getValue();
        JRCrosstabRowGroup[] jRCrosstabRowGroupArray = crosstab.getRowGroups();
        int n = jRCrosstabRowGroupArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRCrosstabRowGroup rowGroup = jRCrosstabRowGroupArray[n2];
            this.createRelayoutCommand(rowGroup.getTotalHeader(), c);
            this.createRelayoutCommand(rowGroup.getHeader(), c);
            ++n2;
        }
        jRCrosstabRowGroupArray = crosstab.getColumnGroups();
        n = jRCrosstabRowGroupArray.length;
        n2 = 0;
        while (n2 < n) {
            JRCrosstabRowGroup colGroup = jRCrosstabRowGroupArray[n2];
            this.createRelayoutCommand(colGroup.getTotalHeader(), c);
            this.createRelayoutCommand(colGroup.getHeader(), c);
            this.createRelayoutCommand(colGroup.getCrosstabHeader(), c);
            ++n2;
        }
        for (JRCrosstabCell cell : crosstab.getCellsList()) {
            this.createRelayoutCommand(cell, c);
        }
    }

    private void createRelayoutCommand(JRCellContents jrElement, JSSCompoundCommand c) {
        if (jrElement != null) {
            JRCellContents jrGroup = jrElement;
            Dimension d = new Dimension();
            d.setSize(new Dimension(jrElement.getWidth(), jrElement.getHeight()));
            JRPropertiesMap map = jrElement.getPropertiesMap();
            String str = map.getProperty("com.jaspersoft.studio.layout");
            if (str == null) {
                str = VerticalRowLayout.class.getName();
            }
            ILayout parentLayout = LayoutManager.getLayout((String)str);
            d = LayoutManager.getPaddedSize((JRBoxContainer)jrElement, (Dimension)d);
            c.add((Command)new LayoutCommand(this.container.getJasperDesign(), (JRElementGroup)jrGroup, parentLayout, d));
        }
    }

    private void createRelayoutCommand(JRCrosstabCell jrElement, JSSCompoundCommand c) {
        if (jrElement != null) {
            this.createRelayoutCommand(jrElement.getContents(), c);
        }
    }
}

