/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.AgregationFunctionEnum;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.CrosstabWizard;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.Wrapper;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.combo.EditableComboBoxCellEditor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.fields.StaticWizardFieldsPage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabBucket;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.analytics.dataset.BucketOrder;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CrosstabWizardColumnPage
extends StaticWizardFieldsPage {
    private static final String F_CALCULATION = "CALCULATION";
    private static final String F_TOTALPOSITION = "TOTALPOSITION";
    private static final String F_ORDER = "ORDER";
    private static final String F_NAME = "NAME";
    protected static final String[] bucketOrderNames = EnumHelper.getEnumNames((NamedEnum[])BucketOrder.values(), (NullEnum)NullEnum.NOTNULL);
    protected static final String[] crosstabTotalPositionEnumNames = EnumHelper.getEnumNames((NamedEnum[])CrosstabTotalPositionEnum.values(), (NullEnum)NullEnum.NOTNULL);

    protected CrosstabWizardColumnPage() {
        this("crosstabcolumnpage");
    }

    protected CrosstabWizardColumnPage(String pagename) {
        super(pagename);
        this.setTitle(Messages.CrosstabWizardColumnPage_columns);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/wizard_columns.png"));
        this.setDescription(Messages.CrosstabWizardColumnPage_description);
        this.setPageComplete(false);
    }

    public void setAvailableFields(List<?> inFields) {
        ArrayList<Wrapper> nlist = new ArrayList<Wrapper>();
        if (inFields != null) {
            for (Object obj : inFields) {
                nlist.add(new Wrapper(obj));
            }
        }
        super.setAvailableFields(nlist);
    }

    public List<Object> getAvailableFields() {
        List wlist = super.getAvailableFields();
        if (wlist != null) {
            ArrayList<Object> out = new ArrayList<Object>(wlist.size());
            for (Object w : wlist) {
                out.add(((Wrapper)w).getValue());
            }
            return out;
        }
        return null;
    }

    public List<Object> getSelectedFields() {
        List wlist = super.getSelectedFields();
        if (wlist != null) {
            ArrayList<Object> out = new ArrayList<Object>(wlist.size());
            for (Object w : wlist) {
                out.add(((Wrapper)w).getValue());
            }
            return out;
        }
        return null;
    }

    public List<Wrapper> getSelectedFieldWrappers() {
        List wlist = super.getSelectedFields();
        if (wlist != null) {
            ArrayList<Wrapper> out = new ArrayList<Wrapper>(wlist.size());
            for (Object w : wlist) {
                out.add((Wrapper)w);
            }
            return out;
        }
        return null;
    }

    protected void setLabelProvider(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new TColumnLabelProvider());
    }

    protected void createColumns() {
        TableColumn[] col = new TableColumn[4];
        col[0] = new TableColumn(this.rightTable, 0);
        col[0].setText(Messages.common_fields);
        col[0].pack();
        col[1] = new TableColumn(this.rightTable, 0);
        col[1].setText(Messages.common_order);
        col[1].pack();
        col[2] = new TableColumn(this.rightTable, 0);
        col[2].setText(Messages.common_total_position);
        col[2].pack();
        col[3] = new TableColumn(this.rightTable, 0);
        col[3].setText(Messages.common_calculation);
        col[3].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(20, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(30, false));
        this.rightTable.setLayout((Layout)tlayout);
    }

    protected void attachCellEditors(final TableViewer viewer, Composite parent) {
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (property.equals(CrosstabWizardColumnPage.F_ORDER)) {
                    return true;
                }
                if (property.equals(CrosstabWizardColumnPage.F_TOTALPOSITION)) {
                    return true;
                }
                if (property.equals(CrosstabWizardColumnPage.F_CALCULATION)) {
                    return AgregationFunctionEnum.isEditable(((Wrapper)element).getBaseObjectType());
                }
                return false;
            }

            public Object getValue(Object element, String property) {
                Wrapper w = (Wrapper)element;
                JRDesignCrosstabColumnGroup prop = (JRDesignCrosstabColumnGroup)w.getValue();
                if (CrosstabWizardColumnPage.F_NAME.equals(property)) {
                    return ((TColumnLabelProvider)viewer.getLabelProvider()).getColumnText(element, 1);
                }
                if (CrosstabWizardColumnPage.F_ORDER.equals(property)) {
                    return EnumHelper.getEnumIndexByTranslatedName((String[])bucketOrderNames, (NamedEnum)prop.getBucket().getOrder());
                }
                if (CrosstabWizardColumnPage.F_TOTALPOSITION.equals(property)) {
                    return EnumHelper.getEnumIndexByTranslatedName((String[])crosstabTotalPositionEnumNames, (NamedEnum)prop.getTotalPositionValue());
                }
                if (CrosstabWizardColumnPage.F_CALCULATION.equals(property)) {
                    return w.getCalculation() != null ? w.getCalculation() : "";
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                CrosstabWizardColumnPage.this.setErrorMessage(null);
                CrosstabWizardColumnPage.this.setMessage(CrosstabWizardColumnPage.this.getDescription());
                Wrapper w = (Wrapper)tableItem.getData();
                JRDesignCrosstabColumnGroup data = (JRDesignCrosstabColumnGroup)w.getValue();
                JRDesignCrosstabBucket bucket = (JRDesignCrosstabBucket)data.getBucket();
                if (CrosstabWizardColumnPage.F_ORDER.equals(property)) {
                    bucket.setOrder((BucketOrder)EnumHelper.getEnumByObjectValue((NamedEnum[])BucketOrder.values(), (Object)value));
                } else if (CrosstabWizardColumnPage.F_TOTALPOSITION.equals(property)) {
                    data.setTotalPosition((CrosstabTotalPositionEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])CrosstabTotalPositionEnum.values(), (Object)value));
                } else if (CrosstabWizardColumnPage.F_CALCULATION.equals(property)) {
                    AgregationFunctionEnum function = (AgregationFunctionEnum)((Object)value);
                    w.setCalculation(function);
                    CrosstabWizard.setBucketExpression(bucket, w.getBaseObjectExpression(), function);
                }
                viewer.update(element, new String[]{property});
                viewer.refresh();
            }
        });
        TextCellEditor nameEditor = new TextCellEditor(parent);
        ComboBoxCellEditor sortEditor = new ComboBoxCellEditor(parent, EnumHelper.getEnumNames((NamedEnum[])SortOrderEnum.values(), (NullEnum)NullEnum.NOTNULL), 8);
        ComboBoxCellEditor totalEditor = new ComboBoxCellEditor(parent, EnumHelper.getEnumNames((NamedEnum[])CrosstabTotalPositionEnum.values(), (NullEnum)NullEnum.NOTNULL), 8);
        EditableComboBoxCellEditor aggregationEditor = new EditableComboBoxCellEditor(parent, new String[0], 8){

            protected void doSetValue(Object value) {
                AgregationFunctionEnum[] values;
                int index;
                StructuredSelection sel = (StructuredSelection)CrosstabWizardColumnPage.this.rightTView.getSelection();
                if (!sel.isEmpty()) {
                    Wrapper selected = (Wrapper)sel.getFirstElement();
                    String className = selected.getBaseObjectType();
                    AgregationFunctionEnum[] values2 = AgregationFunctionEnum.getStringValues(className);
                    String[] names = AgregationFunctionEnum.getValuesNames(values2);
                    this.comboBox.setItems(names);
                    this.comboBox.setData((Object)values2);
                }
                if ((index = Arrays.asList(values = (AgregationFunctionEnum[])this.comboBox.getData()).indexOf(value)) >= 0 && index < this.comboBox.getItemCount()) {
                    super.doSetValue((Object)index);
                } else {
                    this.doSetValue(0);
                }
            }

            protected Object doGetValue() {
                int index = (Integer)super.doGetValue();
                AgregationFunctionEnum[] values = (AgregationFunctionEnum[])this.comboBox.getData();
                return values[index];
            }
        };
        viewer.setCellEditors(new CellEditor[]{nameEditor, sortEditor, totalEditor, aggregationEditor});
        viewer.setColumnProperties(new String[]{F_NAME, F_ORDER, F_TOTALPOSITION, F_CALCULATION});
    }

    public void loadSettings() {
        if (this.getSettings() == null) {
            return;
        }
        if (this.getWizard() instanceof CrosstabWizard) {
            this.setAvailableFields(((CrosstabWizard)this.getWizard()).getAvailableColumnGroups());
        } else {
            this.setAvailableFields(null);
        }
    }

    public void storeSettings() {
        if (this.getWizard() instanceof JSSWizard && this.getWizard() != null) {
            Map settings = ((JSSWizard)this.getWizard()).getSettings();
            if (settings == null) {
                return;
            }
            settings.put("CROSSTAB_COLUMNS", this.getSelectedFields());
            this.getContainer().updateButtons();
        }
    }

    public boolean isPageComplete() {
        if (this.getWizard() instanceof JSSWizard && this.getWizard() != null) {
            Map settings = ((JSSWizard)this.getWizard()).getSettings();
            if (settings != null && settings.get("CROSSTAB_COLUMNS") != null) {
                List fields = (List)settings.get("CROSSTAB_COLUMNS");
                return !fields.isEmpty();
            }
            return false;
        }
        return super.isPageComplete();
    }

    protected Object findElement(Object object, List<?> fields) {
        String objName = ((TColumnLabelProvider)this.rightTView.getLabelProvider()).getColumnText(object, 0);
        for (Object obj : fields) {
            if (!((TColumnLabelProvider)this.leftTView.getLabelProvider()).getColumnText(obj, 0).equals(objName)) continue;
            return obj;
        }
        return null;
    }

    private final class TColumnLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TColumnLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Wrapper w = (Wrapper)element;
            String oldExpText = w.getBaseObjectExpression();
            switch (columnIndex) {
                case 0: {
                    if (oldExpText.startsWith("$F{")) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MField.getIconDescriptor().getIcon16());
                    }
                    if (oldExpText.startsWith("$P{")) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MParameter.getIconDescriptor().getIcon16());
                    }
                    if (!oldExpText.startsWith("$V{")) break;
                    return JaspersoftStudioPlugin.getInstance().getImage(MVariable.getIconDescriptor().getIcon16());
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Wrapper w = (Wrapper)element;
            JRDesignCrosstabColumnGroup m = (JRDesignCrosstabColumnGroup)w.getValue();
            JRCrosstabBucket bucket = m.getBucket();
            switch (columnIndex) {
                case 0: {
                    return w.getLabel();
                }
                case 1: {
                    return bucket.getOrder().getName();
                }
                case 2: {
                    return m.getTotalPositionValue().getName();
                }
                case 3: {
                    return w.getCalculation() != null ? w.getCalculation().getName() : "";
                }
            }
            return "";
        }
    }
}

