/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.crosstab.messages.Messages;
import com.jaspersoft.studio.components.crosstab.model.crosstab.command.wizard.CrosstabWizard;
import com.jaspersoft.studio.model.field.MField;
import com.jaspersoft.studio.model.parameter.MParameter;
import com.jaspersoft.studio.model.variable.MVariable;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.wizards.JSSWizard;
import com.jaspersoft.studio.wizards.fields.StaticWizardFieldsPage;
import java.sql.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstabMeasure;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class CrosstabWizardMeasurePage
extends StaticWizardFieldsPage {
    private static final String F_CALCULATION = "CALCULATION";
    private static final String F_NAME = "NAME";
    private static LinkedHashMap<Object, String> enumValuesMap = EnumHelper.getEnumMapNames((NamedEnum[])CalculationEnum.values(), (NullEnum)NullEnum.NOTNULL);

    protected CrosstabWizardMeasurePage() {
        super("crosstabmeasurepage");
        this.setTitle(Messages.CrosstabWizardMeasurePage_measures);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/wizard_details.png"));
        this.setDescription(Messages.CrosstabWizardMeasurePage_description);
        this.setPageComplete(false);
    }

    protected void setLabelProvider(TableViewer tableViewer) {
        tableViewer.setLabelProvider((IBaseLabelProvider)new TMeasureLabelProvider());
    }

    protected void createColumns() {
        TableColumn[] col = new TableColumn[2];
        col[0] = new TableColumn(this.rightTable, 0);
        col[0].setText(Messages.common_fields);
        col[0].pack();
        col[1] = new TableColumn(this.rightTable, 0);
        col[1].setText(Messages.common_calculation);
        col[1].pack();
        TableLayout tlayout = new TableLayout();
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, false));
        tlayout.addColumnData((ColumnLayoutData)new ColumnWeightData(50, false));
        this.rightTable.setLayout((Layout)tlayout);
    }

    protected void attachCellEditors(final TableViewer viewer, Composite parent) {
        String[] enumNames = enumValuesMap.values().toArray(new String[enumValuesMap.values().size()]);
        final ComboBoxCellEditor calcCombo = new ComboBoxCellEditor(parent, enumNames, 8);
        viewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                JRDesignCrosstabMeasure prop = (JRDesignCrosstabMeasure)element;
                if (property.equals(CrosstabWizardMeasurePage.F_CALCULATION)) {
                    String[] items = null;
                    items = Date.class.isAssignableFrom(prop.getValueClass()) ? new String[]{(String)enumValuesMap.get(CalculationEnum.COUNT), (String)enumValuesMap.get(CalculationEnum.DISTINCT_COUNT), (String)enumValuesMap.get(CalculationEnum.HIGHEST), (String)enumValuesMap.get(CalculationEnum.LOWEST), (String)enumValuesMap.get(CalculationEnum.FIRST), (String)enumValuesMap.get(CalculationEnum.NOTHING)} : (Number.class.isAssignableFrom(prop.getValueClass()) ? enumValuesMap.values().toArray(new String[enumValuesMap.values().size()]) : new String[]{(String)enumValuesMap.get(CalculationEnum.COUNT), (String)enumValuesMap.get(CalculationEnum.DISTINCT_COUNT), (String)enumValuesMap.get(CalculationEnum.FIRST), (String)enumValuesMap.get(CalculationEnum.NOTHING)});
                    calcCombo.setItems(items);
                    return true;
                }
                return false;
            }

            public Object getValue(Object element, String property) {
                JRDesignCrosstabMeasure prop = (JRDesignCrosstabMeasure)element;
                if (CrosstabWizardMeasurePage.F_NAME.equals(property)) {
                    return ((TMeasureLabelProvider)viewer.getLabelProvider()).getColumnText(element, 1);
                }
                if (CrosstabWizardMeasurePage.F_CALCULATION.equals(property)) {
                    String name = (String)enumValuesMap.get(prop.getCalculationValue());
                    String[] items = calcCombo.getItems();
                    int i = 0;
                    while (i < items.length) {
                        if (items[i].equals(name)) {
                            return i;
                        }
                        ++i;
                    }
                    return 0;
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tableItem = (TableItem)element;
                CrosstabWizardMeasurePage.this.setErrorMessage(null);
                CrosstabWizardMeasurePage.this.setMessage(CrosstabWizardMeasurePage.this.getDescription());
                JRDesignCrosstabMeasure data = (JRDesignCrosstabMeasure)tableItem.getData();
                if (CrosstabWizardMeasurePage.F_CALCULATION.equals(property)) {
                    String name = calcCombo.getItems()[(Integer)value];
                    for (Map.Entry enumPair : enumValuesMap.entrySet()) {
                        if (!((String)enumPair.getValue()).equals(name)) continue;
                        data.setCalculation((CalculationEnum)enumPair.getKey());
                    }
                }
                viewer.update(element, new String[]{property});
                viewer.refresh();
            }
        });
        viewer.setCellEditors(new CellEditor[]{new TextCellEditor(parent), calcCombo});
        viewer.setColumnProperties(new String[]{F_NAME, F_CALCULATION});
    }

    public void loadSettings() {
        if (this.getSettings() == null) {
            return;
        }
        if (this.getWizard() instanceof CrosstabWizard) {
            this.setAvailableFields(((CrosstabWizard)this.getWizard()).getAvailableMeasures());
        } else {
            this.setAvailableFields(null);
        }
    }

    public void storeSettings() {
        if (this.getWizard() instanceof JSSWizard && this.getWizard() != null) {
            Map settings = ((JSSWizard)this.getWizard()).getSettings();
            if (settings == null) {
                return;
            }
            settings.put("CROSSTAB_MEASURES", this.getSelectedFields());
            this.getContainer().updateButtons();
        }
    }

    public boolean isPageComplete() {
        if (this.getWizard() instanceof JSSWizard && this.getWizard() != null) {
            Map settings = ((JSSWizard)this.getWizard()).getSettings();
            if (settings != null && settings.get("CROSSTAB_MEASURES") != null) {
                List fields = (List)settings.get("CROSSTAB_MEASURES");
                return !fields.isEmpty();
            }
            return false;
        }
        return super.isPageComplete();
    }

    protected Object findElement(Object object, List<?> fields) {
        String objName = ((TMeasureLabelProvider)this.rightTView.getLabelProvider()).getColumnText(object, 0);
        for (Object obj : fields) {
            if (!((TMeasureLabelProvider)this.leftTView.getLabelProvider()).getColumnText(obj, 0).equals(objName)) continue;
            return obj;
        }
        return null;
    }

    private final class TMeasureLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private TMeasureLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            JRDesignCrosstabMeasure m = (JRDesignCrosstabMeasure)element;
            String txt = m.getValueExpression().getText();
            switch (columnIndex) {
                case 0: {
                    if (txt.startsWith("$F{")) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MField.getIconDescriptor().getIcon16());
                    }
                    if (txt.startsWith("$P{")) {
                        return JaspersoftStudioPlugin.getInstance().getImage(MParameter.getIconDescriptor().getIcon16());
                    }
                    if (!txt.startsWith("$V{")) break;
                    return JaspersoftStudioPlugin.getInstance().getImage(MVariable.getIconDescriptor().getIcon16());
                }
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            JRDesignCrosstabMeasure m = (JRDesignCrosstabMeasure)element;
            String txt = m.getValueExpression().getText();
            switch (columnIndex) {
                case 0: {
                    return txt.substring(3, txt.length() - 1);
                }
                case 1: {
                    if (m == null || m.getCalculationValue() == null) {
                        return "";
                    }
                    return (String)enumValuesMap.get(m.getCalculationValue());
                }
            }
            return "";
        }
    }
}

