/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.model.dialog;

import com.jaspersoft.studio.components.crosstab.model.dialog.CrosstabStyle;
import com.jaspersoft.studio.editor.gef.figures.borders.ShadowBorder;
import com.jaspersoft.studio.property.color.ColorSchemaGenerator;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.wb.swt.SWTResourceManager;

public class CrosstabStylePreview
extends Composite {
    private CrosstabStyle crosstabStyle;
    private Figure parentFigure;
    private Canvas square;
    private RectangleFigure crosstabPreview;
    private LightweightSystem lws;
    private List<Listener> previewPaintListener = new ArrayList<Listener>();

    public CrosstabStylePreview(Composite parent, int style) {
        super(parent, style);
        this.crosstabStyle = new CrosstabStyle(AlfaRGB.getFullyOpaque((RGB)ColorConstants.lightBlue.getRGB()), ColorSchemaGenerator.SCHEMAS.DEFAULT, false);
        this.createFigure();
    }

    public void setTableStyle(CrosstabStyle style) {
        this.crosstabStyle = style;
        this.setTBounds();
    }

    private void createFigure() {
        this.setLayout((Layout)new GridLayout(1, false));
        this.lws = new LightweightSystem();
        this.square = new Canvas((Composite)this, 0x140000);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        this.square.setLayoutData((Object)gd);
        this.lws.setControl(this.square);
        this.parentFigure = new Figure();
        this.parentFigure.setLayoutManager((LayoutManager)new XYLayout());
        this.lws.setContents((IFigure)this.parentFigure);
        this.crosstabPreview = new RectangleFigure(){

            public void paint(Graphics graphics) {
                int y = 5;
                int x = 5;
                int w = this.getBounds().width - 10;
                int h = this.getBounds().height - 10;
                int rowHeight = h / 4;
                int rowWidth = w / 4;
                w = rowWidth * 4;
                h = rowHeight * 4;
                Color originalBackgroun = graphics.getBackgroundColor();
                Color originalForeground = graphics.getForegroundColor();
                Rectangle lastRow = new Rectangle(x, y + rowHeight * 3, w, rowHeight);
                Rectangle lastCol = new Rectangle(x + rowWidth * 3, y, rowWidth, h);
                graphics.setBackgroundColor(CrosstabStylePreview.this.getSwtColor(CrosstabStylePreview.this.crosstabStyle.getColorValue("color_total")));
                graphics.fillRectangle(lastRow.x, lastRow.y, lastRow.width, lastRow.height);
                graphics.fillRectangle(lastCol.x, lastCol.y, lastCol.width, lastCol.height);
                Rectangle beforeLastRow = new Rectangle(x, y + rowHeight * 2, rowWidth * 3, rowHeight);
                Rectangle beforeLastCol = new Rectangle(x + rowWidth * 2, y, rowWidth, rowHeight * 3);
                graphics.setBackgroundColor(CrosstabStylePreview.this.getSwtColor(CrosstabStylePreview.this.crosstabStyle.getColorValue("color_group")));
                graphics.fillRectangle(beforeLastRow.x, beforeLastRow.y, beforeLastRow.width, beforeLastRow.height);
                graphics.fillRectangle(beforeLastCol.x, beforeLastCol.y, beforeLastCol.width, beforeLastCol.height);
                Rectangle detail = new Rectangle(x + rowWidth, y + rowHeight, rowWidth, rowHeight);
                graphics.setBackgroundColor(CrosstabStylePreview.this.getSwtColor(CrosstabStylePreview.this.crosstabStyle.getColorValue("color_detail")));
                graphics.fillRectangle(detail.x, detail.y, detail.width, detail.height);
                Rectangle measure1 = new Rectangle(x, y + rowHeight, rowWidth, rowHeight);
                Rectangle measure2 = new Rectangle(x + rowWidth, y, rowWidth, rowHeight);
                graphics.setBackgroundColor(CrosstabStylePreview.this.getSwtColor(CrosstabStylePreview.this.crosstabStyle.getColorValue("color_measures")));
                graphics.fillRectangle(measure1.x, measure1.y, measure1.width, measure1.height);
                graphics.fillRectangle(measure2.x, measure2.y, measure2.width, measure2.height);
                if (CrosstabStylePreview.this.crosstabStyle.isShowGrid().booleanValue()) {
                    if (CrosstabStylePreview.this.crosstabStyle.getWhiteGrid().booleanValue()) {
                        graphics.setForegroundColor(ColorConstants.white);
                    } else {
                        graphics.setForegroundColor(ColorConstants.black);
                    }
                    int i = 0;
                    while (i < 5) {
                        if (i == 0) {
                            graphics.drawLine(x + rowWidth, y + rowHeight * i, x + w, y + rowHeight * i);
                        } else {
                            graphics.drawLine(x, y + rowHeight * i, x + w, y + rowHeight * i);
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < 5) {
                        if (i == 0) {
                            graphics.drawLine(x + rowWidth * i, y + rowHeight, x + rowWidth * i, y + h);
                        } else {
                            graphics.drawLine(x + rowWidth * i, y, x + rowWidth * i, y + h);
                        }
                        ++i;
                    }
                }
                graphics.setBackgroundColor(originalBackgroun);
                graphics.setForegroundColor(originalForeground);
                CrosstabStylePreview.this.firePreviewPaintListeners(graphics, x, y, w, h);
            }
        };
        this.crosstabPreview.setBorder((Border)new ShadowBorder());
        this.parentFigure.add((IFigure)this.crosstabPreview);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CrosstabStylePreview.this.setTBounds();
            }
        });
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                CrosstabStylePreview.this.setTBounds();
            }
        });
    }

    private Color getSwtColor(java.awt.Color awtColor) {
        return SWTResourceManager.getColor((int)awtColor.getRed(), (int)awtColor.getGreen(), (int)awtColor.getBlue());
    }

    public void setTBounds() {
        if (!this.isDisposed()) {
            Dimension psize = this.parentFigure.getSize();
            this.crosstabPreview.setSize(psize);
            this.crosstabPreview.setLocation(new Point(0, 0));
            this.parentFigure.invalidate();
            this.square.redraw();
            this.lws.getUpdateManager().performUpdate();
        }
    }

    public void addPreviewPaintListenr(Listener listener) {
        if (listener != null && !this.previewPaintListener.contains(listener)) {
            this.previewPaintListener.add(listener);
        }
    }

    protected void firePreviewPaintListeners(Graphics graphics, int x, int y, int w, int h) {
        Event e = new Event();
        e.widget = this;
        e.data = graphics;
        e.x = x;
        e.y = y;
        e.width = w;
        e.height = h;
        for (Listener listener : this.previewPaintListener) {
            listener.handleEvent(e);
        }
    }

    public void dispose() {
        super.dispose();
        this.previewPaintListener.clear();
    }
}

