/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.crosstab.part.editpolicy;

import com.jaspersoft.studio.components.crosstab.part.ACrosstabCellEditPart;
import com.jaspersoft.studio.components.crosstab.part.editpolicy.CreateResize;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.parts.RedrawingEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.handles.CellMoveHandle;
import com.jaspersoft.studio.editor.gef.parts.handles.CellResizeHandle2;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class CrosstabCellResizableEditPolicy
extends RedrawingEditPolicy {
    public CrosstabCellResizableEditPolicy() {
        this.setDragAllowed(false);
    }

    public ACrosstabCellEditPart getHost() {
        return (ACrosstabCellEditPart)super.getHost();
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        ACrosstabCellEditPart geditPart = this.getHost();
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 4));
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 1));
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 16));
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 8));
        CellMoveHandle hand = new CellMoveHandle((GraphicalEditPart)geditPart, true, true);
        list.add((Handle)hand);
        return list;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        return CreateResize.createResizeCommand(request, (GraphicalEditPart)this.getHost());
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        Point moveDelta = request.getMoveDelta().getCopy();
        Dimension sizeDelta = request.getSizeDelta().getCopy();
        moveDelta.y = 0;
        this.getFeedbackLayer().translateToParent((Translatable)moveDelta);
        int delta = moveDelta.x;
        if (request.getType().equals("move")) {
            request.setMoveDelta(new Point(delta, 0));
            if (delta == 0) {
                return;
            }
        }
        if (request.getType().equals("resize") && sizeDelta.width == 0 && sizeDelta.height == 0) {
            return;
        }
        PrecisionRectangle rdelta = new PrecisionRectangle(new Rectangle(moveDelta, sizeDelta));
        FeedbackFigure feedback = (FeedbackFigure)this.getDragSourceFeedbackFigure();
        IFigure hfig = this.getHostFigure();
        feedback.setRequest(request);
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        Dimension contaierSize = this.getHost().getContaierSize();
        if (request.getType().equals("resize") && request.getResizeDirection() == 4) {
            rect.x = 10;
            rect.width = contaierSize.width;
        } else if (request.getType().equals("resize") && request.getResizeDirection() == 1) {
            rect.x = 10;
            rdelta.y = -rdelta.height;
            rect.width = contaierSize.width;
        } else if (request.getType().equals("move")) {
            rect.y = 0;
            rect.height = contaierSize.height + 20;
        } else {
            rect.y = 10;
            rect.height = contaierSize.height + 1;
        }
        hfig.translateToAbsolute((Translatable)rect);
        rect.translate(rdelta.x, rdelta.y);
        rect.resize(rdelta.width, rdelta.height);
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
        feedback.validate();
        super.showChangeBoundsFeedback(request);
    }

    protected IFigure createDragSourceFeedbackFigure() {
        FeedbackFigure r = new FeedbackFigure();
        r.setOpaque(false);
        r.setAlpha(50);
        r.setBackgroundColor(ColorConstants.gray);
        r.setFill(false);
        r.setBorder((Border)new LineBorder(ColorConstants.gray, 1));
        this.addFeedback((IFigure)r);
        return r;
    }

    private final class FeedbackFigure
    extends RectangleFigure {
        private ChangeBoundsRequest request;

        private FeedbackFigure() {
        }

        public void setRequest(ChangeBoundsRequest request) {
            this.request = request;
        }

        public void paintFigure(Graphics g) {
            PrecisionRectangle b = new PrecisionRectangle(this.getBounds().getCopy());
            if (this.request.getType().equals("resize")) {
                super.paintFigure(g);
                Graphics2D gr = ComponentFigure.getG2D((Graphics)g);
                if (gr != null) {
                    gr.fillRect(b.x, b.y, b.width, b.height);
                    AlphaComposite ac = AlphaComposite.getInstance(3, 1.0f);
                    gr.setComposite(ac);
                    gr.fillOval(b.x + b.width / 2 - 3, b.y - 3, 7, 7);
                    gr.fillOval(b.x + b.width / 2 - 3, b.y + b.height - 4, 7, 7);
                    gr.drawLine(b.x + b.width / 2, b.y, b.x + b.width / 2, b.y + b.height - 2);
                }
            }
        }
    }
}

