/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model;

import com.jaspersoft.studio.components.map.MapNodeIconDescriptor;
import com.jaspersoft.studio.components.map.figure.MapDesignConverter;
import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.property.MarkersPropertyDescriptor;
import com.jaspersoft.studio.components.map.property.PathPropertyDescriptor;
import com.jaspersoft.studio.components.map.property.StylePropertyDescriptor;
import com.jaspersoft.studio.editor.defaults.DefaultManager;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IDatasetContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.dataset.MDatasetRun;
import com.jaspersoft.studio.model.util.IIconDescriptor;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.combo.RComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.expression.ExprUtil;
import com.jaspersoft.studio.property.descriptor.expression.JRExpressionPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.text.NTextPropertyDescriptor;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.utils.EnumHelper;
import com.jaspersoft.studio.utils.ExpressionInterpreter;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.map.MapComponent;
import net.sf.jasperreports.components.map.StandardMapComponent;
import net.sf.jasperreports.components.map.type.MapImageTypeEnum;
import net.sf.jasperreports.components.map.type.MapScaleEnum;
import net.sf.jasperreports.components.map.type.MapTypeEnum;
import net.sf.jasperreports.eclipse.util.BasicMapInfoData;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.design.events.JRChangeEventsSupport;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.NamedEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MMap
extends MGraphicElement
implements IDatasetContainer {
    public static final long serialVersionUID = 10200L;
    private transient IPropertyDescriptor[] descriptors;
    private transient NamedEnumPropertyDescriptor<OnErrorTypeEnum> onErrorTypeD;
    private static IIconDescriptor iconDescriptor;
    private transient RComboBoxPropertyDescriptor evaluationGroupNameD;
    private static NamedEnumPropertyDescriptor<MapTypeEnum> mapTypeD;
    private static NamedEnumPropertyDescriptor<MapImageTypeEnum> imageTypeD;
    private static NamedEnumPropertyDescriptor<MapScaleEnum> mapScaleD;

    public MMap() {
    }

    public MMap(ANode parent, JRDesignComponentElement jrObject, int newIndex) {
        super(parent, (JRDesignElement)jrObject, newIndex);
    }

    public static IIconDescriptor getIconDescriptor() {
        if (iconDescriptor == null) {
            iconDescriptor = new MapNodeIconDescriptor("map");
        }
        return iconDescriptor;
    }

    public String getDisplayText() {
        String p = this.getElementNameProperty();
        return Misc.isNullOrEmpty((String)p) ? MMap.getIconDescriptor().getTitle() : p;
    }

    public ImageDescriptor getImagePath() {
        return MMap.getIconDescriptor().getIcon16();
    }

    public String getToolTip() {
        return MMap.getIconDescriptor().getToolTip();
    }

    public IPropertyDescriptor[] getDescriptors() {
        return this.descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        this.descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        super.createPropertyDescriptors(desc);
        NamedEnumPropertyDescriptor evaluationTimeD = new NamedEnumPropertyDescriptor((Object)"evaluationTime", Messages.MMap_evaluation_time, (Enum)EvaluationTimeEnum.NOW, NullEnum.NOTNULL);
        evaluationTimeD.setDescription(Messages.MMap_evaluation_time_description);
        desc.add((IPropertyDescriptor)evaluationTimeD);
        this.evaluationGroupNameD = new RComboBoxPropertyDescriptor((Object)"evaluationGroup", Messages.MMap_evaluation_group, new String[]{""});
        this.evaluationGroupNameD.setDescription(Messages.MMap_evaluation_group_description);
        desc.add((IPropertyDescriptor)this.evaluationGroupNameD);
        this.onErrorTypeD = new NamedEnumPropertyDescriptor((Object)"onErrorType", Messages.MMap_OnErrorType, (Enum)OnErrorTypeEnum.BLANK, NullEnum.NULL);
        this.onErrorTypeD.setDescription(Messages.MMap_OnErrorTypeDescription);
        desc.add((IPropertyDescriptor)this.onErrorTypeD);
        MarkersPropertyDescriptor markerD = new MarkersPropertyDescriptor("markerDataList", Messages.MMap_markersDescription, (APropertyNode)this);
        markerD.setDescription(Messages.MMap_markersDescription);
        markerD.setCategory(Messages.MMap_common_map_properties);
        desc.add((IPropertyDescriptor)markerD);
        PathPropertyDescriptor mapPathsD = new PathPropertyDescriptor("pathDataList", Messages.MMap_MapPaths, (APropertyNode)this);
        mapPathsD.setDescription(Messages.MMap_MapPaths);
        mapPathsD.setCategory(Messages.MMap_common_map_properties);
        desc.add((IPropertyDescriptor)mapPathsD);
        StylePropertyDescriptor mapPathStylesD = new StylePropertyDescriptor("pathStyleList", Messages.MMap_MapStyles, (APropertyNode)this);
        mapPathStylesD.setDescription(Messages.MMap_MapStyles);
        mapPathStylesD.setCategory(Messages.MMap_common_map_properties);
        desc.add((IPropertyDescriptor)mapPathStylesD);
        JRExpressionPropertyDescriptor latitudeExprD = new JRExpressionPropertyDescriptor((Object)"latitudeExpression", Messages.MMap_latitude);
        latitudeExprD.setDescription(Messages.MMap_latitude_description);
        desc.add((IPropertyDescriptor)latitudeExprD);
        latitudeExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/components.schema.reference.html#latitudeExpression"));
        JRExpressionPropertyDescriptor longitudeExprD = new JRExpressionPropertyDescriptor((Object)"longitudeExpression", Messages.MMap_longitude);
        longitudeExprD.setDescription(Messages.MMap_longitude_description);
        desc.add((IPropertyDescriptor)longitudeExprD);
        longitudeExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/components.schema.reference.html#longitudeExpression"));
        JRExpressionPropertyDescriptor addressExprD = new JRExpressionPropertyDescriptor((Object)"addressExpression", Messages.MMap_0);
        addressExprD.setDescription(Messages.MMap_1);
        desc.add((IPropertyDescriptor)addressExprD);
        addressExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/components.schema.reference.html#addressExpression"));
        JRExpressionPropertyDescriptor zoomExprD = new JRExpressionPropertyDescriptor((Object)"zoomExpression", Messages.MMap_zoom);
        zoomExprD.setDescription(Messages.MMap_zoom_description);
        desc.add((IPropertyDescriptor)zoomExprD);
        zoomExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/components.schema.reference.html#zoomExpression"));
        JRExpressionPropertyDescriptor langExprD = new JRExpressionPropertyDescriptor((Object)"languageExpression", Messages.MMap_languageExpressionTitle);
        langExprD.setDescription(Messages.MMap_languageExpressionDescription);
        desc.add((IPropertyDescriptor)langExprD);
        langExprD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/components.schema.reference.html#languageExpression"));
        MMap.getMapTypeD();
        desc.add((IPropertyDescriptor)mapTypeD);
        MMap.getMapScaleD();
        desc.add((IPropertyDescriptor)mapScaleD);
        MMap.getMapImageTypeD();
        desc.add((IPropertyDescriptor)imageTypeD);
        NTextPropertyDescriptor mapKeyD = new NTextPropertyDescriptor((Object)"net.sf.jasperreports.components.map.key", Messages.MMap_ApiKeyText);
        mapKeyD.setDescription(Messages.MMap_ApiKeyDescription);
        desc.add((IPropertyDescriptor)mapKeyD);
        NTextPropertyDescriptor mapClientIdD = new NTextPropertyDescriptor((Object)"net.sf.jasperreports.components.map.client.id", Messages.MMap_ClientIdText);
        mapClientIdD.setDescription(Messages.MMap_ClientIdDescription);
        desc.add((IPropertyDescriptor)mapClientIdD);
        NTextPropertyDescriptor mapClientSignatureD = new NTextPropertyDescriptor((Object)"net.sf.jasperreports.components.map.signature", Messages.MMap_SignatureText);
        mapClientSignatureD.setDescription(Messages.MMap_SignatureDescription);
        desc.add((IPropertyDescriptor)mapClientSignatureD);
        NTextPropertyDescriptor mapVersionD = new NTextPropertyDescriptor((Object)"net.sf.jasperreports.components.map.google.version", Messages.MMap_VersionText);
        mapVersionD.setDescription(Messages.MMap_VersionDescription);
        desc.add((IPropertyDescriptor)mapVersionD);
        this.setHelpPrefix(desc, "net.sf.jasperreports.doc/docs/components.schema.reference.html#");
        langExprD.setCategory(Messages.MMap_common_map_properties);
        mapTypeD.setCategory(Messages.MMap_common_map_properties);
        mapScaleD.setCategory(Messages.MMap_common_map_properties);
        imageTypeD.setCategory(Messages.MMap_common_map_properties);
        this.onErrorTypeD.setCategory(Messages.MMap_common_map_properties);
        evaluationTimeD.setCategory(Messages.MMap_common_map_properties);
        this.evaluationGroupNameD.setCategory(Messages.MMap_common_map_properties);
        latitudeExprD.setCategory(Messages.MMap_common_map_properties);
        longitudeExprD.setCategory(Messages.MMap_common_map_properties);
        addressExprD.setCategory(Messages.MMap_common_map_properties);
        zoomExprD.setCategory(Messages.MMap_common_map_properties);
        mapKeyD.setCategory(Messages.MMap_Category_Authentication);
        mapClientIdD.setCategory(Messages.MMap_Category_Authentication);
        mapClientSignatureD.setCategory(Messages.MMap_Category_Authentication);
        mapVersionD.setCategory(Messages.MMap_Category_Authentication);
        mapPathStylesD.setCategory(Messages.MMap_PathsStylesCategory);
        mapPathsD.setCategory(Messages.MMap_PathsStylesCategoryDesc);
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        int roadMapValue = NamedEnumPropertyDescriptor.getIntValue((Enum)MapTypeEnum.ROADMAP, (NullEnum)NullEnum.NOTNULL, (Enum)MapTypeEnum.ROADMAP);
        defaultsMap.put("mapType", new DefaultValue((Object)roadMapValue, false));
        int mapTypeValue = NamedEnumPropertyDescriptor.getIntValue((Enum)MapScaleEnum.ONE, (NullEnum)NullEnum.NOTNULL, (Enum)MapScaleEnum.ONE);
        defaultsMap.put("mapType", new DefaultValue((Object)mapTypeValue, false));
        int imageTypeValue = NamedEnumPropertyDescriptor.getIntValue((Enum)MapImageTypeEnum.PNG, (NullEnum)NullEnum.NOTNULL, (Enum)MapImageTypeEnum.PNG);
        defaultsMap.put("imageType", new DefaultValue((Object)imageTypeValue, false));
        int onErrorValue = NamedEnumPropertyDescriptor.getIntValue((Enum)OnErrorTypeEnum.ERROR, (NullEnum)NullEnum.NULL, (Enum)OnErrorTypeEnum.ERROR);
        defaultsMap.put("onErrorType", new DefaultValue((Object)onErrorValue, true));
        defaultsMap.put("evaluationTime", new DefaultValue((Object)EvaluationTimeEnum.NOW, false));
        defaultsMap.put("zoomExpression", new DefaultValue((Object)MapComponent.DEFAULT_ZOOM, false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        StandardMapComponent component = this.getMapComponent();
        if (id.equals("evaluationTime")) {
            return component.getEvaluationTime();
        }
        if (id.equals("evaluationGroup")) {
            return component.getEvaluationGroup();
        }
        if (id.equals("onErrorType")) {
            return this.onErrorTypeD.getIntValue((Enum)component.getOnErrorType());
        }
        if (id.equals("languageExpression")) {
            return ExprUtil.getExpression((JRExpression)component.getLanguageExpression());
        }
        if (id.equals("longitudeExpression")) {
            return ExprUtil.getExpression((JRExpression)component.getLongitudeExpression());
        }
        if (id.equals("latitudeExpression")) {
            return ExprUtil.getExpression((JRExpression)component.getLatitudeExpression());
        }
        if (id.equals("addressExpression")) {
            return ExprUtil.getExpression((JRExpression)component.getAddressExpression());
        }
        if (id.equals("zoomExpression")) {
            return ExprUtil.getExpression((JRExpression)component.getZoomExpression());
        }
        if (id.equals("mapType")) {
            return mapTypeD.getIntValue((Enum)component.getMapType());
        }
        if (id.equals("mapScale")) {
            return mapScaleD.getIntValue((Enum)component.getMapScale());
        }
        if (id.equals("imageType")) {
            return imageTypeD.getIntValue((Enum)component.getImageType());
        }
        if (id.equals("net.sf.jasperreports.components.map.key")) {
            return this.getJasperDesign().getProperty("net.sf.jasperreports.components.map.key");
        }
        if (id.equals("net.sf.jasperreports.components.map.client.id")) {
            return this.getJasperDesign().getProperty("net.sf.jasperreports.components.map.client.id");
        }
        if (id.equals("net.sf.jasperreports.components.map.signature")) {
            return this.getJasperDesign().getProperty("net.sf.jasperreports.components.map.signature");
        }
        if (id.equals("net.sf.jasperreports.components.map.google.version")) {
            return this.getJasperDesign().getProperty("net.sf.jasperreports.components.map.google.version");
        }
        if (id.equals("net.sf.jasperreports.components.map.google.version")) {
            return this.getJasperDesign().getProperty("net.sf.jasperreports.components.map.google.version");
        }
        if (id.equals("markerDataList")) {
            List ids = component.getMarkerDataList();
            if (ids == null) {
                return new ArrayList();
            }
            return new ArrayList(ids);
        }
        if (id.equals("pathDataList")) {
            List ids = component.getPathDataList();
            if (ids == null) {
                return new ArrayList();
            }
            return new ArrayList(ids);
        }
        if (id.equals("pathStyleList")) {
            List ids = component.getPathStyleList();
            if (ids == null) {
                return new ArrayList();
            }
            return new ArrayList(ids);
        }
        return super.getPropertyValue(id);
    }

    public void setPropertyValue(Object id, Object value) {
        StandardMapComponent component = this.getMapComponent();
        if (id.equals("evaluationTime")) {
            EvaluationTimeEnum evalTime = (EvaluationTimeEnum)EnumHelper.getEnumByObjectValue((NamedEnum[])EvaluationTimeEnum.values(), (Object)value);
            component.setEvaluationTime(evalTime);
            if (evalTime != null && !evalTime.equals((Object)EvaluationTimeEnum.GROUP)) {
                component.setEvaluationGroup(null);
            }
        } else if (id.equals("evaluationGroup")) {
            component.setEvaluationGroup(ModelUtils.getGroupNameForProperty((Object)value));
        } else if (id.equals("longitudeExpression")) {
            component.setLongitudeExpression(ExprUtil.setValues((JRExpression)component.getLongitudeExpression(), (Object)value, null));
        } else if (id.equals("latitudeExpression")) {
            component.setLatitudeExpression(ExprUtil.setValues((JRExpression)component.getLatitudeExpression(), (Object)value, null));
        } else if (id.equals("addressExpression")) {
            component.setAddressExpression(ExprUtil.setValues((JRExpression)component.getAddressExpression(), (Object)value, null));
        } else if (id.equals("languageExpression")) {
            component.setLanguageExpression(ExprUtil.setValues((JRExpression)component.getLanguageExpression(), (Object)value, null));
        } else if (id.equals("zoomExpression")) {
            component.setZoomExpression(ExprUtil.setValues((JRExpression)component.getZoomExpression(), (Object)value, null));
        } else if (id.equals("mapType")) {
            component.setMapType((MapTypeEnum)mapTypeD.getEnumValue(value));
        } else if (id.equals("mapScale")) {
            component.setMapScale((MapScaleEnum)mapScaleD.getEnumValue(value));
        } else if (id.equals("imageType")) {
            component.setImageType((MapImageTypeEnum)imageTypeD.getEnumValue(value));
        } else if (id.equals("onErrorType")) {
            component.setOnErrorType((OnErrorTypeEnum)this.onErrorTypeD.getEnumValue(value));
        } else if (id.equals("net.sf.jasperreports.components.map.key")) {
            if (value instanceof String && !Misc.isNullOrEmptyString((Object)value)) {
                this.getJasperDesign().setProperty("net.sf.jasperreports.components.map.key", (String)value);
            } else {
                this.getJasperDesign().removeProperty("net.sf.jasperreports.components.map.key");
            }
        } else if (id.equals("net.sf.jasperreports.components.map.client.id")) {
            if (value instanceof String && !Misc.isNullOrEmptyString((Object)value)) {
                this.getJasperDesign().setProperty("net.sf.jasperreports.components.map.client.id", (String)value);
            } else {
                this.getJasperDesign().removeProperty("net.sf.jasperreports.components.map.client.id");
            }
        } else if (id.equals("net.sf.jasperreports.components.map.signature")) {
            if (value instanceof String && !Misc.isNullOrEmptyString((Object)value)) {
                this.getJasperDesign().setProperty("net.sf.jasperreports.components.map.signature", (String)value);
            } else {
                this.getJasperDesign().removeProperty("net.sf.jasperreports.components.map.signature");
            }
        } else if (id.equals("net.sf.jasperreports.components.map.google.version")) {
            if (value instanceof String && !Misc.isNullOrEmptyString((Object)value)) {
                this.getJasperDesign().setProperty("net.sf.jasperreports.components.map.google.version", (String)value);
            } else {
                this.getJasperDesign().removeProperty("net.sf.jasperreports.components.map.google.version");
            }
        } else if (id.equals("net.sf.jasperreports.components.map.google.version")) {
            if (value instanceof String && !Misc.isNullOrEmptyString((Object)value)) {
                this.getJasperDesign().setProperty("net.sf.jasperreports.components.map.google.version", (String)value);
            } else {
                this.getJasperDesign().removeProperty("net.sf.jasperreports.components.map.google.version");
            }
        } else if (id.equals("markerDataList")) {
            if (value instanceof List) {
                Object[] existing;
                ArrayList itemDatas = new ArrayList((List)value);
                Object[] objectArray = existing = component.getMarkerDataList().toArray();
                int n = existing.length;
                int n2 = 0;
                while (n2 < n) {
                    Object p = objectArray[n2];
                    component.removeMarkerData((ItemData)p);
                    ++n2;
                }
                for (ItemData n3 : itemDatas) {
                    component.addMarkerData(n3);
                }
            }
        } else if (id.equals("pathDataList")) {
            if (value instanceof List) {
                Object[] existing;
                List itemDatas = (List)value;
                Object[] objectArray = existing = component.getPathDataList().toArray();
                int n = existing.length;
                int n4 = 0;
                while (n4 < n) {
                    Object p = objectArray[n4];
                    component.removePathData((ItemData)p);
                    ++n4;
                }
                for (ItemData n5 : itemDatas) {
                    component.addPathData(n5);
                }
            }
        } else if (id.equals("pathStyleList")) {
            if (value instanceof List) {
                Object[] existing;
                List itemDatas = (List)value;
                Object[] objectArray = existing = component.getPathStyleList().toArray();
                int n = existing.length;
                int n6 = 0;
                while (n6 < n) {
                    Object p = objectArray[n6];
                    component.removePathStyle((ItemData)p);
                    ++n6;
                }
                for (ItemData n7 : itemDatas) {
                    component.addPathStyle(n7);
                }
            }
        } else {
            super.setPropertyValue(id, value);
        }
    }

    protected List<ValidationError> doValidation() {
        ArrayList<ValidationError> errors = super.doValidation();
        if (errors == null) {
            errors = new ArrayList<ValidationError>();
        }
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        StandardMapComponent tm = (StandardMapComponent)jrElement.getComponent();
        JRExpression lonExp = tm.getLongitudeExpression();
        JRExpression latExp = tm.getLatitudeExpression();
        JRExpression adrExp = tm.getAddressExpression();
        if ((lonExp == null || latExp == null) && adrExp == null) {
            ArrayList<String> ids = new ArrayList<String>();
            if (lonExp == null) {
                ids.add("longitudeExpression");
            }
            if (latExp == null) {
                ids.add("latitudeExpression");
            }
            ids.add("addressExpression");
            errors.add(new ValidationError(ids, Messages.MarkersDescriptor_76, true));
        }
        return errors;
    }

    public StandardMapComponent getMapComponent() {
        JRDesignComponentElement jrElement = (JRDesignComponentElement)this.getValue();
        if (jrElement == null) {
            return null;
        }
        return (StandardMapComponent)jrElement.getComponent();
    }

    protected void setGroupItems(String[] items) {
        super.setGroupItems(items);
        if (this.evaluationGroupNameD != null) {
            this.evaluationGroupNameD.setItems(items);
        }
    }

    public static NamedEnumPropertyDescriptor<MapTypeEnum> getMapTypeD() {
        if (mapTypeD == null) {
            mapTypeD = new NamedEnumPropertyDescriptor((Object)"mapType", Messages.MMap_mapTypeTitle, (Enum)MapTypeEnum.HYBRID, NullEnum.NOTNULL);
        }
        return mapTypeD;
    }

    public static NamedEnumPropertyDescriptor<MapScaleEnum> getMapScaleD() {
        if (mapScaleD == null) {
            mapScaleD = new NamedEnumPropertyDescriptor((Object)"mapScale", Messages.MMap_mapScaleTitle, (Enum)MapScaleEnum.ONE, NullEnum.NOTNULL);
            mapScaleD.setDescription(Messages.MMap_mapScaleDescription);
        }
        return mapScaleD;
    }

    public static NamedEnumPropertyDescriptor<MapImageTypeEnum> getMapImageTypeD() {
        if (imageTypeD == null) {
            imageTypeD = new NamedEnumPropertyDescriptor((Object)"imageType", Messages.MMap_imageTypeTitle, (Enum)MapImageTypeEnum.GIF, NullEnum.NOTNULL);
            imageTypeD.setDescription(Messages.MMap_mapScaleDescription);
        }
        return imageTypeD;
    }

    public void setValue(Object value) {
        Object obj;
        if (this.getValue() != null && (obj = this.getComponent()) instanceof JRChangeEventsSupport) {
            ((JRChangeEventsSupport)obj).getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
        if (value != null) {
            obj = this.getComponent(value);
            if (value instanceof JRChangeEventsSupport) {
                ((JRChangeEventsSupport)obj).getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
            }
        }
        super.setValue(value);
    }

    private Object getComponent() {
        return this.getComponent(this.getValue());
    }

    private Object getComponent(Object value) {
        if (value != null) {
            JRDesignComponentElement jrElement = (JRDesignComponentElement)value;
            return jrElement.getComponent();
        }
        return null;
    }

    public JRDesignComponentElement createJRElement(JasperDesign jasperDesign, boolean applyDefault) {
        JRDesignComponentElement designMap = new JRDesignComponentElement((JRDefaultStyleProvider)jasperDesign);
        StandardMapComponent component = new StandardMapComponent();
        JRDesignExpression exp1 = new JRDesignExpression();
        exp1.setText(String.valueOf(MapDesignConverter.DEFAULT_LATITUDE.toString()) + "f");
        JRDesignExpression exp2 = new JRDesignExpression();
        exp2.setText(String.valueOf(MapDesignConverter.DEFAULT_LONGITUDE.toString()) + "f");
        component.setLatitudeExpression((JRExpression)exp1);
        component.setLongitudeExpression((JRExpression)exp2);
        JRDesignExpression exp3 = new JRDesignExpression();
        exp3.setText("8");
        component.setZoomExpression((JRExpression)exp3);
        designMap.setComponent((Component)component);
        designMap.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "c", "map"));
        if (applyDefault) {
            DefaultManager.INSTANCE.applyDefault(((Object)((Object)this)).getClass(), (JRElement)designMap);
        }
        return designMap;
    }

    public int getDefaultHeight() {
        return 150;
    }

    public int getDefaultWidth() {
        return 400;
    }

    public List<MDatasetRun> getDatasetRunList() {
        HashSet<JRDatasetRun> dsr = new HashSet<JRDatasetRun>();
        for (ItemData id : this.getMapComponent().getMarkerDataList()) {
            if (id.getDataset() == null || id.getDataset().getDatasetRun() == null) continue;
            dsr.add(id.getDataset().getDatasetRun());
        }
        for (ItemData id : this.getMapComponent().getPathDataList()) {
            if (id.getDataset() == null || id.getDataset().getDatasetRun() == null) continue;
            dsr.add(id.getDataset().getDatasetRun());
        }
        for (ItemData id : this.getMapComponent().getPathStyleList()) {
            if (id.getDataset() == null || id.getDataset().getDatasetRun() == null) continue;
            dsr.add(id.getDataset().getDatasetRun());
        }
        JasperDesign jd = this.getJasperDesign();
        ArrayList<MDatasetRun> datasetList = new ArrayList<MDatasetRun>();
        for (JRDatasetRun dr : dsr) {
            datasetList.add(new MDatasetRun(dr, jd));
        }
        return datasetList;
    }

    public void trasnferProperties(JRElement target) {
        super.trasnferProperties(target);
        StandardMapComponent jrSourceMap = this.getMapComponent();
        JRDesignComponentElement jrTargetElement = (JRDesignComponentElement)target;
        StandardMapComponent jrTargetMap = (StandardMapComponent)jrTargetElement.getComponent();
        jrTargetMap.setMapType(jrSourceMap.getMapType());
        jrTargetMap.setMapScale(jrSourceMap.getMapScale());
        jrTargetMap.setImageType(jrSourceMap.getImageType());
        jrTargetMap.setOnErrorType(jrSourceMap.getOnErrorType());
    }

    public BasicMapInfoData getBasicMapInformation() {
        Integer type;
        Object zoomObj;
        JRDesignExpression zoomExpr;
        Object adrObj;
        JRDesignExpression adrExpr;
        BasicMapInfoData info = new BasicMapInfoData();
        JRDesignDataset dataset = ModelUtils.getDataset((ANode)this);
        JasperDesign jd = this.getJasperDesign();
        if (dataset == null) {
            dataset = (JRDesignDataset)jd.getMainDataset();
        }
        ExpressionInterpreter expIntr = new ExpressionInterpreter(dataset, jd, this.getJasperConfiguration());
        JRDesignExpression latitudeExpr = (JRDesignExpression)this.getPropertyValue("latitudeExpression");
        JRDesignExpression longitudeExpr = (JRDesignExpression)this.getPropertyValue("longitudeExpression");
        if (latitudeExpr != null && longitudeExpr != null) {
            Object latObj = expIntr.interpretExpression(Misc.nvl((String)latitudeExpr.getText()));
            Object lngObj = expIntr.interpretExpression(Misc.nvl((String)longitudeExpr.getText()));
            if (latObj instanceof Number && lngObj instanceof Number) {
                info.setLatitude(Double.valueOf(((Number)latObj).doubleValue()));
                info.setLongitude(Double.valueOf(((Number)lngObj).doubleValue()));
            }
        }
        if ((adrExpr = (JRDesignExpression)this.getPropertyValue("addressExpression")) != null && (adrObj = expIntr.interpretExpression(adrExpr.getText())) instanceof String) {
            info.setAddress((String)adrObj);
        }
        if ((zoomExpr = (JRDesignExpression)this.getPropertyValue("zoomExpression")) != null && (zoomObj = expIntr.interpretExpression(zoomExpr.getText())) instanceof Number) {
            info.setZoom(((Number)zoomObj).intValue());
        }
        if ((type = (Integer)this.getPropertyValue("mapType")) != null) {
            MapTypeEnum typeVal = (MapTypeEnum)MMap.getMapTypeD().getEnumValue((Object)type);
            info.setMapType(typeVal);
        }
        return info;
    }
}

