/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.itemdata;

import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataDatasetDTO;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementDTO;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementItemDTO;
import com.jaspersoft.studio.components.map.model.itemdata.dto.MapDataElementsConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import org.eclipse.osgi.util.NLS;

public class ElementDataHelper {
    public static final String ELEMENT_DATASET_PREFIX = "{0} Dataset ";
    public static final String DEFAULT_ELEMENT_NAME = "<default>";

    private ElementDataHelper() {
    }

    public static MapDataElementsConfiguration convertFromElementDataInformation(List<ItemData> elementDataElements, String elementLabel) {
        MapDataElementsConfiguration config = new MapDataElementsConfiguration(elementLabel);
        ArrayList<MapDataDatasetDTO> datasetDTOs = new ArrayList<MapDataDatasetDTO>();
        ArrayList<MapDataElementDTO> elementsDTOs = new ArrayList<MapDataElementDTO>();
        int datasetsCounter = 1;
        for (ItemData elementData : elementDataElements) {
            JRElementDataset dataset = elementData.getDataset();
            String dsNameForDTO = null;
            if (dataset != null) {
                Object dsClone = dataset.clone();
                MapDataDatasetDTO dsDTO = new MapDataDatasetDTO();
                dsDTO.setDataset((JRElementDataset)dsClone);
                dsNameForDTO = String.valueOf(NLS.bind((String)ELEMENT_DATASET_PREFIX, (Object)elementLabel)) + datasetsCounter;
                dsDTO.setName(dsNameForDTO);
                datasetDTOs.add(dsDTO);
                ++datasetsCounter;
            }
            for (Item elementItem : elementData.getItems()) {
                ItemProperty elementName = ElementDataHelper.getElementNameForItem(elementItem);
                MapDataElementItemDTO itemDTO = new MapDataElementItemDTO(elementName);
                itemDTO.setDatasetName(dsNameForDTO);
                itemDTO.setItem((Item)elementItem.clone());
                itemDTO.setStatic(dataset == null);
                ElementDataHelper.createOrUpdateElementsList(elementsDTOs, elementName, itemDTO);
            }
        }
        config.setDatasets(datasetDTOs);
        config.setElements(elementsDTOs);
        return config;
    }

    private static void createOrUpdateElementsList(List<MapDataElementDTO> elementsDTOs, ItemProperty elementName, MapDataElementItemDTO itemDTO) {
        MapDataElementDTO elementFound = null;
        for (MapDataElementDTO element : elementsDTOs) {
            if (!ElementDataHelper.areNamesEqual(element.getName(), elementName)) continue;
            elementFound = element;
            break;
        }
        if (elementFound == null) {
            elementFound = new MapDataElementDTO();
            elementFound.setName(elementName);
            elementsDTOs.add(elementFound);
        }
        elementFound.getDataItems().add(itemDTO);
    }

    private static ItemProperty getElementNameForItem(Item item) {
        ItemProperty nameProperty = ElementDataHelper.getItemProperty(item, "name");
        return nameProperty != null ? (ItemProperty)nameProperty.clone() : null;
    }

    public static String getItemPropertyValueAsString(ItemProperty property) {
        return ElementDataHelper.getItemPropertyValueAsString(property, false);
    }

    public static String getItemPropertyValueAsString(ItemProperty property, boolean addDoubleQuotes) {
        if (property != null) {
            String propertyValue = property.getValue();
            if (propertyValue == null && property.getValueExpression() != null) {
                propertyValue = property.getValueExpression().getText();
            } else if (addDoubleQuotes) {
                propertyValue = "\"" + propertyValue + "\"";
            }
            return propertyValue;
        }
        return null;
    }

    public static String getItemPropertyValueAsString(Item item, String propertyName) {
        return ElementDataHelper.getItemPropertyValueAsString(item, propertyName, false);
    }

    public static String getItemPropertyValueAsString(Item item, String propertyName, boolean addDoubleQuotes) {
        return ElementDataHelper.getItemPropertyValueAsString(ElementDataHelper.getItemProperty(item, propertyName), addDoubleQuotes);
    }

    public static ItemProperty getItemProperty(Item item, String propertyName) {
        for (ItemProperty p : item.getProperties()) {
            if (!propertyName.equals(p.getName())) continue;
            return p;
        }
        return null;
    }

    public static List<ItemData> convertToElementDataInformation(MapDataElementsConfiguration config) {
        ArrayList<ItemData> elementDatas = new ArrayList<ItemData>();
        ArrayList<MapDataElementItemDTO> allItems = new ArrayList<MapDataElementItemDTO>();
        for (MapDataElementDTO el : config.getElements()) {
            allItems.addAll(el.getDataItems());
        }
        ArrayList<MapDataDatasetDTO> remainingDS = new ArrayList<MapDataDatasetDTO>();
        remainingDS.addAll(config.getDatasets());
        for (MapDataElementItemDTO item : allItems) {
            MapDataDatasetDTO usedDSDTO = ElementDataHelper.createOrUpdateElementDataList(item, elementDatas, config.getDatasets());
            if (usedDSDTO == null) continue;
            remainingDS.remove(usedDSDTO);
        }
        for (MapDataDatasetDTO dsDTO : remainingDS) {
            StandardItemData newElementData = new StandardItemData();
            newElementData.setDataset(dsDTO.getDataset());
            elementDatas.add((ItemData)newElementData);
        }
        return elementDatas;
    }

    private static MapDataDatasetDTO createOrUpdateElementDataList(MapDataElementItemDTO item, List<ItemData> itemDatas, List<MapDataDatasetDTO> datasetDTOs) {
        Iterator<MapDataDatasetDTO> iterator;
        String datasetName = item.getDatasetName();
        JRElementDataset ds = null;
        MapDataDatasetDTO usedDSDTO = null;
        if (datasetName != null && (iterator = datasetDTOs.iterator()).hasNext()) {
            MapDataDatasetDTO d = iterator.next();
            if (d.getName().equals(datasetName)) {
                ds = d.getDataset();
            }
            usedDSDTO = d;
        }
        ItemData foundItemData = null;
        for (ItemData itemData : itemDatas) {
            JRElementDataset currDS = itemData.getDataset();
            if ((ds == null || !ds.equals(currDS)) && (ds != null || currDS != null)) continue;
            foundItemData = itemData;
        }
        if (foundItemData != null) {
            ((StandardItemData)foundItemData).addItem(item.getItem());
        } else {
            StandardItemData newItemData = new StandardItemData();
            newItemData.setDataset(ds);
            newItemData.addItem(item.getItem());
            itemDatas.add((ItemData)newItemData);
        }
        return usedDSDTO;
    }

    public static void fixDatasetNames(MapDataElementsConfiguration config) {
        int counter = 1;
        for (MapDataDatasetDTO ds : config.getDatasets()) {
            ds.setName(String.valueOf(NLS.bind((String)ELEMENT_DATASET_PREFIX, (Object)config.getElementLabel())) + counter);
            ++counter;
        }
    }

    public static void fixElementNameForChildren(MapDataElementDTO element) {
        for (MapDataElementItemDTO item : element.getDataItems()) {
            item.setParentName((ItemProperty)element.getName().clone());
        }
    }

    public static void removeElementDataItem(MapDataElementsConfiguration mapElementsConfig, ItemProperty parentName, MapDataElementItemDTO item) {
        for (MapDataElementDTO el : mapElementsConfig.getElements()) {
            if (!ElementDataHelper.areNamesEqual(parentName, el.getName())) continue;
            el.getDataItems().remove(item);
            return;
        }
    }

    public static void moveDownDataItem(MapDataElementsConfiguration mapElementsConfig, ItemProperty parentName, MapDataElementItemDTO item) {
        MapDataElementDTO foundEl = null;
        for (MapDataElementDTO el : mapElementsConfig.getElements()) {
            if (!ElementDataHelper.areNamesEqual(parentName, el.getName())) continue;
            foundEl = el;
            break;
        }
        if (foundEl != null) {
            int currItemIndex = foundEl.getDataItems().indexOf(item);
            int numItems = foundEl.getDataItems().size();
            if (currItemIndex != -1 && currItemIndex < numItems - 1) {
                foundEl.getDataItems().remove(item);
                foundEl.getDataItems().add(currItemIndex + 1, item);
            }
        }
    }

    public static void moveUpDataItem(MapDataElementsConfiguration mapElementsConfig, ItemProperty parentName, MapDataElementItemDTO item) {
        int currItemIndex;
        MapDataElementDTO foundEl = null;
        for (MapDataElementDTO el : mapElementsConfig.getElements()) {
            if (!ElementDataHelper.areNamesEqual(parentName, el.getName())) continue;
            foundEl = el;
            break;
        }
        if (foundEl != null && (currItemIndex = foundEl.getDataItems().indexOf(item)) != -1 && currItemIndex > 0) {
            foundEl.getDataItems().remove(item);
            foundEl.getDataItems().add(currItemIndex - 1, item);
        }
    }

    public static void updateElementDataItem(MapDataElementsConfiguration mapElementsConfig, ItemProperty pname, MapDataElementItemDTO oldDTO, MapDataElementItemDTO newDTO) {
        for (MapDataElementDTO el : mapElementsConfig.getElements()) {
            if (!ElementDataHelper.areNamesEqual(pname, el.getName())) continue;
            int indexOf = el.getDataItems().indexOf(oldDTO);
            el.getDataItems().remove(indexOf);
            el.getDataItems().add(indexOf, newDTO);
            return;
        }
    }

    public static boolean areNamesEqual(ItemProperty name1, ItemProperty name2) {
        ItemProperty name1fixed = ElementDataHelper.fixElementNameProperty(name1);
        ItemProperty name2fixed = ElementDataHelper.fixElementNameProperty(name2);
        String name1Txt = "";
        if (name1fixed != null) {
            name1Txt = ElementDataHelper.getItemPropertyValueAsString(name1fixed, true);
        }
        String name2Txt = "";
        if (name2fixed != null) {
            name2Txt = ElementDataHelper.getItemPropertyValueAsString(name2fixed, true);
        }
        return name1Txt.equals(name2Txt);
    }

    public static ItemProperty fixElementNameProperty(ItemProperty pname) {
        if (pname == null) {
            return null;
        }
        String value = pname.getValue();
        JRExpression valueExpression = pname.getValueExpression();
        if ((value == null || value.isEmpty()) && (valueExpression == null || valueExpression.getText() == null || valueExpression.getText().isEmpty())) {
            return null;
        }
        return pname;
    }
}

