/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.model.itemdata.dialog;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.editor.expression.IExpressionContextSetter;
import com.jaspersoft.studio.property.infoList.ElementDescription;
import com.jaspersoft.studio.property.infoList.SelectableComposite;
import com.jaspersoft.studio.swt.events.ExpressionModifiedEvent;
import com.jaspersoft.studio.swt.events.ExpressionModifiedListener;
import com.jaspersoft.studio.swt.widgets.WTextExpression;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.PersistentLocationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ItemPropertyDialog
extends PersistentLocationDialog
implements IExpressionContextSetter {
    private Composite dialogArea;
    private Text propertyName;
    private Button useExpressionCheckbox;
    private Text propertyValue;
    private WTextExpression propertyValueExpression;
    private ExpressionContext expContext;
    private StandardItemProperty itemProperty;
    private SelectableComposite infoPanel;
    private String propertiesFileLocation;

    public ItemPropertyDialog(Shell parentShell, ItemProperty itemProperty, String propertiesFileLocation) {
        super(parentShell);
        this.itemProperty = (StandardItemProperty)itemProperty;
        this.propertiesFileLocation = propertiesFileLocation;
    }

    protected Control createDialogArea(Composite parent) {
        this.dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        this.dialogArea.setLayout((Layout)layout);
        Label lblPropertyName = new Label(this.dialogArea, 0);
        lblPropertyName.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        lblPropertyName.setText(Messages.ItemPropertyDialog_PropertyName);
        this.propertyName = new Text(this.dialogArea, 2048);
        this.propertyName.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.useExpressionCheckbox = new Button(this.dialogArea, 32);
        this.useExpressionCheckbox.setText(Messages.ItemPropertyDialog_UseExpression);
        this.useExpressionCheckbox.setLayoutData((Object)new GridData(4, 4, true, false));
        Label lblPropertyValue = new Label(this.dialogArea, 0);
        lblPropertyValue.setText(Messages.ItemPropertyDialog_PropertyValue);
        lblPropertyValue.setLayoutData((Object)new GridData(4, 4, true, false));
        this.propertyValue = new Text(this.dialogArea, 2048);
        GridData gd_propertyValue = new GridData(4, 4, true, false);
        this.propertyValue.setLayoutData((Object)gd_propertyValue);
        this.propertyValueExpression = new WTextExpression(this.dialogArea, 0);
        GridData gd_propertyValueExpression = new GridData(4, 4, true, false);
        gd_propertyValueExpression.heightHint = 50;
        this.propertyValueExpression.setLayoutData((Object)gd_propertyValueExpression);
        this.propertyValueExpression.setExpressionContext(this.expContext);
        this.infoPanel = new SelectableComposite(this.dialogArea);
        this.infoPanel.setItems(this.getPropertiesInformation());
        GridData infoGD = new GridData(4, 4, true, true);
        infoGD.heightHint = 200;
        infoGD.verticalIndent = 5;
        this.infoPanel.setLayoutData((Object)infoGD);
        this.infoPanel.SetDoubleClickListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemPropertyDialog.this.propertyName.setText(ItemPropertyDialog.this.infoPanel.getSelectedElement().getName());
            }
        });
        this.initWidgets();
        this.addListeners();
        return this.dialogArea;
    }

    private List<ElementDescription> getPropertiesInformation() {
        ArrayList<ElementDescription> descriptions = new ArrayList<ElementDescription>();
        try {
            descriptions.addAll(ElementDescription.getPropertiesInformation((String)Activator.getDefault().getFileLocation(this.propertiesFileLocation)));
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
        return descriptions;
    }

    private void initWidgets() {
        if (this.itemProperty == null) {
            this.itemProperty = new StandardItemProperty("", "", null);
        }
        if (this.itemProperty.getValue() != null) {
            this.useExpressionCheckbox.setSelection(false);
            this.propertyName.setText(Misc.nvl((String)this.itemProperty.getName()));
            this.propertyValue.setText(this.itemProperty.getValue());
            this.propertyValueExpression.setVisible(false);
            this.propertyValueExpression.setEnabled(false);
            this.propertyValueExpression.setExpression(null);
            ((GridData)this.propertyValueExpression.getLayoutData()).exclude = true;
        } else {
            this.useExpressionCheckbox.setSelection(true);
            this.propertyName.setText(Misc.nvl((String)this.itemProperty.getName()));
            this.propertyValueExpression.setExpression((JRDesignExpression)this.itemProperty.getValueExpression());
            this.propertyValue.setVisible(false);
            this.propertyValue.setEnabled(false);
            ((GridData)this.propertyValue.getLayoutData()).exclude = true;
        }
    }

    private void addListeners() {
        this.propertyName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ItemPropertyDialog.this.itemProperty.setName(ItemPropertyDialog.this.propertyName.getText());
            }
        });
        this.propertyValue.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ItemPropertyDialog.this.itemProperty.setValue(ItemPropertyDialog.this.propertyValue.getText());
            }
        });
        this.propertyValueExpression.addModifyListener(new ExpressionModifiedListener(){

            public void expressionModified(ExpressionModifiedEvent event) {
                ItemPropertyDialog.this.itemProperty.setValueExpression(event.modifiedExpression);
            }
        });
        this.useExpressionCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ItemPropertyDialog.this.useExpressionCheckbox.getSelection()) {
                    ItemPropertyDialog.this.propertyValue.setText("");
                    ItemPropertyDialog.this.itemProperty.setValue(null);
                    ItemPropertyDialog.this.propertyValue.setVisible(false);
                    ItemPropertyDialog.this.propertyValue.setEnabled(false);
                    ((GridData)((ItemPropertyDialog)ItemPropertyDialog.this).propertyValue.getLayoutData()).exclude = true;
                    ItemPropertyDialog.this.propertyValueExpression.setVisible(true);
                    ItemPropertyDialog.this.propertyValueExpression.setEnabled(true);
                    ((GridData)((ItemPropertyDialog)ItemPropertyDialog.this).propertyValueExpression.getLayoutData()).exclude = false;
                } else {
                    ItemPropertyDialog.this.propertyValueExpression.setVisible(false);
                    ItemPropertyDialog.this.propertyValueExpression.setEnabled(false);
                    ItemPropertyDialog.this.propertyValueExpression.setExpression(null);
                    ((GridData)((ItemPropertyDialog)ItemPropertyDialog.this).propertyValueExpression.getLayoutData()).exclude = true;
                    ItemPropertyDialog.this.propertyValue.setText("");
                    ItemPropertyDialog.this.propertyValue.setVisible(true);
                    ItemPropertyDialog.this.propertyValue.setEnabled(true);
                    ((GridData)((ItemPropertyDialog)ItemPropertyDialog.this).propertyValue.getLayoutData()).exclude = false;
                }
                ItemPropertyDialog.this.dialogArea.layout();
            }
        });
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ItemPropertyDialog_EditItemProperty);
        UIUtils.resizeAndCenterShell((Shell)newShell, (int)450, (int)400);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x10);
    }

    public boolean close() {
        return super.close();
    }

    public void setExpressionContext(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public ItemProperty getItemProperty() {
        return this.itemProperty;
    }
}

