/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.property;

import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.properties.view.TabbedPropertySheetPage;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.property.section.widgets.ASPropertyWidget;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class MapAuthenticationSection
extends AbstractSection {
    private ASPropertyWidget<?> keyWidget;
    private ASPropertyWidget<?> signatureWidget;
    private ASPropertyWidget<?> idWidget;
    private Button useBusinessAPICheck;
    private Composite cmpContainer;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.cmpContainer = this.getWidgetFactory().createComposite(parent);
        this.cmpContainer.setLayout((Layout)new GridLayout(2, false));
        GridData containerGD = new GridData(4, 4, true, true);
        containerGD.minimumHeight = 150;
        this.cmpContainer.setLayoutData((Object)containerGD);
        this.useBusinessAPICheck = this.getWidgetFactory().createButton(this.cmpContainer, Messages.MapAuthenticationSection_UseBusinessAPICheckbox, 32);
        this.useBusinessAPICheck.setLayoutData((Object)new GridData(4, 128, true, false, 2, 1));
        this.keyWidget = this.createWidget4Property(this.cmpContainer, "net.sf.jasperreports.components.map.key");
        this.idWidget = this.createWidget4Property(this.cmpContainer, "net.sf.jasperreports.components.map.client.id");
        this.signatureWidget = this.createWidget4Property(this.cmpContainer, "net.sf.jasperreports.components.map.signature");
        this.createWidget4Property(this.cmpContainer, "net.sf.jasperreports.components.map.google.version");
        this.useBusinessAPICheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean useBusiness = MapAuthenticationSection.this.useBusinessAPICheck.getSelection();
                MapAuthenticationSection.this.useBusinessSelected(MapAuthenticationSection.this.cmpContainer, useBusiness);
            }
        });
        parent.layout();
        boolean usingBusinessAPI = this.isUsingBusinessAPI();
        this.useBusinessAPICheck.setSelection(usingBusinessAPI);
        this.useBusinessSelected(this.cmpContainer, usingBusinessAPI);
    }

    private void useBusinessSelected(Composite parent, boolean useBusiness) {
        this.keyWidget.toggleVisibility(!useBusiness);
        this.idWidget.toggleVisibility(useBusiness);
        this.signatureWidget.toggleVisibility(useBusiness);
        if (useBusiness) {
            ((Text)this.keyWidget.getControl()).setText("");
            this.getElement().setPropertyValue((Object)"net.sf.jasperreports.components.map.key", null);
        } else {
            ((Text)this.idWidget.getControl()).setText("");
            this.getElement().setPropertyValue((Object)"net.sf.jasperreports.components.map.client.id", null);
            ((Text)this.signatureWidget.getControl()).setText("");
            this.getElement().setPropertyValue((Object)"net.sf.jasperreports.components.map.signature", null);
        }
        parent.update();
        parent.layout();
    }

    private boolean isUsingBusinessAPI() {
        Object clientID = this.getElement().getPropertyValue((Object)"net.sf.jasperreports.components.map.client.id");
        return clientID instanceof String && !((String)clientID).isEmpty();
    }

    protected void initializeProvidedProperties() {
        super.initializeProvidedProperties();
        this.addProvidedProperties("net.sf.jasperreports.components.map.key", Messages.MapAuthenticationSection_ApiKeyText);
        this.addProvidedProperties("net.sf.jasperreports.components.map.client.id", Messages.MapAuthenticationSection_ClientIdText);
        this.addProvidedProperties("net.sf.jasperreports.components.map.signature", Messages.MapAuthenticationSection_SignatureText);
        this.addProvidedProperties("net.sf.jasperreports.components.map.google.version", Messages.MapAuthenticationSection_VersionText);
    }
}

