/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.property;

import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.model.MMap;
import com.jaspersoft.studio.components.map.property.desc.MarkersDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.util.ItemPropertyUtil;
import com.jaspersoft.studio.property.itemproperty.desc.AItemDataListPropertyDescriptor;
import com.jaspersoft.studio.property.itemproperty.dialog.AItemDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.FormItemDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.ItemDataDialog;
import com.jaspersoft.studio.property.itemproperty.sp.SPItemDataList;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.utils.ExpressionInterpreter;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.support.GMapUtils;
import com.jaspersoft.studio.widgets.map.ui.GMapsMarkersPanel;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.BasicMapInfoData;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MarkersPropertyDescriptor
extends AItemDataListPropertyDescriptor {
    public MarkersPropertyDescriptor(Object id, String displayName, APropertyNode pNode) {
        super(id, displayName, pNode);
    }

    protected void initShowColumns() {
        this.descriptor = new MarkersDescriptor();
    }

    protected SPItemDataList createSPWidget(Composite parent, AbstractSection section) {
        return new SPMarkerItemDataList(parent, section, this, false);
    }

    private final class SPMarkerItemDataList
    extends SPItemDataList {
        private SPMarkerItemDataList(Composite parent, AbstractSection section, AItemDataListPropertyDescriptor pDescriptor, boolean showElements) {
            super(parent, section, pDescriptor, showElements);
        }

        protected ItemDataDialog createItemDataDialog(List<ItemData> clones, StandardItemData itemData) {
            return new ItemDataDialog(UIUtils.getShell(), Messages.MMap_markersDescription, Messages.SPMarker_MarkersListBtn, clones, itemData, this.section.getJasperReportsContext(), MarkersPropertyDescriptor.this.getDescriptor(), this.expContext, this.pnode){
                private GMapsMarkersPanel pmap;

                protected AItemDialog createItemDialog() {
                    return SPMarkerItemDataList.this.createItemDialog();
                }

                protected String getItemName() {
                    return Messages.MMap_markersDescription;
                }

                protected void createItems(final CTabFolder tabFolder) {
                    super.createItems(tabFolder);
                    final CTabItem tabItem = new CTabItem(tabFolder, 0);
                    tabItem.setText(Messages.MarkersPropertyDescriptor_3);
                    tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (tabFolder.getSelection() == tabItem) {
                                UIUtils.getDisplay().asyncExec(() -> pmap.refresh());
                            } else if (itemsViewer.getTable().isVisible()) {
                                itemsViewer.setInput((Object)itemData.getItems());
                                itemsViewer.refresh();
                            }
                        }
                    });
                    Composite cmp = new Composite((Composite)tabFolder, 0);
                    GridLayout layout = new GridLayout(2, false);
                    layout.marginWidth = 0;
                    layout.marginRight = -5;
                    cmp.setLayout((Layout)layout);
                    try {
                        this.pmap = new GMapsMarkersPanel(cmp, 0){
                            private MMap mmap;
                            private BasicMapInfoData mapInfo;

                            public void initMap() {
                                this.initMarkers = true;
                                try {
                                    this.mmap = (MMap)SPMarkerItemDataList.this.pnode;
                                    if (this.mapInfo == null) {
                                        this.mapInfo = this.mmap.getBasicMapInformation();
                                        if (this.mapInfo.getLatitude() != null && this.mapInfo.getLongitude() != null) {
                                            this.setMapCenter(new LatLng(this.mapInfo.getLatitude(), this.mapInfo.getLongitude(), true));
                                        } else if (this.mapInfo.getAddress() != null) {
                                            this.setAddress(this.mapInfo.getAddress());
                                        }
                                        if (this.mapInfo.getMapType() != null) {
                                            this.setMapType(MapType.fromStringID((String)this.mapInfo.getMapType().getName()));
                                        }
                                        if (this.mapInfo.getZoom() != 0) {
                                            this.setZoomLevel(this.mapInfo.getZoom());
                                        }
                                    }
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }

                            public void postInitMap() {
                                super.postInitMap();
                                this.initMarkers = true;
                                try {
                                    JasperDesign jd = this.mmap.getJasperDesign();
                                    this.clearMarkers();
                                    JRDesignDataset dataset = null;
                                    if (itemData.getDataset() != null) {
                                        dataset = ModelUtils.getDesignDatasetForDatasetRun((JasperDesign)jd, (JRDatasetRun)itemData.getDataset().getDatasetRun());
                                    }
                                    if (dataset == null) {
                                        dataset = ModelUtils.getDataset((ANode)this.mmap);
                                    }
                                    if (dataset == null) {
                                        dataset = (JRDesignDataset)jd.getMainDataset();
                                    }
                                    ExpressionInterpreter expIntr = ExpressionUtil.getCachedInterpreter((JRDesignDataset)dataset, (JasperDesign)jd, (JasperReportsConfiguration)this.mmap.getJasperConfiguration());
                                    for (Item it : itemData.getItems()) {
                                        Double lat = null;
                                        Double lon = null;
                                        StandardItemProperty ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"latitude");
                                        if (ip != null) {
                                            lat = ItemPropertyUtil.getItemPropertyDouble((StandardItemProperty)ip, (ExpressionInterpreter)expIntr);
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"longitude")) != null) {
                                            lon = ItemPropertyUtil.getItemPropertyDouble((StandardItemProperty)ip, (ExpressionInterpreter)expIntr);
                                        }
                                        if (lat == null || lon == null) {
                                            ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"address");
                                            String adr = ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr);
                                            if (Misc.isNullOrEmpty((String)adr)) continue;
                                            LatLng coords = GMapUtils.getAddressCoordinates((String)adr);
                                            if (coords != null) {
                                                lat = coords.getLat();
                                                lon = coords.getLng();
                                            }
                                        }
                                        if (lat == null || lon == null) continue;
                                        Marker m = new Marker(new LatLng(lat, lon));
                                        ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"flat");
                                        if (ip != null) {
                                            m.setFlat(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"clickable")) != null) {
                                            m.setClickable(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"draggable")) != null) {
                                            m.setDraggable(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"visible")) != null) {
                                            m.setVisible(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"optimized")) != null) {
                                            m.getOptions().setOptimized(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"raiseOnDrag")) != null) {
                                            m.getOptions().setRaiseOnDrag(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"cursor")) != null) {
                                            m.setCursor(ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"title")) != null) {
                                            m.setTitle(ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"zIndex")) != null) {
                                            m.setZIndex(ItemPropertyUtil.getItemPropertyInteger((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        this.addNewMarker(m);
                                    }
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }

                            protected void handleNewMarker(Marker newMarker) {
                                if (this.initMarkers) {
                                    return;
                                }
                                super.handleNewMarker(newMarker);
                                StandardItem si = new StandardItem();
                                LatLng p = newMarker.getPosition();
                                si.addItemProperty((ItemProperty)new StandardItemProperty("latitude", coordinatesFormatter.format(p.getLat()), null));
                                si.addItemProperty((ItemProperty)new StandardItemProperty("longitude", coordinatesFormatter.format(p.getLng()), null));
                                itemData.addItem((Item)si);
                            }

                            protected void handleUpdateMarkerPosition(int markerIdx, Marker m) {
                                super.handleUpdateMarkerPosition(markerIdx, m);
                                StandardItem si = (StandardItem)itemData.getItems().get(markerIdx);
                                if (si != null) {
                                    StandardItemProperty ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)si.getProperties(), (String)"latitude");
                                    LatLng p = m.getPosition();
                                    if (ip.getValueExpression() != null) {
                                        ip.setValueExpression((JRExpression)new JRDesignExpression(coordinatesFormatter.format(p.getLat())));
                                    } else {
                                        ip.setValue(coordinatesFormatter.format(p.getLat()));
                                    }
                                    ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)si.getProperties(), (String)"longitude");
                                    if (ip.getValueExpression() != null) {
                                        ip.setValueExpression((JRExpression)new JRDesignExpression(coordinatesFormatter.format(p.getLng())));
                                    } else {
                                        ip.setValue(coordinatesFormatter.format(p.getLng()));
                                    }
                                }
                            }

                            protected void handleRemoveMarker(int markerIndex) {
                                super.handleRemoveMarker(markerIndex);
                                itemData.removeItem((Item)itemData.getItems().get(markerIndex));
                            }

                            protected void handleRemoveMarker(int[] mIndxs) {
                                CopyOnWriteArrayList<Item> itms = new CopyOnWriteArrayList<Item>();
                                int[] nArray = mIndxs;
                                int n = mIndxs.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    int i = nArray[n2];
                                    itms.add((Item)itemData.getItems().get(i));
                                    ++n2;
                                }
                                for (Item it : itms) {
                                    itemData.removeItem(it);
                                }
                                super.handleRemoveMarker(mIndxs);
                                this.initMarkers = true;
                                try {
                                    this.postInitMap();
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }

                            protected void handleAddressChanged(String address) {
                                SPMarkerItemDataList.this.addPostCreateCommand("addressExpression", address);
                                SPMarkerItemDataList.this.addPostCreateCommand("latitudeExpression", null);
                                SPMarkerItemDataList.this.addPostCreateCommand("longitudeExpression", null);
                            }

                            protected void handleMapZoomChanged(int newZoomLevel) {
                                if (this.initMarkers) {
                                    return;
                                }
                                SPMarkerItemDataList.this.addPostCreateCommand("zoomExpression", newZoomLevel);
                            }

                            protected void handleMapTypeChanged(MapType mapType) {
                                if (this.initMarkers) {
                                    return;
                                }
                                SPMarkerItemDataList.this.addPostCreateCommand("mapType", mapType.ordinal());
                            }

                            protected void handleMapCenterChanged(LatLng position) {
                                if (this.initMarkers) {
                                    return;
                                }
                                super.handleMapCenterChanged(position);
                                if (Misc.isNullOrEmpty((String)this.getAddress())) {
                                    SPMarkerItemDataList.this.addPostCreateCommand("addressExpression", null);
                                    SPMarkerItemDataList.this.addPostCreateCommand("latitudeExpression", 2.coordinatesFormatter.format(position.getLat()));
                                    SPMarkerItemDataList.this.addPostCreateCommand("longitudeExpression", 2.coordinatesFormatter.format(position.getLng()));
                                }
                            }

                            protected void handleMarkerDoubleClick(int ind) {
                                editElement.editElement(itemData.getItems(), ind);
                                this.initMarkers = true;
                                try {
                                    this.postInitMap();
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }
                        };
                    }
                    catch (Throwable throwable) {
                        tabItem.dispose();
                        return;
                    }
                    tabItem.setControl((Control)cmp);
                }
            };
        }

        public AItemDialog createItemDialog() {
            return new FormItemDialog(UIUtils.getShell(), MarkersPropertyDescriptor.this.getDescriptor(), this.section.getJasperReportsContext(), false, false){

                protected void createValues(Composite cmp) {
                    Label lbl = this.createCenteredLabel(cmp);
                    lbl.setText(Messages.MapSection_1);
                    this.createItemProperty(cmp, "latitude");
                    this.createItemProperty(cmp, "longitude");
                    this.createItemProperty(cmp, "address");
                    SPMarkerItemDataList.2.createSeparator((Composite)cmp);
                    this.createItemProperty(cmp, "title");
                    this.createItemProperty(cmp, "url");
                    this.createItemProperty(cmp, "target");
                    this.createItemProperty(cmp, "icon");
                    Composite c = this.createSection(cmp, Messages.MarkersPropertyDescriptor_1, false);
                    this.createItemProperty(c, "icon.url");
                    this.createItemProperty(c, "icon.width");
                    this.createItemProperty(c, "icon.height");
                    this.createItemProperty(c, "icon.origin.x");
                    this.createItemProperty(c, "icon.origin.y");
                    this.createItemProperty(c, "icon.anchor.x");
                    this.createItemProperty(c, "icon.anchor.y");
                    this.createItemProperty(cmp, "shadow");
                    c = this.createSection(cmp, Messages.MarkersPropertyDescriptor_2, false);
                    this.createItemProperty(c, "shadow.url");
                    this.createItemProperty(c, "shadow.width");
                    this.createItemProperty(c, "shadow.height");
                    this.createItemProperty(c, "shadow.origin.x");
                    this.createItemProperty(c, "shadow.origin.y");
                    this.createItemProperty(c, "shadow.anchor.x");
                    this.createItemProperty(c, "shadow.anchor.y");
                    c = this.createSection(cmp, Messages.MarkersPropertyDescriptor_0, false);
                    this.createItemProperty(c, "infowindow.content");
                    this.createItemProperty(c, "infowindow.pixelOffset");
                    this.createItemProperty(c, "infowindow.maxWidth");
                    SPMarkerItemDataList.2.createSeparator((Composite)cmp);
                    this.createItemProperty(cmp, "color");
                    this.createItemProperty(cmp, "label");
                    this.createItemProperty(cmp, "cursor");
                    this.createItemProperty(cmp, "zIndex");
                    this.createItemProperty(cmp, "clickable");
                    this.createItemProperty(cmp, "draggable");
                    this.createItemProperty(cmp, "flat");
                    this.createItemProperty(cmp, "optimized");
                    this.createItemProperty(cmp, "raiseOnDrag");
                    this.createItemProperty(cmp, "visible");
                    this.createItemProperty(cmp, "size");
                }
            };
        }
    }
}

