/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.property;

import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.components.map.model.MMap;
import com.jaspersoft.studio.components.map.property.desc.PathDescriptor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.util.ItemPropertyUtil;
import com.jaspersoft.studio.property.itemproperty.desc.AItemDataListPropertyDescriptor;
import com.jaspersoft.studio.property.itemproperty.dialog.AItemDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.FormItemDialog;
import com.jaspersoft.studio.property.itemproperty.dialog.ItemDataDialog;
import com.jaspersoft.studio.property.itemproperty.sp.SPItemDataList;
import com.jaspersoft.studio.property.section.AbstractSection;
import com.jaspersoft.studio.utils.ExpressionInterpreter;
import com.jaspersoft.studio.utils.ExpressionUtil;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.MapType;
import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.support.GMapUtils;
import com.jaspersoft.studio.widgets.map.ui.GMapsPathsPanel;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemData;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.BasicMapInfoData;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PathPropertyDescriptor
extends AItemDataListPropertyDescriptor {
    public PathPropertyDescriptor(Object id, String displayName, APropertyNode pNode) {
        super(id, displayName, pNode);
    }

    protected void initShowColumns() {
        this.descriptor = new PathDescriptor();
    }

    protected SPItemDataList createSPWidget(Composite parent, AbstractSection section) {
        return new SPMarkerItemDataList(parent, section, this, false);
    }

    private final class SPMarkerItemDataList
    extends SPItemDataList {
        private SPMarkerItemDataList(Composite parent, AbstractSection section, AItemDataListPropertyDescriptor pDescriptor, boolean showElements) {
            super(parent, section, pDescriptor, showElements);
        }

        protected ItemDataDialog createItemDataDialog(List<ItemData> clones, StandardItemData itemData) {
            ItemDataDialog dialog = new ItemDataDialog(UIUtils.getShell(), Messages.MMap_MapPaths, Messages.PathPropertyDescriptor_0, clones, itemData, this.section.getJasperReportsContext(), PathPropertyDescriptor.this.getDescriptor(), this.expContext, this.pnode){
                private GMapsPathsPanel pmap;

                protected AItemDialog createItemDialog() {
                    return SPMarkerItemDataList.this.createItemDialog();
                }

                protected String getItemName() {
                    return Messages.MMap_MapPaths;
                }

                protected void createItems(final CTabFolder tabFolder) {
                    super.createItems(tabFolder);
                    final CTabItem tabItem = new CTabItem(tabFolder, 0);
                    tabItem.setText(Messages.MarkersPropertyDescriptor_3);
                    tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (tabFolder.getSelection() == tabItem) {
                                UIUtils.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        pmap.refresh();
                                        pmap.initMarkers();
                                    }
                                });
                            } else if (itemsViewer.getTable().isVisible()) {
                                itemsViewer.setInput((Object)itemData.getItems());
                                itemsViewer.refresh();
                            }
                        }
                    });
                    Composite cmp = new Composite((Composite)tabFolder, 0);
                    GridLayout layout = new GridLayout(2, false);
                    layout.marginWidth = 0;
                    layout.marginRight = -5;
                    cmp.setLayout((Layout)layout);
                    try {
                        this.pmap = new GMapsPathsPanel(cmp, 0){
                            private MMap mmap;
                            private BasicMapInfoData mapInfo;

                            public void initMap() {
                                this.initMarkers = true;
                                try {
                                    this.mmap = (MMap)SPMarkerItemDataList.this.pnode;
                                    if (this.mapInfo == null) {
                                        this.mapInfo = this.mmap.getBasicMapInformation();
                                        if (this.mapInfo.getLatitude() != null && this.mapInfo.getLongitude() != null) {
                                            this.setMapCenter(new LatLng(this.mapInfo.getLatitude(), this.mapInfo.getLongitude(), true));
                                        } else if (this.mapInfo.getAddress() != null) {
                                            this.setAddress(this.mapInfo.getAddress());
                                        } else {
                                            SPMarkerItemDataList.this.addPostCreateCommand("latitudeExpression", this.getMapCenter().getLat());
                                            SPMarkerItemDataList.this.addPostCreateCommand("longitudeExpression", this.getMapCenter().getLng());
                                        }
                                        if (this.mapInfo.getMapType() != null) {
                                            this.setMapType(MapType.fromStringID((String)this.mapInfo.getMapType().getName()));
                                        } else {
                                            SPMarkerItemDataList.this.addPostCreateCommand("mapType", this.getMapType());
                                        }
                                        if (this.mapInfo.getZoom() != 0) {
                                            this.setZoomLevel(this.mapInfo.getZoom());
                                        } else {
                                            SPMarkerItemDataList.this.addPostCreateCommand("zoomExpression", this.getZoomLevel());
                                        }
                                    }
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }

                            private ExpressionInterpreter getExpressionInterpretter() {
                                JasperDesign jd = this.mmap.getJasperDesign();
                                JRDesignDataset dataset = null;
                                if (itemData.getDataset() != null) {
                                    dataset = ModelUtils.getDesignDatasetForDatasetRun((JasperDesign)jd, (JRDatasetRun)itemData.getDataset().getDatasetRun());
                                }
                                if (dataset == null) {
                                    dataset = ModelUtils.getDataset((ANode)this.mmap);
                                }
                                if (dataset == null) {
                                    dataset = (JRDesignDataset)jd.getMainDataset();
                                }
                                return ExpressionUtil.getCachedInterpreter((JRDesignDataset)dataset, (JasperDesign)jd, (JasperReportsConfiguration)this.mmap.getJasperConfiguration());
                            }

                            public void postInitMap() {
                                super.postInitMap();
                                this.fillPaths();
                            }

                            public void initMarkers() {
                                this.initMarkers = true;
                                try {
                                    if (this.markersList != null && this.markersList.getItemCount() > 0) {
                                        this.clearMarkers();
                                    }
                                    String path = this.cPaths.getText();
                                    ExpressionInterpreter expIntr = this.getExpressionInterpretter();
                                    for (Item it : itemData.getItems()) {
                                        Double lat = null;
                                        Double lon = null;
                                        String itPath = null;
                                        StandardItemProperty ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"name");
                                        if (ip != null) {
                                            itPath = ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr);
                                        }
                                        if ((!Misc.isNullOrEmpty((String)path) || !Misc.isNullOrEmpty((String)itPath)) && !path.equals(itPath)) continue;
                                        ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"latitude");
                                        if (ip != null) {
                                            lat = ItemPropertyUtil.getItemPropertyDouble((StandardItemProperty)ip, (ExpressionInterpreter)expIntr);
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"longitude")) != null) {
                                            lon = ItemPropertyUtil.getItemPropertyDouble((StandardItemProperty)ip, (ExpressionInterpreter)expIntr);
                                        }
                                        if (lat == null || lon == null) {
                                            ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"address");
                                            String adr = ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr);
                                            if (Misc.isNullOrEmpty((String)adr)) continue;
                                            LatLng coords = GMapUtils.getAddressCoordinates((String)adr);
                                            if (coords != null) {
                                                lat = coords.getLat();
                                                lon = coords.getLng();
                                            }
                                        }
                                        if (lat == null || lon == null) continue;
                                        Marker m = new Marker(new LatLng(lat, lon));
                                        ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"flat");
                                        if (ip != null) {
                                            m.setFlat(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"clickable")) != null) {
                                            m.setClickable(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"draggable")) != null) {
                                            m.setDraggable(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"visible")) != null) {
                                            m.setVisible(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"optimized")) != null) {
                                            m.getOptions().setOptimized(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"raiseOnDrag")) != null) {
                                            m.getOptions().setRaiseOnDrag(ItemPropertyUtil.getItemPropertyBoolean((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"cursor")) != null) {
                                            m.setCursor(ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"title")) != null) {
                                            m.setTitle(ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        if ((ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"zIndex")) != null) {
                                            m.setZIndex(ItemPropertyUtil.getItemPropertyInteger((StandardItemProperty)ip, (ExpressionInterpreter)expIntr));
                                        }
                                        this.addNewMarker(m);
                                    }
                                    this.drawPolyline();
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }

                            protected void fillPaths() {
                                this.initMarkers = true;
                                try {
                                    String oldSelection = this.cPaths.getText();
                                    this.cPaths.removeAll();
                                    LinkedHashSet<String> set = new LinkedHashSet<String>();
                                    ExpressionInterpreter expIntr = this.getExpressionInterpretter();
                                    for (Item it : itemData.getItems()) {
                                        String path;
                                        StandardItemProperty ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"name");
                                        if (ip == null || Misc.isNullOrEmpty((String)(path = ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr)))) continue;
                                        set.add(path);
                                    }
                                    this.cPaths.setItems(set.toArray(new String[set.size()]));
                                    int i = 0;
                                    for (String path : set) {
                                        if (path.equals(oldSelection)) {
                                            this.cPaths.select(i);
                                            break;
                                        }
                                        ++i;
                                    }
                                    if (this.cPaths.getSelectionIndex() < 0) {
                                        this.cPaths.setText(oldSelection);
                                    }
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }

                            protected void handlePathChanged() {
                                this.initMarkers();
                            }

                            protected void handleNewMarker(Marker newMarker) {
                                if (this.initMarkers) {
                                    return;
                                }
                                super.handleNewMarker(newMarker);
                                StandardItem si = new StandardItem();
                                LatLng p = newMarker.getPosition();
                                si.addItemProperty((ItemProperty)new StandardItemProperty("latitude", coordinatesFormatter.format(p.getLat()), null));
                                si.addItemProperty((ItemProperty)new StandardItemProperty("longitude", coordinatesFormatter.format(p.getLng()), null));
                                String path = this.cPaths.getText();
                                if (!Misc.isNullOrEmpty((String)path)) {
                                    si.addItemProperty((ItemProperty)new StandardItemProperty("name", path, null));
                                }
                                itemData.addItem((Item)si);
                            }

                            protected void handleUpdateMarkerPosition(int markerIdx, Marker m) {
                                super.handleUpdateMarkerPosition(markerIdx, m);
                                StandardItem si = (StandardItem)itemData.getItems().get(markerIdx);
                                if (si != null) {
                                    StandardItemProperty ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)si.getProperties(), (String)"latitude");
                                    LatLng p = m.getPosition();
                                    if (ip.getValueExpression() != null) {
                                        ip.setValueExpression((JRExpression)new JRDesignExpression(coordinatesFormatter.format(p.getLat())));
                                    } else {
                                        ip.setValue(coordinatesFormatter.format(p.getLat()));
                                    }
                                    ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)si.getProperties(), (String)"longitude");
                                    if (ip.getValueExpression() != null) {
                                        ip.setValueExpression((JRExpression)new JRDesignExpression(coordinatesFormatter.format(p.getLng())));
                                    } else {
                                        ip.setValue(coordinatesFormatter.format(p.getLng()));
                                    }
                                }
                            }

                            protected void handleRemoveMarker(int[] mIndxs) {
                                ArrayList<Item> itms = new ArrayList<Item>();
                                String p = this.cPaths.getText();
                                if (!Misc.isNullOrEmpty((String)p)) {
                                    ExpressionInterpreter expIntr = this.getExpressionInterpretter();
                                    ArrayList<Item> pitems = new ArrayList<Item>();
                                    for (Item it : itemData.getItems()) {
                                        String path;
                                        StandardItemProperty ip = (StandardItemProperty)ItemPropertyUtil.getProperty((List)it.getProperties(), (String)"name");
                                        if (ip == null || Misc.isNullOrEmpty((String)(path = ItemPropertyUtil.getItemPropertyString((StandardItemProperty)ip, (ExpressionInterpreter)expIntr))) || !path.equals(p)) continue;
                                        pitems.add(it);
                                    }
                                    int[] nArray = mIndxs;
                                    int n = mIndxs.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        int i = nArray[n2];
                                        itms.add((Item)pitems.get(i));
                                        ++n2;
                                    }
                                } else {
                                    int[] nArray = mIndxs;
                                    int n = mIndxs.length;
                                    int n3 = 0;
                                    while (n3 < n) {
                                        int i = nArray[n3];
                                        itms.add((Item)itemData.getItems().get(i));
                                        ++n3;
                                    }
                                }
                                for (Item it : itms) {
                                    itemData.removeItem(it);
                                }
                                super.handleRemoveMarker(mIndxs);
                                this.initMarkers = true;
                                try {
                                    this.postInitMap();
                                    this.initMarkers();
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }

                            protected void handleAddressChanged(String address) {
                                SPMarkerItemDataList.this.addPostCreateCommand("addressExpression", address);
                                SPMarkerItemDataList.this.addPostCreateCommand("latitudeExpression", null);
                                SPMarkerItemDataList.this.addPostCreateCommand("longitudeExpression", null);
                            }

                            protected void handleMapZoomChanged(int newZoomLevel) {
                                if (this.initMarkers) {
                                    return;
                                }
                                SPMarkerItemDataList.this.addPostCreateCommand("zoomExpression", newZoomLevel);
                            }

                            protected void handleMapTypeChanged(MapType mapType) {
                                if (this.initMarkers) {
                                    return;
                                }
                                SPMarkerItemDataList.this.addPostCreateCommand("mapType", mapType.ordinal());
                            }

                            protected void handleMapCenterChanged(LatLng position) {
                                if (this.initMarkers) {
                                    return;
                                }
                                super.handleMapCenterChanged(position);
                                if (Misc.isNullOrEmpty((String)this.getAddress())) {
                                    SPMarkerItemDataList.this.addPostCreateCommand("addressExpression", null);
                                    SPMarkerItemDataList.this.addPostCreateCommand("latitudeExpression", 2.coordinatesFormatter.format(position.getLat()));
                                    SPMarkerItemDataList.this.addPostCreateCommand("longitudeExpression", 2.coordinatesFormatter.format(position.getLng()));
                                }
                            }

                            protected void handleMarkerDoubleClick(int ind) {
                                editElement.editElement(itemData.getItems(), ind);
                                this.initMarkers = true;
                                try {
                                    this.postInitMap();
                                }
                                finally {
                                    this.initMarkers = false;
                                }
                            }
                        };
                    }
                    catch (Throwable throwable) {
                        tabItem.dispose();
                        return;
                    }
                    tabItem.setControl((Control)cmp);
                }
            };
            return dialog;
        }

        protected AItemDialog createItemDialog() {
            return new FormItemDialog(UIUtils.getShell(), PathPropertyDescriptor.this.getDescriptor(), this.section.getJasperReportsContext(), false, false){

                protected void createValues(Composite cmp) {
                    this.createItemProperty(cmp, "name");
                    Label lbl = this.createCenteredLabel(cmp);
                    lbl.setText(Messages.MapSection_1);
                    this.createItemProperty(cmp, "latitude");
                    this.createItemProperty(cmp, "longitude");
                    this.createItemProperty(cmp, "address");
                    SPMarkerItemDataList.2.createSeparator((Composite)cmp);
                    this.createItemProperty(cmp, "style");
                    SPMarkerItemDataList.2.createSeparator((Composite)cmp);
                    this.createItemProperty(cmp, "strokeColor");
                    this.createItemProperty(cmp, "strokeOpacity");
                    this.createItemProperty(cmp, "strokeWeight");
                    SPMarkerItemDataList.2.createSeparator((Composite)cmp);
                    this.createItemProperty(cmp, "fillColor");
                    this.createItemProperty(cmp, "fillOpacity");
                    SPMarkerItemDataList.2.createSeparator((Composite)cmp);
                    this.createItemProperty(cmp, "isPolygon");
                    this.createItemProperty(cmp, "clickable");
                    this.createItemProperty(cmp, "editable");
                    this.createItemProperty(cmp, "draggable");
                    this.createItemProperty(cmp, "geodesic");
                    this.createItemProperty(cmp, "visible");
                    this.createItemProperty(cmp, "zIndex");
                }
            };
        }

        protected ViewerComparator getElementViewerComparator() {
            return new ViewerComparator(){

                public int compare(Viewer viewer, Object e1, Object e2) {
                    Item t1 = (Item)e1;
                    Item t2 = (Item)e2;
                    ItemProperty ip1 = this.getItemProperty(t1);
                    ItemProperty ip2 = this.getItemProperty(t2);
                    if (ip1 != null && ip2 != null) {
                        JRExpression ip1exp = ip1.getValueExpression();
                        JRExpression ip2exp = ip2.getValueExpression();
                        if (ip1exp != null && ip2exp != null) {
                            return Misc.nvl((String)ip1exp.getText()).compareTo(Misc.nvl((String)ip2exp.getText()));
                        }
                        if (ip1exp != null) {
                            return -1;
                        }
                        if (ip2exp != null) {
                            return 1;
                        }
                        return Misc.nvl((String)ip1.getValue()).compareTo(Misc.nvl((String)ip2.getValue()));
                    }
                    return -1;
                }

                private ItemProperty getItemProperty(Item item) {
                    List p = item.getProperties();
                    if (p != null) {
                        return ItemPropertyUtil.getProperty((List)p, (String)"name");
                    }
                    return null;
                }
            };
        }
    }
}

