/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.map.property.desc;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.map.messages.Messages;
import com.jaspersoft.studio.model.util.ItemPropertyUtil;
import com.jaspersoft.studio.properties.view.validation.ValidationError;
import com.jaspersoft.studio.property.itemproperty.desc.ADescriptor;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.PropertyEditorAdapter;
import com.jaspersoft.studio.widgets.framework.ui.ColorPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ComboItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.DoublePropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.IntegerPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import com.jaspersoft.studio.widgets.framework.ui.TextPropertyDescription;
import java.util.Collection;
import java.util.List;
import net.sf.jasperreports.components.items.Item;
import net.sf.jasperreports.components.items.ItemData;
import net.sf.jasperreports.components.items.ItemProperty;
import net.sf.jasperreports.components.items.StandardItem;
import net.sf.jasperreports.components.items.StandardItemProperty;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRExpression;
import org.eclipse.swt.graphics.Image;

public class MarkersDescriptor
extends ADescriptor {
    private IPropertyEditor standardItemEditor = new PropertyEditorAdapter(){

        public JRExpression getPropertyValueExpression(String propertyName) {
            for (ItemProperty prop : MarkersDescriptor.this.item.getProperties()) {
                if (!prop.getName().equals(propertyName)) continue;
                StandardItemProperty stdProp = (StandardItemProperty)prop;
                return stdProp.getValueExpression();
            }
            return null;
        }

        public String getPropertyValue(String propertyName) {
            for (ItemProperty prop : MarkersDescriptor.this.item.getProperties()) {
                if (!prop.getName().equals(propertyName)) continue;
                StandardItemProperty stdProp = (StandardItemProperty)prop;
                return stdProp.getValue();
            }
            return null;
        }

        public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
            boolean found = false;
            for (ItemProperty prop : MarkersDescriptor.this.item.getProperties()) {
                if (!prop.getName().equals(propertyName)) continue;
                StandardItemProperty stdProp = (StandardItemProperty)prop;
                stdProp.setValue(value);
                stdProp.setValueExpression(valueExpression);
                found = true;
                break;
            }
            if (!found) {
                ((StandardItem)MarkersDescriptor.this.item).addItemProperty((ItemProperty)new StandardItemProperty(propertyName, value, valueExpression));
            }
        }

        public void removeProperty(String propertyName) {
            for (ItemProperty prop : MarkersDescriptor.this.item.getProperties()) {
                if (!prop.getName().equals(propertyName)) continue;
                ((StandardItem)MarkersDescriptor.this.item).removeItemProperty(prop);
                break;
            }
        }
    };

    public String getDisplayName() {
        return Messages.MarkersDescriptor_0;
    }

    public Image getIcon(Object element) {
        if (element instanceof Item) {
            return Activator.getDefault().getImage("icons/map-16.png");
        }
        return super.getIcon(element);
    }

    protected void initItemPropertyDescriptors() {
        this.itemProperties = new ItemPropertyDescription[]{new TextPropertyDescription("title", Messages.MarkersDescriptor_1, "", false, (Object)Messages.MarkersDescriptor_0), new DoublePropertyDescription("latitude", Messages.MarkerPage_LatitudeColumn, "", false, Double.valueOf(37.7833), -85.0, 85.0), new DoublePropertyDescription("longitude", Messages.MarkerPage_LongitudeColumn, "", false, Double.valueOf(-122.4167), -180.0, 180.0), new TextPropertyDescription("address", Messages.MarkersDescriptor_3, Messages.MarkersDescriptor_4, false), new TextPropertyDescription("url", Messages.MarkersDescriptor_5, Messages.MarkersDescriptor_6, false), new ComboItemPropertyDescription("target", Messages.MarkersDescriptor_7, Messages.MarkersDescriptor_8, false, new String[]{"_blank", "_parent", "_self", "_top", ""}), new TextPropertyDescription("icon", Messages.MarkersDescriptor_14, Messages.MarkersDescriptor_15, false), new TextPropertyDescription("icon.url", Messages.MarkersDescriptor_16, Messages.MarkersDescriptor_17, false), new IntegerPropertyDescription("icon.width", Messages.MarkersDescriptor_18, Messages.MarkersDescriptor_19, false, Integer.valueOf(0), null), new IntegerPropertyDescription("icon.height", Messages.MarkersDescriptor_20, Messages.MarkersDescriptor_21, false, Integer.valueOf(0), null), new IntegerPropertyDescription("icon.origin.x", Messages.MarkersDescriptor_22, Messages.MarkersDescriptor_23, false, Integer.valueOf(0), null, null), new IntegerPropertyDescription("icon.origin.y", Messages.MarkersDescriptor_24, Messages.MarkersDescriptor_25, false, Integer.valueOf(0), null, null), new IntegerPropertyDescription("icon.anchor.x", Messages.MarkersDescriptor_26, Messages.MarkersDescriptor_27, false, Integer.valueOf(0), null, null), new IntegerPropertyDescription("icon.anchor.y", Messages.MarkersDescriptor_28, Messages.MarkersDescriptor_29, false, Integer.valueOf(0), null, null), new TextPropertyDescription("shadow", Messages.MarkersDescriptor_30, Messages.MarkersDescriptor_31, false), new TextPropertyDescription("shadow.url", Messages.MarkersDescriptor_32, Messages.MarkersDescriptor_33, false), new IntegerPropertyDescription("shadow.width", Messages.MarkersDescriptor_34, Messages.MarkersDescriptor_35, false, Integer.valueOf(0), null), new IntegerPropertyDescription("shadow.height", Messages.MarkersDescriptor_36, Messages.MarkersDescriptor_37, false, Integer.valueOf(0), null), new IntegerPropertyDescription("shadow.origin.x", Messages.MarkersDescriptor_38, Messages.MarkersDescriptor_39, false, Integer.valueOf(0), null, null), new IntegerPropertyDescription("shadow.origin.y", Messages.MarkersDescriptor_40, Messages.MarkersDescriptor_41, false, Integer.valueOf(0), null, null), new IntegerPropertyDescription("shadow.anchor.x", Messages.MarkersDescriptor_42, Messages.MarkersDescriptor_43, false, Integer.valueOf(0), null, null), new IntegerPropertyDescription("shadow.anchor.y", Messages.MarkersDescriptor_44, Messages.MarkersDescriptor_45, false, Integer.valueOf(0), null, null), new TextPropertyDescription("infowindow.content", Messages.MarkersDescriptor_46, Messages.MarkersDescriptor_47, false), new IntegerPropertyDescription("infowindow.pixelOffset", Messages.MarkersDescriptor_48, Messages.MarkersDescriptor_49, false, null, null), new IntegerPropertyDescription("infowindow.maxWidth", Messages.MarkersDescriptor_50, Messages.MarkersDescriptor_51, false, Integer.valueOf(0), null), new ColorPropertyDescription("color", Messages.MarkersDescriptor_52, Messages.MarkersDescriptor_53, false), new TextPropertyDescription("label", Messages.MarkerPage_LabelColumn, Messages.MarkersDescriptor_54, false), new TextPropertyDescription("cursor", Messages.MarkersDescriptor_55, "", false), new IntegerPropertyDescription("zIndex", Messages.MarkersDescriptor_56, "", false, new Integer(0), null), new ComboItemPropertyDescription("clickable", Messages.MarkersDescriptor_57, "", false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("draggable", Messages.MarkersDescriptor_58, "", false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("flat", Messages.MarkersDescriptor_59, "", false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("optimized", Messages.MarkersDescriptor_60, "", false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("raiseOnDrag", Messages.MarkersDescriptor_61, "", false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("visible", Messages.MarkersDescriptor_62, "", false, (Object)Boolean.FALSE, new String[]{"", "true", "false"}), new ComboItemPropertyDescription("size", Messages.MarkersDescriptor_63, Messages.MarkersDescriptor_64, false, new String[]{"", "mid", "tiny", "small"})};
    }

    public void validateItem(ItemProperty itemProperty) throws ValidationError {
        super.validateItem(itemProperty);
        if (itemProperty == null) {
            for (ItemData id : this.itemDatas) {
                if (id.getItems() == null) continue;
                for (Item it : id.getItems()) {
                    if (Misc.isNullOrEmpty((Collection)it.getProperties())) {
                        throw new ValidationError(Messages.MarkersDescriptor_75);
                    }
                    boolean address = false;
                    boolean lon = false;
                    boolean lat = false;
                    if (ItemPropertyUtil.hasValue((List)it.getProperties(), (String)"latitude")) {
                        lat = true;
                    }
                    if (ItemPropertyUtil.hasValue((List)it.getProperties(), (String)"longitude")) {
                        lon = true;
                    }
                    if (ItemPropertyUtil.hasValue((List)it.getProperties(), (String)"address")) {
                        address = true;
                    }
                    if (address || lon && lat) continue;
                    throw new ValidationError(Messages.MarkersDescriptor_76);
                }
            }
        }
    }

    public IPropertyEditor getPropertyEditor() {
        return this.standardItemEditor;
    }
}

