/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table;

import com.jaspersoft.studio.components.table.ColumnCell;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.Cell;

public class Guide {
    private int y;
    private List<ColumnCell> prev = new ArrayList<ColumnCell>();
    private List<ColumnCell> next = new ArrayList<ColumnCell>();

    public Guide(int y) {
        this.y = y;
    }

    public void setNext(List<ColumnCell> next) {
        this.next = next;
    }

    public void setPrev(List<ColumnCell> prev) {
        this.prev = prev;
    }

    public List<ColumnCell> getPrev() {
        return this.prev;
    }

    public List<ColumnCell> getNext() {
        return this.next;
    }

    public void addWest(ColumnCell cell) {
        cell.setEast(this);
        this.prev.add(cell);
    }

    public void addEast(ColumnCell cell) {
        cell.setWest(this);
        this.next.add(cell);
    }

    public void addNorth(ColumnCell cell) {
        cell.setSouth(this);
        this.prev.add(cell);
    }

    public void addSouth(ColumnCell cell) {
        cell.setNorth(this);
        this.next.add(cell);
    }

    public void mirror() {
        this.switchCells(this.next);
        this.switchCells(this.prev);
        List<ColumnCell> tmp = this.next;
        this.next = this.prev;
        this.prev = tmp;
    }

    private void switchCells(List<ColumnCell> cols) {
        for (ColumnCell cc : cols) {
            Guide t = cc.getSouth();
            cc.setSouth(cc.getNorth());
            cc.setNorth(t);
        }
    }

    public int getY() {
        return this.y;
    }

    public void setY(Guide north, Cell c) {
        if (c != null) {
            this.y = Math.max(this.y, north.getY() + c.getHeight());
        }
    }

    public void setY(int y) {
        this.y = y;
    }

    public String toString() {
        StringBuffer res = new StringBuffer();
        res.append("y: " + this.y + " NORTH");
        for (ColumnCell cc : this.prev) {
            res.append(cc.toString());
        }
        res.append("\nSOUTH");
        for (ColumnCell cc : this.next) {
            res.append(cc.toString());
        }
        return res.toString();
    }
}

