/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table;

import com.jaspersoft.studio.components.table.ColumnCell;
import com.jaspersoft.studio.components.table.Guide;
import com.jaspersoft.studio.components.table.RowGuide;
import com.jaspersoft.studio.components.table.TableManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRGroup;
import org.eclipse.draw2d.geometry.Rectangle;

public class TableMatrix {
    private List<Guide> hGuides = new ArrayList<Guide>();
    private List<Guide> vGuides = new ArrayList<Guide>();
    private Map<ColumnCell, Rectangle> map = new HashMap<ColumnCell, Rectangle>();
    private List<JRGroup> groupsList;

    public Map<ColumnCell, Rectangle> getCells() {
        return this.map;
    }

    public void setY(Guide north, int y) {
        int delta = y - north.getY();
        int i = this.hGuides.indexOf(north);
        while (!(north instanceof RowGuide)) {
            north = this.hGuides.get(i);
            north.setY(north.getY() + delta);
            --i;
        }
    }

    public Rectangle getYHColumn(BaseColumn bc, int type, String grName) {
        return this.map.get(new ColumnCell(type, Misc.nvl((String)grName), bc));
    }

    public ColumnCell getColumnCell(ColumnCell colcel) {
        for (ColumnCell cc : this.map.keySet()) {
            if (!cc.equals(colcel)) continue;
            return cc;
        }
        return null;
    }

    public int getSectionHeight(ColumnCell cc) {
        Guide north = cc.getNorth();
        Guide south = cc.getSouth();
        int i = this.hGuides.indexOf(north);
        while (!(north instanceof RowGuide)) {
            north = this.hGuides.get(i);
            --i;
        }
        i = this.hGuides.indexOf(south);
        while (!(south instanceof RowGuide)) {
            south = this.hGuides.get(i);
            ++i;
        }
        return south.getY() - north.getY();
    }

    public int getRowHeight(ColumnCell cc) {
        Guide g;
        int h = 0;
        if (cc != null && (g = this.getRowGuide(cc)) != null) {
            if (cc.getNorth() == null) {
                cc = this.getColumnCell(cc);
            }
            if (cc != null) {
                if (TableManager.isBottomOfTable(cc.type)) {
                    return cc.getSouth().getY() - g.getY();
                }
                return g.getY() - cc.getNorth().getY();
            }
        }
        return h;
    }

    public Guide getRowGuide(ColumnCell cc) {
        block6: {
            if (cc == null) break block6;
            if (TableManager.isBottomOfTable(cc.type)) {
                Guide s = cc.getSouth();
                int i = this.hGuides.indexOf(s) - 1;
                while (i < this.hGuides.size()) {
                    Guide g = this.hGuides.get(i);
                    if (g instanceof RowGuide) {
                        return g;
                    }
                    --i;
                }
            } else {
                Guide n = cc.getNorth();
                int i = this.hGuides.indexOf(n) + 1;
                while (i < this.hGuides.size()) {
                    Guide g = this.hGuides.get(i);
                    if (g instanceof RowGuide) {
                        return g;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private void fixCells() {
        for (ColumnCell cc : this.map.keySet()) {
            this.map.put(cc, cc.getBounds());
        }
    }

    public void fillMatrix(StandardTable table, TableUtil tableUtil) {
        this.hGuides.clear();
        this.vGuides.clear();
        this.map.clear();
        Guide north = new Guide(0);
        this.hGuides.add(north);
        Guide south = this.fillRowTop(north, this.addNextRow(north), table.getColumns(), 0, "");
        south = this.fillRowTop(south, this.addNextRow(south), table.getColumns(), 2, "");
        this.groupsList = tableUtil.getGroupList();
        if (this.groupsList != null) {
            for (JRGroup jrGroup : this.groupsList) {
                south = this.fillRowTop(south, this.addNextRow(south), table.getColumns(), 5, jrGroup.getName());
            }
        }
        south = this.fillRowDetail(south, this.addNextRow(south), table.getColumns());
        int offset = this.hGuides.indexOf(south);
        north = new Guide(0);
        this.hGuides.add(north);
        south = this.fillRowTop(north, this.addNextRow(north), table.getColumns(), 1, "");
        south = this.fillRowTop(south, this.addNextRow(south), table.getColumns(), 3, "");
        if (this.groupsList != null) {
            for (JRGroup jrGroup : this.groupsList) {
                south = this.fillRowTop(south, this.addNextRow(south), table.getColumns(), 6, jrGroup.getName());
            }
        }
        this.mirrorBottom(offset);
        this.fillVertical(table);
        this.fixCells();
    }

    public void mirrorBottom(int offset) {
        int size = this.hGuides.size();
        int maxy = 0;
        int i = offset + 1;
        while (i < size) {
            maxy = Math.max(maxy, this.hGuides.get(i).getY());
            ++i;
        }
        int y = this.hGuides.get(offset).getY();
        int i2 = offset + 1;
        while (i2 < size) {
            Guide g = this.hGuides.get(i2);
            g.setY(y + maxy - g.getY());
            ++i2;
        }
        Guide g = this.hGuides.get(offset);
        Guide lg = this.hGuides.get(size - 1);
        g.setNext(lg.getPrev());
        int i3 = offset + 1;
        while (i3 < size) {
            this.hGuides.get(i3).mirror();
            ++i3;
        }
        this.hGuides.remove(lg);
        size = this.hGuides.size() - 1;
        int s = size - offset;
        int i4 = 0;
        while (i4 < s) {
            int tind = offset + 1 + i4;
            int bind = size - i4;
            if (tind >= bind) break;
            Guide tmp = this.hGuides.get(tind);
            this.hGuides.set(tind, this.hGuides.get(bind));
            this.hGuides.set(bind, tmp);
            ++i4;
        }
        Guide fg = this.hGuides.get(offset + 1);
        for (ColumnCell cc : fg.getPrev()) {
            cc.setSouth(g);
        }
    }

    private Guide fillRowDetail(Guide north, Guide south, List<BaseColumn> cols) {
        for (BaseColumn bc : cols) {
            if (bc instanceof StandardColumnGroup) {
                this.fillRowDetail(north, south, ((StandardColumnGroup)bc).getColumns());
                continue;
            }
            ColumnCell cell = this.createCell(bc, 4, "");
            north.addSouth(cell);
            south.addNorth(cell);
            south.setY(north, (Cell)cell.cell);
        }
        return south;
    }

    private Guide fillRowTop(Guide north, Guide south, List<BaseColumn> cols, int type, String grName) {
        for (BaseColumn bc : cols) {
            ColumnCell cell = this.createCell(bc, type, grName);
            north.addSouth(cell);
            if (bc instanceof StandardColumnGroup) {
                Guide gn = this.addNext(north, this.hGuides);
                gn.addNorth(cell);
                gn.setY(north, (Cell)cell.cell);
                south.setY(Math.max(gn.getY(), south.getY()));
                this.fillRowTop(gn, south, ((StandardColumnGroup)bc).getColumns(), type, grName);
                continue;
            }
            south.addNorth(cell);
            south.setY(north, (Cell)cell.cell);
        }
        return south;
    }

    private void fillVertical(StandardTable table) {
        Guide west = new Guide(0);
        this.vGuides.add(west);
        Guide east = this.addNext(west, this.vGuides);
        this.fillVertical(west, east, table.getColumns());
    }

    private Guide fillVertical(Guide west, Guide east, List<BaseColumn> cols) {
        int i = 0;
        while (i < cols.size()) {
            BaseColumn bc = cols.get(i);
            if (bc instanceof StandardColumnGroup) {
                east = this.fillVertical(west, east, ((StandardColumnGroup)bc).getColumns());
            } else {
                east.setY(west.getY() + bc.getWidth());
                this.setVGuides(west, east, bc, 4, "");
            }
            this.setVGuides(west, east, bc, 0, "");
            this.setVGuides(west, east, bc, 2, "");
            this.setVGuides(west, east, bc, 3, "");
            this.setVGuides(west, east, bc, 1, "");
            if (this.groupsList != null) {
                for (JRGroup jrGroup : this.groupsList) {
                    this.setVGuides(west, east, bc, 5, jrGroup.getName());
                    this.setVGuides(west, east, bc, 6, jrGroup.getName());
                }
            }
            if (i < cols.size() - 1) {
                west = east;
                east = this.addNext(west, this.vGuides);
            }
            ++i;
        }
        return east;
    }

    public void setVGuides(Guide west, Guide east, BaseColumn bc, int type, String grName) {
        ColumnCell cc = this.getColumnCell(new ColumnCell(type, grName, bc));
        if (cc == null) {
            return;
        }
        west.addEast(cc);
        east.addWest(cc);
    }

    private Guide addNext(Guide north, List<Guide> guides) {
        Guide south = new Guide(north.getY());
        int i = guides.indexOf(north) + 1;
        if (i <= guides.size()) {
            guides.add(i, south);
        } else {
            guides.add(south);
        }
        return south;
    }

    private Guide addNextRow(Guide north) {
        RowGuide south = new RowGuide(north.getY());
        this.hGuides.add(south);
        return south;
    }

    public ColumnCell createCell(BaseColumn bc, int type, String grName) {
        ColumnCell cc = new ColumnCell(type, grName, bc);
        cc.setCell((DesignCell)TableUtil.getCell((BaseColumn)bc, (int)type, (String)grName));
        this.map.put(cc, null);
        return cc;
    }

    public void print() {
        System.out.println("-- NEW TABLE--------------------");
        int i = 0;
        while (i < this.hGuides.size()) {
            Guide g = this.hGuides.get(i);
            System.out.println("row:" + i + "\n" + g.toString());
            ++i;
        }
    }
}

