/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.action;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.editor.TableEditor;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.MPage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPart;

public class SelectAllCellsAction
extends ACachedSelectionAction {
    public static final String ID = "com.jaspersoft.studio.components.table.action.SelectAllCellsAction";

    public SelectAllCellsAction(IWorkbenchPart part) {
        super(part);
        this.setText(Messages.SelectAllCellsAction_1);
        this.setId(ID);
    }

    protected boolean calculateEnabled() {
        List tables = this.getSelectedObjects();
        for (Object obj : tables) {
            StandardTable jrTable;
            MTable table;
            if (obj instanceof EditPart) {
                obj = ((EditPart)obj).getModel();
            }
            if (obj instanceof MTable) {
                table = (MTable)((Object)obj);
                if (table == null) continue;
                jrTable = table.getStandardTable();
                if (!(table.getParent() instanceof MPage) || jrTable.getColumns().size() <= 0) continue;
                return true;
            }
            if (!(obj instanceof MColumn) && !(obj instanceof AMCollection) || (table = TableManager.getTableNode((ANode)obj)) == null) continue;
            jrTable = table.getStandardTable();
            if (!(table.getParent() instanceof MPage) || jrTable.getColumns().size() <= 0) continue;
            return true;
        }
        return false;
    }

    private StandardTable getTable() {
        List tables = this.getSelectedObjects();
        for (Object obj : tables) {
            if (obj instanceof EditPart) {
                obj = ((EditPart)obj).getModel();
            }
            if (obj instanceof MTable) {
                return ((MTable)((Object)obj)).getStandardTable();
            }
            if (obj instanceof MColumn) {
                return ((MColumn)((Object)obj)).getMTable().getStandardTable();
            }
            if (!(obj instanceof AMCollection)) continue;
            return ((AMCollection)((Object)obj)).getStandardTable();
        }
        return null;
    }

    public void run() {
        TableEditor part = (TableEditor)this.getWorkbenchPart();
        StandardTable tbl = this.getTable();
        List<Cell> tblels = SelectAllCellsAction.getTableCells(tbl);
        ArrayList<EditPart> parts = new ArrayList<EditPart>();
        Map map = part.getGraphicalViewer().getEditPartRegistry();
        for (Object obj : map.keySet()) {
            EditPart ep;
            if (!(obj instanceof MCell) || !tblels.contains(((MCell)((Object)obj)).getCell()) || (ep = (EditPart)map.get(obj)) == null) continue;
            parts.add(ep);
        }
        StructuredSelection s = new StructuredSelection(parts);
        part.getGraphicalViewer().setSelection((ISelection)s);
    }

    public static List<Cell> getTableCells(StandardTable table) {
        ArrayList<Cell> list2 = new ArrayList<Cell>();
        SelectAllCellsAction.getTableCell(table.getColumns(), list2);
        return list2;
    }

    public static void getTableCell(List<BaseColumn> cols, List<Cell> list2) {
        for (BaseColumn c : cols) {
            SelectAllCellsAction.getTableCell(c.getTableHeader(), list2);
            SelectAllCellsAction.getTableCell(c.getTableFooter(), list2);
            SelectAllCellsAction.getTableCell(c.getColumnHeader(), list2);
            SelectAllCellsAction.getTableCell(c.getColumnFooter(), list2);
            for (GroupCell gc : c.getGroupHeaders()) {
                if (gc == null) continue;
                SelectAllCellsAction.getTableCell(gc.getCell(), list2);
            }
            for (GroupCell gc : c.getGroupFooters()) {
                if (gc == null) continue;
                SelectAllCellsAction.getTableCell(gc.getCell(), list2);
            }
            if (c instanceof StandardColumn) {
                SelectAllCellsAction.getTableCell(((StandardColumn)c).getDetailCell(), list2);
            }
            if (!(c instanceof StandardColumnGroup)) continue;
            SelectAllCellsAction.getTableCell(((StandardColumnGroup)c).getColumns(), list2);
        }
    }

    public static void getTableCell(Cell cell, List<Cell> list2) {
        if (cell == null) {
            return;
        }
        list2.add(cell);
    }
}

