/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.decorator;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.editor.action.CustomSelectionAction;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MReport;
import com.jaspersoft.studio.property.SetValueCommand;
import java.util.List;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySource;

public class PdfActionTable
extends CustomSelectionAction {
    public static final String ID_DEFAULT = "net.sf.jasperreports.components.table.generate.pdf.tags.default";
    public static final String ID_ENABLED = "net.sf.jasperreports.components.table.generate.pdf.tags.enabled";
    public static final String ID_DISABLED = "net.sf.jasperreports.components.table.generate.pdf.tags.disabled";
    public static final String JR_PROPERTY = "net.sf.jasperreports.components.table.generate.pdf.tags";
    private TYPE status;

    public PdfActionTable(IWorkbenchPart part, TYPE status) {
        super(part, 2);
        this.status = status;
        this.initUI();
    }

    protected boolean calculateEnabled() {
        List graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MTable.class);
        if (graphicalElements.size() > 0) {
            return true;
        }
        graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MReport.class);
        return graphicalElements.size() > 0;
    }

    public boolean isChecked() {
        List graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(APropertyNode.class);
        boolean result = true;
        if (graphicalElements.isEmpty()) {
            return false;
        }
        for (Object element : graphicalElements) {
            APropertyNode model = (APropertyNode)element;
            JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue((Object)"PROPERTY_MAP");
            if (v == null) {
                return false;
            }
            String oldValue = v.getProperty(JR_PROPERTY);
            if (this.status.equals((Object)TYPE.DEFAULT)) {
                if (oldValue == null) continue;
                result = false;
                break;
            }
            if (oldValue != null) {
                if (this.status.equals((Object)TYPE.ENABLED)) {
                    if (Boolean.TRUE.toString().equalsIgnoreCase(oldValue.toString())) continue;
                    result = false;
                    break;
                }
                if (!this.status.equals((Object)TYPE.DISABLED) || Boolean.FALSE.toString().equalsIgnoreCase(oldValue.toString())) continue;
                result = false;
                break;
            }
            result = false;
            break;
        }
        return result;
    }

    protected void initUI() {
        this.setToolTipText(null);
        this.setImageDescriptor(null);
        this.setDisabledImageDescriptor(null);
        switch (this.status) {
            case DEFAULT: {
                this.setId(ID_DEFAULT);
                this.setText(Messages.PdfActionTable_defaultLabel);
                break;
            }
            case ENABLED: {
                this.setId(ID_ENABLED);
                this.setText(Messages.PdfActionTable_enabledLabel);
                break;
            }
            case DISABLED: {
                this.setId(ID_DISABLED);
                this.setText(Messages.PdfActionTable_disabledLabel);
            }
        }
    }

    public Command createCommand(APropertyNode model) {
        SetValueCommand cmd = new SetValueCommand();
        cmd.setTarget((IPropertySource)model);
        cmd.setPropertyId((Object)"PROPERTY_MAP");
        JRPropertiesMap v = (JRPropertiesMap)model.getPropertyValue((Object)"PROPERTY_MAP");
        if (v == null) {
            v = new JRPropertiesMap();
        }
        switch (this.status) {
            case DEFAULT: {
                v.removeProperty(JR_PROPERTY);
                break;
            }
            case ENABLED: {
                v.setProperty(JR_PROPERTY, Boolean.TRUE.toString());
                break;
            }
            case DISABLED: {
                v.setProperty(JR_PROPERTY, Boolean.FALSE.toString());
            }
        }
        cmd.setPropertyValue((Object)v);
        return cmd;
    }

    protected Command createCommand() {
        MGraphicElement grModel;
        List graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MTable.class);
        JSSCompoundCommand command = new JSSCompoundCommand(this.getText(), null);
        for (Object element : graphicalElements) {
            grModel = (MGraphicElement)element;
            command.setReferenceNodeIfNull((ANode)grModel);
            command.add(this.createCommand((APropertyNode)grModel));
        }
        graphicalElements = this.editor.getSelectionCache().getSelectionModelForType(MReport.class);
        for (Object element : graphicalElements) {
            grModel = (MReport)element;
            command.setReferenceNodeIfNull((ANode)grModel);
            command.add(this.createCommand((APropertyNode)grModel));
        }
        return command;
    }

    public void run() {
        this.execute(this.createCommand());
    }

    public String getText() {
        if (this.status.equals((Object)TYPE.DEFAULT)) {
            List nodes = this.editor.getSelectionCache().getSelectionModelForType(MTable.class);
            for (Object node : nodes) {
                APropertyNode aNode = (APropertyNode)node;
                JasperDesign jd = aNode.getJasperDesign();
                if (jd == null || jd.getPropertiesMap() == null) continue;
                String value = jd.getPropertiesMap().getProperty(JR_PROPERTY);
                if (value == null) break;
                if (Boolean.TRUE.toString().equalsIgnoreCase(value.toString())) {
                    return String.valueOf(super.getText()) + " " + Messages.PdfActionTable_enableInheritLabel;
                }
                return String.valueOf(super.getText()) + " " + Messages.PdfActionTable_disableInheritLabel;
            }
        }
        return super.getText();
    }

    public static enum TYPE {
        ENABLED,
        DISABLED,
        DEFAULT;

    }
}

