/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.components.table.util.TableColumnSize;
import com.jaspersoft.studio.model.ANode;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.gef.commands.Command;

public class CreateColumnFromGroupCommand
extends Command {
    private StandardBaseColumn jrColumn;
    protected StandardColumnGroup jrGroup;
    protected StandardTable jrTable;
    protected JasperDesign jrDesign;
    private int index;

    public CreateColumnFromGroupCommand(MColumnGroup destNode, MColumn srcNode, int index) {
        this.jrGroup = destNode.getValue();
        this.index = index;
        this.jrColumn = srcNode.getValue();
        this.jrTable = TableManager.getTable((ANode)destNode.getMTable());
        this.jrDesign = destNode.getJasperDesign();
    }

    public CreateColumnFromGroupCommand(MColumnGroupCell destNode, MColumn srcNode, int index) {
        this.jrGroup = (StandardColumnGroup)destNode.getValue();
        this.index = index;
        this.jrColumn = srcNode.getValue();
        this.jrTable = TableManager.getTable((ANode)destNode.getMTable());
        this.jrDesign = destNode.getJasperDesign();
    }

    protected StandardBaseColumn createColumn() {
        List groupsList;
        boolean createTHeader = true;
        boolean createTFooter = true;
        boolean createCHeader = true;
        boolean createCFooter = true;
        boolean createGHeader = false;
        boolean createGFooter = false;
        List columns = TableUtil.getAllColumns((TableComponent)this.jrTable);
        BaseColumn sibling = null;
        if (columns.size() > 0) {
            sibling = this.index >= columns.size() ? (BaseColumn)columns.get(columns.size() - 1) : (this.index <= 0 ? (BaseColumn)columns.get(columns.size() - 1) : (BaseColumn)columns.get(this.index));
        }
        if (sibling != null) {
            createTHeader = sibling.getTableHeader() != null;
            createTFooter = sibling.getTableFooter() != null;
            createCHeader = sibling.getColumnHeader() != null;
            boolean bl = createCFooter = sibling.getColumnFooter() != null;
            if (sibling.getGroupHeaders().size() > 0) {
                boolean bl2 = createGHeader = sibling.getGroupHeaders().get(0) != null;
            }
            if (sibling.getGroupFooters().size() > 0) {
                createGFooter = sibling.getGroupFooters().get(0) != null;
            }
        }
        StandardColumn col = new StandardColumn();
        col.setWidth(Integer.valueOf(40));
        DesignCell cell = null;
        if (createTHeader) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitGroupHeight(this.jrTable, this.jrGroup, 0, null)));
            col.setTableHeader((Cell)cell);
            if (sibling != null && sibling.getTableHeader() != null) {
                cell.setStyle(sibling.getTableHeader().getStyle());
            }
        }
        if (createTFooter) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitGroupHeight(this.jrTable, this.jrGroup, 1, null)));
            col.setTableFooter((Cell)cell);
            if (sibling != null && sibling.getTableFooter() != null) {
                cell.setStyle(sibling.getTableFooter().getStyle());
            }
        }
        if (createCHeader) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitGroupHeight(this.jrTable, this.jrGroup, 2, null)));
            col.setColumnHeader((Cell)cell);
            if (sibling != null && sibling.getColumnHeader() != null) {
                cell.setStyle(sibling.getColumnHeader().getStyle());
            }
        }
        if (createCFooter) {
            cell = new DesignCell();
            cell.setHeight(Integer.valueOf(TableColumnSize.getInitGroupHeight(this.jrTable, this.jrGroup, 3, null)));
            col.setColumnFooter((Cell)cell);
            if (sibling != null && sibling.getColumnFooter() != null) {
                cell.setStyle(sibling.getColumnFooter().getStyle());
            }
        }
        cell = new DesignCell();
        cell.setHeight(Integer.valueOf(TableColumnSize.getInitGroupHeight(this.jrTable, this.jrGroup, 4, null)));
        col.setDetailCell((Cell)cell);
        if (sibling != null && sibling instanceof StandardBaseColumn) {
            StandardColumn siblingStandardCol = (StandardColumn)sibling;
            cell.setStyle(siblingStandardCol.getDetailCell().getStyle());
        }
        if ((groupsList = TableUtil.getGroupList((TableComponent)this.jrTable, (JRReport)this.jrDesign)) != null) {
            for (JRDesignGroup jrDesignGroup : groupsList) {
                Cell siblingGroupCell;
                if (createGHeader) {
                    cell = new DesignCell();
                    cell.setHeight(Integer.valueOf(TableColumnSize.getInitGroupHeight(this.jrTable, this.jrGroup, 5, jrDesignGroup.getName())));
                    col.setGroupHeader(jrDesignGroup.getName(), (Cell)cell);
                    siblingGroupCell = sibling.getGroupHeader(jrDesignGroup.getName());
                    if (siblingGroupCell != null) {
                        cell.setStyle(siblingGroupCell.getStyle());
                    }
                }
                if (!createGFooter) continue;
                cell = new DesignCell();
                cell.setHeight(Integer.valueOf(TableColumnSize.getInitGroupHeight(this.jrTable, this.jrGroup, 6, jrDesignGroup.getName())));
                col.setGroupFooter(jrDesignGroup.getName(), (Cell)cell);
                siblingGroupCell = sibling.getGroupFooter(jrDesignGroup.getName());
                if (siblingGroupCell == null) continue;
                cell.setStyle(siblingGroupCell.getStyle());
            }
        }
        return col;
    }

    public void execute() {
        if (this.jrColumn == null) {
            this.jrColumn = this.createColumn();
        }
        if (this.index >= 0 && this.index < this.jrGroup.getColumns().size()) {
            this.jrGroup.addColumn(this.index, (BaseColumn)this.jrColumn);
        } else {
            this.jrGroup.addColumn((BaseColumn)this.jrColumn);
        }
        TableColumnSize.setGroupWidth2Top(this.jrTable.getColumns(), this.jrGroup, this.jrColumn.getWidth());
    }

    public boolean canUndo() {
        return true;
    }

    public void undo() {
        this.index = this.jrGroup.getColumns().indexOf(this.jrColumn);
        this.jrGroup.removeColumn((BaseColumn)this.jrColumn);
        TableColumnSize.setGroupWidth2Top(this.jrTable.getColumns(), this.jrGroup, -this.jrColumn.getWidth().intValue());
    }
}

