/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.MTableColumnFooter;
import com.jaspersoft.studio.components.table.model.MTableColumnHeader;
import com.jaspersoft.studio.components.table.model.MTableFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupHeader;
import com.jaspersoft.studio.components.table.model.MTableHeader;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.components.table.model.column.command.AddCellDeltaHeightCommand;
import com.jaspersoft.studio.components.table.model.column.command.FixCellHeightsCommand;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.List;
import net.sf.jasperreports.components.table.Cell;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardBaseColumn;

public class DeleteColumnGroupCellCommand
extends JSSCompoundCommand {
    private StandardBaseColumn jrColumn;
    private Class<?> type;
    private String groupName;
    private Cell jrCell;
    private MTable tableNode;

    public DeleteColumnGroupCellCommand(ANode parent, MColumnGroupCell srcNode) {
        super(parent);
        this.type = parent instanceof MColumnGroup ? ((Object)((Object)((MColumnGroup)parent).getSection())).getClass() : (parent instanceof MColumnGroupCell ? ((Object)((Object)((MColumnGroupCell)parent).getSection())).getClass() : parent.getClass());
        if (parent instanceof MTableGroupHeader) {
            this.groupName = ((MTableGroupHeader)parent).getJrDesignGroup().getName();
        }
        if (parent instanceof MTableGroupFooter) {
            this.groupName = ((MTableGroupFooter)parent).getJrDesignGroup().getName();
        }
        this.jrColumn = srcNode.getValue();
        this.tableNode = srcNode.getMTable();
        if (this.otherGroupCellOnLevel(srcNode.getParent(), srcNode)) {
            this.setCellHeightDelta(srcNode.getChildren(), -srcNode.getCell().getHeight().intValue());
        } else {
            this.setCellHeightDelta(this.getRow((ANode)srcNode).getChildren(), -srcNode.getCell().getHeight().intValue());
        }
        this.add(new FixCellHeightsCommand(srcNode));
    }

    public void execute() {
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            this.jrCell = this.jrColumn.getTableHeader();
            this.jrColumn.setTableHeader(null);
        } else if (this.type.isAssignableFrom(MTableFooter.class)) {
            this.jrCell = this.jrColumn.getTableFooter();
            this.jrColumn.setTableFooter(null);
        } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            this.jrCell = this.jrColumn.getColumnHeader();
            this.jrColumn.setColumnHeader(null);
        } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            this.jrCell = this.jrColumn.getColumnFooter();
            this.jrColumn.setColumnFooter(null);
        } else if (this.type.isAssignableFrom(MTableGroupHeader.class)) {
            this.jrCell = this.jrColumn.getGroupHeader(this.groupName);
            this.jrColumn.setGroupHeader(this.groupName, null);
        } else if (this.type.isAssignableFrom(MTableGroupFooter.class)) {
            this.jrCell = this.jrColumn.getGroupFooter(this.groupName);
            this.jrColumn.setGroupFooter(this.groupName, null);
        }
        super.execute();
        this.tableNode.getTableManager().updateTableSpans();
    }

    protected Cell createCell() {
        DesignCell cell = new DesignCell();
        cell.setHeight(Integer.valueOf(10));
        return cell;
    }

    private ANode getRow(ANode cell) {
        ANode parent = cell.getParent();
        if (parent instanceof MTable) {
            return cell;
        }
        return this.getRow(parent);
    }

    private boolean otherGroupCellOnLevel(ANode parent, MColumnGroupCell srcNode) {
        for (INode child : parent.getChildren()) {
            if (child == srcNode || !(child instanceof MColumnGroupCell)) continue;
            return true;
        }
        return false;
    }

    private void setCellHeightDelta(List<INode> children, int newHeightDelta) {
        for (INode child : children) {
            if (child.getClass().equals(MCell.class)) {
                this.add(new AddCellDeltaHeightCommand((Cell)((MCell)child).getCell(), newHeightDelta));
            }
            this.setCellHeightDelta(child.getChildren(), newHeightDelta);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public void redo() {
        this.execute();
    }

    public void undo() {
        if (this.type.isAssignableFrom(MTableHeader.class)) {
            this.jrColumn.setTableHeader(this.jrCell);
        } else if (this.type.isAssignableFrom(MTableFooter.class)) {
            this.jrColumn.setTableFooter(this.jrCell);
        } else if (this.type.isAssignableFrom(MTableColumnHeader.class)) {
            this.jrColumn.setColumnHeader(this.jrCell);
        } else if (this.type.isAssignableFrom(MTableColumnFooter.class)) {
            this.jrColumn.setColumnFooter(this.jrCell);
        } else if (this.type.isAssignableFrom(MTableGroupHeader.class)) {
            this.jrColumn.setGroupHeader(this.groupName, this.jrCell);
        } else if (this.type.isAssignableFrom(MTableGroupFooter.class)) {
            this.jrColumn.setGroupFooter(this.groupName, this.jrCell);
        }
        super.undo();
        this.tableNode.getTableManager().updateTableSpans();
    }
}

