/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.column.command;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.model.ANode;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardTable;
import org.eclipse.gef.commands.Command;

public class ReorderColumnCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private StandardBaseColumn jrColumn;
    private StandardTable jrTable;

    public ReorderColumnCommand(MColumn child, MTable parent, int newIndex) {
        super(Messages.ReorderColumnCommand_reorder_columns);
        this.newIndex = Math.max(0, newIndex);
        this.jrTable = TableManager.getTable((ANode)parent);
        this.jrColumn = child.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrTable.getColumns().indexOf(this.jrColumn);
        this.jrTable.removeColumn((BaseColumn)this.jrColumn);
        if (this.newIndex >= 0 && this.newIndex < this.jrTable.getColumns().size()) {
            this.jrTable.addColumn(this.newIndex, (BaseColumn)this.jrColumn);
        } else {
            this.jrTable.addColumn((BaseColumn)this.jrColumn);
        }
    }

    public void undo() {
        this.jrTable.removeColumn((BaseColumn)this.jrColumn);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrTable.getColumns().size()) {
            this.jrTable.addColumn(this.oldIndex, (BaseColumn)this.jrColumn);
        } else {
            this.jrTable.addColumn((BaseColumn)this.jrColumn);
        }
    }
}

