/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.columngroup.action;

import com.jaspersoft.studio.components.Activator;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.MTableDetail;
import com.jaspersoft.studio.components.table.model.column.MCell;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.CheckColumnsOrder;
import com.jaspersoft.studio.components.table.model.column.command.CreateColumnGroupCellCommand;
import com.jaspersoft.studio.components.table.model.column.command.FixCellHeightsCommand;
import com.jaspersoft.studio.components.table.model.column.command.MoveColumnCommand;
import com.jaspersoft.studio.components.table.model.column.command.RefreshColumnNamesCommand;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.command.CreateColumnGroupCommand;
import com.jaspersoft.studio.components.table.part.editpolicy.JSSCompoundTableCommand;
import com.jaspersoft.studio.editor.action.ACachedSelectionAction;
import com.jaspersoft.studio.model.ANode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.ui.IWorkbenchPart;

public class GroupColumnsAction
extends ACachedSelectionAction {
    public static final String ID = "create_table_column_group";

    public GroupColumnsAction(IWorkbenchPart part) {
        super(part);
    }

    protected void init() {
        super.init();
        this.setText(Messages.CreateColumnAction_create_column_group);
        this.setToolTipText(Messages.CreateColumnAction_create_column_group_tool_tip);
        this.setId(ID);
        this.setImageDescriptor(Activator.getDefault().getImageDescriptor("icons/table-join-row.png"));
        this.setDisabledImageDescriptor(Activator.getDefault().getImageDescriptor("icons/table-join-row.png"));
        this.setEnabled(false);
    }

    private List<MColumn> getSelectedColumns() {
        ArrayList<MColumn> columns = new ArrayList<MColumn>();
        List objects = this.getSelectedObjects();
        ANode currentParent = null;
        for (Object obj : objects) {
            MColumn col;
            if (obj instanceof EditPart) {
                obj = ((EditPart)obj).getModel();
            }
            if (!(obj instanceof MCell) && !(obj instanceof MColumnGroup) || this.isTableDetail(col = (MColumn)((Object)obj))) continue;
            if (currentParent != null) {
                if (currentParent != col.getParent()) {
                    return null;
                }
            } else {
                currentParent = col.getParent();
            }
            columns.add(col);
        }
        if (currentParent != null && columns.size() > 1) {
            int[] indexes = new int[columns.size()];
            int i = 0;
            for (MColumn col : columns) {
                indexes[i] = currentParent.getChildren().indexOf((Object)col);
                ++i;
            }
            Arrays.sort(indexes);
            i = 0;
            while (i < indexes.length - 1) {
                if (indexes[i] + 1 != indexes[i + 1]) {
                    return null;
                }
                ++i;
            }
        }
        return columns;
    }

    private boolean isTableDetail(MColumn column) {
        if (column == null) {
            return true;
        }
        ANode parent = column.getParent();
        while (parent != null && !(parent instanceof AMCollection)) {
            parent = parent.getParent();
        }
        return parent == null || parent instanceof MTableDetail;
    }

    public Command createCommand() {
        List<MColumn> columns = this.getSelectedColumns();
        MColumn fmc = columns.get(0);
        ANode mparent = fmc.getParent();
        if (mparent == null) {
            return null;
        }
        JSSCompoundTableCommand c = new JSSCompoundTableCommand(Messages.CreateColumnAction_create_column_group, fmc.getMTable(), true);
        MColumnGroup mcolgr = new MColumnGroup();
        int index = mparent.getChildren().indexOf((Object)fmc);
        CreateColumnGroupCommand cmd = this.createGroup(index, mparent, mcolgr);
        MTable table = fmc.getMTable();
        StandardColumnGroup newGroup = (StandardColumnGroup)cmd.createColumn(fmc.getJasperDesign(), table.getStandardTable(), table.getPropertiesMap());
        mcolgr.setValue(newGroup);
        c.add(new RefreshColumnNamesCommand(mparent, false, true));
        ArrayList<CheckColumnsOrder> fixOrderCommandList = new ArrayList<CheckColumnsOrder>();
        for (MColumn src : columns) {
            fixOrderCommandList.add(new CheckColumnsOrder(src));
        }
        Collections.sort(fixOrderCommandList);
        Collections.reverse(fixOrderCommandList);
        c.addAll(fixOrderCommandList);
        c.add(this.createGroup(index, mparent, mcolgr));
        for (MColumn src : columns) {
            c.add(new MoveColumnCommand(src, mcolgr, false));
        }
        c.add(new FixCellHeightsCommand(fmc));
        c.add(new RefreshColumnNamesCommand(mparent, true, false));
        c.add((Command)new CreateColumnGroupCellCommand(fmc.getSection(), mparent, newGroup));
        return c;
    }

    protected boolean calculateEnabled() {
        List<MColumn> columns = this.getSelectedColumns();
        if (columns == null || columns.isEmpty()) {
            return false;
        }
        MTable table = columns.get(0).getMTable();
        if (table != null) {
            return table.getStandardTable().getColumns().size() > 0;
        }
        return false;
    }

    public CreateColumnGroupCommand createGroup(int index, ANode mparent, MColumnGroup mcolgr) {
        CreateColumnGroupCommand cmd = null;
        if (mparent instanceof MColumn) {
            cmd = new CreateColumnGroupCommand((MColumn)mparent, mcolgr, index);
        }
        if (mparent instanceof AMCollection) {
            cmd = new CreateColumnGroupCommand((AMCollection)mparent, mcolgr, index);
        }
        cmd.setResize(false);
        return cmd;
    }
}

