/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.columngroup.command;

import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import org.eclipse.gef.commands.Command;

public class ReorderColumnGroupCommand
extends Command {
    private int oldIndex;
    private int newIndex;
    private StandardBaseColumn jrColumn;
    private StandardColumnGroup jrGroup;

    public ReorderColumnGroupCommand(MColumn child, MColumnGroup parent, int newIndex) {
        super(Messages.ReorderColumnGroupCommand_reorder_column_group);
        this.newIndex = Math.max(0, newIndex);
        this.jrGroup = parent.getValue();
        this.jrColumn = child.getValue();
    }

    public ReorderColumnGroupCommand(MColumn child, MColumnGroupCell parent, int newIndex) {
        super(Messages.ReorderColumnGroupCommand_reorder_column_group);
        this.newIndex = newIndex;
        this.jrGroup = (StandardColumnGroup)parent.getValue();
        this.jrColumn = child.getValue();
    }

    public void execute() {
        this.oldIndex = this.jrGroup.getColumns().indexOf(this.jrColumn);
        this.jrGroup.removeColumn((BaseColumn)this.jrColumn);
        if (this.newIndex >= 0 && this.newIndex < this.jrGroup.getColumns().size()) {
            this.jrGroup.addColumn(this.newIndex, (BaseColumn)this.jrColumn);
        } else {
            this.jrGroup.addColumn((BaseColumn)this.jrColumn);
        }
    }

    public void undo() {
        this.jrGroup.removeColumn((BaseColumn)this.jrColumn);
        if (this.oldIndex >= 0 && this.oldIndex < this.jrGroup.getColumns().size()) {
            this.jrGroup.addColumn(this.oldIndex, (BaseColumn)this.jrColumn);
        } else {
            this.jrGroup.addColumn((BaseColumn)this.jrColumn);
        }
    }
}

