/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.nodata;

import com.jaspersoft.studio.components.crosstab.model.cell.MCell;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.editor.layout.FreeLayout;
import com.jaspersoft.studio.editor.layout.ILayout;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.outline.part.TreeEditPart;
import com.jaspersoft.studio.help.HelpReferenceBuilder;
import com.jaspersoft.studio.help.IHelpRefBuilder;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.APropertyNode;
import com.jaspersoft.studio.model.DefaultValue;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.IContainerEditPart;
import com.jaspersoft.studio.model.IContainerLayout;
import com.jaspersoft.studio.model.IGraphicElement;
import com.jaspersoft.studio.model.IGraphicElementContainer;
import com.jaspersoft.studio.model.IGraphicalPropertiesHandler;
import com.jaspersoft.studio.model.IGroupElement;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.IPastable;
import com.jaspersoft.studio.model.IPastableGraphic;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptor.combo.RWStyleComboBoxPropertyDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.JPropertyExpressionsDescriptor;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionDTO;
import com.jaspersoft.studio.property.descriptor.propexpr.PropertyExpressionsDTO;
import com.jaspersoft.studio.property.descriptors.PixelPropertyDescriptor;
import com.jaspersoft.studio.utils.ModelUtils;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.DesignBaseCell;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class MTableNoData
extends APropertyNode
implements IGraphicElement,
IPastableGraphic,
IGraphicElementContainer,
IPastable,
IGroupElement,
IGraphicalPropertiesHandler,
IContainer,
IContainerLayout,
IContainerEditPart {
    public static final long serialVersionUID = 10200L;
    private static IPropertyDescriptor[] descriptors;
    private transient PropertyChangeListener tbListener;
    private MTable containerTable;
    private boolean visualPropertyChanged = true;
    private static HashSet<String> cachedGraphicalProperties;

    static {
        cachedGraphicalProperties = null;
    }

    public MTableNoData() {
    }

    public MTableNoData(ANode parent, DesignBaseCell cell, int index) {
        super(parent, index);
        this.setValue(cell);
    }

    private PropertyChangeListener getTableListener() {
        if (this.tbListener == null) {
            this.tbListener = evt -> {
                if (evt.getPropertyName().equals("noData")) {
                    this.setValue(evt.getNewValue());
                }
            };
        }
        return this.tbListener;
    }

    public void setParent(ANode newparent, int newIndex) {
        super.setParent(newparent, newIndex);
        if (this.containerTable != null) {
            this.containerTable.getStandardTable().getEventSupport().removePropertyChangeListener(this.getTableListener());
        }
        ANode node = this.getParent();
        while (node != null) {
            if (node instanceof MTable) {
                this.containerTable = (MTable)node;
                this.containerTable.getStandardTable().getEventSupport().addPropertyChangeListener(this.getTableListener());
                break;
            }
            node = node.getParent();
        }
        if (newparent == null && this.getValue() != null) {
            this.getValue().getEventSupport().removePropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void setValue(Object value) {
        super.setValue(value);
        EditPart fep = this.getFigureEditPart();
        if (fep != null) {
            fep.refresh();
        }
    }

    public EditPart getFigureEditPart() {
        PropertyChangeListener[] propertyChangeListenerArray = this.getPropertyChangeSupport().getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener o = propertyChangeListenerArray[n2];
            if (o instanceof TreeEditPart) {
                return (EditPart)o;
            }
            ++n2;
        }
        return null;
    }

    public DesignBaseCell getValue() {
        return (DesignBaseCell)super.getValue();
    }

    public MTable getMTable() {
        return this.containerTable;
    }

    public ILayout getDefaultLayout() {
        return LayoutManager.getLayout((String)FreeLayout.class.getName());
    }

    public String getDisplayText() {
        return "No Data";
    }

    public ImageDescriptor getImagePath() {
        return MTableNoData.getIconDescriptor().getIcon16();
    }

    public IPropertyDescriptor[] getDescriptors() {
        return descriptors;
    }

    public void setDescriptors(IPropertyDescriptor[] descriptors1) {
        descriptors = descriptors1;
    }

    public void createPropertyDescriptors(List<IPropertyDescriptor> desc) {
        RWStyleComboBoxPropertyDescriptor styleD = new RWStyleComboBoxPropertyDescriptor((Object)"style", Messages.MCell_parent_style, new String[]{""}, NullEnum.NULL);
        styleD.setDescription(Messages.MCell_parent_style_description);
        desc.add((IPropertyDescriptor)styleD);
        styleD.setHelpRefBuilder((IHelpRefBuilder)new HelpReferenceBuilder("net.sf.jasperreports.doc/docs/schema.reference.html?cp=0_1#reportElement_style"));
        PixelPropertyDescriptor hD = new PixelPropertyDescriptor((Object)"height", Messages.MCell_height);
        desc.add((IPropertyDescriptor)hD);
        JPropertyExpressionsDescriptor propertiesD = new JPropertyExpressionsDescriptor((Object)"propertyExpressions", com.jaspersoft.studio.messages.Messages.MGraphicElement_property_expressions);
        propertiesD.setDescription(com.jaspersoft.studio.messages.Messages.MGraphicElement_property_expressions_description);
        desc.add((IPropertyDescriptor)propertiesD);
        styleD.setCategory(Messages.MCell_cell_properties_category);
        hD.setCategory(Messages.MCell_cell_properties_category);
    }

    protected Map<String, DefaultValue> createDefaultsMap() {
        Map defaultsMap = super.createDefaultsMap();
        defaultsMap.put("style", new DefaultValue(null, false));
        return defaultsMap;
    }

    public Object getPropertyValue(Object id) {
        DesignBaseCell cell = this.getValue();
        if (cell != null) {
            if (id.equals("style")) {
                if (cell.getStyleNameReference() != null) {
                    return cell.getStyleNameReference();
                }
                JRStyle actualStyle = this.getActualStyle();
                return actualStyle != null ? actualStyle.getName() : "";
            }
            if (id.equals("height")) {
                return cell.getHeight();
            }
            if (id.equals("propertyExpressions")) {
                JRPropertiesMap propertiesMap = cell.getPropertiesMap();
                if (propertiesMap != null) {
                    propertiesMap = propertiesMap.cloneProperties();
                }
                return new PropertyExpressionsDTO(null, propertiesMap, (Object)this.getValue(), ModelUtils.getExpressionContext((ANode)this));
            }
            if (id.equals("PROPERTY_MAP")) {
                return this.getPropertiesMapClone();
            }
        }
        return null;
    }

    protected JRPropertiesMap getPropertiesMapClone() {
        JRPropertiesMap propertiesMap = null;
        DesignBaseCell cell = this.getValue();
        if (cell != null && (propertiesMap = cell.getPropertiesMap()) != null) {
            propertiesMap = propertiesMap.cloneProperties();
        }
        return propertiesMap;
    }

    public void setPropertyValue(Object id, Object value) {
        DesignBaseCell cell = this.getValue();
        if (cell != null) {
            if (id.equals("style")) {
                if (value != null && !((String)value).trim().isEmpty()) {
                    if (!value.equals("")) {
                        JRStyle style = (JRStyle)this.getJasperDesign().getStylesMap().get(value);
                        if (style != null) {
                            cell.setStyleNameReference(null);
                            cell.setStyle(style);
                        } else {
                            cell.setStyleNameReference((String)value);
                            cell.setStyle(null);
                        }
                    }
                } else {
                    cell.setStyleNameReference(null);
                    cell.setStyle(null);
                }
            } else if (id.equals("height")) {
                cell.setHeight((Integer)value);
            } else if (id.equals("PROPERTY_MAP")) {
                JRPropertiesMap originalMap = cell.getPropertiesMap().cloneProperties();
                JRPropertiesMap v = (JRPropertiesMap)value;
                String[] names = cell.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    cell.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                names = v.getPropertyNames();
                i = 0;
                while (i < names.length) {
                    cell.getPropertiesMap().setProperty(names[i], v.getProperty(names[i]));
                    ++i;
                }
                this.getPropertyChangeSupport().firePropertyChange(new PropertyChangeEvent(cell, "PROPERTY_MAP", originalMap, cell.getPropertiesMap()));
            } else if (id.equals("propertyExpressions") && value instanceof PropertyExpressionsDTO) {
                PropertyExpressionsDTO dto = (PropertyExpressionsDTO)value;
                String[] names = cell.getPropertiesMap().getPropertyNames();
                int i = 0;
                while (i < names.length) {
                    cell.getPropertiesMap().removeProperty(names[i]);
                    ++i;
                }
                for (PropertyExpressionDTO p : dto.getProperties()) {
                    if (p.isExpression()) continue;
                    cell.getPropertiesMap().setProperty(p.getName(), p.getValue());
                }
                this.getPropertyChangeSupport().firePropertyChange("PROPERTY_MAP", false, true);
            }
        }
    }

    public int getDefaultWidth() {
        return 40;
    }

    public int getDefaultHeight() {
        return 40;
    }

    public JRDesignElement createJRElement(JasperDesign jasperDesign) {
        return null;
    }

    public Color getForeground() {
        if (this.getValue() == null) {
            return UIUtils.getSystemColor((int)39);
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        HashSet<String> graphicalProperties = this.getGraphicalProperties();
        if (graphicalProperties.contains(evt.getPropertyName())) {
            this.setChangedProperty(true);
        }
        super.propertyChange(evt);
    }

    public JRBoxContainer getBoxContainer() {
        return this.getValue();
    }

    public Integer getTopPadding() {
        DesignBaseCell v = this.getValue();
        if (v == null) {
            return 0;
        }
        return v.getLineBox().getTopPadding();
    }

    public Integer getLeftPadding() {
        DesignBaseCell v = this.getValue();
        if (v == null) {
            return 0;
        }
        return v.getLineBox().getLeftPadding();
    }

    public Integer getBottomPadding() {
        DesignBaseCell v = this.getValue();
        if (v == null) {
            return 0;
        }
        return v.getLineBox().getBottomPadding();
    }

    public Integer getRightPadding() {
        DesignBaseCell v = this.getValue();
        if (v == null) {
            return 0;
        }
        return v.getLineBox().getRightPadding();
    }

    public Integer getPadding() {
        DesignBaseCell v = this.getValue();
        if (v == null) {
            return 0;
        }
        return v.getLineBox().getPadding();
    }

    protected int getTableWidth() {
        ANode parent = this.getParent();
        while (parent != null) {
            if (parent instanceof MTable) {
                return ((MTable)parent).getValue().getWidth();
            }
            parent = parent.getParent();
        }
        return 100;
    }

    public Dimension getSize() {
        DesignBaseCell cell = this.getValue();
        int h = cell != null && cell.getHeight() != null ? cell.getHeight() : 0;
        return new Dimension(this.getTableWidth(), h);
    }

    public JRElementGroup getJRElementGroup() {
        return this.getValue();
    }

    public JRPropertiesHolder[] getPropertyHolder() {
        return new JRPropertiesHolder[]{this.getValue()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasChangedProperty() {
        MTableNoData mTableNoData = this;
        synchronized (mTableNoData) {
            return this.visualPropertyChanged;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setChangedProperty(boolean value) {
        MTableNoData mTableNoData = this;
        synchronized (mTableNoData) {
            if (value) {
                ANode parent = this.getParent();
                while (parent != null) {
                    if (parent instanceof IGraphicalPropertiesHandler) {
                        IGraphicalPropertiesHandler handler = (IGraphicalPropertiesHandler)parent;
                        handler.setChangedProperty(true);
                        break;
                    }
                    parent = parent.getParent();
                }
            }
            this.visualPropertyChanged = value;
        }
    }

    public void setStyleChangedProperty() {
        HashSet<ANode> refreshedParents = new HashSet<ANode>();
        PropertyChangeListener[] propertyChangeListenerArray = this.getValue().getEventSupport().getPropertyChangeListeners();
        int n = propertyChangeListenerArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyChangeListener listener = propertyChangeListenerArray[n2];
            if (listener instanceof MCell) {
                ANode tableParent;
                MCell listenerCell = (MCell)((Object)listener);
                MTable table = this.getMTable();
                if (table != null && (tableParent = table.getParent()) != null && !refreshedParents.contains(tableParent)) {
                    refreshedParents.add(tableParent);
                    listenerCell.setChangedProperty(true);
                }
            }
            ++n2;
        }
    }

    public HashSet<String> getGraphicalProperties() {
        if (cachedGraphicalProperties == null) {
            cachedGraphicalProperties = new HashSet();
            cachedGraphicalProperties.add("style");
            cachedGraphicalProperties.add("height");
        }
        return cachedGraphicalProperties;
    }

    public Map<String, List<ANode>> getUsedStyles() {
        Map result = super.getUsedStyles();
        DesignBaseCell cell = this.getValue();
        if (cell != null) {
            this.addElementStyle(cell.getStyle(), result);
        }
        for (INode node : this.getChildren()) {
            if (!(node instanceof ANode)) continue;
            this.mergeElementStyle(result, ((ANode)node).getUsedStyles());
        }
        return result;
    }

    public void setStyle(JRStyle style) {
        DesignBaseCell cell = this.getValue();
        if (cell != null) {
            cell.setStyle(style);
        }
    }

    public JRStyle getActualStyle() {
        DesignBaseCell cell = this.getValue();
        if (cell != null) {
            if (cell.getStyle() != null && !this.getJasperDesign().getStylesMap().containsKey(cell.getStyle().getName())) {
                this.setPropertyValue("style", null);
            }
            if (cell.getStyle() != null) {
                return cell.getStyle();
            }
        }
        return null;
    }

    public HashMap<String, Object> getStylesDescriptors() {
        HashMap result = super.getStylesDescriptors();
        if (this.getValue() == null) {
            return result;
        }
        return result;
    }

    public Rectangle getAbsoluteBounds() {
        Rectangle b = this.getBounds();
        return new Rectangle(b.x, b.y + 40, b.width, b.height);
    }

    public Rectangle getBounds() {
        MTable tableModel = this.getMTable();
        DesignBaseCell cell = this.getValue();
        int h = cell != null && cell.getHeight() != null ? cell.getHeight() + 30 : 0;
        Rectangle tableLocation = tableModel.getAbsoluteBounds();
        int x = 0;
        int y = tableLocation.height + tableLocation.y;
        return new Rectangle(x, y + 30, tableModel.getValue().getWidth(), h);
    }

    public boolean isEditable() {
        return this.getValue() != null;
    }
}

