/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.table.command;

import com.jaspersoft.studio.components.table.TableComponentFactory;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.MTableDetail;
import com.jaspersoft.studio.components.table.model.MTableGroupFooter;
import com.jaspersoft.studio.components.table.model.MTableGroupHeader;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.GroupCell;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.TableComponent;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import org.eclipse.gef.commands.Command;

public class SwitchDatasetCommand
extends Command {
    private MTable table;
    private List<GroupCell> headerCell;
    private List<GroupCell> footerCell;
    private StandardColumnGroup oldGroup;
    private String newDatasetName;
    private String oldDatasetName;

    public SwitchDatasetCommand(MTable table, String datasetName) {
        this.table = table;
        this.newDatasetName = datasetName;
    }

    private void reloadAvailableGroups() {
        MTableDetail detailNode = null;
        ArrayList<MTableGroupFooter> footerList = new ArrayList<MTableGroupFooter>();
        ArrayList<MTableGroupHeader> headerList = new ArrayList<MTableGroupHeader>();
        for (INode child : this.table.getChildren()) {
            if (detailNode == null && child instanceof MTableDetail) {
                detailNode = (MTableDetail)child;
                continue;
            }
            if (child instanceof MTableGroupFooter) {
                MTableGroupFooter footer = (MTableGroupFooter)child;
                footerList.add(footer);
                continue;
            }
            if (!(child instanceof MTableGroupHeader)) continue;
            MTableGroupHeader header = (MTableGroupHeader)child;
            headerList.add(header);
        }
        this.table.removeChildren(footerList);
        this.table.removeChildren(headerList);
        StandardTable jrTable = this.table.getStandardTable();
        int detailIndex = this.table.getChildren().indexOf((Object)detailNode);
        List groupsList = TableUtil.getGroupList((TableComponent)jrTable, (JRReport)this.table.getJasperDesign());
        ArrayList<MTableGroupHeader> grHeaders = new ArrayList<MTableGroupHeader>();
        ArrayList<MTableGroupFooter> grFooters = new ArrayList<MTableGroupFooter>();
        if (groupsList != null) {
            for (JRDesignGroup jrGroup : groupsList) {
                MTableGroupHeader newHeader = new MTableGroupHeader((ANode)this.table, (JRDesignComponentElement)this.table.getValue(), jrGroup, "");
                this.table.addChild((ANode)newHeader, detailIndex);
                grHeaders.add(newHeader);
                ++detailIndex;
            }
            ++detailIndex;
            for (JRDesignGroup jrGroup : groupsList) {
                MTableGroupFooter newFooter = new MTableGroupFooter((ANode)this.table, (JRDesignComponentElement)this.table.getValue(), jrGroup, "");
                this.table.addChild((ANode)newFooter, detailIndex);
                grFooters.add(newFooter);
                ++detailIndex;
            }
        }
        List columns = jrTable.getColumns();
        int i = 0;
        while (i < columns.size()) {
            String groupName;
            BaseColumn bc = (BaseColumn)columns.get(i);
            for (MTableGroupHeader mTableGroupHeader : grHeaders) {
                groupName = mTableGroupHeader.getJrDesignGroup().getName();
                TableComponentFactory.createCellGroupHeader((ANode)mTableGroupHeader, bc, i + 1, groupName, i);
            }
            for (MTableGroupFooter mTableGroupFooter : grFooters) {
                groupName = mTableGroupFooter.getJrDesignGroup().getName();
                TableComponentFactory.createCellGroupFooter((ANode)mTableGroupFooter, bc, i + 1, groupName, i);
            }
            ++i;
        }
    }

    private void removeGroup() {
        StandardTable jrTable = this.table.getStandardTable();
        List columns = jrTable.getColumns();
        if (columns.size() > 0 && columns.get(0) instanceof StandardColumnGroup) {
            this.oldGroup = (StandardColumnGroup)columns.get(0);
            this.footerCell = new ArrayList<GroupCell>(this.oldGroup.getGroupFooters());
            for (GroupCell cell : this.footerCell) {
                this.oldGroup.removeGroupFooter(cell);
            }
            this.headerCell = new ArrayList<GroupCell>(this.oldGroup.getGroupHeaders());
            for (GroupCell cell : this.headerCell) {
                this.oldGroup.removeGroupHeader(cell);
            }
        }
    }

    private void restoreGroup() {
        if (this.oldGroup != null) {
            for (GroupCell cell : this.footerCell) {
                this.oldGroup.addGroupFooter(cell);
            }
            for (GroupCell cell : this.headerCell) {
                this.oldGroup.addGroupHeader(cell);
            }
            this.footerCell = null;
            this.headerCell = null;
            this.oldGroup = null;
        }
    }

    public void execute() {
        this.removeGroup();
        JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.table.getStandardTable().getDatasetRun();
        this.oldDatasetName = datasetRun.getDatasetName();
        datasetRun.setDatasetName(this.newDatasetName);
        this.reloadAvailableGroups();
        this.table.propertyChange(new PropertyChangeEvent(this.table.getValue(), "columns", null, null));
        this.table.setChangedProperty(true);
    }

    public void undo() {
        JRDesignDatasetRun datasetRun = (JRDesignDatasetRun)this.table.getStandardTable().getDatasetRun();
        datasetRun.setDatasetName(this.oldDatasetName);
        this.oldDatasetName = null;
        this.restoreGroup();
        this.reloadAvailableGroups();
        this.table.propertyChange(new PropertyChangeEvent(this.table.getValue(), "columns", null, null));
        this.table.setChangedProperty(true);
    }

    public boolean canExecute() {
        return this.table != null && this.newDatasetName != null;
    }
}

