/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.model.table.command.wizard;

import com.jaspersoft.studio.components.table.TableManager;
import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.command.CreateColumnCommand;
import com.jaspersoft.studio.components.table.model.dialog.ApplyTableStyleAction;
import com.jaspersoft.studio.components.table.model.dialog.TableStyle;
import com.jaspersoft.studio.components.table.model.table.command.wizard.TableWizardFieldsPage;
import com.jaspersoft.studio.components.table.model.table.command.wizard.TableWizardLayoutPage;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.dataset.command.CreateDatasetCommand;
import com.jaspersoft.studio.model.style.command.CreateStyleCommand;
import com.jaspersoft.studio.model.text.MStaticText;
import com.jaspersoft.studio.model.text.MTextField;
import com.jaspersoft.studio.property.dataset.wizard.WizardConnectionPage;
import com.jaspersoft.studio.property.dataset.wizard.WizardDatasetPage;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.wizards.JSSWizard;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignDatasetRun;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignStaticText;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.design.JRDesignTextField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizardPage;

public class TableWizard
extends JSSWizard {
    private WizardDatasetPage step1;
    private TableWizardFieldsPage step3;
    private WizardConnectionPage step2;
    private TableWizardLayoutPage step4;
    private MTable table = null;
    float baseColor = new Float(Math.tan(Math.toRadians(208.0))).floatValue();

    public TableWizard() {
        this.setWindowTitle(Messages.common_table_wizard);
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.step1 = new WizardDatasetPage(false, "Table");
        this.addPage((IWizardPage)this.step1);
        this.step2 = new WizardConnectionPage();
        this.addPage((IWizardPage)this.step2);
        this.step2.setExpressionContext(ModelUtils.getElementExpressionContext(null, null));
        this.step3 = new TableWizardFieldsPage();
        this.addPage((IWizardPage)this.step3);
        this.step4 = new TableWizardLayoutPage();
        this.addPage((IWizardPage)this.step4);
    }

    public IWizardPage getNextPage(IWizardPage page) {
        return super.getNextPage(page);
    }

    public JRDesignDataset getDataset() {
        return this.step1.getSelectedDataset();
    }

    public MTable getTable(int tableWidth) {
        String dsname;
        if (this.table != null) {
            return this.table;
        }
        this.table = new MTable();
        this.table.setValue(this.table.createJRElement(this.getConfig().getJasperDesign()));
        this.table.setJasperConfiguration(this.getConfig());
        List lst = this.step3.getSelectedFields();
        StandardTable tbl = TableManager.getTable((ANode)this.table);
        JRDesignDataset dataset = this.getDataset();
        JRDesignDatasetRun datasetRun = this.step2.getJRDesignDatasetRun();
        if (datasetRun == null) {
            datasetRun = new JRDesignDatasetRun();
        }
        datasetRun.setDatasetName(dataset.isMainDataset() ? null : dataset.getName());
        tbl.setDatasetRun((JRDatasetRun)datasetRun);
        JasperDesign jd = this.getConfig().getJasperDesign();
        if (tbl != null && lst != null) {
            int colWidth = 40;
            if (tableWidth < 0) {
                tableWidth = this.table.getDefaultWidth();
            }
            if (lst.size() > 0) {
                colWidth = tableWidth / lst.size();
                for (Object f : lst) {
                    StandardColumn col = CreateColumnCommand.addColumnWithStyle(jd, tbl, this.table.getPropertiesMap(), this.step4.isTableHeader(), this.step4.isTableFooter(), this.step4.isColumnHeader(), this.step4.isColumnFooter(), this.step4.isGroupHeader(), this.step4.isGroupFooter());
                    col.setWidth(Integer.valueOf(colWidth));
                    DesignCell colHeadCell = (DesignCell)col.getColumnHeader();
                    DesignCell detCell = (DesignCell)col.getDetailCell();
                    if (this.step4.isColumnHeader()) {
                        JRDesignStaticText sText = (JRDesignStaticText)new MStaticText().createJRElement(jd);
                        sText.setWidth(col.getWidth().intValue());
                        sText.setHeight(colHeadCell.getHeight().intValue());
                        sText.setText(((JRField)f).getName());
                        colHeadCell.addElement((JRDesignElement)sText);
                    }
                    JRDesignTextField fText = (JRDesignTextField)new MTextField().createJRElement(jd);
                    fText.setWidth(col.getWidth().intValue());
                    fText.setHeight(detCell.getHeight().intValue());
                    JRDesignExpression jre = new JRDesignExpression();
                    jre.setText("$F{" + ((JRField)f).getName() + "}");
                    fText.setExpression((JRExpression)jre);
                    detCell.addElement((JRDesignElement)fText);
                    tbl.addColumn((BaseColumn)col);
                }
            } else {
                StandardColumn col = CreateColumnCommand.addColumnWithStyle(jd, tbl, this.table.getPropertiesMap(), this.step4.isTableHeader(), this.step4.isTableFooter(), this.step4.isColumnHeader(), this.step4.isColumnFooter(), this.step4.isGroupHeader(), this.step4.isGroupFooter());
                col.setWidth(Integer.valueOf(colWidth));
                tbl.addColumn((BaseColumn)col);
            }
        }
        if ((dsname = tbl.getDatasetRun().getDatasetName()) == null || dsname.trim().isEmpty()) {
            JRDesignDataset jrDataset = new JRDesignDataset(false);
            jrDataset.setName(ModelUtils.getDefaultName((Map)jd.getDatasetMap(), (String)"Empty Dataset"));
            this.addCommand((Command)new CreateDatasetCommand(this.getConfig(), jrDataset));
            ((JRDesignDatasetRun)tbl.getDatasetRun()).setDatasetName(jrDataset.getName());
        }
        ApplyTableStyleAction applyAction = new ApplyTableStyleAction(this.step4.getSelectedStyle(), (JRElement)this.table.getValue());
        applyAction.applayStyle(jd);
        return this.table;
    }

    private void setBorderWidth(JRDesignStyle element, float lineWidth) {
        JRLineBox box = element.getLineBox();
        box.getPen().setLineWidth(Float.valueOf(lineWidth));
        box.getLeftPen().setLineWidth(Float.valueOf(lineWidth));
        box.getRightPen().setLineWidth(Float.valueOf(lineWidth));
        box.getBottomPen().setLineWidth(Float.valueOf(lineWidth));
        box.getTopPen().setLineWidth(Float.valueOf(lineWidth));
    }

    private void setBorderColor(JRDesignStyle element, Color lineColor) {
        JRLineBox box = element.getLineBox();
        box.getPen().setLineColor(lineColor);
        box.getLeftPen().setLineColor(lineColor);
        box.getRightPen().setLineColor(lineColor);
        box.getBottomPen().setLineColor(lineColor);
        box.getTopPen().setLineColor(lineColor);
    }

    public List<JRDesignStyle> createStyles(JasperDesign jd, TableStyle style) {
        String name;
        String baseName = "Table";
        int i = 0;
        while (true) {
            name = baseName;
            if (i > 0) {
                name = String.valueOf(baseName) + " " + i;
            }
            if (!jd.getStylesMap().containsKey(name)) break;
            ++i;
        }
        baseName = name;
        ArrayList<JRDesignStyle> styles = new ArrayList<JRDesignStyle>();
        JRDesignStyle tableStyle = new JRDesignStyle();
        tableStyle.setName(baseName);
        if (style.getBorderStyle() == TableStyle.BorderStyleEnum.FULL || style.getBorderStyle() == TableStyle.BorderStyleEnum.PARTIAL_VERTICAL) {
            this.setBorderColor(tableStyle, style.getBorderColor());
            this.setBorderWidth(tableStyle, 1.0f);
        } else {
            tableStyle.getLineBox().getTopPen().setLineColor(style.getBorderColor());
            tableStyle.getLineBox().getTopPen().setLineWidth(Float.valueOf(1.0f));
            tableStyle.getLineBox().getBottomPen().setLineColor(style.getBorderColor());
            tableStyle.getLineBox().getBottomPen().setLineWidth(Float.valueOf(1.0f));
        }
        this.addCommand((Command)new CreateStyleCommand(jd, tableStyle));
        styles.add(tableStyle);
        JRDesignStyle tableHeaderStyle = new JRDesignStyle();
        tableHeaderStyle.setName(String.valueOf(baseName) + "_TH");
        if (style.getBorderStyle() == TableStyle.BorderStyleEnum.FULL) {
            this.setBorderColor(tableHeaderStyle, style.getBorderColor());
            this.setBorderWidth(tableHeaderStyle, 0.5f);
        } else {
            tableHeaderStyle.getLineBox().getBottomPen().setLineColor(style.getBorderColor());
            tableHeaderStyle.getLineBox().getBottomPen().setLineWidth(Float.valueOf(0.5f));
            tableHeaderStyle.getLineBox().getTopPen().setLineColor(style.getBorderColor());
            tableHeaderStyle.getLineBox().getTopPen().setLineWidth(Float.valueOf(0.5f));
        }
        tableHeaderStyle.setMode(ModeEnum.OPAQUE);
        tableHeaderStyle.setBackcolor(style.getColorValue("color_table_header"));
        this.addCommand((Command)new CreateStyleCommand(jd, tableHeaderStyle));
        styles.add(tableHeaderStyle);
        JRDesignStyle columnHeaderStyle = new JRDesignStyle();
        columnHeaderStyle.setName(String.valueOf(baseName) + "_CH");
        if (style.getBorderStyle() == TableStyle.BorderStyleEnum.FULL) {
            this.setBorderColor(columnHeaderStyle, style.getBorderColor());
            this.setBorderWidth(columnHeaderStyle, 0.5f);
        } else {
            columnHeaderStyle.getLineBox().getBottomPen().setLineColor(style.getBorderColor());
            columnHeaderStyle.getLineBox().getBottomPen().setLineWidth(Float.valueOf(0.5f));
            columnHeaderStyle.getLineBox().getTopPen().setLineColor(style.getBorderColor());
            columnHeaderStyle.getLineBox().getTopPen().setLineWidth(Float.valueOf(0.5f));
        }
        columnHeaderStyle.setMode(ModeEnum.OPAQUE);
        columnHeaderStyle.setBackcolor(style.getColorValue("color_column_header"));
        this.addCommand((Command)new CreateStyleCommand(jd, columnHeaderStyle));
        styles.add(columnHeaderStyle);
        JRDesignStyle cellStyle = new JRDesignStyle();
        cellStyle.setName(String.valueOf(baseName) + "_TD");
        if (style.getBorderStyle() == TableStyle.BorderStyleEnum.FULL) {
            this.setBorderColor(cellStyle, style.getBorderColor());
            this.setBorderWidth(cellStyle, 0.5f);
        } else {
            cellStyle.getLineBox().getBottomPen().setLineColor(style.getBorderColor());
            cellStyle.getLineBox().getBottomPen().setLineWidth(Float.valueOf(0.5f));
            cellStyle.getLineBox().getTopPen().setLineColor(style.getBorderColor());
            cellStyle.getLineBox().getTopPen().setLineWidth(Float.valueOf(0.5f));
        }
        cellStyle.setMode(ModeEnum.OPAQUE);
        cellStyle.setBackcolor(Color.WHITE);
        if (style.hasAlternateColor().booleanValue()) {
            JRDesignConditionalStyle condStyle = new JRDesignConditionalStyle();
            condStyle.setConditionExpression((JRExpression)ModelUtils.createExpression((String)"new Boolean($V{REPORT_COUNT}.intValue()%2==0)"));
            condStyle.setBackcolor(style.getColorValue("color_detail"));
            cellStyle.addConditionalStyle((JRConditionalStyle)condStyle);
        }
        this.addCommand((Command)new CreateStyleCommand(jd, cellStyle));
        styles.add(cellStyle);
        return styles;
    }
}

