/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.part;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.callout.CalloutEditPart;
import com.jaspersoft.studio.callout.command.CalloutSetConstraintCommand;
import com.jaspersoft.studio.callout.pin.PinEditPart;
import com.jaspersoft.studio.callout.pin.command.PinSetConstraintCommand;
import com.jaspersoft.studio.components.table.TableComponentFactory;
import com.jaspersoft.studio.components.table.figure.WhenNoDataCellFigure;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.nodata.MTableNoData;
import com.jaspersoft.studio.components.table.model.nodata.cmd.CreateNoDataCommand;
import com.jaspersoft.studio.components.table.part.editpolicy.TableNoDataResizableEditPolicy;
import com.jaspersoft.studio.editor.gef.commands.SetPageConstraintCommand;
import com.jaspersoft.studio.editor.gef.figures.APageFigure;
import com.jaspersoft.studio.editor.gef.figures.borders.ShadowBorder;
import com.jaspersoft.studio.editor.gef.figures.borders.SimpleShadowBorder;
import com.jaspersoft.studio.editor.gef.parts.APrefFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.FigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.FrameFigureEditPart;
import com.jaspersoft.studio.editor.gef.parts.IContainerPart;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.ColoredLayoutPositionRectangle;
import com.jaspersoft.studio.editor.gef.parts.editPolicy.PageLayoutEditPolicy;
import com.jaspersoft.studio.editor.outline.editpolicy.CloseSubeditorDeletePolicy;
import com.jaspersoft.studio.jasper.JSSDrawVisitor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.IContainer;
import com.jaspersoft.studio.model.MGraphicElement;
import com.jaspersoft.studio.model.MPage;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.design.JRDesignElement;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.handles.HandleBounds;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.IPropertySourceProvider;

public class TableNoDataEditPart
extends APrefFigureEditPart
implements IContainerPart,
IContainer {
    private Dimension containerSize;
    private TableNoDataResizableEditPolicy cellSelectionPolicy = new TableNoDataResizableEditPolicy(){

        protected void showSelection() {
            super.showSelection();
            TableNoDataEditPart.this.updateRulers();
        }
    };
    public static final int X_OFFSET = 10;
    public static final int Y_OFFSET = 10;

    public Object getAdapter(Class key) {
        if (key == IPropertySourceProvider.class || key == IPropertySource.class) {
            return super.getAdapter(key);
        }
        return this.getParent() != null ? this.getParent().getAdapter(key) : null;
    }

    public void performRequest(Request req) {
        Command c;
        if ("open".equals(req.getType()) && (c = TableComponentFactory.INST().getStretchToContent((ANode)this.getModel())) != null) {
            this.getViewer().getEditDomain().getCommandStack().execute(c);
        }
        super.performRequest(req);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new CloseSubeditorDeletePolicy());
        this.installEditPolicy("LayoutEditPolicy", (EditPolicy)new PageLayoutEditPolicy(){
            private ColoredLayoutPositionRectangle targetFeedback;

            protected void eraseLayoutTargetFeedback(Request request) {
                super.eraseLayoutTargetFeedback(request);
                if (this.targetFeedback != null) {
                    this.removeFeedback((IFigure)this.targetFeedback);
                    this.targetFeedback = null;
                }
            }

            protected IFigure getLayoutTargetFeedback(Request request) {
                ChangeBoundsRequest cbr;
                ArrayList<Object> nodes = new ArrayList<Object>();
                if (request instanceof ChangeBoundsRequest) {
                    cbr = (ChangeBoundsRequest)request;
                    List lst = cbr.getEditParts();
                    for (EditPart ep : lst) {
                        nodes.add(ep.getModel());
                        if (((ANode)ep.getModel()).getParent() == TableNoDataEditPart.this.getModel()) {
                            return null;
                        }
                        if (!(ep instanceof TableNoDataEditPart)) continue;
                        return null;
                    }
                } else if (request instanceof CreateRequest) {
                    if (!(TableNoDataEditPart.this.getModel() instanceof MTableNoData)) {
                        return null;
                    }
                    cbr = (CreateRequest)request;
                    nodes.add(cbr.getNewObject());
                }
                if (this.targetFeedback == null) {
                    this.targetFeedback = new ColoredLayoutPositionRectangle((EditPart)TableNoDataEditPart.this, FrameFigureEditPart.addElementColor, 2.0f, (ANode)TableNoDataEditPart.this.getModel(), nodes);
                    this.targetFeedback.setFill(false);
                    IFigure hostFigure = this.getHostFigure();
                    Rectangle bounds = hostFigure.getBounds();
                    if (hostFigure instanceof HandleBounds) {
                        bounds = ((HandleBounds)hostFigure).getHandleBounds();
                    }
                    PrecisionRectangle rect = new PrecisionRectangle(bounds);
                    this.getHostFigure().translateToAbsolute((Translatable)rect);
                    this.getFeedbackLayer().translateToRelative((Translatable)rect);
                    this.targetFeedback.setBounds((Rectangle)rect);
                    this.addFeedback((IFigure)this.targetFeedback);
                }
                return this.targetFeedback;
            }

            protected void showLayoutTargetFeedback(Request request) {
                super.showLayoutTargetFeedback(request);
                this.getLayoutTargetFeedback(request);
            }

            protected Command getCreateCommand(ANode parent, Object obj, Rectangle constraint, int index, Request request) {
                if (parent instanceof MPage) {
                    parent = TableNoDataEditPart.this.getModel();
                }
                Rectangle b = TableNoDataEditPart.this.getModel().getBounds();
                int x = constraint.x - b.x;
                int y = constraint.y - b.y;
                constraint = new Rectangle(x, y, constraint.width, constraint.height);
                return super.getCreateCommand(parent, obj, constraint, index, request);
            }

            protected Command getAddCommand(Request generic) {
                ChangeBoundsRequest request = (ChangeBoundsRequest)generic;
                List editParts = request.getEditParts();
                MTableNoData mband = TableNoDataEditPart.this.getModel();
                JSSCompoundCommand command = new JSSCompoundCommand((ANode)mband);
                command.enableSelectionRestore(true);
                command.setDebugLabel("Add in Table Cell");
                ISelection currentSelection = null;
                int i = 0;
                while (i < editParts.size()) {
                    GraphicalEditPart child = (GraphicalEditPart)editParts.get(i);
                    if (currentSelection == null) {
                        currentSelection = child.getViewer().getSelection();
                    }
                    command.add(this.createAddCommand(request, (EditPart)child, this.translateToModelConstraint(this.getConstraintFor(request, child))));
                    ++i;
                }
                return command;
            }

            protected Command createAddCommand(EditPart child, Object constraint) {
                Rectangle rect = (Rectangle)constraint;
                if (child.getModel() instanceof MGraphicElement) {
                    MGraphicElement cmodel = (MGraphicElement)child.getModel();
                    if (cmodel.getParent() instanceof MTableNoData) {
                        MTableNoData cparent = (MTableNoData)cmodel.getParent();
                        if (cparent == TableNoDataEditPart.this.getModel()) {
                            SetPageConstraintCommand cmd = new SetPageConstraintCommand();
                            MGraphicElement model = (MGraphicElement)child.getModel();
                            Rectangle r = model.getBounds();
                            JRDesignElement jde = model.getValue();
                            int x = r.x + rect.x - jde.getX();
                            int y = r.y + rect.y - jde.getY() - 20;
                            rect.setLocation(x, y);
                            cmd.setContext((ANode)TableNoDataEditPart.this.getModel(), (ANode)child.getModel(), rect);
                            return cmd;
                        }
                        CompoundCommand c = new CompoundCommand();
                        c.add((Command)new CreateNoDataCommand(TableNoDataEditPart.this.getModel()));
                        return c;
                    }
                    return super.createChangeConstraintCommand(child, constraint);
                }
                if (child instanceof CalloutEditPart) {
                    return new CalloutSetConstraintCommand(((CalloutEditPart)child).getModel(), this.adaptConstraint(constraint));
                }
                if (child instanceof PinEditPart) {
                    return new PinSetConstraintCommand(((PinEditPart)child).getModel(), this.adaptConstraint(constraint));
                }
                return null;
            }
        });
        this.installEditPolicy("Selection Feedback", (EditPolicy)this.cellSelectionPolicy);
    }

    public EditPolicy getEditPolicy() {
        return null;
    }

    public Command getCommand(Request request) {
        if (request.getType().equals("move") && ((ChangeBoundsRequest)request).getMoveDelta().x == 0) {
            return null;
        }
        return super.getCommand(request);
    }

    public boolean isSelectable() {
        return true;
    }

    public MTableNoData getModel() {
        return (MTableNoData)super.getModel();
    }

    protected void setupFigure(IFigure rect) {
        this.updateContainerSize();
        MTableNoData model = this.getModel();
        rect.setToolTip((IFigure)new Label(model.getToolTip()));
        Rectangle bounds = model.getBounds();
        if (bounds != null) {
            int x = bounds.x;
            int y = bounds.y + APageFigure.PAGE_BORDER.top - 30;
            rect.setLocation(new Point(x, y));
            rect.setToolTip((IFigure)new Label(String.valueOf(x) + "," + y));
            JSSDrawVisitor dv = this.getDrawVisitor();
            if (rect instanceof WhenNoDataCellFigure) {
                ((WhenNoDataCellFigure)rect).setJRElement(model.getValue(), model.getMTable().getValue(), dv);
            }
            rect.setSize(new Dimension(bounds.width, bounds.height + 15));
            this.updateRulers();
        }
        if (this.getSelected() == 1) {
            this.updateRulers();
        } else {
            List selected = this.getViewer().getSelectedEditParts();
            if (selected.isEmpty()) {
                this.updateRulers();
            } else {
                for (Object obj : selected) {
                    FigureEditPart figEditPart;
                    if (!(obj instanceof FigureEditPart) || (figEditPart = (FigureEditPart)obj).getModel().getParent() != this.getModel()) continue;
                    figEditPart.updateRulers();
                }
            }
        }
    }

    public Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        return new Rectangle(0, 0, request.getSizeDelta().width, request.getSizeDelta().height);
    }

    public void updateRulers() {
        Dimension d = this.getContaierSize();
        EditPartViewer v = this.getViewer();
        if (d != null) {
            int h = this.getModel().getValue().getHeight();
            v.setProperty("HEND", (Object)d.width);
            v.setProperty("VEND", (Object)h);
        }
        v.setProperty("HOFFSET", (Object)10);
        int y = this.getModel().getBounds().y + 10;
        v.setProperty("VOFFSET", (Object)y);
        v.setProperty("SnapToGrid.GridOrigin", (Object)new Point(10, y));
    }

    public Dimension getContaierSize() {
        return this.containerSize;
    }

    private void updateContainerSize() {
        MTableNoData m = this.getModel();
        MTable table = m.getMTable();
        if (table != null) {
            Dimension d = table.getTableManager().getSize();
            d.height = (Integer)Misc.nvl((Object)((Integer)table.getPropertyValue("height")), (Object)0);
            d.width = Math.max(d.width, (Integer)table.getPropertyValue("width"));
            this.containerSize = d;
        } else {
            this.containerSize = null;
        }
    }

    protected IFigure createFigure() {
        IFigure fig = super.createFigure();
        if (fig instanceof WhenNoDataCellFigure) {
            this.setBandNameShowing(fig);
        }
        return fig;
    }

    protected void handlePreferenceChanged(PropertyChangeEvent event) {
        if (event.getProperty().equals("showReportBandNames")) {
            this.setBandNameShowing(this.getFigure());
        } else if (event.getProperty().equals("pageDesignBorderStyle")) {
            this.setPrefsBorder(this.getFigure());
        } else {
            super.handlePreferenceChanged(event);
        }
    }

    public void setPrefsBorder(IFigure rect) {
        String pref;
        if (this.jConfig == null) {
            this.jConfig = this.getModel().getJasperConfiguration();
        }
        if ((pref = this.jConfig.getProperty("pageDesignBorderStyle", "shadow")).equals("shadow")) {
            rect.setBorder((Border)new ShadowBorder());
        } else {
            rect.setBorder((Border)new SimpleShadowBorder());
        }
    }

    private void setBandNameShowing(IFigure figure) {
        if (figure instanceof WhenNoDataCellFigure) {
            if (this.jConfig == null) {
                this.jConfig = this.getModel().getJasperConfiguration();
            }
            boolean showBandName = this.jConfig.getPropertyBoolean("showReportBandNames", true);
            ((WhenNoDataCellFigure)figure).setShowBandName(showBandName);
        }
    }
}

