/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.part.editpolicy;

import com.jaspersoft.studio.JSSCompoundCommand;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.ModelUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.ColumnGroup;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;

public class JSSCompoundTableCommand
extends JSSCompoundCommand {
    private MTable table;
    private boolean updateTableSpan = false;
    private HashMap<BaseColumn, Integer> originalColumnsSize = null;
    private boolean layoutTableContent = false;
    private HashSet<BaseColumn> fixedColumns = null;

    public JSSCompoundTableCommand(MTable table, boolean updateTableSpan) {
        super("Change Cell Size", (ANode)table);
        this.table = table;
        this.updateTableSpan = updateTableSpan;
    }

    public JSSCompoundTableCommand(MTable table) {
        this(table, false);
    }

    public JSSCompoundTableCommand(String commandText, MTable table) {
        this(commandText, table, false);
    }

    public JSSCompoundTableCommand(String commandText, MTable table, boolean updateTableSpan) {
        super(commandText, (ANode)table);
        this.table = table;
        this.updateTableSpan = updateTableSpan;
    }

    public void execute() {
        if (this.table.hasColumnsAutoresizeProportional()) {
            int currentTableWidth;
            this.storeColumnsSize();
            super.execute();
            boolean changed = false;
            if (this.fixedColumns == null) {
                currentTableWidth = this.table.getValue().getWidth();
                HashSet<BaseColumn> modifiedColumn = this.getModifiedColumns();
                boolean widthChanged = modifiedColumn.size() > 0;
                this.addGroup(modifiedColumn, this.table.getStandardTable());
                changed = this.table.getTableManager().fillSpace(currentTableWidth, true, modifiedColumn, widthChanged);
            } else {
                currentTableWidth = this.table.getValue().getWidth();
                this.addGroup(this.fixedColumns, this.table.getStandardTable());
                changed = this.table.getTableManager().fillSpace(currentTableWidth, true, this.fixedColumns);
            }
            if (!changed) {
                JSSCompoundCommand layoutCommands = this.table.getTableManager().getLayoutCommand();
                layoutCommands.setReferenceNodeIfNull((ANode)this.table);
                layoutCommands.execute();
            }
        } else {
            super.execute();
            if (this.layoutTableContent) {
                JSSCompoundCommand layoutCommands = this.table.getTableManager().getLayoutCommand();
                layoutCommands.setReferenceNodeIfNull((ANode)this.table);
                layoutCommands.execute();
            }
        }
        if (this.updateTableSpan) {
            this.table.getTableManager().updateTableSpans();
        }
    }

    protected void addGroup(HashSet<BaseColumn> excludedColumns, StandardColumnGroup currentGroup) {
        boolean allContained = true;
        List currentColumns = currentGroup.getColumns();
        for (BaseColumn col : currentColumns) {
            if (col instanceof StandardColumnGroup) {
                StandardColumnGroup childGroup = (StandardColumnGroup)col;
                this.addGroup(excludedColumns, childGroup);
            }
            if (excludedColumns.contains(col)) continue;
            allContained = false;
            break;
        }
        if (allContained) {
            excludedColumns.add((BaseColumn)currentGroup);
        }
    }

    protected void addGroup(HashSet<BaseColumn> excludedColumns, StandardTable table) {
        if (table != null) {
            for (BaseColumn col : table.getColumns()) {
                if (!(col instanceof StandardColumnGroup)) continue;
                this.addGroup(excludedColumns, (StandardColumnGroup)col);
            }
        }
    }

    public void undo() {
        if (this.table.hasColumnsAutoresizeProportional()) {
            super.undo();
            this.restoreColumnsSize(this.table.getStandardTable().getColumns());
            boolean changed = this.table.getTableManager().fillSpace(this.table.getValue().getWidth(), true, new HashSet<BaseColumn>());
            if (!changed) {
                JSSCompoundCommand layoutCommands = this.table.getTableManager().getLayoutCommand();
                layoutCommands.setReferenceNodeIfNull((ANode)this.table);
                layoutCommands.execute();
            }
        } else {
            super.undo();
            if (this.layoutTableContent) {
                JSSCompoundCommand layoutCommands = this.table.getTableManager().getLayoutCommand();
                layoutCommands.setReferenceNodeIfNull((ANode)this.table);
                layoutCommands.execute();
            }
        }
        if (this.updateTableSpan) {
            this.table.getTableManager().updateTableSpans();
        }
    }

    public void redo() {
        if (this.table.hasColumnsAutoresizeProportional()) {
            this.storeColumnsSize();
            super.redo();
            HashSet<BaseColumn> modifiedColumn = this.getModifiedColumns();
            boolean widthChanged = modifiedColumn.size() > 0;
            this.table.getTableManager().fillSpace(this.table.getValue().getWidth(), true, modifiedColumn, widthChanged);
        } else {
            super.redo();
            if (this.layoutTableContent) {
                JSSCompoundCommand layoutCommands = this.table.getTableManager().getLayoutCommand();
                layoutCommands.setReferenceNodeIfNull((ANode)this.table);
                layoutCommands.execute();
            }
        }
        if (this.updateTableSpan) {
            this.table.getTableManager().updateTableSpans();
        }
    }

    protected void storeColumnsSize() {
        List<BaseColumn> columns = this.getAllColumns(this.table.getStandardTable().getColumns());
        this.originalColumnsSize = new HashMap();
        for (BaseColumn column : columns) {
            this.originalColumnsSize.put(column, column.getWidth());
        }
    }

    protected HashSet<BaseColumn> getModifiedColumns() {
        HashSet<BaseColumn> result = new HashSet<BaseColumn>();
        for (Map.Entry<BaseColumn, Integer> columnEntry : this.originalColumnsSize.entrySet()) {
            if (ModelUtils.safeEquals((Object)columnEntry.getKey().getWidth(), (Object)columnEntry.getValue())) continue;
            result.add(columnEntry.getKey());
        }
        return result;
    }

    protected void addColumnToList(List<BaseColumn> list, BaseColumn columnToAdd) {
        list.add(columnToAdd);
        if (columnToAdd instanceof ColumnGroup) {
            ColumnGroup group = (ColumnGroup)columnToAdd;
            for (BaseColumn groupColumn : group.getColumns()) {
                this.addColumnToList(list, groupColumn);
            }
        }
    }

    protected void restoreColumnsSize(List<BaseColumn> columns) {
        if (this.originalColumnsSize != null) {
            for (BaseColumn column : columns) {
                Integer originalWidth;
                if (column instanceof StandardColumnGroup) {
                    StandardColumnGroup groupColumn = (StandardColumnGroup)column;
                    this.restoreColumnsSize(groupColumn.getColumns());
                }
                if ((originalWidth = this.originalColumnsSize.get(column)) == null) continue;
                ((StandardBaseColumn)column).setWidth(originalWidth);
            }
        }
    }

    protected List<BaseColumn> getAllColumns(List<BaseColumn> cols) {
        ArrayList<BaseColumn> lst = new ArrayList<BaseColumn>();
        for (BaseColumn bc : cols) {
            if (bc instanceof ColumnGroup) {
                lst.addAll(this.getAllColumns(((ColumnGroup)bc).getColumns()));
            }
            lst.add(bc);
        }
        return lst;
    }

    public void setLayoutTableContent(boolean value) {
        this.layoutTableContent = value;
    }

    public boolean canExecute() {
        return this.table != null && super.canExecute();
    }

    public boolean canUndo() {
        return this.table != null;
    }

    public void setFixedColumns(HashSet<BaseColumn> fixedColumns) {
        this.fixedColumns = fixedColumns;
    }
}

