/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.part.editpolicy;

import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.column.command.MoveColumnCommand;
import com.jaspersoft.studio.components.table.part.TableCellEditPart;
import com.jaspersoft.studio.components.table.part.editpolicy.CreateResize;
import com.jaspersoft.studio.editor.gef.figures.ComponentFigure;
import com.jaspersoft.studio.editor.gef.parts.RedrawingEditPolicy;
import com.jaspersoft.studio.editor.gef.parts.handles.CellMoveHandle;
import com.jaspersoft.studio.editor.gef.parts.handles.CellResizeHandle2;
import com.jaspersoft.studio.editor.gef.util.GEFUtil;
import com.jaspersoft.studio.model.ANode;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.RectangleFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Handle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;

public class TableCellResizableEditPolicy
extends RedrawingEditPolicy {
    private MovePlacer movePlace = new MovePlacer();

    public TableCellResizableEditPolicy() {
        this.setDragAllowed(true);
    }

    public TableCellEditPart getHost() {
        return (TableCellEditPart)super.getHost();
    }

    protected List<Handle> createSelectionHandles() {
        ArrayList<Handle> list = new ArrayList<Handle>();
        TableCellEditPart geditPart = this.getHost();
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 4));
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 1));
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 16));
        list.add((Handle)new CellResizeHandle2((GraphicalEditPart)geditPart, 8));
        CellMoveHandle hand = new CellMoveHandle((GraphicalEditPart)geditPart, true, false, -3);
        list.add((Handle)hand);
        return list;
    }

    protected Command getMoveCommand(ChangeBoundsRequest request) {
        Point p = request.getMoveDelta();
        p.y = 0;
        request.setMoveDelta(p);
        MColumn model = this.getHost().getModel();
        IFigure hfigure = this.getHostFigure();
        Rectangle hbounds = hfigure.getBounds().getCopy();
        double zoom = GEFUtil.getZoom((GraphicalEditPart)this.getHost());
        TableCellEditPart ep = this.movePlace.calcMovePlace((int)Math.floor((double)request.getMoveDelta().x / zoom), hbounds);
        if (ep != null) {
            return new MoveColumnCommand(model, (ANode)ep.getModel());
        }
        return null;
    }

    protected Command getResizeCommand(ChangeBoundsRequest request) {
        return CreateResize.createResizeCommand(request, this.getHost());
    }

    protected IFigure createDragSourceFeedbackFigure() {
        FeedbackFigure r = new FeedbackFigure();
        r.setOpaque(false);
        r.setAlpha(50);
        r.setBackgroundColor(ColorConstants.gray);
        r.setFill(false);
        r.setBorder((Border)new LineBorder(ColorConstants.gray, 1));
        this.addFeedback((IFigure)r);
        return r;
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        Point moveDelta = request.getMoveDelta().getCopy();
        Dimension sizeDelta = request.getSizeDelta().getCopy();
        moveDelta.y = 0;
        this.getFeedbackLayer().translateToParent((Translatable)moveDelta);
        int delta = moveDelta.x;
        if (request.getType().equals("move")) {
            request.setMoveDelta(new Point(delta, 0));
            if (delta == 0) {
                return;
            }
        }
        if (request.getType().equals("resize") && sizeDelta.width == 0 && sizeDelta.height == 0) {
            return;
        }
        PrecisionRectangle rdelta = new PrecisionRectangle(new Rectangle(moveDelta, sizeDelta));
        FeedbackFigure feedback = (FeedbackFigure)this.getDragSourceFeedbackFigure();
        IFigure hfig = this.getHostFigure();
        feedback.setRequest(request);
        if (request.getType().equals("move")) {
            double zoom = GEFUtil.getZoom((GraphicalEditPart)this.getHost());
            this.movePlace.calcMovePlace((int)Math.floor((double)moveDelta.x / zoom), hfig.getBounds().getCopy());
            if (this.movePlace.x1 != this.movePlace.xRef) {
                feedback.setInsertLine(this.movePlace.x1, this.movePlace.y1, this.movePlace.y2);
            }
        }
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        Dimension contaierSize = this.getHost().getContaierSize();
        if (request.getType().equals("resize") && request.getResizeDirection() == 4) {
            rect.x = 10;
            rect.width = contaierSize.width;
        } else if (request.getType().equals("resize") && request.getResizeDirection() == 1) {
            rect.x = 10;
            rdelta.y = -rdelta.height;
            rect.width = contaierSize.width;
        } else if (request.getType().equals("move")) {
            rect.y = 0;
            rect.height = contaierSize.height + 20;
        } else {
            rect.y = 10;
            rect.height = contaierSize.height + 1;
        }
        hfig.translateToAbsolute((Translatable)rect);
        rect.translate(rdelta.x, rdelta.y);
        rect.resize(rdelta.width, rdelta.height);
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
        feedback.validate();
        super.showChangeBoundsFeedback(request);
    }

    private final class FeedbackFigure
    extends RectangleFigure {
        private ChangeBoundsRequest request;
        private int x1;
        private int y1;
        private int y2;

        private FeedbackFigure() {
        }

        public void setRequest(ChangeBoundsRequest request) {
            this.request = request;
        }

        public void setInsertLine(int x1, int y1, int y2) {
            this.x1 = x1;
            this.y1 = y1;
            this.y2 = y2;
        }

        public void paintFigure(Graphics g) {
            PrecisionRectangle b = new PrecisionRectangle(this.getBounds().getCopy());
            if (this.request.getType().equals("resize")) {
                super.paintFigure(g);
                Graphics2D gr = ComponentFigure.getG2D((Graphics)g);
                if (gr != null) {
                    gr.fillRect(b.x, b.y, b.width, b.height);
                    AlphaComposite ac = AlphaComposite.getInstance(3, 1.0f);
                    gr.setComposite(ac);
                    gr.fillOval(b.x + b.width / 2 - 3, b.y - 3, 7, 7);
                    gr.fillOval(b.x + b.width / 2 - 3, b.y + b.height - 4, 7, 7);
                    gr.drawLine(b.x + b.width / 2, b.y, b.x + b.width / 2, b.y + b.height - 2);
                }
            } else if (this.request.getType().equals("move")) {
                double zoom = GEFUtil.getZoom((Rectangle)b, (IFigure)TableCellResizableEditPolicy.this.getHostFigure());
                Graphics2D gr = ComponentFigure.getG2D((Graphics)g);
                if (gr != null) {
                    gr.setColor(Color.gray);
                    AlphaComposite ac = AlphaComposite.getInstance(3, 0.1f);
                    gr.setComposite(ac);
                    int h = 10;
                    b.y = b.y + (int)Math.floor((double)h * zoom) - h - 3;
                    int height = b.height - (int)Math.floor((double)h * zoom);
                    gr.fillRect(b.x, b.y, b.width, height - b.y);
                    ac = AlphaComposite.getInstance(3, 0.8f);
                    gr.setComposite(ac);
                    gr.fillRect(b.x, b.y, b.width, h);
                    gr.fillRect(b.x, height + 3, b.width, h);
                    gr.setStroke(new BasicStroke(2.0f));
                    ac = AlphaComposite.getInstance(3, 1.0f);
                    gr.setComposite(ac);
                    gr.setColor(Color.red);
                    PrecisionRectangle r = new PrecisionRectangle(new Rectangle(this.x1, this.y1, this.x1, this.y2));
                    TableCellResizableEditPolicy.this.getHostFigure().translateToAbsolute((Translatable)r);
                    TableCellResizableEditPolicy.this.getFeedbackLayer().translateToRelative((Translatable)r);
                    gr.drawLine(r.x, r.y, r.x, r.height);
                }
            }
        }
    }

    private class MovePlacer {
        private int delta;
        private Rectangle hbounds;
        private TableCellEditPart tbCell;
        public int x1;
        public int y1;
        public int y2;
        public int xRef;

        private MovePlacer() {
        }

        public TableCellEditPart calcMovePlace(int delta, Rectangle hbounds) {
            if (this.delta == delta && hbounds != null && this.hbounds != null && this.hbounds.equals((Object)hbounds)) {
                return this.tbCell;
            }
            this.x1 = this.xRef = delta >= 0 ? hbounds.x + hbounds.width : hbounds.x;
            this.y1 = TableCellResizableEditPolicy.this.getHost().getContaierSize().height;
            this.y2 = 10;
            this.tbCell = null;
            List lst = TableCellResizableEditPolicy.this.getHost().getParent().getChildren();
            for (EditPart ep : lst) {
                int diff;
                if (ep == TableCellResizableEditPolicy.this.getHost() || !(ep instanceof TableCellEditPart)) continue;
                TableCellEditPart tmp = (TableCellEditPart)ep;
                Rectangle r = tmp.getFigure().getBounds();
                if (delta >= 0) {
                    int rightSide = r.x + r.width - 3;
                    if (rightSide <= this.xRef || (diff = rightSide - this.xRef) <= 0 || diff > delta || this.x1 > rightSide) continue;
                    this.x1 = rightSide;
                    this.y1 = Math.min(r.y, this.y1);
                    this.y2 = Math.max(r.y + r.height, this.y2);
                    this.tbCell = tmp;
                    continue;
                }
                int leftSide = r.x;
                if (leftSide >= this.xRef || (diff = leftSide - this.xRef - delta) <= 0 || this.x1 < leftSide) continue;
                this.x1 = leftSide;
                this.y1 = Math.min(r.y, this.y1);
                this.y2 = Math.max(r.y + r.height, this.y2);
                this.tbCell = tmp;
            }
            return this.tbCell;
        }
    }
}

