/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.table.util;

import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.components.table.model.AMCollection;
import com.jaspersoft.studio.components.table.model.MTable;
import com.jaspersoft.studio.components.table.model.column.MColumn;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroup;
import com.jaspersoft.studio.components.table.model.columngroup.MColumnGroupCell;
import com.jaspersoft.studio.model.INode;
import java.util.List;
import net.sf.jasperreports.components.table.BaseColumn;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardTable;
import net.sf.jasperreports.components.table.util.TableUtil;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;

public class TableColumnNumerator {
    public static void renumerateColumnNames(MTable mtable) {
        JRDesignComponentElement tbl = (JRDesignComponentElement)mtable.getValue();
        if (tbl.getComponent() instanceof StandardTable) {
            StandardTable table = (StandardTable)tbl.getComponent();
            List columns = TableUtil.getAllColumns((List)table.getColumns());
            TableColumnNumerator.setColNames((INode)mtable, columns);
        }
    }

    public static void setColNames(INode n, List<BaseColumn> columns) {
        for (INode node : n.getChildren()) {
            if (node instanceof MColumn) {
                TableColumnNumerator.setColumnName((MColumn)node, columns);
            }
            if (!(node instanceof AMCollection) && !(node instanceof MColumn)) continue;
            TableColumnNumerator.setColNames(node, columns);
        }
    }

    public static void setColumnName(MColumn col, List<BaseColumn> columns) {
        StandardBaseColumn bc = col.getValue();
        int i = columns.indexOf(bc) + 1;
        if (col instanceof MColumnGroup || col instanceof MColumnGroupCell) {
            int size = TableUtil.getAllColumns((List)((StandardColumnGroup)bc).getColumns()).size();
            col.setName(String.valueOf(Messages.common_columns) + " [" + size + "]");
        } else if (col instanceof MColumn) {
            col.setName(String.valueOf(Messages.common_column) + i);
        }
    }
}

