/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.widgets;

import com.jaspersoft.studio.components.table.messages.Messages;
import com.jaspersoft.studio.property.color.ColorSchemaGenerator;
import com.jaspersoft.studio.property.color.Tag;
import com.jaspersoft.studio.property.color.chooser.ColorDialog;
import com.jaspersoft.studio.property.descriptor.color.ColorLabelProvider;
import com.jaspersoft.studio.utils.AlfaRGB;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.util.Util;
import org.eclipse.nebula.widgets.tablecombo.TableCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class ColorSelectionWidget {
    private static final ColorLabelProvider colorLabelProvider = new ColorLabelProvider(null);
    private StackLayout layout;
    private Button changeControl;
    private Composite manualComposite;
    private Composite schemaCompoiste;
    private TableCombo colorScheme;
    private Combo variations;
    private List<Tag> variants;
    private HashMap<String, ToolItem> buttonsMap;
    private SelectionAdapter selectionChangeButton;
    private SelectionAdapter selectionChangeCombo;
    private Composite parent;
    private List<ButtonDescriptor> buttonToAdd;
    private STYLE style;

    public ColorSelectionWidget(Composite parent, SelectionAdapter selectionChangeButton, SelectionAdapter selectionChangeCombo, STYLE style) {
        this.parent = parent;
        this.selectionChangeButton = selectionChangeButton;
        this.selectionChangeCombo = selectionChangeCombo;
        this.buttonToAdd = new ArrayList<ButtonDescriptor>();
        this.buttonsMap = new HashMap();
        this.style = style;
    }

    public void addButton(String id, String text, AlfaRGB initialColor) {
        this.buttonToAdd.add(new ButtonDescriptor(id, text, initialColor));
    }

    private void createSchema(Composite colorComposite) {
        Composite sComp = new Composite(colorComposite, 0);
        sComp.setLayout((Layout)new GridLayout(2, false));
        sComp.setLayoutData((Object)new GridData(1808));
        Label firstLabel = new Label(sComp, 0);
        firstLabel.setText(Messages.TableWizardLayoutPage_color_schema_label);
        this.colorScheme = new TableCombo(sComp, 2048);
        List colors = ColorSchemaGenerator.getColors();
        for (String color : colors) {
            TableItem item = new TableItem(this.colorScheme.getTable(), 8);
            item.setImage(ColorSchemaGenerator.getImagePreview((String)color));
            item.setText(color);
        }
        this.colorScheme.setLayoutData((Object)new GridData(768));
        this.colorScheme.select(0);
        this.colorScheme.setEditable(false);
        Label secondLabel = new Label(sComp, 0);
        secondLabel.setText(Messages.TableWizardLayoutPage_variations_label);
        this.variations = new Combo(sComp, 8);
        this.variations.setItems(this.getVariantsName());
        this.variations.setLayoutData((Object)new GridData(768));
        this.variations.select(0);
        this.variations.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Event selEvent = new Event();
                selEvent.widget = e.widget;
                ColorSelectionWidget.this.selectionChangeCombo.widgetSelected(new SelectionEvent(selEvent));
            }
        });
        this.colorScheme.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorSelectionWidget.this.selectionChangeCombo.widgetSelected(e);
            }
        });
    }

    private void createManual(Composite manualComposite) {
        for (ButtonDescriptor desc : this.buttonToAdd) {
            ToolItem item = this.createSingleColors(desc.id, desc.text, manualComposite, desc.color);
            this.buttonsMap.put(desc.id, item);
        }
    }

    private GridLayout createNoBorderLayout(int colNum, int marginHeight) {
        GridLayout layout = new GridLayout(colNum, false);
        layout.marginHeight = marginHeight;
        layout.marginWidth = 0;
        return layout;
    }

    public void createControl(String schemaGroupName, String manualGroupName, int manualColorColumn) {
        if (this.style.equals((Object)STYLE.HIDDEN)) {
            Composite mainComp = new Composite(this.parent, 0);
            mainComp.setLayout((Layout)this.createNoBorderLayout(2, 0));
            mainComp.setLayoutData((Object)new GridData(1808));
            Composite colorComposite = new Composite(mainComp, 0);
            colorComposite.setLayoutData((Object)new GridData(1808));
            this.layout = new StackLayout();
            colorComposite.setLayout((Layout)this.layout);
            Group group1 = new Group(colorComposite, 0);
            group1.setText(schemaGroupName);
            group1.setLayout((Layout)this.createNoBorderLayout(1, 0));
            group1.setLayoutData((Object)new GridData(1808));
            this.createSchema((Composite)group1);
            this.schemaCompoiste = group1;
            Group group2 = new Group(colorComposite, 0);
            group2.setText(manualGroupName);
            group2.setLayout((Layout)this.createNoBorderLayout(manualColorColumn, 5));
            group2.setLayoutData((Object)new GridData(1808));
            this.manualComposite = group2;
            this.createManual((Composite)group2);
            this.layout.topControl = this.schemaCompoiste;
            this.changeControl = new Button(mainComp, 0);
            this.changeControl.setText(">>");
            this.changeControl.setLayoutData((Object)new GridData(1040));
            this.changeControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (((ColorSelectionWidget)ColorSelectionWidget.this).layout.topControl == ColorSelectionWidget.this.schemaCompoiste) {
                        ColorSelectionWidget.this.switchInputMethod(ColorInput.MANUAL);
                    } else {
                        ColorSelectionWidget.this.switchInputMethod(ColorInput.SCHEMA);
                    }
                }
            });
        } else {
            Group group2 = new Group(this.parent, 0);
            group2.setText(manualGroupName);
            group2.setLayout((Layout)new GridLayout(manualColorColumn, false));
            group2.setLayoutData((Object)new GridData(1808));
            this.manualComposite = group2;
            this.createManual((Composite)group2);
            Group group = new Group(this.parent, 0);
            group.setText(schemaGroupName);
            group.setLayout((Layout)new GridLayout(2, false));
            group.setLayoutData((Object)new GridData(1808));
            this.createSchema((Composite)group);
            this.schemaCompoiste = group;
        }
    }

    public Composite getManualComposite() {
        return this.manualComposite;
    }

    public AlfaRGB getButtonData(String buttonId) {
        ToolItem button = this.buttonsMap.get(buttonId);
        if (button != null) {
            return (AlfaRGB)button.getData();
        }
        return null;
    }

    public void setButtonData(String buttonId, AlfaRGB newColor) {
        ToolItem button = this.buttonsMap.get(buttonId);
        if (button != null) {
            button.setImage(colorLabelProvider.getImage((Object)newColor));
            button.setData((Object)newColor);
        }
    }

    public ColorSchemaGenerator.SCHEMAS getVariantSelectedKey() {
        return (ColorSchemaGenerator.SCHEMAS)this.variants.get(this.variations.getSelectionIndex()).getValue();
    }

    public String getSchemaSelected() {
        return this.colorScheme.getItem(this.colorScheme.getSelectionIndex());
    }

    private ToolItem createSingleColors(final String id, String text, Composite parent, AlfaRGB color) {
        new Label(parent, 0).setText(text);
        final ToolBar toolBar = new ToolBar(parent, 0x804040);
        if (!Util.isLinux()) {
            toolBar.setBackground(parent.getBackground());
        }
        final ToolItem foreButton = new ToolItem(toolBar, 8);
        this.setButtonColor(id, color, foreButton);
        foreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AlfaRGB newColor;
                ColorDialog cd = new ColorDialog(toolBar.getShell());
                cd.setText(Messages.TableWizardLayoutPage_colorSelectionDialog);
                if (foreButton.getData() instanceof AlfaRGB) {
                    cd.setRGB((AlfaRGB)foreButton.getData());
                }
                if ((newColor = cd.openAlfaRGB()) != null) {
                    ColorSelectionWidget.this.setButtonColor(id, newColor, foreButton);
                    ColorSelectionWidget.this.selectionChangeButton.widgetSelected(e);
                }
            }
        });
        toolBar.pack();
        return foreButton;
    }

    public void switchInputMethod(ColorInput mode) {
        if (this.style.equals((Object)STYLE.HIDDEN)) {
            if (mode.equals((Object)ColorInput.MANUAL)) {
                this.layout.topControl = this.manualComposite;
                this.changeControl.setText("<<");
                this.changeControl.setToolTipText(Messages.TableWizardLayoutPage_changeButtonTooltip1);
            } else {
                this.layout.topControl = this.schemaCompoiste;
                this.changeControl.setText(">>");
                this.changeControl.setToolTipText(Messages.TableWizardLayoutPage_changeButtonTooltip2);
            }
            this.schemaCompoiste.getParent().layout();
        }
    }

    private void setButtonColor(String id, AlfaRGB newColor, ToolItem button) {
        button.setImage(colorLabelProvider.getImage((Object)newColor));
        button.setData((Object)newColor);
        button.setData("id", (Object)id);
    }

    private String[] getVariantsName() {
        this.variants = ColorSchemaGenerator.getVariants();
        String[] variantsName = new String[this.variants.size()];
        int i = 0;
        while (i < this.variants.size()) {
            variantsName[i] = this.variants.get(i).getName();
            ++i;
        }
        return variantsName;
    }

    private class ButtonDescriptor {
        private String id;
        private String text;
        private AlfaRGB color;

        public ButtonDescriptor(String id, String text, AlfaRGB color) {
            this.id = id;
            this.text = text;
            this.color = color;
        }
    }

    public static enum ColorInput {
        MANUAL,
        SCHEMA;

    }

    public static enum STYLE {
        BOTTOM,
        HIDDEN;

    }
}

