/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.widgets.framework.ui;

import com.jaspersoft.studio.components.widgets.framework.ui.SeriesSelectionPanelManager;
import com.jaspersoft.studio.editor.expression.ExpressionContext;
import com.jaspersoft.studio.property.descriptor.NullEnum;
import com.jaspersoft.studio.property.descriptors.NamedEnumPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import com.jaspersoft.studio.widgets.framework.IWItemProperty;
import com.jaspersoft.studio.widgets.framework.WItemProperty;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedEvent;
import com.jaspersoft.studio.widgets.framework.events.ItemPropertyModifiedListener;
import com.jaspersoft.studio.widgets.framework.model.WidgetPropertyDescriptor;
import com.jaspersoft.studio.widgets.framework.ui.ItemPropertyDescription;
import net.sf.jasperreports.customizers.shape.ShapeTypeEnum;
import org.eclipse.swt.widgets.Composite;

public class ShapePanelManager
extends SeriesSelectionPanelManager {
    private ItemPropertyModifiedListener shapeTypeChange = new ItemPropertyModifiedListener(){

        public void itemModified(ItemPropertyModifiedEvent event) {
            WItemProperty editedWidget = event.source;
            ShapePanelManager.this.updatePointsVisibility(editedWidget);
        }
    };

    public ShapePanelManager(Composite parent) {
        super(parent);
    }

    protected void updatePointsVisibility(WItemProperty shapeWidget) {
        if (shapeWidget != null) {
            if (shapeWidget.isExpressionMode()) {
                this.setPropertyVisible("shapePoints", true);
            } else {
                ShapeTypeEnum value = null;
                String editorValue = shapeWidget.getStaticValue();
                if (editorValue != null) {
                    value = (ShapeTypeEnum)NamedEnumPropertyDescriptor.getEnumValue((Enum)ShapeTypeEnum.ELLIPSE, (NullEnum)NullEnum.NOTNULL, (Object)editorValue);
                }
                boolean pointsVisible = ShapeTypeEnum.POLYLINE.equals(value) || ShapeTypeEnum.POLYGON.equals((Object)value);
                this.setPropertyVisible("shapePoints", pointsVisible);
            }
        }
    }

    @Override
    public IWItemProperty createWidget(WidgetPropertyDescriptor widgetDesc, ItemPropertyDescription<?> widget, IPropertyEditor editor, ExpressionContext ec) {
        WItemProperty property = (WItemProperty)super.createWidget(widgetDesc, widget, editor, ec);
        if (widget.getName().equals("shapeType")) {
            property.addModifyListener(this.shapeTypeChange);
        }
        return property;
    }

    @Override
    public void updateWidgets() {
        super.updateWidgets();
        WItemProperty shapeWidget = this.getWidget("shapeType");
        this.updatePointsVisibility(shapeWidget);
    }
}

