/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.widgets.framework.ui.dialogs;

import com.jaspersoft.studio.components.widgets.framework.ui.dialogs.ProvidePointDialog;
import com.jaspersoft.studio.swt.widgets.table.ListContentProvider;
import com.jaspersoft.studio.wizards.JSSHelpWizardPage;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.customizers.shape.Point;
import net.sf.jasperreports.customizers.shape.ShapeTypeEnum;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class PointsWizardPage
extends JSSHelpWizardPage {
    private List<Point> definedPoints = new ArrayList<Point>();
    private TableViewer pointsTable;
    private Button editButton;
    private Button deleteButton;
    private Composite paintArea;
    private Point currentSelectedPoint = null;
    private ShapeTypeEnum editedShape;

    public PointsWizardPage(ShapeTypeEnum editedShape) {
        super("pointsDefinitionPage");
        this.editedShape = editedShape;
    }

    public PointsWizardPage(ShapeTypeEnum editedShape, List<Point> currentPoints) {
        this(editedShape);
        this.definedPoints = currentPoints != null ? new ArrayList<Point>(currentPoints) : new ArrayList<Point>();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        this.createTable(container);
        this.createPreviewArea(container);
        this.setTitle("Define the shape points");
        this.setMessage("Define the points that compose the shape lines");
        this.setControl((Control)container);
    }

    protected String getContextName() {
        return null;
    }

    protected void createTable(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridData gd = new GridData(768);
        cmp.setLayoutData((Object)gd);
        GridLayout cmpLayout = new GridLayout(2, false);
        cmpLayout.horizontalSpacing = 3;
        cmpLayout.verticalSpacing = 0;
        cmpLayout.marginWidth = 0;
        cmpLayout.marginHeight = 0;
        cmp.setLayout((Layout)cmpLayout);
        Table tbl = new Table(cmp, 2052);
        tbl.setLinesVisible(false);
        tbl.setHeaderVisible(true);
        TableColumn col = new TableColumn(tbl, 0);
        col.setText("Shape Points");
        gd = new GridData(768);
        gd.heightHint = 150;
        gd.widthHint = 200;
        tbl.setLayoutData((Object)gd);
        this.pointsTable = new TableViewer(tbl);
        this.pointsTable.setContentProvider((IContentProvider)new ListContentProvider());
        this.pointsTable.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                Point point = (Point)element;
                StringBuilder text = new StringBuilder();
                text.append("X: ");
                text.append(point.getX());
                text.append(" Y: ");
                text.append(point.getY());
                return text.toString();
            }
        });
        this.pointsTable.setInput(this.definedPoints);
        Composite bcmp = new Composite(cmp, 0);
        GridLayout bcmpLayout = new GridLayout(1, false);
        bcmpLayout.horizontalSpacing = 0;
        bcmpLayout.verticalSpacing = 2;
        bcmpLayout.marginWidth = 0;
        bcmpLayout.marginHeight = 0;
        bcmp.setLayout((Layout)bcmpLayout);
        gd = new GridData(2);
        gd.widthHint = 100;
        bcmp.setLayoutData((Object)gd);
        col.setWidth(300);
        this.createNewButton(bcmp);
        this.editButton = this.createEditButton(bcmp);
        this.deleteButton = this.createDeleteButton(bcmp);
        this.pointsTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection selection = (StructuredSelection)event.getSelection();
                if (selection.size() > 0) {
                    PointsWizardPage.this.currentSelectedPoint = (Point)selection.getFirstElement();
                    PointsWizardPage.this.updateButtonEnablemenet(PointsWizardPage.this.currentSelectedPoint);
                } else {
                    PointsWizardPage.this.updateButtonEnablemenet(null);
                }
            }
        });
        this.pointsTable.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                PointsWizardPage.this.editAction();
            }
        });
    }

    protected void updateButtonEnablemenet(Point definition) {
        if (definition == null) {
            this.editButton.setEnabled(false);
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
            this.editButton.setEnabled(true);
        }
    }

    protected void createNewButton(Composite parent) {
        GridData buttonsData = new GridData(768);
        Button newButton = new Button(parent, 8);
        newButton.setLayoutData((Object)buttonsData);
        newButton.setText("New Point");
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ProvidePointDialog creationDialog = new ProvidePointDialog(PointsWizardPage.this.getShell());
                if (creationDialog.open() == 0) {
                    Point newPoint = new Point(creationDialog.getX(), creationDialog.getY());
                    PointsWizardPage.this.definedPoints.add(newPoint);
                    PointsWizardPage.this.pointsTable.refresh();
                    PointsWizardPage.this.paintArea.redraw();
                }
            }
        });
    }

    protected Button createEditButton(Composite parent) {
        GridData buttonsData = new GridData(768);
        Button editButton = new Button(parent, 8);
        editButton.setLayoutData((Object)buttonsData);
        editButton.setText("Edit Point");
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PointsWizardPage.this.editAction();
            }
        });
        editButton.setEnabled(false);
        return editButton;
    }

    protected Button createDeleteButton(Composite parent) {
        GridData buttonsData = new GridData(768);
        Button deleteButton = new Button(parent, 8);
        deleteButton.setLayoutData((Object)buttonsData);
        deleteButton.setText("Delete Point");
        deleteButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection selection = (StructuredSelection)PointsWizardPage.this.pointsTable.getSelection();
                if (selection != null && selection.size() > 0) {
                    Point definition = (Point)selection.getFirstElement();
                    PointsWizardPage.this.definedPoints.remove(definition);
                    PointsWizardPage.this.pointsTable.refresh();
                    PointsWizardPage.this.paintArea.redraw();
                }
            }
        });
        deleteButton.setEnabled(false);
        return deleteButton;
    }

    protected void editAction() {
        StructuredSelection selection = (StructuredSelection)this.pointsTable.getSelection();
        if (!selection.isEmpty()) {
            Point editElement = (Point)selection.getFirstElement();
            ProvidePointDialog dialog = new ProvidePointDialog(this.getShell(), editElement.getX(), editElement.getY());
            if (dialog.open() == 0) {
                editElement.setX(dialog.getX());
                editElement.setY(dialog.getY());
                this.pointsTable.refresh();
                this.paintArea.redraw();
            }
        }
    }

    protected void createPreviewArea(Composite parent) {
        Group container = new Group(parent, 0);
        container.setText("Preview");
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        this.paintArea = new PaintArea((Composite)container, 0);
        this.paintArea.setBackground(ColorConstants.white);
        this.paintArea.setForeground(ColorConstants.black);
        GridData paintAreaData = new GridData(768);
        paintAreaData.verticalAlignment = 0x1000000;
        paintAreaData.grabExcessVerticalSpace = true;
        this.paintArea.setLayoutData((Object)paintAreaData);
    }

    public List<Point> getPoints() {
        return this.definedPoints;
    }

    public IWizardPage getNextPage() {
        return null;
    }

    private class PaintArea
    extends Composite {
        private float scaleFactor;
        private int xOffset;
        private int yOffset;

        public PaintArea(Composite parent, int style) {
            super(parent, style);
            this.scaleFactor = 1.0f;
            this.xOffset = 0;
            this.yOffset = 0;
            this.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    PaintArea.this.scaleFactor = 1.0f;
                    PaintArea.this.yOffset = 0;
                    PaintArea.this.xOffset = 0;
                    if (PointsWizardPage.this.definedPoints.size() < 2) {
                        return;
                    }
                    GC context = e.gc;
                    Rectangle bounds = PointsWizardPage.this.paintArea.getBounds();
                    bounds.width -= 6;
                    bounds.height -= 6;
                    int[] points = new int[PointsWizardPage.this.definedPoints.size() * 2];
                    int index = 0;
                    Integer top = null;
                    Integer bottom = null;
                    Integer left = null;
                    Integer right = null;
                    for (Point point : PointsWizardPage.this.definedPoints) {
                        points[index] = point.getX();
                        points[index + 1] = point.getY();
                        index += 2;
                        if (top == null || point.getY() < top) {
                            top = point.getY();
                        }
                        if (bottom == null || point.getY() > bottom) {
                            bottom = point.getY();
                        }
                        if (left == null || point.getX() < left) {
                            left = point.getX();
                        }
                        if (right != null && point.getX() <= right) continue;
                        right = point.getX();
                    }
                    int linesWidth = right - left;
                    int linesHeight = bottom - top;
                    if (linesWidth > bounds.width || linesHeight > bounds.height) {
                        float scaleFactorX = new Float(bounds.width).floatValue() / new Float(linesWidth).floatValue();
                        float scaleFactorY = new Float(bounds.height).floatValue() / new Float(linesHeight).floatValue();
                        PaintArea.this.scaleFactor = Math.min(scaleFactorX, scaleFactorY);
                        PaintArea.this.xOffset = Math.round(((float)bounds.width - PaintArea.this.scaleFactor * (float)linesWidth) / 2.0f - (float)left.intValue() * PaintArea.this.scaleFactor) + 3;
                        PaintArea.this.yOffset = Math.round(((float)bounds.height - PaintArea.this.scaleFactor * (float)linesHeight) / 2.0f - (float)top.intValue() * PaintArea.this.scaleFactor) + 3;
                    } else {
                        PaintArea.this.xOffset = Math.round((bounds.width - linesWidth) / 2) - left;
                        PaintArea.this.yOffset = Math.round((bounds.height - linesHeight) / 2) - top;
                    }
                    int i = 0;
                    while (i + 1 < points.length) {
                        float currentPointX = new Float(points[i]).floatValue() * PaintArea.this.scaleFactor + (float)PaintArea.this.xOffset;
                        float currentPointY = new Float(points[i + 1]).floatValue() * PaintArea.this.scaleFactor + (float)PaintArea.this.yOffset;
                        points[i] = Math.round(currentPointX);
                        points[i + 1] = Math.round(currentPointY);
                        i += 2;
                    }
                    if (PointsWizardPage.this.editedShape == ShapeTypeEnum.POLYLINE) {
                        context.drawPolyline(points);
                    } else {
                        context.drawPolygon(points);
                    }
                }
            });
            this.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(final MouseEvent e) {
                    if (e.button == 3) {
                        if (PointsWizardPage.this.paintArea.getMenu() != null) {
                            PointsWizardPage.this.paintArea.getMenu().dispose();
                        }
                        Menu menu = new Menu((Control)PointsWizardPage.this.paintArea);
                        MenuItem item = new MenuItem(menu, 0);
                        item.setText("Add Point");
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent selEvent) {
                                int newX = Math.round((float)(e.x - PaintArea.this.xOffset) / PaintArea.this.scaleFactor);
                                int newY = Math.round((float)(e.y - PaintArea.this.yOffset) / PaintArea.this.scaleFactor);
                                Point newPoint = new Point(newX, newY);
                                PointsWizardPage.this.definedPoints.add(newPoint);
                                PointsWizardPage.this.pointsTable.refresh();
                                PointsWizardPage.this.paintArea.redraw();
                            }
                        });
                        menu.setLocation(PointsWizardPage.this.paintArea.toDisplay(e.x, e.y));
                        menu.setVisible(true);
                    }
                }
            });
        }
    }
}

