/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.action;

import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.Util;
import com.jaspersoft.studio.data.sql.action.AAction;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.select.MSelect;
import com.jaspersoft.studio.data.sql.model.query.select.MSelectColumn;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.data.sql.ui.gef.command.CreateColumnCommand;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import java.util.HashSet;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;

public class TableSelectAllAction
extends AAction {
    private SQLQueryDesigner designer;

    public TableSelectAllAction(SQLQueryDesigner designer, String title) {
        super(title, designer.getOutline().getTreeViewer());
        this.designer = designer;
    }

    @Override
    public boolean calculateEnabled(Object[] selection) {
        super.calculateEnabled(selection);
        if (selection == null) {
            return false;
        }
        return selection.length == 1 && TableSelectAllAction.isInFrom(selection[0]);
    }

    public static boolean isInFrom(Object element) {
        if (element instanceof MFromTable && ((MFromTable)element).getValue() instanceof MQueryTable) {
            return false;
        }
        return element instanceof MFromTable;
    }

    public void run() {
        CompoundCommand c = new CompoundCommand();
        MFromTable tbl = (MFromTable)this.selection[0];
        MSelect sel = Util.getKeyword((ANode)tbl, MSelect.class);
        HashSet<MSelectColumn> existing = new HashSet<MSelectColumn>();
        for (INode n : sel.getChildren()) {
            if (!(n instanceof MSelectColumn) || ((MSelectColumn)n).getMFromTable() != tbl) continue;
            existing.add((MSelectColumn)n);
        }
        for (INode n : ((MSqlTable)tbl.getValue()).getChildren()) {
            if (!(n instanceof MSQLColumn)) continue;
            boolean exists = false;
            for (MSelectColumn sc : existing) {
                if (!((MSQLColumn)sc.getValue()).equals(n)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            c.add((Command)new CreateColumnCommand((MSQLColumn)n, sel, -1, tbl));
        }
        if (!c.isEmpty()) {
            this.designer.getDiagram().getViewer().getEditDomain().getCommandStack().execute((Command)c);
            tbl.firePropertyChange("wrongvalue", true, false);
        }
    }
}

