/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.dialogs;

import com.jaspersoft.studio.data.designer.AQueryDesigner;
import com.jaspersoft.studio.data.sql.dialogs.OperandDialog;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.enums.Operator;
import com.jaspersoft.studio.data.sql.model.query.AMKeyword;
import com.jaspersoft.studio.data.sql.model.query.expression.MExpression;
import com.jaspersoft.studio.data.sql.model.query.operand.AOperand;
import com.jaspersoft.studio.data.sql.widgets.Factory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class EditExpressionDialog
extends ATitledDialog {
    private MExpression value;
    private AQueryDesigner designer;
    private List<AOperand> operands;
    private String prevcond;
    private String operator;
    private Map<String, Composite> map = new HashMap<String, Composite>();
    private Composite rcmp;
    private StackLayout stackLayout;
    private Button opDel;
    private Button opEdit;
    private org.eclipse.swt.widgets.List inlist;

    public EditExpressionDialog(Shell parentShell, AQueryDesigner designer) {
        super(parentShell);
        this.designer = designer;
        this.setTitle(Messages.EditExpressionDialog_0);
        this.setDescription(String.valueOf(Messages.EditExpressionDialog_1) + Messages.EditExpressionDialog_2 + Messages.EditExpressionDialog_3);
    }

    public void setValue(MExpression value) {
        this.value = value;
        this.setOperator(value.getOperator().getSqlname());
        this.setPrevcond(value.getPrevCond());
        this.operands = new ArrayList<AOperand>(value.getOperands());
    }

    public String getPrevcond() {
        return this.prevcond;
    }

    public void setPrevcond(String prevcond) {
        this.prevcond = prevcond;
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public List<AOperand> getOperands() {
        return this.operands;
    }

    protected Control createDialogArea(Composite parent) {
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(5, false));
        DataBindingContext bindingContext = new DataBindingContext();
        if (!this.value.isFirst()) {
            Composite c = new Composite(cmp, 0);
            GridLayout layout = new GridLayout(3, false);
            layout.marginWidth = 0;
            c.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            gd.horizontalSpan = 5;
            c.setLayoutData((Object)gd);
            new Label(c, 0).setText(Messages.EditExpressionDialog_4);
            Combo prevoperator = new Combo(c, 8);
            prevoperator.setItems(AMKeyword.CONDITIONS);
            new Label(c, 0).setText(Messages.EditExpressionDialog_5);
            bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)prevoperator), PojoObservables.observeValue((Object)((Object)this), (String)"prevcond"));
        } else {
            GridData gd = new GridData(768);
            gd.horizontalSpan = 5;
            new Label(cmp, 0).setLayoutData((Object)gd);
        }
        Control w = Factory.createWidget(cmp, this.operands, 0, this.value, this.designer);
        GridData gd = new GridData(898);
        gd.widthHint = 250;
        w.setLayoutData((Object)gd);
        Combo optr = new Combo(cmp, 8);
        optr.setItems(Operator.operators);
        optr.setLayoutData((Object)new GridData(2));
        optr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditExpressionDialog.this.showRight();
            }
        });
        this.rcmp = new Composite(cmp, 0);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginHeight = 0;
        this.stackLayout.marginWidth = 0;
        this.rcmp.setLayout((Layout)this.stackLayout);
        gd = new GridData(1808);
        gd.heightHint = 150;
        gd.widthHint = 400;
        gd.verticalSpan = 2;
        gd.horizontalSpan = 3;
        this.rcmp.setLayoutData((Object)gd);
        this.showRight();
        bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)optr), PojoObservables.observeValue((Object)((Object)this), (String)"operator"));
        return cmp;
    }

    private void showRight() {
        Composite cmp = this.map.get(this.getOperator());
        if (cmp == null) {
            Operator op = Operator.getOperator(this.getOperator());
            if (op.getNrOperands() == 1) {
                cmp = new Composite(this.rcmp, 0);
                cmp.setLayout((Layout)new GridLayout());
            } else if (op.getNrOperands() == 2) {
                cmp = new Composite(this.rcmp, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                cmp.setLayout((Layout)layout);
                Control w = Factory.createWidget(cmp, this.operands, 1, this.value, this.designer);
                GridData gd = new GridData(832);
                gd.widthHint = 250;
                w.setLayoutData((Object)gd);
            } else if (op.getNrOperands() == 3 && (op == Operator.BETWEEN || op == Operator.NOTBETWEEN)) {
                cmp = new Composite(this.rcmp, 0);
                GridLayout layout = new GridLayout(3, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                cmp.setLayout((Layout)layout);
                Control w = Factory.createWidget(cmp, this.operands, 1, this.value, this.designer);
                GridData gd = new GridData(832);
                gd.widthHint = 250;
                w.setLayoutData((Object)gd);
                new Label(cmp, 0).setText(Messages.EditExpressionDialog_6);
                w = Factory.createWidget(cmp, this.operands, 2, this.value, this.designer);
                gd = new GridData(832);
                gd.widthHint = 250;
                w.setLayoutData((Object)gd);
            } else {
                cmp = new Composite(this.rcmp, 0);
                GridLayout layout = new GridLayout(2, false);
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                cmp.setLayout((Layout)layout);
                this.createInList(cmp);
            }
        }
        this.stackLayout.topControl = cmp;
        this.rcmp.layout(true);
    }

    protected void createInList(Composite cmp) {
        this.inlist = new org.eclipse.swt.widgets.List(cmp, 2058);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 3;
        gd.widthHint = 250;
        this.inlist.setLayoutData((Object)gd);
        Button op3 = new Button(cmp, 8);
        op3.setText(Messages.EditExpressionDialog_7);
        gd = new GridData(768);
        op3.setLayoutData((Object)gd);
        op3.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditExpressionDialog.this.handleAddInList(EditExpressionDialog.this.inlist);
            }
        });
        this.opEdit = new Button(cmp, 8);
        this.opEdit.setText(Messages.EditExpressionDialog_8);
        gd = new GridData(768);
        this.opEdit.setLayoutData((Object)gd);
        this.opEdit.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditExpressionDialog.this.handleEditInList(EditExpressionDialog.this.inlist);
            }
        });
        this.opDel = new Button(cmp, 8);
        this.opDel.setText(Messages.EditExpressionDialog_9);
        gd = new GridData(770);
        this.opDel.setLayoutData((Object)gd);
        this.opDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = EditExpressionDialog.this.inlist.getSelectionIndex() + 1;
                if (index >= 0 && index < EditExpressionDialog.this.operands.size()) {
                    EditExpressionDialog.this.operands.remove(index);
                    EditExpressionDialog.this.showInList(EditExpressionDialog.this.inlist);
                }
            }
        });
        this.inlist.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditExpressionDialog.this.setupListButtons();
            }
        });
        this.inlist.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                EditExpressionDialog.this.handleEditInList(EditExpressionDialog.this.inlist);
            }
        });
        this.showInList(this.inlist);
        this.setupListButtons();
    }

    private void setupListButtons() {
        boolean canEdit = this.inlist.getSelectionCount() > 0;
        this.opEdit.setEnabled(canEdit);
        this.opDel.setEnabled(canEdit);
    }

    private void handleAddInList(org.eclipse.swt.widgets.List inlist) {
        int index = Math.max(0, inlist.getSelectionIndex());
        OperandDialog dialog = new OperandDialog(this.getShell(), this.designer);
        ArrayList<AOperand> ops = new ArrayList<AOperand>(this.operands);
        if (index < ops.size()) {
            ops.add(index, Factory.getDefaultOperand(this.value));
        } else {
            ops.add(Factory.getDefaultOperand(this.value));
        }
        dialog.setValues(this.value, ops, index);
        if (dialog.open() == 0) {
            AOperand op = dialog.getOperand();
            if (index < ops.size()) {
                this.operands.add(index + 1, op);
            } else {
                ops.add(op);
            }
            this.showInList(inlist);
        }
    }

    private void handleEditInList(org.eclipse.swt.widgets.List inlist) {
        int index = inlist.getSelectionIndex() + 1;
        if (index >= 0 && index < this.operands.size()) {
            OperandDialog dialog = new OperandDialog(this.getShell(), this.designer);
            dialog.setValues(this.value, new ArrayList<AOperand>(this.operands), index);
            if (dialog.open() == 0) {
                this.operands.set(index, dialog.getOperand());
                this.showInList(inlist);
            }
        }
    }

    private void showInList(org.eclipse.swt.widgets.List inlist) {
        String[] ilarray = new String[Math.max(this.operands.size() - 1, 0)];
        if (!this.operands.isEmpty()) {
            int i = 1;
            while (i < this.operands.size()) {
                ilarray[i - 1] = this.operands.get(i).toSQLString();
                ++i;
            }
        }
        inlist.setItems(ilarray);
    }
}

