/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.sql.dialogs;

import com.jaspersoft.studio.data.sql.QueryWriter;
import com.jaspersoft.studio.data.sql.SQLQueryDesigner;
import com.jaspersoft.studio.data.sql.action.AAction;
import com.jaspersoft.studio.data.sql.action.ActionFactory;
import com.jaspersoft.studio.data.sql.action.DeleteAction;
import com.jaspersoft.studio.data.sql.action.expression.ChangeOperator;
import com.jaspersoft.studio.data.sql.action.expression.CreateExpression;
import com.jaspersoft.studio.data.sql.action.expression.CreateExpressionGroup;
import com.jaspersoft.studio.data.sql.action.expression.CreateXExpression;
import com.jaspersoft.studio.data.sql.action.expression.EditExpression;
import com.jaspersoft.studio.data.sql.messages.Messages;
import com.jaspersoft.studio.data.sql.model.metadata.MSQLColumn;
import com.jaspersoft.studio.data.sql.model.metadata.MSqlTable;
import com.jaspersoft.studio.data.sql.model.query.AMKeyword;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTable;
import com.jaspersoft.studio.data.sql.model.query.from.MFromTableJoin;
import com.jaspersoft.studio.data.sql.model.query.subquery.MQueryTable;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.outline.ReportTreeContetProvider;
import com.jaspersoft.studio.outline.ReportTreeLabelProvider;
import com.jaspersoft.studio.utils.UIUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.ATitledDialog;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class JoinFromTableDialog
extends ATitledDialog {
    private MFromTable srcTable;
    private String fromTable;
    private String join = "INNER JOIN";
    private TreeViewer treeViewer;
    private ActionFactory afactory;
    private SQLQueryDesigner designer;
    private boolean create = false;

    public JoinFromTableDialog(Shell parentShell, SQLQueryDesigner designer) {
        this(parentShell, designer, false);
    }

    public JoinFromTableDialog(Shell parentShell, SQLQueryDesigner designer, boolean create) {
        super(parentShell);
        this.setTitle(Messages.JoinFromTableDialog_0);
        this.setDescription(Messages.JoinFromTableDialog_1);
        this.designer = designer;
        this.create = create;
    }

    public void setValue(MFromTable value) {
        this.srcTable = value;
        if (value instanceof MFromTableJoin) {
            this.fromTable = ((MFromTable)value.getParent()).toSQLString();
            this.join = ((MFromTableJoin)value).getJoin();
        } else {
            List children = value.getParent().getChildren();
            int ind = children.indexOf(value) - 1;
            if (ind < 0) {
                ind = children.indexOf(value) + 1;
            }
            this.fromTable = ((MFromTable)children.get(ind)).toSQLString();
        }
    }

    private String[] getFromTables() {
        ANode parent = this.srcTable.getParent();
        if (this.srcTable instanceof MFromTableJoin) {
            parent = parent.getParent();
        }
        ArrayList<String> lst = new ArrayList<String>();
        String spStr = null;
        if (this.srcTable instanceof MFromTableJoin) {
            MFromTable sp = (MFromTable)this.srcTable.getParent();
            spStr = sp.toSQLString().replace(",", "").trim();
            lst.add(sp.getDisplayText());
        }
        for (INode s : parent.getChildren()) {
            if (this.srcTable == s || spStr != null && s.getDisplayText().equals(spStr) || s.getDisplayText().equals(this.srcTable.toSQLString())) continue;
            lst.add(s.getDisplayText());
        }
        return lst.toArray(new String[lst.size()]);
    }

    private int getFromTablesIndex() {
        String[] fromTables = this.getFromTables();
        String ftbl = this.fromTable.replace(",", "").trim();
        int i = 0;
        while (i < fromTables.length) {
            if (fromTables[i].equals(ftbl)) {
                return i;
            }
            ++i;
        }
        if (fromTables.length > 0) {
            this.fromTable = fromTables[0];
        }
        return 0;
    }

    public String getFromTable() {
        return this.fromTable;
    }

    public void setFromTable(String fromTable) {
        this.fromTable = fromTable;
    }

    public String getJoin() {
        return this.join;
    }

    public void setJoin(String join) {
        this.join = join;
    }

    protected Control createDialogArea(Composite parent) {
        Label lbl;
        Composite cmp = (Composite)super.createDialogArea(parent);
        cmp.setLayout((Layout)new GridLayout(3, false));
        Combo ftable = new Combo(cmp, 8);
        GridData gd = new GridData(768);
        gd.widthHint = 200;
        ftable.setLayoutData((Object)gd);
        ftable.setItems(this.getFromTables());
        ftable.select(this.getFromTablesIndex());
        Combo keyword = new Combo(cmp, 8);
        keyword.setItems(AMKeyword.JOIN_KEYWORDS);
        if (this.srcTable.getValue() instanceof MQueryTable) {
            lbl = new Label(cmp, 2056);
            UIUtil.setBold((Control)lbl);
            lbl.setText(Messages.EditFromTableDialog_3);
            lbl.setToolTipText(QueryWriter.writeSubQuery((ANode)this.srcTable));
        } else {
            lbl = new Text(cmp, 2056);
            lbl.setText(((MSqlTable)this.srcTable.getValue()).toSQLString());
            lbl.setToolTipText(lbl.getText());
            gd = new GridData(768);
            gd.widthHint = 200;
            lbl.setLayoutData((Object)gd);
        }
        DataBindingContext bindingContext = new DataBindingContext();
        bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)keyword), PojoObservables.observeValue((Object)((Object)this), (String)"join"));
        bindingContext.bindValue((IObservableValue)SWTObservables.observeSelection((Control)ftable), PojoObservables.observeValue((Object)((Object)this), (String)"fromTable"));
        if (!this.create) {
            this.treeViewer = new TreeViewer(cmp, 2050);
            this.treeViewer.setContentProvider((IContentProvider)new ReportTreeContetProvider());
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new ReportTreeLabelProvider());
            gd = new GridData(1808);
            gd.heightHint = 200;
            gd.horizontalSpan = 3;
            this.treeViewer.getControl().setLayoutData((Object)gd);
            this.treeViewer.addDoubleClickListener(event -> {
                TreeSelection ts = (TreeSelection)this.treeViewer.getSelection();
                Object el = ts.getFirstElement();
                if (el instanceof MSQLColumn) {
                    this.okPressed();
                } else if (this.treeViewer.getExpandedState(el)) {
                    this.treeViewer.collapseToLevel(el, 1);
                } else {
                    this.treeViewer.expandToLevel(el, 1);
                }
            });
            ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.treeViewer);
            MenuManager menuMgr = new MenuManager();
            menuMgr.setRemoveAllWhenShown(true);
            this.afactory = new ActionFactory(this.designer, this.treeViewer);
            menuMgr.addMenuListener(mgr -> {
                TreeSelection s = (TreeSelection)this.treeViewer.getSelection();
                Object[] selection = s != null ? s.toArray() : null;
                boolean isFromTable = false;
                if (selection != null) {
                    Object[] objectArray = selection;
                    int n = selection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        if (o instanceof MFromTable) {
                            isFromTable = true;
                            break;
                        }
                        ++n2;
                    }
                }
                for (AAction act : this.afactory.getActions()) {
                    if (act == null) {
                        mgr.add((IContributionItem)new Separator());
                        continue;
                    }
                    if (!act.calculateEnabled(selection) || isFromTable && !(act instanceof CreateExpressionGroup) && !(act instanceof CreateExpression) && !(act instanceof CreateXExpression)) continue;
                    mgr.add((IAction)act);
                }
            });
            Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
            this.treeViewer.getControl().setMenu(menu);
            this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    this.runAction(event, JoinFromTableDialog.this.afactory.getAction(ChangeOperator.class));
                    this.runAction(event, JoinFromTableDialog.this.afactory.getAction(EditExpression.class));
                }

                private void runAction(DoubleClickEvent event, AAction sd) {
                    if (sd.calculateEnabled(event.getSelection())) {
                        sd.run();
                    }
                }
            });
            this.treeViewer.getControl().addKeyListener((KeyListener)new KeyAdapter(){

                public void keyPressed(KeyEvent event) {
                    if (event.character == '\u007f' && event.stateMask == 0) {
                        TreeSelection s = (TreeSelection)JoinFromTableDialog.this.treeViewer.getSelection();
                        if (s == null) {
                            return;
                        }
                        ArrayList selection = new ArrayList();
                        for (Object obj : s.toList()) {
                            if (obj instanceof MFromTable) continue;
                            selection.add(obj);
                        }
                        List<DeleteAction<?>> dactions = JoinFromTableDialog.this.afactory.getDeleteActions(selection.toArray());
                        Iterator<DeleteAction<?>> iterator = dactions.iterator();
                        if (iterator.hasNext()) {
                            DeleteAction<?> da = iterator.next();
                            da.run();
                        }
                    }
                }
            });
            this.treeViewer.setInput((Object)this.srcTable.getParent());
            this.treeViewer.expandAll();
        }
        return cmp;
    }
}

